/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.maps.A_Map;
import avail.descriptor.objects.ObjectTypeDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.BlockPhraseDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.bootstrap.syntax.P_BootstrapBlockMacro;
import avail.interpreter.primitive.style.P_BootstrapBlockMacroStyler;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u000fH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapBlockMacro;", "Lavail/interpreter/Primitive;", "()V", "clientDataKey", "Lavail/descriptor/atoms/A_Atom;", "scopeMapKey", "scopeStackKey", "staticTokensKey", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapBlockMacroStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_BootstrapBlockMacro
extends Primitive {
    @NotNull
    public static final P_BootstrapBlockMacro INSTANCE = new P_BootstrapBlockMacro();
    @NotNull
    private static final A_Atom clientDataKey = AtomDescriptor.SpecialAtom.CLIENT_DATA_GLOBAL_KEY.getAtom();
    @NotNull
    private static final A_Atom scopeMapKey = AtomDescriptor.SpecialAtom.COMPILER_SCOPE_MAP_KEY.getAtom();
    @NotNull
    private static final A_Atom scopeStackKey = AtomDescriptor.SpecialAtom.COMPILER_SCOPE_STACK_KEY.getAtom();
    @NotNull
    private static final A_Atom staticTokensKey = AtomDescriptor.SpecialAtom.STATIC_TOKENS_KEY.getAtom();

    private P_BootstrapBlockMacro() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(7, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        AvailObject declaredReturnType;
        A_Type deducedReturnType;
        List allStatements;
        Primitive primitive2;
        List argumentDeclarationsList;
        A_Tuple scopeStack;
        AvailObject tokens;
        A_Map clientData;
        A_Map fiberGlobals;
        AvailObject optionalExceptionTypes;
        block39: {
            A_Type primitiveReturnType;
            block35: {
                A_Type labelReturnType;
                block36: {
                    Object object;
                    CompilerDiagnostics.ParseNotificationLevel parseNotificationLevel;
                    block38: {
                        block37: {
                            boolean presentLabel2;
                            boolean primPhrase2;
                            A_BasicObject failureDeclarationName;
                            Object primNamePhrase;
                            boolean bl;
                            boolean bl2;
                            Intrinsics.checkNotNullParameter(interpreter, "interpreter");
                            interpreter.checkArgumentCount(7);
                            AvailObject optionalArgumentDeclarations = interpreter.argument(0);
                            AvailObject optionalPrimitive = interpreter.argument(1);
                            AvailObject optionalLabel = interpreter.argument(2);
                            AvailObject statements = interpreter.argument(3);
                            AvailObject optionalReturnExpression = interpreter.argument(4);
                            AvailObject optionalReturnType = interpreter.argument(5);
                            optionalExceptionTypes = interpreter.argument(6);
                            fiberGlobals = A_Fiber.Companion.getFiberGlobals(interpreter.fiber());
                            AvailObject availObject = A_Map.Companion.mapAtOrNull(fiberGlobals, clientDataKey);
                            if (availObject == null) {
                                return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
                            }
                            clientData = availObject;
                            if (!A_Map.Companion.hasKey(clientData, scopeMapKey)) {
                                return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION);
                            }
                            AvailObject availObject2 = A_Map.Companion.mapAtOrNull(clientData, staticTokensKey);
                            if (availObject2 == null) {
                                return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION);
                            }
                            tokens = availObject2;
                            AvailObject availObject3 = A_Map.Companion.mapAtOrNull(clientData, scopeStackKey);
                            if (availObject3 == null) {
                                return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION);
                            }
                            scopeStack = availObject3;
                            if (!scopeStack.isTuple() || A_Tuple.Companion.getTupleSize(scopeStack) == 0) {
                                return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION);
                            }
                            AvailObject scopeMap = A_Tuple.Companion.tupleAt(scopeStack, A_Tuple.Companion.getTupleSize(scopeStack));
                            boolean bl3 = bl2 = A_Phrase.Companion.getExpressionsSize(optionalArgumentDeclarations) <= 1;
                            if (_Assertions.ENABLED && !bl2) {
                                String string2 = "Assertion failed";
                                throw new AssertionError((Object)string2);
                            }
                            A_Tuple argumentDeclarationPairs = A_Phrase.Companion.getExpressionsSize(optionalArgumentDeclarations) == 0 ? (A_Tuple)TupleDescriptor.Companion.getEmptyTuple() : A_Phrase.Companion.getExpressionsTuple(A_Phrase.Companion.expressionAt(optionalArgumentDeclarations, 1));
                            argumentDeclarationsList = new ArrayList();
                            for (Object declarationPair : argumentDeclarationPairs) {
                                AvailObject declaration2;
                                A_String declarationName = A_Phrase.Companion.getToken(A_Phrase.Companion.expressionAt((A_Phrase)declarationPair, 1)).string();
                                if (A_Map.Companion.mapAtOrNull(scopeMap, declarationName) == null) {
                                    return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION);
                                }
                                argumentDeclarationsList.add(declaration2);
                            }
                            boolean bl4 = bl = A_Phrase.Companion.getExpressionsSize(optionalPrimitive) <= 1;
                            if (_Assertions.ENABLED && !bl) {
                                Object declarationPair;
                                declarationPair = "Assertion failed";
                                throw new AssertionError(declarationPair);
                            }
                            primitive2 = null;
                            primitiveReturnType = null;
                            boolean canHaveStatements = true;
                            allStatements = new ArrayList();
                            if (A_Phrase.Companion.getExpressionsSize(optionalPrimitive) == 1) {
                                boolean bl5;
                                A_Phrase primPhrase2 = A_Phrase.Companion.expressionAt(optionalPrimitive, 1);
                                primNamePhrase = A_Phrase.Companion.expressionAt(primPhrase2, 1);
                                if (!A_Phrase.Companion.phraseKindIsUnder((A_Phrase)primNamePhrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
                                    throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "primitive specification to be a (compiler created) literal keyword token", new Object[0]);
                                }
                                A_String primName = A_Phrase.Companion.getToken((A_Phrase)primNamePhrase).string();
                                primitive2 = Primitive.PrimitiveHolder.Companion.primitiveByName(primName.asNativeString());
                                if (primitive2 == null) {
                                    return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION);
                                }
                                canHaveStatements = !primitive2.hasFlag(Primitive.Flag.CannotFail);
                                A_Phrase optionalFailurePair = A_Phrase.Companion.expressionAt(primPhrase2, 2);
                                boolean bl6 = bl5 = A_Phrase.Companion.getExpressionsSize(optionalFailurePair) <= 1;
                                if (_Assertions.ENABLED && !bl5) {
                                    String string3 = "Assertion failed";
                                    throw new AssertionError((Object)string3);
                                }
                                if (A_Phrase.Companion.getExpressionsSize(optionalFailurePair) == 1 != canHaveStatements) {
                                    throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, !canHaveStatements ? "infallible primitive function not to have statements" : "fallible primitive function to have statements", new Object[0]);
                                }
                                if (A_Phrase.Companion.getExpressionsSize(optionalFailurePair) == 1) {
                                    A_Phrase failurePair = A_Phrase.Companion.expressionAt(optionalFailurePair, 1);
                                    A_Token failureToken = A_Phrase.Companion.getToken(A_Phrase.Companion.expressionAt(failurePair, 1));
                                    failureDeclarationName = failureToken.literal().string();
                                    AvailObject availObject4 = A_Map.Companion.mapAtOrNull(scopeMap, failureDeclarationName);
                                    if (availObject4 == null) {
                                        return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION);
                                    }
                                    AvailObject failureDeclaration = availObject4;
                                    allStatements.add(failureDeclaration);
                                }
                                primitiveReturnType = A_Type.Companion.getReturnType(primitive2.blockTypeRestriction());
                            } else {
                                primitive2 = null;
                                primitiveReturnType = null;
                            }
                            boolean bl7 = primPhrase2 = A_Phrase.Companion.getExpressionsSize(optionalLabel) <= 1;
                            if (_Assertions.ENABLED && !primPhrase2) {
                                primNamePhrase = "Assertion failed";
                                throw new AssertionError(primNamePhrase);
                            }
                            labelReturnType = null;
                            if (A_Phrase.Companion.getExpressionsSize(optionalLabel) == 1) {
                                A_Phrase presentLabel2 = A_Phrase.Companion.expressionAt(optionalLabel, 1);
                                A_Token labelToken = A_Phrase.Companion.getToken(A_Phrase.Companion.expressionAt(presentLabel2, 1));
                                A_String labelDeclarationName = labelToken.literal().string();
                                AvailObject availObject5 = A_Map.Companion.mapAtOrNull(scopeMap, labelDeclarationName);
                                if (availObject5 == null) {
                                    return interpreter.primitiveFailure(AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION);
                                }
                                AvailObject label = availObject5;
                                A_Phrase optionalLabelReturnTypePhrase = A_Phrase.Companion.expressionAt(presentLabel2, 2);
                                allStatements.add(label);
                                if (A_Phrase.Companion.getExpressionsSize(optionalLabelReturnTypePhrase) == 1) {
                                    labelReturnType = A_Type.Companion.getReturnType(A_Type.Companion.getFunctionType(A_Phrase.Companion.getDeclaredType(label)));
                                }
                            }
                            for (Object statement : A_Phrase.Companion.getExpressionsTuple(statements)) {
                                allStatements.add(A_Phrase.Companion.getToken((A_Phrase)statement).literal());
                            }
                            boolean bl8 = presentLabel2 = A_Phrase.Companion.getExpressionsSize(optionalReturnExpression) <= 1;
                            if (_Assertions.ENABLED && !presentLabel2) {
                                Object statement;
                                statement = "Assertion failed";
                                throw new AssertionError(statement);
                            }
                            if (A_Phrase.Companion.getExpressionsSize(optionalReturnExpression) == 1) {
                                A_Phrase returnLiteralPhrase = A_Phrase.Companion.expressionAt(optionalReturnExpression, 1);
                                boolean labelDeclarationName = A_Phrase.Companion.phraseKindIsUnder(returnLiteralPhrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE);
                                if (_Assertions.ENABLED && !labelDeclarationName) {
                                    String label = "Assertion failed";
                                    throw new AssertionError((Object)label);
                                }
                                AvailObject returnExpression = A_Phrase.Companion.getToken(returnLiteralPhrase).literal();
                                allStatements.add(returnExpression);
                                v10 = labelReturnType == null ? A_Phrase.Companion.getPhraseExpressionType(returnExpression) : A_Type.Companion.typeUnion(A_Phrase.Companion.getPhraseExpressionType(returnExpression), labelReturnType);
                            } else {
                                v10 = deducedReturnType = primitive2 != null && primitive2.hasFlag(Primitive.Flag.CannotFail) ? A_Type.Companion.getReturnType(primitive2.blockTypeRestriction()) : (A_Type)PrimitiveTypeDescriptor.Types.TOP.getO();
                            }
                            if (allStatements.size() > 0 && !canHaveStatements) {
                                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "infallible primitive function not to have statements", new Object[0]);
                            }
                            AvailObject availObject6 = declaredReturnType = A_Phrase.Companion.getExpressionsSize(optionalReturnType) != 0 ? A_Phrase.Companion.getToken(A_Phrase.Companion.expressionAt(optionalReturnType, 1)).literal() : null;
                            if (declaredReturnType == null) break block35;
                            if (A_Type.Companion.isSubtypeOf(deducedReturnType, declaredReturnType)) break block36;
                            parseNotificationLevel = CompilerDiagnostics.ParseNotificationLevel.STRONG;
                            object = labelReturnType;
                            if (object == null) break block37;
                            failureDeclarationName = object;
                            CompilerDiagnostics.ParseNotificationLevel parseNotificationLevel2 = parseNotificationLevel;
                            boolean bl9 = false;
                            String string4 = "the union (" + deducedReturnType + ") of the final expression's type and the label's declared type to agree with the declared return type (" + declaredReturnType + ")";
                            parseNotificationLevel = parseNotificationLevel2;
                            object = string4;
                            if (string4 != null) break block38;
                        }
                        object = "final expression's type (" + deducedReturnType + ") to agree with the declared return type (" + declaredReturnType + ")";
                    }
                    Object[] objectArray = new Object[]{};
                    Object object2 = object;
                    CompilerDiagnostics.ParseNotificationLevel parseNotificationLevel3 = parseNotificationLevel;
                    throw new AvailRejectedParseException(parseNotificationLevel3, (String)object2, objectArray);
                }
                if (primitiveReturnType != null && !A_Type.Companion.isSubtypeOf(primitiveReturnType, declaredReturnType)) {
                    throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "primitive's intrinsic return type (" + primitiveReturnType + ") to agree with the declared return type (" + declaredReturnType + ")", new Object[0]);
                }
                if (labelReturnType != null && !A_Type.Companion.isSubtypeOf(labelReturnType, declaredReturnType)) {
                    throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "label's declared return type (" + labelReturnType + ") to agree with the function's declared return type (" + declaredReturnType + ")", new Object[0]);
                }
                break block39;
            }
            if (primitiveReturnType != null) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.WEAK, "primitive function to declare its return type", new Object[0]);
            }
        }
        AvailObject availObject = declaredReturnType;
        A_Type returnType = availObject != null ? (A_Type)availObject : deducedReturnType;
        A_Set exceptionsSet = SetDescriptor.Companion.getEmptySet();
        if (A_Phrase.Companion.getExpressionsSize(optionalExceptionTypes) == 1) {
            A_Tuple expressions = A_Phrase.Companion.getExpressionsTuple(A_Phrase.Companion.getLastExpression(optionalExceptionTypes));
            exceptionsSet = SetDescriptor.Companion.generateSetFrom(expressions, attempt.2.INSTANCE).makeImmutable();
        }
        int lineNumber = A_Tuple.Companion.getTupleSize(tokens) == 0 ? 0 : A_Tuple.Companion.tupleAt(tokens, 1).lineNumber();
        AvailObject block = BlockPhraseDescriptor.Companion.newBlockNode(ObjectTupleDescriptor.Companion.tupleFromList(argumentDeclarationsList), primitive2, ObjectTupleDescriptor.Companion.tupleFromList(allStatements), returnType, exceptionsSet, lineNumber, tokens);
        block.makeImmutable();
        A_Fiber fiber2 = interpreter.fiber();
        scopeStack = A_Tuple.Companion.copyTupleFromToCanDestroy(scopeStack, 1, A_Tuple.Companion.getTupleSize(scopeStack) - 1, true);
        clientData = A_Map.Companion.mapAtPuttingCanDestroy(clientData, scopeStackKey, scopeStack, true);
        A_Fiber.Companion.setFiberGlobals(fiber2, A_Map.Companion.mapAtPuttingCanDestroy(fiberGlobals, clientDataKey, clientData, true));
        return interpreter.primitiveSuccess(block);
    }

    @Override
    @NotNull
    public P_BootstrapBlockMacroStyler bootstrapStyler() {
        return P_BootstrapBlockMacroStyler.INSTANCE;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[7];
        A_Type[] a_TypeArray = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), InstanceMetaDescriptor.Companion.anyMeta()};
        a_BasicObjectArray[0] = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.oneOrMoreOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray))));
        a_TypeArray = new A_Type[2];
        a_TypeArray[0] = PrimitiveTypeDescriptor.Types.TOKEN.getO();
        A_Type[] a_TypeArray2 = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), InstanceMetaDescriptor.Companion.anyMeta()};
        a_TypeArray[1] = TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray2));
        a_BasicObjectArray[1] = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray)));
        a_TypeArray = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), TupleTypeDescriptor.Companion.zeroOrOneOf(InstanceMetaDescriptor.Companion.topMeta())};
        a_BasicObjectArray[2] = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray)));
        a_BasicObjectArray[3] = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrMoreOf(PhraseTypeDescriptor.PhraseKind.STATEMENT_PHRASE.getMostGeneralType()));
        a_BasicObjectArray[4] = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.create(PrimitiveTypeDescriptor.Types.ANY.getO())));
        a_BasicObjectArray[5] = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(InstanceMetaDescriptor.Companion.topMeta()));
        a_BasicObjectArray[6] = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.oneOrMoreOf(ObjectTypeDescriptor.Companion.Exceptions.INSTANCE.getExceptionType())));
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray), PhraseTypeDescriptor.PhraseKind.BLOCK_PHRASE.getMostGeneralType(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_INCONSISTENT_PREFIX_FUNCTION};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

