/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.pojos;

import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.pojos.PojoDescriptor;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.PojoTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MarshalingException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.primitive.pojos.PrimitiveHelper;
import avail.utility.Mutable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lavail/interpreter/primitive/pojos/P_InvokeInstancePojoMethod;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_InvokeInstancePojoMethod
extends Primitive {
    @NotNull
    public static final P_InvokeInstancePojoMethod INSTANCE = new P_InvokeInstancePojoMethod();

    private P_InvokeInstancePojoMethod() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Private, Primitive.Flag.HasSideEffect};
        super(-1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Object result2;
        Object object;
        boolean bl;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        A_Tuple methodArgs = ObjectTupleDescriptor.Companion.tupleFromList(interpreter.argsBuffer);
        A_Function a_Function = interpreter.function;
        Intrinsics.checkNotNull(a_Function);
        A_Function primitiveFunction = a_Function;
        A_RawFunction primitiveRawFunction = primitiveFunction.code();
        boolean bl2 = bl = primitiveRawFunction.codePrimitive() == this;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject methodPojo = primitiveFunction.outerVarAt(1);
        AvailObject marshaledTypes = primitiveFunction.outerVarAt(2);
        A_Type expectedType = A_Type.Companion.getReturnType(primitiveRawFunction.functionType());
        AvailLoader availLoader = interpreter.availLoaderOrNull();
        if (availLoader != null) {
            availLoader.statementCanBeSummarized(false);
        }
        Method method = (Method)methodPojo.javaObjectNotNull();
        Mutable<Object> errorOut = new Mutable<Object>(null);
        Object receiver = A_Tuple.Companion.tupleAt(methodArgs, 1).marshalToJava((Class)A_Tuple.Companion.tupleAt(marshaledTypes, 1).javaObject());
        Object[] marshaledArgs = PrimitiveHelper.INSTANCE.marshalValues$avail(A_Tuple.Companion.copyTupleFromToCanDestroy(marshaledTypes, 2, A_Tuple.Companion.getTupleSize(marshaledTypes), false), A_Tuple.Companion.copyTupleFromToCanDestroy(methodArgs, 2, A_Tuple.Companion.getTupleSize(methodArgs), false), errorOut);
        if (errorOut.getValue() != null) {
            Object v3 = errorOut.getValue();
            Intrinsics.checkNotNull(v3);
            AvailErrorCode e = v3;
            return interpreter.primitiveFailure(PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo((Object)e), PojoTypeDescriptor.Companion.pojoTypeForClass(((Object)((Object)e)).getClass())));
        }
        try {
            Intrinsics.checkNotNull(marshaledArgs);
            object = marshaledArgs;
            object = method.invoke(receiver, Arrays.copyOf(object, ((Object[])object).length));
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            Intrinsics.checkNotNull(throwable);
            Throwable cause = throwable;
            return interpreter.primitiveFailure(PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo(cause), PojoTypeDescriptor.Companion.pojoTypeForClass(cause.getClass())));
        }
        catch (Throwable e) {
            return interpreter.primitiveFailure(PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo(e), PojoTypeDescriptor.Companion.pojoTypeForClass(e.getClass())));
        }
        Object object2 = result2 = object;
        if (result2 == null) {
            return interpreter.primitiveSuccess(PojoDescriptor.Companion.nullPojo());
        }
        try {
            object = interpreter.primitiveSuccess(PojoTypeDescriptor.Companion.unmarshal(result2, expectedType));
        }
        catch (MarshalingException e) {
            object = interpreter.primitiveFailure(PojoDescriptor.Companion.newPojo(RawPojoDescriptor.Companion.identityPojo(e), PojoTypeDescriptor.Companion.pojoTypeForClass(e.getClass())));
        }
        return object;
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        return A_Type.Companion.getReturnType(rawFunction.functionType());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return BottomTypeDescriptor.Companion.getBottom();
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        return PojoTypeDescriptor.Companion.pojoTypeForClass(Throwable.class);
    }
}

