/*
 * Decompiled with CFR 0.152.
 */
package avail.utility;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/utility/UTF8ResourceBundleControl;", "Ljava/util/ResourceBundle$Control;", "()V", "newBundle", "Ljava/util/ResourceBundle;", "baseName", "", "locale", "Ljava/util/Locale;", "format", "loader", "Ljava/lang/ClassLoader;", "reload", "", "avail"})
public final class UTF8ResourceBundleControl
extends ResourceBundle.Control {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResourceBundle newBundle(@NotNull String baseName, @NotNull Locale locale, @NotNull String format, @NotNull ClassLoader loader, boolean reload) throws IOException {
        Intrinsics.checkNotNullParameter(baseName, "baseName");
        Intrinsics.checkNotNullParameter(locale, "locale");
        Intrinsics.checkNotNullParameter(format, "format");
        Intrinsics.checkNotNullParameter(loader, "loader");
        String bundleName = this.toBundleName(baseName, locale);
        ResourceBundle bundle = null;
        if (Intrinsics.areEqual(format, "java.class")) {
            try {
                Class<?> $this$cast$iv = loader.loadClass(bundleName);
                boolean $i$f$cast = false;
                Class bundleClass = (Class)((Object)$this$cast$iv);
                if (!ResourceBundle.class.isAssignableFrom(bundleClass)) {
                    throw new ClassCastException(bundleClass.getName() + " cannot be cast to ResourceBundle");
                }
                bundle = (ResourceBundle)bundleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ClassNotFoundException bundleClass) {
            }
            catch (InstantiationException bundleClass) {
            }
            catch (IllegalAccessException bundleClass) {}
        } else if (Intrinsics.areEqual(format, "java.properties")) {
            Reader stream = null;
            try {
                String resourceName = this.toResourceName(bundleName, "properties");
                stream = AccessController.doPrivileged(() -> UTF8ResourceBundleControl.newBundle$lambda-0(reload, loader, resourceName));
            }
            catch (PrivilegedActionException e) {
                Exception exception = e.getException();
                Intrinsics.checkNotNull(exception, "null cannot be cast to non-null type java.io.IOException");
                throw (IOException)exception;
            }
            if (stream != null) {
                PropertyResourceBundle propertyResourceBundle;
                Closeable closeable = stream;
                Throwable throwable = null;
                try {
                    Reader p0 = (Reader)closeable;
                    boolean bl = false;
                    propertyResourceBundle = new PropertyResourceBundle(p0);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                bundle = propertyResourceBundle;
            }
        } else {
            throw new IllegalArgumentException("unknown format: " + format);
        }
        return bundle;
    }

    private static final InputStreamReader newBundle$lambda-0(boolean $reload, ClassLoader $loader, String $resourceName) {
        Intrinsics.checkNotNullParameter($loader, "$loader");
        InputStream inputStream = null;
        if ($reload) {
            URL uRL = $loader.getResource($resourceName);
            if (uRL == null) {
                throw new IOException("Invalid URL for resource");
            }
            URL url = uRL;
            URLConnection uRLConnection = url.openConnection();
            if (uRLConnection == null) {
                throw new IOException("Invalid URL for resource");
            }
            URLConnection connection = uRLConnection;
            connection.setUseCaches(false);
            InputStream inputStream2 = connection.getInputStream();
            Intrinsics.checkNotNullExpressionValue(inputStream2, "connection.getInputStream()");
            inputStream = inputStream2;
        } else {
            InputStream inputStream3 = $loader.getResourceAsStream($resourceName);
            Intrinsics.checkNotNull(inputStream3);
            inputStream = inputStream3;
        }
        return new InputStreamReader(inputStream, StandardCharsets.UTF_8);
    }
}

