/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks.module;

import avail.descriptor.maps.A_Map;
import avail.descriptor.tuples.A_String;
import avail.stacks.CommentGroup;
import avail.stacks.StacksFilename;
import avail.stacks.comment.GrammaticalRestrictionComment;
import avail.stacks.comment.MacroComment;
import avail.stacks.comment.MethodComment;
import avail.stacks.comment.SemanticRestrictionComment;
import avail.stacks.module.CommentsModule;
import avail.stacks.module.StacksExtendsModule;
import avail.stacks.module.StacksImportModule;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0093\u0001\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0005\u0012\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00050\u0005\u0012\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00000\u0005\u0012\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00050\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fB\u0017\b\u0016\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u0007H\u0016J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020$H\u0016J0\u0010%\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020\u0003H\u0016R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006-"}, d2={"Lavail/stacks/module/StacksUsesModule;", "Lavail/stacks/module/StacksImportModule;", "moduleImportName", "", "commentGroups", "", "Lavail/descriptor/tuples/A_String;", "Lavail/stacks/CommentGroup;", "moduleNameToExtendsList", "Lavail/stacks/module/StacksExtendsModule;", "methodLeafNameToModuleName", "moduleNameToUsesList", "usesMethodLeafNameToModuleName", "renames", "Lavail/descriptor/maps/A_Map;", "(Ljava/lang/String;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Lavail/descriptor/maps/A_Map;)V", "module", "Lavail/stacks/module/CommentsModule;", "renamesMap", "(Lavail/stacks/module/CommentsModule;Lavail/descriptor/maps/A_Map;)V", "getRenames", "()Lavail/descriptor/maps/A_Map;", "addClassImplementationGroup", "", "key", "classCommentGroup", "addGlobalImplementationGroup", "globalCommentGroup", "addGrammaticalImplementation", "implementation", "Lavail/stacks/comment/GrammaticalRestrictionComment;", "addMacroImplementation", "Lavail/stacks/comment/MacroComment;", "addMethodImplementation", "Lavail/stacks/comment/MethodComment;", "addSemanticImplementation", "Lavail/stacks/comment/SemanticRestrictionComment;", "renameImplementation", "newName", "newlyDefinedModule", "newFileName", "Lavail/stacks/StacksFilename;", "deleteOriginal", "", "toString", "avail"})
public final class StacksUsesModule
extends StacksImportModule {
    @NotNull
    private final A_Map renames;

    @NotNull
    public final A_Map getRenames() {
        return this.renames;
    }

    public StacksUsesModule(@NotNull String moduleImportName, @NotNull Map<A_String, CommentGroup> commentGroups, @NotNull Map<String, StacksExtendsModule> moduleNameToExtendsList, @NotNull Map<A_String, Map<String, CommentGroup>> methodLeafNameToModuleName, @NotNull Map<String, StacksUsesModule> moduleNameToUsesList, @NotNull Map<A_String, Map<String, CommentGroup>> usesMethodLeafNameToModuleName, @NotNull A_Map renames) {
        Intrinsics.checkNotNullParameter((Object)moduleImportName, (String)"moduleImportName");
        Intrinsics.checkNotNullParameter(commentGroups, (String)"commentGroups");
        Intrinsics.checkNotNullParameter(moduleNameToExtendsList, (String)"moduleNameToExtendsList");
        Intrinsics.checkNotNullParameter(methodLeafNameToModuleName, (String)"methodLeafNameToModuleName");
        Intrinsics.checkNotNullParameter(moduleNameToUsesList, (String)"moduleNameToUsesList");
        Intrinsics.checkNotNullParameter(usesMethodLeafNameToModuleName, (String)"usesMethodLeafNameToModuleName");
        Intrinsics.checkNotNullParameter((Object)renames, (String)"renames");
        super(moduleImportName, commentGroups, moduleNameToExtendsList, methodLeafNameToModuleName, moduleNameToUsesList, usesMethodLeafNameToModuleName);
        this.renames = renames;
    }

    @Override
    public void addMethodImplementation(@NotNull A_String key, @NotNull MethodComment implementation) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
        CommentGroup commentGroup = this.getCommentGroups().get(key);
        if (commentGroup != null) {
            commentGroup.addMethod(implementation);
        }
        Map<String, CommentGroup> map = this.getExtendsMethodLeafNameToModuleName().get(key);
        Intrinsics.checkNotNull(map);
        for (CommentGroup group : map.values()) {
            group.addMethod(implementation);
        }
    }

    @Override
    public void addMacroImplementation(@NotNull A_String key, @NotNull MacroComment implementation) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
        CommentGroup commentGroup = this.getCommentGroups().get(key);
        if (commentGroup != null) {
            commentGroup.addMacro(implementation);
        }
        Map<String, CommentGroup> map = this.getExtendsMethodLeafNameToModuleName().get(key);
        Intrinsics.checkNotNull(map);
        for (CommentGroup group : map.values()) {
            group.addMacro(implementation);
        }
    }

    @Override
    public void addSemanticImplementation(@NotNull A_String key, @NotNull SemanticRestrictionComment implementation) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
        CommentGroup commentGroup = this.getCommentGroups().get(key);
        if (commentGroup != null) {
            commentGroup.addSemanticRestriction(implementation);
        }
        Map<String, CommentGroup> map = this.getExtendsMethodLeafNameToModuleName().get(key);
        Intrinsics.checkNotNull(map);
        for (CommentGroup group : map.values()) {
            group.addSemanticRestriction(implementation);
        }
    }

    @Override
    public void addGrammaticalImplementation(@NotNull A_String key, @NotNull GrammaticalRestrictionComment implementation) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)implementation, (String)"implementation");
        CommentGroup commentGroup = this.getCommentGroups().get(key);
        if (commentGroup != null) {
            commentGroup.addGrammaticalRestriction(implementation);
        }
        Map<String, CommentGroup> map = this.getExtendsMethodLeafNameToModuleName().get(key);
        Intrinsics.checkNotNull(map);
        for (CommentGroup group : map.values()) {
            group.addGrammaticalRestriction(implementation);
        }
    }

    @Override
    public void addClassImplementationGroup(@NotNull A_String key, @NotNull CommentGroup classCommentGroup) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)classCommentGroup, (String)"classCommentGroup");
        this.getCommentGroups().put(key, classCommentGroup);
    }

    @Override
    public void addGlobalImplementationGroup(@NotNull A_String key, @NotNull CommentGroup globalCommentGroup) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)globalCommentGroup, (String)"globalCommentGroup");
        if (this.getCommentGroups().containsKey(key)) {
            this.getCommentGroups().put(key, globalCommentGroup);
        }
    }

    @Override
    public void renameImplementation(@NotNull A_String key, @NotNull A_String newName, @NotNull CommentsModule newlyDefinedModule, @NotNull StacksFilename newFileName, boolean deleteOriginal) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter((Object)newlyDefinedModule, (String)"newlyDefinedModule");
        Intrinsics.checkNotNullParameter((Object)newFileName, (String)"newFileName");
        CommentGroup group = null;
        group = new CommentGroup(key, newlyDefinedModule.getModuleName(), newFileName, false);
        Map<String, CommentGroup> map = this.getExtendsMethodLeafNameToModuleName().get(key);
        Intrinsics.checkNotNull(map);
        for (CommentGroup aGroup : map.values()) {
            group = new CommentGroup(aGroup, newFileName, newlyDefinedModule.getModuleName(), newName);
        }
        if (newlyDefinedModule.getUsesMethodLeafNameToModuleName().containsKey(newName)) {
            Map<String, CommentGroup> map2 = newlyDefinedModule.getUsesMethodLeafNameToModuleName().get(newName);
            if (map2 != null) {
                Map<String, CommentGroup> it = map2;
                boolean bl = false;
                it.put(newlyDefinedModule.getModuleName(), group);
            }
        } else {
            Map newMap = new LinkedHashMap();
            newMap.put(newlyDefinedModule.getModuleName(), group);
            newlyDefinedModule.getUsesMethodLeafNameToModuleName().put(newName, newMap);
        }
        if (deleteOriginal) {
            this.getExtendsMethodLeafNameToModuleName().remove(key);
        }
    }

    public StacksUsesModule(@NotNull CommentsModule module, @NotNull A_Map renamesMap) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)renamesMap, (String)"renamesMap");
        super(module.getModuleName(), MapsKt.toMutableMap(module.getNamedPublicCommentImplementations()), MapsKt.toMutableMap(module.getExtendedNamesImplementations()), MapsKt.toMutableMap(module.getExtendsMethodLeafNameToModuleName()), module.getUsesNamesImplementations(), module.getUsesMethodLeafNameToModuleName());
        this.renames = renamesMap;
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u2d1.append("<h4>").append(this.getModuleName()).append("</h4>").append("<ol>");
        for (A_String key : this.getCommentGroups().keySet()) {
            $this$toString_u24lambda_u2d1.append("<li>").append(key.asNativeString()).append("</li>");
        }
        $this$toString_u24lambda_u2d1.append("</ol>");
        for (StacksUsesModule usesModule : this.getModuleNameToUsesList().values()) {
            $this$toString_u24lambda_u2d1.append(usesModule);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply {\n\u2026Module)\n\t\t}\n\t}.toString()");
        return string2;
    }
}

