/*
 * Decompiled with CFR 0.152.
 */
package avail.builder;

import avail.AvailTask;
import avail.builder.AvailBuilder;
import avail.builder.ModuleName;
import avail.builder.ResolvedModuleName;
import avail.compiler.ModuleHeader;
import avail.compiler.problems.Problem;
import avail.compiler.problems.ProblemHandler;
import avail.compiler.problems.ProblemType;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.error.ErrorCode;
import avail.persistence.cache.Repository;
import avail.serialization.Deserializer;
import avail.stacks.StacksGenerator;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.persistence.IndexedFile;
import org.availlang.persistence.MalformedSerialStreamException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010JF\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0018\u0010\u0014\u001a\u0014\u0012\n\u0012\b\u0018\u00010\u0016R\u00020\u0017\u0012\u0004\u0012\u00020\f0\u00152\u001a\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0012\u0004\u0012\u00020\f0\u0019H\u0002J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010J&\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0002J&\u0010 \u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u001fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lavail/builder/DocumentationTracer;", "", "availBuilder", "Lavail/builder/AvailBuilder;", "documentationPath", "Ljava/nio/file/Path;", "(Lavail/builder/AvailBuilder;Ljava/nio/file/Path;)V", "getAvailBuilder", "()Lavail/builder/AvailBuilder;", "generator", "Lavail/stacks/StacksGenerator;", "generate", "", "target", "Lavail/builder/ModuleName;", "problemHandler", "Lavail/compiler/problems/ProblemHandler;", "getVersion", "moduleName", "Lavail/builder/ResolvedModuleName;", "withVersion", "Lkotlin/Function1;", "Lavail/persistence/cache/Repository$ModuleVersion;", "Lavail/persistence/cache/Repository;", "failureHandler", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "load", "loadComments", "completionAction", "Lkotlin/Function0;", "scheduleLoadComments", "avail"})
public final class DocumentationTracer {
    @NotNull
    private final AvailBuilder availBuilder;
    @NotNull
    private final StacksGenerator generator;

    public DocumentationTracer(@NotNull AvailBuilder availBuilder, @NotNull Path documentationPath) {
        Intrinsics.checkNotNullParameter(availBuilder, "availBuilder");
        Intrinsics.checkNotNullParameter(documentationPath, "documentationPath");
        this.availBuilder = availBuilder;
        this.generator = new StacksGenerator(documentationPath, this.availBuilder.getRuntime().getModuleNameResolver());
    }

    @NotNull
    public final AvailBuilder getAvailBuilder() {
        return this.availBuilder;
    }

    private final void getVersion(ResolvedModuleName moduleName2, Function1<? super Repository.ModuleVersion, Unit> withVersion, Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Repository repository = moduleName2.getRepository();
        Repository.ModuleArchive archive = repository.getArchive(moduleName2.getRootRelativeName());
        archive.digestForFile(moduleName2, false, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(moduleName2, withVersion, archive){
            final /* synthetic */ ResolvedModuleName $moduleName;
            final /* synthetic */ Function1<Repository.ModuleVersion, Unit> $withVersion;
            final /* synthetic */ Repository.ModuleArchive $archive;
            {
                this.$moduleName = $moduleName;
                this.$withVersion = $withVersion;
                this.$archive = $archive;
                super(1);
            }

            public final void invoke(@NotNull byte[] digest) {
                Intrinsics.checkNotNullParameter(digest, "digest");
                Repository.ModuleVersionKey versionKey = new Repository.ModuleVersionKey(this.$moduleName, digest);
                this.$withVersion.invoke(this.$archive.getVersion(versionKey));
            }
        }, failureHandler);
    }

    private final void loadComments(ResolvedModuleName moduleName2, ProblemHandler problemHandler, Function0<Unit> completionAction) {
        this.getVersion(moduleName2, (Function1<? super Repository.ModuleVersion, Unit>)new Function1<Repository.ModuleVersion, Unit>(moduleName2, problemHandler, this, completionAction){
            final /* synthetic */ ResolvedModuleName $moduleName;
            final /* synthetic */ ProblemHandler $problemHandler;
            final /* synthetic */ DocumentationTracer this$0;
            final /* synthetic */ Function0<Unit> $completionAction;
            {
                this.$moduleName = $moduleName;
                this.$problemHandler = $problemHandler;
                this.this$0 = $receiver;
                this.$completionAction = $completionAction;
                super(1);
            }

            public final void invoke(@Nullable Repository.ModuleVersion version) {
                Deserializer deserializer22;
                ByteArrayInputStream input;
                Repository.ModuleVersion moduleVersion = version;
                if ((byte[])(moduleVersion != null ? moduleVersion.getComments() : null) == null) {
                    ProblemType problemType = ProblemType.TRACE;
                    Object[] objectArray = new Object[]{this.$moduleName};
                    Object[] objectArray2 = objectArray;
                    Problem problem2 = new Problem(this.$moduleName, this.this$0, this.$completionAction, problemType, objectArray2){
                        final /* synthetic */ DocumentationTracer this$0;
                        final /* synthetic */ Function0<Unit> $completionAction;
                        {
                            this.this$0 = $receiver;
                            this.$completionAction = $completionAction;
                            super($moduleName, 1, 0L, $super_call_param$1, "Module \"{0}\" should have been compiled already", $super_call_param$2);
                        }

                        public void abortCompilation() {
                            this.this$0.getAvailBuilder().setStopBuildReason("Comment loading failed");
                            this.$completionAction.invoke();
                        }
                    };
                    this.$problemHandler.handle(problem2);
                    return;
                }
                A_Tuple tuple2 = null;
                try {
                    boolean bl;
                    boolean bl2;
                    byte[] byArray = version.getComments();
                    Intrinsics.checkNotNull(byArray);
                    byte[] bytes = byArray;
                    input = IndexedFile.Companion.validatedBytesFrom(bytes);
                    deserializer22 = new Deserializer(input, this.this$0.getAvailBuilder().getRuntime(), null, 4, null);
                    tuple2 = deserializer22.deserialize();
                    boolean bl3 = bl2 = tuple2 != null;
                    if (_Assertions.ENABLED && !bl2) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    A_Tuple a_Tuple = tuple2;
                    Intrinsics.checkNotNull(a_Tuple);
                    bl2 = ((AvailObject)a_Tuple).isTuple();
                    if (_Assertions.ENABLED && !bl2) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    AvailObject residue = deserializer22.deserialize();
                    boolean bl4 = bl = residue == null;
                    if (_Assertions.ENABLED && !bl) {
                        String string4 = "Assertion failed";
                        throw new AssertionError((Object)string4);
                    }
                }
                catch (MalformedSerialStreamException e) {
                    ProblemType deserializer22 = ProblemType.INTERNAL;
                    Object[] objectArray = new Object[]{this.$moduleName};
                    Object[] objectArray3 = objectArray;
                    Problem problem3 = new Problem(this.$moduleName, this.this$0, this.$completionAction, deserializer22, objectArray3){
                        final /* synthetic */ DocumentationTracer this$0;
                        final /* synthetic */ Function0<Unit> $completionAction;
                        {
                            this.this$0 = $receiver;
                            this.$completionAction = $completionAction;
                            super($moduleName, 1, 0L, $super_call_param$1, "Couldn''t deserialize comment tuple for module \"{0}\"", $super_call_param$2);
                        }

                        public void abortCompilation() {
                            this.this$0.getAvailBuilder().setStopBuildReason("Comment deserialization failed");
                            this.$completionAction.invoke();
                        }
                    };
                    this.$problemHandler.handle(problem3);
                    return;
                }
                ModuleHeader header = null;
                try {
                    input = IndexedFile.Companion.validatedBytesFrom(version.getModuleHeader());
                    deserializer22 = new Deserializer(input, this.this$0.getAvailBuilder().getRuntime(), null, 4, null);
                    header = new ModuleHeader(this.$moduleName);
                    header.deserializeHeaderFrom(deserializer22);
                }
                catch (MalformedSerialStreamException e) {
                    ProblemType problemType = ProblemType.INTERNAL;
                    Object[] objectArray = new Object[]{this.$moduleName};
                    Object[] objectArray4 = objectArray;
                    Problem problem4 = new Problem(this.$moduleName, this.this$0, this.$completionAction, problemType, objectArray4){
                        final /* synthetic */ DocumentationTracer this$0;
                        final /* synthetic */ Function0<Unit> $completionAction;
                        {
                            this.this$0 = $receiver;
                            this.$completionAction = $completionAction;
                            super($moduleName, 1, 0L, $super_call_param$1, "Couldn''t deserialize header for module \"{0}\"", $super_call_param$2);
                        }

                        public void abortCompilation() {
                            this.this$0.getAvailBuilder().setStopBuildReason("Module header deserialization failed when loading comments");
                            this.$completionAction.invoke();
                        }
                    };
                    this.$problemHandler.handle(problem4);
                    return;
                }
                DocumentationTracer.access$getGenerator$p(this.this$0).add(header, tuple2);
                this.$completionAction.invoke();
            }
        }, (Function2<? super ErrorCode, ? super Throwable, Unit>)new Function2<ErrorCode, Throwable, Unit>(moduleName2, problemHandler, this, completionAction){
            final /* synthetic */ ResolvedModuleName $moduleName;
            final /* synthetic */ ProblemHandler $problemHandler;
            final /* synthetic */ DocumentationTracer this$0;
            final /* synthetic */ Function0<Unit> $completionAction;
            {
                this.$moduleName = $moduleName;
                this.$problemHandler = $problemHandler;
                this.this$0 = $receiver;
                this.$completionAction = $completionAction;
                super(2);
            }

            public final void invoke(@NotNull ErrorCode code, @Nullable Throwable ex) {
                Intrinsics.checkNotNullParameter(code, "code");
                ProblemType problemType = ProblemType.TRACE;
                Object[] objectArray = new Object[3];
                objectArray[0] = this.$moduleName;
                objectArray[1] = code;
                Throwable throwable = ex;
                objectArray[2] = throwable != null ? (Serializable)throwable : (Serializable)((Object)"");
                Object[] objectArray2 = objectArray;
                Problem problem2 = new Problem(this.$moduleName, this.this$0, this.$completionAction, problemType, objectArray2){
                    final /* synthetic */ DocumentationTracer this$0;
                    final /* synthetic */ Function0<Unit> $completionAction;
                    {
                        this.this$0 = $receiver;
                        this.$completionAction = $completionAction;
                        super($moduleName, 1, 0L, $super_call_param$1, "Problem getting Module \"{0}\" to load comments: {1} - {2}", $super_call_param$2);
                    }

                    public void abortCompilation() {
                        this.this$0.getAvailBuilder().setStopBuildReason("Comment loading failed");
                        this.$completionAction.invoke();
                    }
                };
                this.$problemHandler.handle(problem2);
            }
        });
    }

    private final void scheduleLoadComments(ResolvedModuleName moduleName2, ProblemHandler problemHandler, Function0<Unit> completionAction) {
        if (this.availBuilder.getShouldStopBuild()) {
            completionAction.invoke();
            return;
        }
        this.availBuilder.getRuntime().execute(50, new Function0<Unit>(this, completionAction, moduleName2, problemHandler){
            final /* synthetic */ DocumentationTracer this$0;
            final /* synthetic */ Function0<Unit> $completionAction;
            final /* synthetic */ ResolvedModuleName $moduleName;
            final /* synthetic */ ProblemHandler $problemHandler;
            {
                this.this$0 = $receiver;
                this.$completionAction = $completionAction;
                this.$moduleName = $moduleName;
                this.$problemHandler = $problemHandler;
                super(0);
            }

            public final void invoke() {
                if (this.this$0.getAvailBuilder().getShouldStopBuild()) {
                    this.$completionAction.invoke();
                } else {
                    DocumentationTracer.access$loadComments(this.this$0, this.$moduleName, this.$problemHandler, this.$completionAction);
                }
            }
        });
    }

    public final void load(@NotNull ProblemHandler problemHandler) {
        Intrinsics.checkNotNullParameter(problemHandler, "problemHandler");
        this.availBuilder.getModuleGraph().parallelVisit((Function2<ResolvedModuleName, Function0<Unit>, Unit>)new Function2<ResolvedModuleName, Function0<? extends Unit>, Unit>(this, problemHandler){
            final /* synthetic */ DocumentationTracer this$0;
            final /* synthetic */ ProblemHandler $problemHandler;
            {
                this.this$0 = $receiver;
                this.$problemHandler = $problemHandler;
                super(2);
            }

            public final void invoke(@NotNull ResolvedModuleName moduleName2, @NotNull Function0<Unit> completionAction) {
                Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
                Intrinsics.checkNotNullParameter(completionAction, "completionAction");
                this.this$0.getAvailBuilder().getRuntime().execute(new AvailTask(50, new Function0<Unit>(this.this$0, moduleName2, this.$problemHandler, completionAction){
                    final /* synthetic */ DocumentationTracer this$0;
                    final /* synthetic */ ResolvedModuleName $moduleName;
                    final /* synthetic */ ProblemHandler $problemHandler;
                    final /* synthetic */ Function0<Unit> $completionAction;
                    {
                        this.this$0 = $receiver;
                        this.$moduleName = $moduleName;
                        this.$problemHandler = $problemHandler;
                        this.$completionAction = $completionAction;
                        super(0);
                    }

                    public final void invoke() {
                        DocumentationTracer.access$scheduleLoadComments(this.this$0, this.$moduleName, this.$problemHandler, this.$completionAction);
                    }
                }));
            }
        });
    }

    public final void generate(@NotNull ModuleName target, @NotNull ProblemHandler problemHandler) {
        Intrinsics.checkNotNullParameter(target, "target");
        Intrinsics.checkNotNullParameter(problemHandler, "problemHandler");
        try {
            this.generator.generate(this.availBuilder.getRuntime(), target);
        }
        catch (Exception e) {
            ProblemType problemType = ProblemType.TRACE;
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue(e.getLocalizedMessage(), "e.localizedMessage");
            Object[] objectArray2 = objectArray;
            Problem problem2 = new Problem(target, this, problemType, objectArray2){
                final /* synthetic */ DocumentationTracer this$0;
                {
                    this.this$0 = $receiver;
                    super($target, 1, 0L, $super_call_param$1, "Could not generate Stacks documentation: {0}", $super_call_param$2);
                }

                public void abortCompilation() {
                    this.this$0.getAvailBuilder().setStopBuildReason("Unable to generate Stacks documentation");
                }
            };
            problemHandler.handle(problem2);
        }
    }

    public static final /* synthetic */ StacksGenerator access$getGenerator$p(DocumentationTracer $this) {
        return $this.generator;
    }

    public static final /* synthetic */ void access$loadComments(DocumentationTracer $this, ResolvedModuleName moduleName2, ProblemHandler problemHandler, Function0 completionAction) {
        $this.loadComments(moduleName2, problemHandler, completionAction);
    }

    public static final /* synthetic */ void access$scheduleLoadComments(DocumentationTracer $this, ResolvedModuleName moduleName2, ProblemHandler problemHandler, Function0 completionAction) {
        $this.scheduleLoadComments(moduleName2, problemHandler, completionAction);
    }
}

