/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelOne;

import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.CompiledCodeDescriptor;
import avail.descriptor.methods.A_Method;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.AssignmentPhraseDescriptor;
import avail.descriptor.phrases.BlockPhraseDescriptor;
import avail.descriptor.phrases.DeclarationPhraseDescriptor;
import avail.descriptor.phrases.FirstOfSequencePhraseDescriptor;
import avail.descriptor.phrases.ListPhraseDescriptor;
import avail.descriptor.phrases.LiteralPhraseDescriptor;
import avail.descriptor.phrases.MarkerPhraseDescriptor;
import avail.descriptor.phrases.PermutedListPhraseDescriptor;
import avail.descriptor.phrases.ReferencePhraseDescriptor;
import avail.descriptor.phrases.SendPhraseDescriptor;
import avail.descriptor.phrases.SuperCastPhraseDescriptor;
import avail.descriptor.phrases.VariableUsePhraseDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.LiteralTokenDescriptor;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.ContinuationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.descriptor.variables.VariableDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.levelOne.L1OperationDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0018\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 J2\u00020\u0001:\u0002JKB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\u0015\u00105\u001a\u00020\u00062\u0006\u00106\u001a\u00020*H\u0000\u00a2\u0006\u0002\b7J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\tH\u0002J\r\u0010;\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b<J\u001b\u0010=\u001a\b\u0012\u0004\u0012\u00020\u00060>2\u0006\u0010?\u001a\u00020*H\u0000\u00a2\u0006\u0002\b@J\u0015\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\bDJ\u001d\u0010E\u001a\u00020\u00062\u0006\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020HH\u0000\u00a2\u0006\u0002\bIR\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u001e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\u0016\u0010\rR\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b&\u0010\rR\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001c\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b.\u0010\rR\u0014\u0010/\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0012R\u001a\u00101\u001a\b\u0012\u0004\u0012\u00020\u00060\u001eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010 R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006L"}, d2={"Lavail/interpreter/levelOne/L1Decompiler;", "", "code", "Lavail/descriptor/functions/A_RawFunction;", "outerDeclarations", "", "Lavail/descriptor/phrases/A_Phrase;", "tempGenerator", "Lkotlin/Function1;", "", "(Lavail/descriptor/functions/A_RawFunction;[Lavail/descriptor/phrases/A_Phrase;Lkotlin/jvm/functions/Function1;)V", "args", "getArgs$avail", "()[Lavail/descriptor/phrases/A_Phrase;", "[Lavail/descriptor/phrases/A_Phrase;", "<set-?>", "block", "getBlock$avail", "()Lavail/descriptor/phrases/A_Phrase;", "getCode$avail", "()Lavail/descriptor/functions/A_RawFunction;", "constants", "getConstants$avail", "endsWithPushNil", "", "getEndsWithPushNil$avail", "()Z", "setEndsWithPushNil$avail", "(Z)V", "expressionStack", "", "getExpressionStack$avail", "()Ljava/util/List;", "instructionDecoder", "Lavail/descriptor/functions/CompiledCodeDescriptor$L1InstructionDecoder;", "getInstructionDecoder$avail", "()Lavail/descriptor/functions/CompiledCodeDescriptor$L1InstructionDecoder;", "locals", "getLocals$avail", "mentionedLocals", "", "numNybbles", "", "getNumNybbles$avail", "()I", "outers", "getOuters$avail", "peekExpression", "getPeekExpression$avail", "statements", "getStatements$avail", "getTempGenerator$avail", "()Lkotlin/jvm/functions/Function1;", "argOrLocalOrConstant", "index", "argOrLocalOrConstant$avail", "createToken", "Lavail/descriptor/tokens/A_Token;", "prefix", "popExpression", "popExpression$avail", "popExpressions", "", "count", "popExpressions$avail", "pushExpression", "", "expression", "pushExpression$avail", "reconstructListWithSuperUnionType", "nArgs", "superUnionType", "Lavail/descriptor/types/A_Type;", "reconstructListWithSuperUnionType$avail", "Companion", "DecompilerDispatcher", "avail"})
public final class L1Decompiler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final A_RawFunction code;
    @NotNull
    private final Function1<String, String> tempGenerator;
    private final int numNybbles;
    @NotNull
    private final A_Phrase[] outers;
    @NotNull
    private final A_Phrase[] args;
    @NotNull
    private final A_Phrase[] locals;
    @NotNull
    private final boolean[] mentionedLocals;
    @NotNull
    private final A_Phrase[] constants;
    @NotNull
    private final CompiledCodeDescriptor.L1InstructionDecoder instructionDecoder;
    @NotNull
    private final List<A_Phrase> expressionStack;
    @NotNull
    private final List<A_Phrase> statements;
    private boolean endsWithPushNil;
    @NotNull
    private A_Phrase block;

    public L1Decompiler(@NotNull A_RawFunction code, @NotNull A_Phrase[] outerDeclarations, @NotNull Function1<? super String, String> tempGenerator) {
        Object prim;
        A_Token token;
        int n;
        Intrinsics.checkNotNullParameter(code, "code");
        Intrinsics.checkNotNullParameter(outerDeclarations, "outerDeclarations");
        Intrinsics.checkNotNullParameter(tempGenerator, "tempGenerator");
        this.code = code;
        this.tempGenerator = tempGenerator;
        this.numNybbles = A_RawFunction.Companion.getNumNybbles(this.code);
        this.outers = (A_Phrase[])outerDeclarations.clone();
        this.constants = new A_Phrase[A_RawFunction.Companion.getNumConstants(this.code)];
        this.instructionDecoder = new CompiledCodeDescriptor.L1InstructionDecoder();
        this.expressionStack = new ArrayList();
        this.statements = new ArrayList();
        this.code.setUpInstructionDecoder(this.instructionDecoder);
        this.instructionDecoder.pc(1);
        A_Type tupleType = A_Type.Companion.getArgsTupleType(this.code.functionType());
        int n2 = 0;
        int n3 = A_RawFunction.Companion.numArgs(this.code);
        A_Phrase[] a_PhraseArray = new A_Phrase[n3];
        L1Decompiler l1Decompiler = this;
        while (n2 < n3) {
            n = n2++;
            token = this.createToken("arg");
            a_PhraseArray[n] = DeclarationPhraseDescriptor.Companion.newArgument(token, A_Type.Companion.typeAtIndex(tupleType, n + 1), NilDescriptor.Companion.getNil());
        }
        l1Decompiler.args = a_PhraseArray;
        this.mentionedLocals = new boolean[A_RawFunction.Companion.getNumLocals(this.code)];
        n2 = 0;
        n3 = A_RawFunction.Companion.getNumLocals(this.code);
        a_PhraseArray = new A_Phrase[n3];
        l1Decompiler = this;
        while (n2 < n3) {
            A_Phrase declaration2;
            n = n2++;
            token = this.createToken("local");
            a_PhraseArray[n] = declaration2 = DeclarationPhraseDescriptor.Companion.newVariable(token, A_Type.Companion.getWriteType(A_RawFunction.Companion.localTypeAt(this.code, n + 1)), NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil());
        }
        l1Decompiler.locals = a_PhraseArray;
        Primitive primitive2 = this.code.codePrimitive();
        if (primitive2 != null) {
            prim = primitive2;
            boolean bl = false;
            if (!((Primitive)prim).hasFlag(Primitive.Flag.CannotFail)) {
                this.argOrLocalOrConstant$avail(this.args.length + 1);
            }
        }
        DecompilerDispatcher dispatcher = new DecompilerDispatcher();
        while (!this.instructionDecoder.atEnd()) {
            this.instructionDecoder.getOperation().dispatch(dispatcher);
        }
        if (this.numNybbles > 0) {
            int n4 = n3 = this.instructionDecoder.pc() == this.numNybbles + 1 ? 1 : 0;
            if (_Assertions.ENABLED && n3 == 0) {
                prim = "Assertion failed";
                throw new AssertionError(prim);
            }
            if (!this.endsWithPushNil) {
                this.statements.add(this.popExpression$avail());
            }
        }
        int n5 = n3 = this.expressionStack.size() == 0 ? 1 : 0;
        if (_Assertions.ENABLED && n3 == 0) {
            boolean $i$a$-assert-L1Decompiler$52 = false;
            String $i$a$-assert-L1Decompiler$52 = "There should be nothing on the stack after the final return";
            throw new AssertionError((Object)$i$a$-assert-L1Decompiler$52);
        }
        boolean[] $this$forEach$iv = this.mentionedLocals;
        boolean $i$f$forEach = false;
        int n6 = $this$forEach$iv.length;
        for (n = 0; n < n6; ++n) {
            boolean element$iv;
            boolean it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            if (!_Assertions.ENABLED || it) continue;
            boolean bl2 = false;
            String string2 = "Local constant was not mentioned";
            throw new AssertionError((Object)string2);
        }
        A_Phrase[] a_PhraseArray2 = this.args;
        this.block = BlockPhraseDescriptor.Companion.newBlockNode(ObjectTupleDescriptor.Companion.tupleFromArray(Arrays.copyOf(a_PhraseArray2, a_PhraseArray2.length)), this.code.codePrimitive(), ObjectTupleDescriptor.Companion.tupleFromList(this.statements), A_Type.Companion.getReturnType(this.code.functionType()), A_Type.Companion.getDeclaredExceptions(this.code.functionType()), 0, TupleDescriptor.Companion.getEmptyTuple());
    }

    @NotNull
    public final A_RawFunction getCode$avail() {
        return this.code;
    }

    @NotNull
    public final Function1<String, String> getTempGenerator$avail() {
        return this.tempGenerator;
    }

    public final int getNumNybbles$avail() {
        return this.numNybbles;
    }

    @NotNull
    public final A_Phrase[] getOuters$avail() {
        return this.outers;
    }

    @NotNull
    public final A_Phrase[] getArgs$avail() {
        return this.args;
    }

    @NotNull
    public final A_Phrase[] getLocals$avail() {
        return this.locals;
    }

    @NotNull
    public final A_Phrase[] getConstants$avail() {
        return this.constants;
    }

    @NotNull
    public final CompiledCodeDescriptor.L1InstructionDecoder getInstructionDecoder$avail() {
        return this.instructionDecoder;
    }

    @NotNull
    public final List<A_Phrase> getExpressionStack$avail() {
        return this.expressionStack;
    }

    @NotNull
    public final List<A_Phrase> getStatements$avail() {
        return this.statements;
    }

    public final boolean getEndsWithPushNil$avail() {
        return this.endsWithPushNil;
    }

    public final void setEndsWithPushNil$avail(boolean bl) {
        this.endsWithPushNil = bl;
    }

    @NotNull
    public final A_Phrase getBlock$avail() {
        return this.block;
    }

    @NotNull
    public final A_Phrase argOrLocalOrConstant$avail(int index2) {
        if (index2 <= this.args.length) {
            return this.args[index2 - 1];
        }
        if (index2 <= this.args.length + this.locals.length) {
            int localSubscript = index2 - this.args.length - 1;
            if (!this.mentionedLocals[localSubscript]) {
                this.mentionedLocals[localSubscript] = true;
                this.statements.add(this.locals[localSubscript]);
            }
            return this.locals[localSubscript];
        }
        int constSubscript = index2 - this.args.length - this.locals.length - 1;
        A_Phrase a_Phrase = this.constants[constSubscript];
        Intrinsics.checkNotNull(a_Phrase);
        return a_Phrase;
    }

    @NotNull
    public final A_Phrase getPeekExpression$avail() {
        return this.expressionStack.get(this.expressionStack.size() - 1);
    }

    @NotNull
    public final A_Phrase popExpression$avail() {
        return this.expressionStack.remove(this.expressionStack.size() - 1);
    }

    @NotNull
    public final List<A_Phrase> popExpressions$avail(int count) {
        List result2 = new ArrayList();
        Iterable $this$forEach$iv = new IntRange(1, count);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            result2.add(0, this.popExpression$avail());
        }
        return result2;
    }

    public final void pushExpression$avail(@NotNull A_Phrase expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        this.expressionStack.add(expression);
    }

    private final A_Token createToken(String prefix) {
        return TokenDescriptor.Companion.newToken(StringDescriptor.Companion.stringFrom(this.tempGenerator.invoke(prefix)), 0, 0, TokenDescriptor.TokenType.KEYWORD, NilDescriptor.Companion.getNil());
    }

    @NotNull
    public final A_Phrase reconstructListWithSuperUnionType$avail(int nArgs, @NotNull A_Type superUnionType) {
        Intrinsics.checkNotNullParameter(superUnionType, "superUnionType");
        A_Tuple permutationTuple = null;
        if (nArgs > 1 && this.getPeekExpression$avail().equals(MarkerPhraseDescriptor.MarkerTypes.PERMUTE.getMarker())) {
            this.popExpression$avail();
            A_Phrase permutationLiteral = this.popExpression$avail();
            boolean bl = A_Phrase.Companion.phraseKindIsUnder(permutationLiteral, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            permutationTuple = A_Phrase.Companion.getToken(permutationLiteral).literal();
        }
        List<A_Phrase> argsList = this.popExpressions$avail(nArgs);
        AvailObject listNode = ListPhraseDescriptor.Companion.newListNode(ObjectTupleDescriptor.Companion.tupleFromList(argsList));
        A_Phrase argsNode = permutationTuple != null ? PermutedListPhraseDescriptor.Companion.newPermutedListNode(listNode, permutationTuple) : (A_Phrase)listNode;
        return L1Decompiler.Companion.adjustSuperCastsIn(argsNode, superUnionType);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0017\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0016J\b\u0010\u0006\u001a\u00020\u0004H\u0016J\b\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u0004H\u0016J\b\u0010\u000f\u001a\u00020\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016J\b\u0010\u0013\u001a\u00020\u0004H\u0016J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u0015\u001a\u00020\u0004H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\b\u0010\u001a\u001a\u00020\u0004H\u0016\u00a8\u0006\u001b"}, d2={"Lavail/interpreter/levelOne/L1Decompiler$DecompilerDispatcher;", "Lavail/interpreter/levelOne/L1OperationDispatcher;", "(Lavail/interpreter/levelOne/L1Decompiler;)V", "L1Ext_doDuplicate", "", "L1Ext_doGetLiteral", "L1Ext_doPermute", "L1Ext_doPushLabel", "L1Ext_doSetLiteral", "L1Ext_doSetLocalSlot", "L1Ext_doSuperCall", "L1_doCall", "L1_doClose", "L1_doExtension", "L1_doGetLocal", "L1_doGetLocalClearing", "L1_doGetOuter", "L1_doGetOuterClearing", "L1_doMakeTuple", "L1_doPop", "L1_doPushLastLocal", "L1_doPushLastOuter", "L1_doPushLiteral", "L1_doPushLocal", "L1_doPushOuter", "L1_doSetLocal", "L1_doSetOuter", "avail"})
    public final class DecompilerDispatcher
    implements L1OperationDispatcher {
        @Override
        public void L1_doCall() {
            AvailObject bundle = A_RawFunction.Companion.literalAt(L1Decompiler.this.getCode$avail(), L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            AvailObject type2 = A_RawFunction.Companion.literalAt(L1Decompiler.this.getCode$avail(), L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
            int nArgs = A_Method.Companion.getNumArgs(method);
            A_Tuple permutationTuple = null;
            if (nArgs > 1 && L1Decompiler.this.getPeekExpression$avail().equals(MarkerPhraseDescriptor.MarkerTypes.PERMUTE.getMarker())) {
                L1Decompiler.this.popExpression$avail();
                A_Phrase permutationLiteral = L1Decompiler.this.popExpression$avail();
                boolean bl = A_Phrase.Companion.phraseKindIsUnder(permutationLiteral, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                permutationTuple = A_Phrase.Companion.getToken(permutationLiteral).literal();
            }
            A_Tuple argsTuple = ObjectTupleDescriptor.Companion.tupleFromList(L1Decompiler.this.popExpressions$avail(nArgs));
            A_Phrase listNode = ListPhraseDescriptor.Companion.newListNode(argsTuple);
            if (permutationTuple != null) {
                listNode = PermutedListPhraseDescriptor.Companion.newPermutedListNode(listNode, permutationTuple);
            }
            A_Phrase sendNode = SendPhraseDescriptor.Companion.newSendNode(TupleDescriptor.Companion.getEmptyTuple(), bundle, listNode, type2);
            L1Decompiler.this.pushExpression$avail(sendNode);
        }

        @Override
        public void L1_doPushLiteral() {
            AvailObject value = A_RawFunction.Companion.literalAt(L1Decompiler.this.getCode$avail(), L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            if (value.isInstanceOfKind(FunctionTypeDescriptor.Companion.mostGeneralFunctionType())) {
                int n = 0;
                int n2 = A_Function.Companion.getNumOuterVars(value);
                A_Phrase[] a_PhraseArray = new A_Phrase[n2];
                while (n < n2) {
                    int n3 = n++;
                    int i = n3 + 1;
                    AvailObject varObject = value.outerVarAt(i);
                    AvailObject token = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, StringDescriptor.Companion.stringFrom("OuterOfUncleanConstantFunction#" + i + " (with value " + varObject + ")"), 0, 0, varObject, NilDescriptor.Companion.getNil(), null, 32, null);
                    a_PhraseArray[n3] = LiteralPhraseDescriptor.Companion.literalNodeFromToken(token);
                }
                A_Phrase[] functionOuters = a_PhraseArray;
                L1Decompiler decompiler2 = new L1Decompiler(value.code(), functionOuters, L1Decompiler.this.getTempGenerator$avail());
                L1Decompiler.this.pushExpression$avail(decompiler2.getBlock$avail());
            } else if (value.isNil()) {
                boolean functionOuters;
                boolean bl = functionOuters = L1Decompiler.this.getInstructionDecoder$avail().pc() > L1Decompiler.this.getNumNybbles$avail();
                if (_Assertions.ENABLED && !functionOuters) {
                    boolean bl2 = false;
                    String string2 = "nil can only be (implicitly) pushed at the end of a sequence of statements";
                    throw new AssertionError((Object)string2);
                }
                L1Decompiler.this.setEndsWithPushNil$avail(true);
            } else {
                AvailObject token = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, StringDescriptor.Companion.stringFrom(value.toString()), 0, 0, value, NilDescriptor.Companion.getNil(), null, 32, null);
                L1Decompiler.this.pushExpression$avail(LiteralPhraseDescriptor.Companion.literalNodeFromToken(token));
            }
        }

        @Override
        public void L1_doPushLastLocal() {
            A_Phrase declaration2 = L1Decompiler.this.argOrLocalOrConstant$avail(L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            A_Phrase use = VariableUsePhraseDescriptor.Companion.newUse(A_Phrase.Companion.getToken(declaration2), declaration2);
            A_Phrase.Companion.setLastUse(use, true);
            if (declaration2.declarationKind().isVariable()) {
                L1Decompiler.this.pushExpression$avail(use);
            } else {
                L1Decompiler.this.pushExpression$avail(ReferencePhraseDescriptor.Companion.referenceNodeFromUse(use));
            }
        }

        @Override
        public void L1_doPushLocal() {
            A_Phrase declaration2 = L1Decompiler.this.argOrLocalOrConstant$avail(L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            A_Phrase use = VariableUsePhraseDescriptor.Companion.newUse(A_Phrase.Companion.getToken(declaration2), declaration2);
            if (declaration2.declarationKind().isVariable()) {
                L1Decompiler.this.pushExpression$avail(use);
            } else {
                L1Decompiler.this.pushExpression$avail(ReferencePhraseDescriptor.Companion.referenceNodeFromUse(use));
            }
        }

        @Override
        public void L1_doPushLastOuter() {
            this.L1_doPushOuter();
        }

        @Override
        public void L1_doClose() {
            int nOuters = L1Decompiler.this.getInstructionDecoder$avail().getOperand();
            AvailObject theCode = A_RawFunction.Companion.literalAt(L1Decompiler.this.getCode$avail(), L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            List<A_Phrase> theOuters = L1Decompiler.this.popExpressions$avail(nOuters);
            for (A_Phrase outer : theOuters) {
                boolean bl;
                PhraseTypeDescriptor.PhraseKind kind2 = A_Phrase.Companion.getPhraseKind(outer);
                boolean bl2 = bl = kind2 == PhraseTypeDescriptor.PhraseKind.VARIABLE_USE_PHRASE || kind2 == PhraseTypeDescriptor.PhraseKind.REFERENCE_PHRASE || kind2 == PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE;
                if (!_Assertions.ENABLED || bl) continue;
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_RawFunction a_RawFunction = theCode;
            Collection $this$toTypedArray$iv = theOuters;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            A_Phrase[] a_PhraseArray = thisCollection$iv.toArray(new A_Phrase[0]);
            Intrinsics.checkNotNull(a_PhraseArray, "null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            L1Decompiler decompiler2 = new L1Decompiler(a_RawFunction, a_PhraseArray, L1Decompiler.this.getTempGenerator$avail());
            L1Decompiler.this.pushExpression$avail(decompiler2.getBlock$avail());
        }

        @Override
        public void L1_doSetLocal() {
            int previousStatementCount = L1Decompiler.this.getStatements$avail().size();
            int indexInFrame = L1Decompiler.this.getInstructionDecoder$avail().getOperand();
            A_Phrase declaration2 = L1Decompiler.this.argOrLocalOrConstant$avail(indexInFrame);
            boolean bl = declaration2.declarationKind().isVariable();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (L1Decompiler.this.getStatements$avail().size() > previousStatementCount) {
                A_Phrase replacementDeclaration;
                boolean bl2 = bl = L1Decompiler.this.getStatements$avail().size() == previousStatementCount + 1;
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                boolean bl3 = bl = CollectionsKt.last(L1Decompiler.this.getStatements$avail()) == declaration2;
                if (_Assertions.ENABLED && !bl) {
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
                bl = A_Phrase.Companion.getInitializationExpression(declaration2).isNil();
                if (_Assertions.ENABLED && !bl) {
                    String string5 = "Assertion failed";
                    throw new AssertionError((Object)string5);
                }
                L1Decompiler.this.getLocals$avail()[indexInFrame - A_RawFunction.Companion.numArgs((A_RawFunction)L1Decompiler.this.getCode$avail()) - 1] = replacementDeclaration = DeclarationPhraseDescriptor.Companion.newVariable(A_Phrase.Companion.getToken(declaration2), A_Phrase.Companion.getDeclaredType(declaration2), A_Phrase.Companion.getTypeExpression(declaration2), L1Decompiler.this.popExpression$avail());
                L1Decompiler.this.getStatements$avail().set(L1Decompiler.this.getStatements$avail().size() - 1, replacementDeclaration);
                return;
            }
            A_Phrase valueNode = L1Decompiler.this.popExpression$avail();
            A_Phrase variableUse = VariableUsePhraseDescriptor.Companion.newUse(A_Phrase.Companion.getToken(declaration2), declaration2);
            A_Phrase assignmentNode = AssignmentPhraseDescriptor.Companion.newAssignment(variableUse, valueNode, TupleDescriptor.Companion.getEmptyTuple(), false);
            if (L1Decompiler.this.getExpressionStack$avail().isEmpty() || A_Phrase.Companion.getPhraseKind(L1Decompiler.this.getPeekExpression$avail()) != PhraseTypeDescriptor.PhraseKind.MARKER_PHRASE) {
                L1Decompiler.this.getStatements$avail().add(assignmentNode);
            } else {
                A_Phrase duplicateExpression = L1Decompiler.this.popExpression$avail();
                boolean bl4 = duplicateExpression.equals(MarkerPhraseDescriptor.MarkerTypes.DUP.getMarker());
                if (_Assertions.ENABLED && !bl4) {
                    String string6 = "Assertion failed";
                    throw new AssertionError((Object)string6);
                }
                L1Decompiler.this.getExpressionStack$avail().add(assignmentNode);
            }
        }

        @Override
        public void L1_doGetLocalClearing() {
            this.L1_doGetLocal();
        }

        @Override
        public void L1_doPushOuter() {
            L1Decompiler.this.pushExpression$avail(L1Decompiler.this.getOuters$avail()[L1Decompiler.this.getInstructionDecoder$avail().getOperand() - 1]);
        }

        @Override
        public void L1_doPop() {
            if (L1Decompiler.this.getExpressionStack$avail().size() == 1) {
                L1Decompiler.this.getStatements$avail().add(L1Decompiler.this.popExpression$avail());
            } else {
                A_Phrase lastExpression = L1Decompiler.this.popExpression$avail();
                A_Phrase penultimateExpression = L1Decompiler.this.popExpression$avail();
                A_Tuple newStatements = A_Phrase.Companion.getPhraseKind(penultimateExpression) == PhraseTypeDescriptor.PhraseKind.FIRST_OF_SEQUENCE_PHRASE ? A_Tuple.Companion.appendCanDestroy(A_Phrase.Companion.getStatements(penultimateExpression), lastExpression, false) : ObjectTupleDescriptor.Companion.tuple(penultimateExpression, lastExpression);
                L1Decompiler.this.pushExpression$avail(FirstOfSequencePhraseDescriptor.Companion.newFirstOfSequenceNode(newStatements));
            }
        }

        @Override
        public void L1_doGetOuterClearing() {
            this.L1_doGetOuter();
        }

        @Override
        public void L1_doSetOuter() {
            A_Phrase a_Phrase;
            A_Phrase outer = L1Decompiler.this.getOuters$avail()[L1Decompiler.this.getInstructionDecoder$avail().getOperand() - 1];
            if (A_Phrase.Companion.phraseKindIsUnder(outer, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
                A_Token token = A_Phrase.Companion.getToken(outer);
                AvailObject variableObject = token.literal();
                a_Phrase = DeclarationPhraseDescriptor.Companion.newModuleVariable(token, variableObject, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil());
            } else {
                boolean token = A_Phrase.Companion.phraseKindIsUnder(outer, PhraseTypeDescriptor.PhraseKind.VARIABLE_USE_PHRASE);
                if (_Assertions.ENABLED && !token) {
                    String variableObject = "Assertion failed";
                    throw new AssertionError((Object)variableObject);
                }
                a_Phrase = A_Phrase.Companion.getDeclaration(outer);
            }
            A_Phrase declaration2 = a_Phrase;
            A_Phrase use = VariableUsePhraseDescriptor.Companion.newUse(A_Phrase.Companion.getToken(declaration2), declaration2);
            A_Phrase valueExpr = L1Decompiler.this.popExpression$avail();
            A_Phrase assignmentNode = AssignmentPhraseDescriptor.Companion.newAssignment(use, valueExpr, TupleDescriptor.Companion.getEmptyTuple(), false);
            if (L1Decompiler.this.getExpressionStack$avail().isEmpty()) {
                L1Decompiler.this.getStatements$avail().add(assignmentNode);
            } else {
                A_Phrase duplicateExpression = L1Decompiler.this.popExpression$avail();
                boolean bl = duplicateExpression.equals(MarkerPhraseDescriptor.MarkerTypes.DUP.getMarker());
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                L1Decompiler.this.getExpressionStack$avail().add(assignmentNode);
            }
        }

        @Override
        public void L1_doGetLocal() {
            A_Phrase localDeclaration = L1Decompiler.this.argOrLocalOrConstant$avail(L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            boolean bl = localDeclaration.declarationKind().isVariable();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Phrase useNode = VariableUsePhraseDescriptor.Companion.newUse(A_Phrase.Companion.getToken(localDeclaration), localDeclaration);
            L1Decompiler.this.pushExpression$avail(useNode);
        }

        @Override
        public void L1_doMakeTuple() {
            int count = L1Decompiler.this.getInstructionDecoder$avail().getOperand();
            A_Tuple permutationTuple = null;
            if (count > 1 && L1Decompiler.this.getPeekExpression$avail().equals(MarkerPhraseDescriptor.MarkerTypes.PERMUTE.getMarker())) {
                L1Decompiler.this.popExpression$avail();
                A_Phrase permutationLiteral = L1Decompiler.this.popExpression$avail();
                boolean bl = A_Phrase.Companion.phraseKindIsUnder(permutationLiteral, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                permutationTuple = A_Phrase.Companion.getToken(permutationLiteral).literal();
            }
            List<A_Phrase> expressions = L1Decompiler.this.popExpressions$avail(count);
            A_Phrase listNode = ListPhraseDescriptor.Companion.newListNode(ObjectTupleDescriptor.Companion.tupleFromList(expressions));
            if (permutationTuple != null) {
                listNode = PermutedListPhraseDescriptor.Companion.newPermutedListNode(listNode, permutationTuple);
            }
            L1Decompiler.this.pushExpression$avail(listNode);
        }

        @Override
        public void L1_doGetOuter() {
            A_Phrase outer = L1Decompiler.this.getOuters$avail()[L1Decompiler.this.getInstructionDecoder$avail().getOperand() - 1];
            if (A_Phrase.Companion.phraseKindIsUnder(outer, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE)) {
                L1Decompiler.this.pushExpression$avail(outer);
                return;
            }
            boolean bl = A_Phrase.Companion.phraseKindIsUnder(outer, PhraseTypeDescriptor.PhraseKind.VARIABLE_USE_PHRASE);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Phrase declaration2 = A_Phrase.Companion.getDeclaration(outer);
            A_Phrase use = VariableUsePhraseDescriptor.Companion.newUse(A_Phrase.Companion.getToken(declaration2), declaration2);
            L1Decompiler.this.pushExpression$avail(use);
        }

        @Override
        public void L1_doExtension() {
            if (_Assertions.ENABLED) {
                boolean bl = false;
                String string2 = "Illegal dispatch nybblecode";
                throw new AssertionError((Object)string2);
            }
        }

        @Override
        public void L1Ext_doPushLabel() {
            A_Phrase a_Phrase;
            if (L1Decompiler.this.getStatements$avail().size() > 0 && L1Decompiler.this.getStatements$avail().get(0).isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.LABEL_PHRASE.getMostGeneralType())) {
                a_Phrase = L1Decompiler.this.getStatements$avail().get(0);
            } else {
                A_Phrase a_Phrase2 = DeclarationPhraseDescriptor.Companion.newLabel(L1Decompiler.this.createToken("label"), NilDescriptor.Companion.getNil(), ContinuationTypeDescriptor.Companion.continuationTypeForFunctionType(L1Decompiler.this.getCode$avail().functionType()));
                L1Decompiler l1Decompiler = L1Decompiler.this;
                A_Phrase it = a_Phrase2;
                boolean bl = false;
                l1Decompiler.getStatements$avail().add(0, it);
                a_Phrase = a_Phrase2;
            }
            A_Phrase label = a_Phrase;
            L1Decompiler.this.pushExpression$avail(VariableUsePhraseDescriptor.Companion.newUse(A_Phrase.Companion.getToken(label), label));
        }

        @Override
        public void L1Ext_doGetLiteral() {
            A_Token globalToken = L1Decompiler.this.createToken("SomeGlobal");
            AvailObject globalVar = A_RawFunction.Companion.literalAt(L1Decompiler.this.getCode$avail(), L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            A_Phrase declaration2 = DeclarationPhraseDescriptor.Companion.newModuleVariable(globalToken, globalVar, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil());
            L1Decompiler.this.pushExpression$avail(VariableUsePhraseDescriptor.Companion.newUse(globalToken, declaration2));
        }

        @Override
        public void L1Ext_doSetLiteral() {
            A_Token globalToken = L1Decompiler.this.createToken("SomeGlobal");
            AvailObject globalVar = A_RawFunction.Companion.literalAt(L1Decompiler.this.getCode$avail(), L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            A_Phrase declaration2 = DeclarationPhraseDescriptor.Companion.newModuleVariable(globalToken, globalVar, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil());
            A_Phrase varUse = VariableUsePhraseDescriptor.Companion.newUse(globalToken, declaration2);
            A_Phrase assignmentNode = AssignmentPhraseDescriptor.Companion.newAssignment(varUse, L1Decompiler.this.popExpression$avail(), TupleDescriptor.Companion.getEmptyTuple(), false);
            if (L1Decompiler.this.getExpressionStack$avail().isEmpty()) {
                L1Decompiler.this.getStatements$avail().add(assignmentNode);
            } else {
                A_Phrase duplicateExpression = L1Decompiler.this.popExpression$avail();
                boolean bl = duplicateExpression.equals(MarkerPhraseDescriptor.MarkerTypes.DUP.getMarker());
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                L1Decompiler.this.getExpressionStack$avail().add(assignmentNode);
            }
        }

        @Override
        public void L1Ext_doDuplicate() {
            A_Phrase rightSide = L1Decompiler.this.popExpression$avail();
            L1Decompiler.this.pushExpression$avail(MarkerPhraseDescriptor.MarkerTypes.DUP.getMarker());
            L1Decompiler.this.pushExpression$avail(rightSide);
        }

        @Override
        public void L1Ext_doPermute() {
            AvailObject permutation = A_RawFunction.Companion.literalAt(L1Decompiler.this.getCode$avail(), L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            L1Decompiler.this.pushExpression$avail(LiteralPhraseDescriptor.Companion.syntheticLiteralNodeFor$default(LiteralPhraseDescriptor.Companion, permutation, null, null, 6, null));
            L1Decompiler.this.pushExpression$avail(MarkerPhraseDescriptor.MarkerTypes.PERMUTE.getMarker());
        }

        @Override
        public void L1Ext_doSuperCall() {
            AvailObject bundle = A_RawFunction.Companion.literalAt(L1Decompiler.this.getCode$avail(), L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            AvailObject type2 = A_RawFunction.Companion.literalAt(L1Decompiler.this.getCode$avail(), L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            AvailObject superUnionType = A_RawFunction.Companion.literalAt(L1Decompiler.this.getCode$avail(), L1Decompiler.this.getInstructionDecoder$avail().getOperand());
            A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
            int nArgs = A_Method.Companion.getNumArgs(method);
            A_Phrase argsNode = L1Decompiler.this.reconstructListWithSuperUnionType$avail(nArgs, superUnionType);
            A_Phrase sendNode = SendPhraseDescriptor.Companion.newSendNode(TupleDescriptor.Companion.getEmptyTuple(), bundle, argsNode, type2);
            L1Decompiler.this.pushExpression$avail(sendNode);
        }

        @Override
        public void L1Ext_doSetLocalSlot() {
            A_Phrase constantDeclaration;
            int constSubscript = L1Decompiler.this.getInstructionDecoder$avail().getOperand() - A_RawFunction.Companion.numArgs(L1Decompiler.this.getCode$avail()) - A_RawFunction.Companion.getNumLocals(L1Decompiler.this.getCode$avail()) - 1;
            A_Token token = L1Decompiler.this.createToken("const");
            L1Decompiler.this.getConstants$avail()[constSubscript] = constantDeclaration = DeclarationPhraseDescriptor.Companion.newConstant(token, L1Decompiler.this.popExpression$avail());
            L1Decompiler.this.getStatements$avail().add(constantDeclaration);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002\u00a8\u0006\u000f"}, d2={"Lavail/interpreter/levelOne/L1Decompiler$Companion;", "", "()V", "adjustSuperCastsIn", "Lavail/descriptor/phrases/A_Phrase;", "phrase", "superUnionType", "Lavail/descriptor/types/A_Type;", "decompile", "code", "Lavail/descriptor/functions/A_RawFunction;", "outerPhraseForDecompiler", "outerIndex", "", "type", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final A_Phrase adjustSuperCastsIn(A_Phrase phrase, A_Type superUnionType) {
            if (superUnionType.isBottom()) {
                return phrase;
            }
            if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.PERMUTED_LIST_PHRASE)) {
                A_Tuple permutation = A_Phrase.Companion.getPermutation(phrase);
                A_Phrase list2 = A_Phrase.Companion.getList(phrase);
                int size = A_Phrase.Companion.getExpressionsSize(list2);
                int n = 0;
                A_Phrase[] a_PhraseArray = new A_Phrase[size];
                while (n < size) {
                    int n2 = n++;
                    a_PhraseArray[n2] = NilDescriptor.Companion.getNil();
                }
                A_Phrase[] outputArray = a_PhraseArray;
                int i = 1;
                if (i <= size) {
                    while (true) {
                        int permutedIndex = A_Tuple.Companion.tupleIntAt(permutation, i);
                        outputArray[permutedIndex - 1] = this.adjustSuperCastsIn(A_Phrase.Companion.expressionAt(list2, permutedIndex), A_Type.Companion.typeAtIndex(superUnionType, i));
                        if (i == size) break;
                        ++i;
                    }
                }
                return PermutedListPhraseDescriptor.Companion.newPermutedListNode(ListPhraseDescriptor.Companion.newListNode(ObjectTupleDescriptor.Companion.tupleFromArray(Arrays.copyOf(outputArray, outputArray.length))), permutation);
            }
            if (A_Phrase.Companion.phraseKindIsUnder(phrase, PhraseTypeDescriptor.PhraseKind.LIST_PHRASE)) {
                return ListPhraseDescriptor.Companion.newListNode(ObjectTupleDescriptor.Companion.generateObjectTupleFrom(A_Phrase.Companion.getExpressionsSize(phrase), (Function1<? super Integer, ? extends A_BasicObject>)new Function1<Integer, A_BasicObject>(phrase, superUnionType){
                    final /* synthetic */ A_Phrase $phrase;
                    final /* synthetic */ A_Type $superUnionType;
                    {
                        this.$phrase = $phrase;
                        this.$superUnionType = $superUnionType;
                        super(1);
                    }

                    @NotNull
                    public final A_BasicObject invoke(int it) {
                        return avail.interpreter.levelOne.L1Decompiler$Companion.access$adjustSuperCastsIn(L1Decompiler.Companion, A_Phrase.Companion.expressionAt(this.$phrase, it), A_Type.Companion.typeAtIndex(this.$superUnionType, it));
                    }
                }));
            }
            return SuperCastPhraseDescriptor.Companion.newSuperCastNode(phrase, superUnionType);
        }

        private final A_Phrase outerPhraseForDecompiler(int outerIndex, A_Type type2) {
            A_String name = StringDescriptor.Companion.stringFrom("Outer#" + outerIndex);
            AvailObject variable = VariableDescriptor.Companion.newVariableWithOuterType$default(VariableDescriptor.Companion, VariableTypeDescriptor.Companion.variableTypeFor(type2), null, 2, null);
            AvailObject token = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, name, 0, 0, variable, NilDescriptor.Companion.getNil(), null, 32, null);
            return LiteralPhraseDescriptor.Companion.fromTokenForDecompiler(token);
        }

        @NotNull
        public final A_Phrase decompile(@NotNull A_RawFunction code) {
            Intrinsics.checkNotNullParameter(code, "code");
            Map counts = new LinkedHashMap();
            int outerCount = A_RawFunction.Companion.getNumOuters(code);
            int n = 0;
            A_Phrase[] a_PhraseArray = new A_Phrase[outerCount];
            while (n < outerCount) {
                int n2 = n++;
                int i = n2 + 1;
                a_PhraseArray[n2] = Companion.outerPhraseForDecompiler(i, A_RawFunction.Companion.outerTypeAt(code, i));
            }
            A_Phrase[] functionOuters = a_PhraseArray;
            L1Decompiler decompiler2 = new L1Decompiler(code, functionOuters, (Function1<? super String, String>)new Function1<String, String>((Map<String, Integer>)counts){
                final /* synthetic */ Map<String, Integer> $counts;
                {
                    this.$counts = $counts;
                    super(1);
                }

                @NotNull
                public final String invoke(@NotNull String it) {
                    Integer newCount;
                    Intrinsics.checkNotNullParameter(it, "it");
                    Integer n = newCount = this.$counts.get(it);
                    newCount = n == null ? Integer.valueOf(1) : Integer.valueOf(n + 1);
                    this.$counts.put(it, newCount);
                    return it + newCount;
                }
            });
            return decompiler2.getBlock$avail();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

