/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.jvm.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ReceiverParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DescriptorBasedTypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactoryImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MethodSignatureBuildingUtilsKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.SignatureBuildingComponents;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MethodSignatureMappingKt {
    @NotNull
    public static final String computeJvmDescriptor(@NotNull FunctionDescriptor $this$computeJvmDescriptor, boolean withReturnType, boolean withName) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$computeJvmDescriptor, "<this>");
        StringBuilder $this$computeJvmDescriptor_u24lambda_u2d1 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (withName) {
            String string2;
            if ($this$computeJvmDescriptor instanceof ConstructorDescriptor) {
                string2 = "<init>";
            } else {
                String string3 = $this$computeJvmDescriptor.getName().asString();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "name.asString()");
            }
            $this$computeJvmDescriptor_u24lambda_u2d1.append(string2);
        }
        $this$computeJvmDescriptor_u24lambda_u2d1.append("(");
        ReceiverParameterDescriptor receiverParameterDescriptor = $this$computeJvmDescriptor.getExtensionReceiverParameter();
        if (receiverParameterDescriptor != null) {
            ReceiverParameterDescriptor it = receiverParameterDescriptor;
            boolean bl2 = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "it.type");
            MethodSignatureMappingKt.appendErasedType($this$computeJvmDescriptor_u24lambda_u2d1, kotlinType);
        }
        for (ValueParameterDescriptor parameter : $this$computeJvmDescriptor.getValueParameters()) {
            KotlinType kotlinType = parameter.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "parameter.type");
            MethodSignatureMappingKt.appendErasedType($this$computeJvmDescriptor_u24lambda_u2d1, kotlinType);
        }
        $this$computeJvmDescriptor_u24lambda_u2d1.append(")");
        if (withReturnType) {
            if (DescriptorBasedTypeSignatureMappingKt.hasVoidReturnType($this$computeJvmDescriptor)) {
                $this$computeJvmDescriptor_u24lambda_u2d1.append("V");
            } else {
                KotlinType kotlinType = $this$computeJvmDescriptor.getReturnType();
                Intrinsics.checkNotNull(kotlinType);
                MethodSignatureMappingKt.appendErasedType($this$computeJvmDescriptor_u24lambda_u2d1, kotlinType);
            }
        }
        String string4 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string4, "StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    public static /* synthetic */ String computeJvmDescriptor$default(FunctionDescriptor functionDescriptor, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            bl2 = true;
        }
        return MethodSignatureMappingKt.computeJvmDescriptor(functionDescriptor, bl, bl2);
    }

    public static final boolean forceSingleValueParameterBoxing(@NotNull CallableDescriptor f) {
        Intrinsics.checkNotNullParameter(f, "f");
        if (!(f instanceof FunctionDescriptor)) {
            return false;
        }
        if (!Intrinsics.areEqual(((FunctionDescriptor)f).getName().asString(), "remove") || ((FunctionDescriptor)f).getValueParameters().size() != 1 || SpecialBuiltinMembers.isFromJavaOrBuiltins((CallableMemberDescriptor)f)) {
            return false;
        }
        List<ValueParameterDescriptor> list2 = ((FunctionDescriptor)f).getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list2, "f.original.valueParameters");
        KotlinType kotlinType = CollectionsKt.single(list2).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "f.original.valueParameters.single().type");
        JvmType jvmType = MethodSignatureMappingKt.mapToJvmType(kotlinType);
        JvmType.Primitive primitive2 = jvmType instanceof JvmType.Primitive ? (JvmType.Primitive)jvmType : null;
        if ((primitive2 != null ? primitive2.getJvmPrimitiveType() : null) != JvmPrimitiveType.INT) {
            return false;
        }
        FunctionDescriptor functionDescriptor = BuiltinMethodsWithSpecialGenericSignature.getOverriddenBuiltinFunctionWithErasedValueParametersInJava((FunctionDescriptor)f);
        if (functionDescriptor == null) {
            return false;
        }
        FunctionDescriptor overridden = functionDescriptor;
        List<ValueParameterDescriptor> list3 = overridden.getOriginal().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list3, "overridden.original.valueParameters");
        KotlinType kotlinType2 = CollectionsKt.single(list3).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "overridden.original.valueParameters.single().type");
        JvmType overriddenParameterType = MethodSignatureMappingKt.mapToJvmType(kotlinType2);
        DeclarationDescriptor declarationDescriptor = overridden.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "overridden.containingDeclaration");
        return Intrinsics.areEqual(DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor), StandardNames.FqNames.mutableCollection.toUnsafe()) && overriddenParameterType instanceof JvmType.Object && Intrinsics.areEqual(((JvmType.Object)overriddenParameterType).getInternalName(), "java/lang/Object");
    }

    @Nullable
    public static final String computeJvmSignature(@NotNull CallableDescriptor $this$computeJvmSignature) {
        Intrinsics.checkNotNullParameter($this$computeJvmSignature, "<this>");
        boolean $i$f$signatures = false;
        SignatureBuildingComponents $this$computeJvmSignature_u24lambda_u2d2 = SignatureBuildingComponents.INSTANCE;
        boolean bl = false;
        if (DescriptorUtils.isLocal($this$computeJvmSignature)) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = $this$computeJvmSignature.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (classDescriptor2.getName().isSpecial()) {
            return null;
        }
        declarationDescriptor = $this$computeJvmSignature.getOriginal();
        SimpleFunctionDescriptor simpleFunctionDescriptor = declarationDescriptor instanceof SimpleFunctionDescriptor ? (SimpleFunctionDescriptor)declarationDescriptor : null;
        if (simpleFunctionDescriptor == null) {
            return null;
        }
        return MethodSignatureBuildingUtilsKt.signature($this$computeJvmSignature_u24lambda_u2d2, classDescriptor2, MethodSignatureMappingKt.computeJvmDescriptor$default(simpleFunctionDescriptor, false, false, 3, null));
    }

    @NotNull
    public static final String getInternalName(@NotNull ClassDescriptor $this$internalName) {
        Intrinsics.checkNotNullParameter($this$internalName, "<this>");
        FqNameUnsafe fqNameUnsafe = DescriptorUtilsKt.getFqNameSafe($this$internalName).toUnsafe();
        Intrinsics.checkNotNullExpressionValue(fqNameUnsafe, "fqNameSafe.toUnsafe()");
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId != null) {
            ClassId it = classId;
            boolean bl = false;
            String string2 = JvmClassName.byClassId(it).getInternalName();
            Intrinsics.checkNotNullExpressionValue(string2, "byClassId(it).internalName");
            return string2;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName$default($this$internalName, null, 2, null);
    }

    private static final void appendErasedType(StringBuilder $this$appendErasedType, KotlinType type2) {
        $this$appendErasedType.append(MethodSignatureMappingKt.mapToJvmType(type2));
    }

    @NotNull
    public static final JvmType mapToJvmType(@NotNull KotlinType $this$mapToJvmType) {
        Intrinsics.checkNotNullParameter($this$mapToJvmType, "<this>");
        return (JvmType)DescriptorBasedTypeSignatureMappingKt.mapType$default($this$mapToJvmType, JvmTypeFactoryImpl.INSTANCE, TypeMappingMode.DEFAULT, TypeMappingConfigurationImpl.INSTANCE, null, null, 32, null);
    }
}

