/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operand;

import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2OperandDispatcher;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadOperand;
import avail.interpreter.levelTwo.operand.L2ReadVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteOperand;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2ValueManifest;
import avail.utility.PublicCloneable;
import avail.utility.Strings;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001a\u0010\u0016\u001a\u00020\u00122\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u0014H\u0016J\u0016\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016J\u001a\u0010\u001b\u001a\u00020\u00122\u0010\u0010\u001c\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u0014H\u0016J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0004H\u0017J\u0014\u0010 \u001a\u00020\u00122\n\u0010!\u001a\u00060\"j\u0002`#H&J.\u0010$\u001a\u00020\u00122\n\u0010!\u001a\u00060\"j\u0002`#2\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00120(J\b\u0010)\u001a\u00020\u0012H\u0017J\u0010\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H&J\u0010\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020/H\u0017J\u0010\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u0004H\u0017J\b\u00102\u001a\u00020\u0012H\u0017J\b\u00103\u001a\u00020\u0012H\u0016J$\u00104\u001a\u00020\u00122\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015062\u0006\u0010\u001f\u001a\u00020\u0004H\u0016J\u0012\u00107\u001a\u00020\u00122\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u00108\u001a\u000209H\u0016J$\u0010:\u001a\u00020\u00002\u001a\u0010;\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180(H\u0016R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0012\u0010\r\u001a\u00020\u000eX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006<"}, d2={"Lavail/interpreter/levelTwo/operand/L2Operand;", "Lavail/utility/PublicCloneable;", "()V", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "getInstruction", "()Lavail/interpreter/levelTwo/L2Instruction;", "instructionHasBeenEmitted", "", "getInstructionHasBeenEmitted", "()Z", "instructionOrNull", "isMisconnected", "operandType", "Lavail/interpreter/levelTwo/L2OperandType;", "getOperandType", "()Lavail/interpreter/levelTwo/L2OperandType;", "addDestinationRegistersTo", "", "destinationRegisters", "", "Lavail/interpreter/levelTwo/register/L2Register;", "addReadsTo", "readOperands", "Lavail/interpreter/levelTwo/operand/L2ReadOperand;", "addSourceRegistersTo", "sourceRegisters", "addWritesTo", "writeOperands", "Lavail/interpreter/levelTwo/operand/L2WriteOperand;", "adjustCloneForInstruction", "theInstruction", "appendTo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "appendWithWarningsTo", "indent", "", "warningStyleChange", "Lkotlin/Function1;", "assertHasBeenEmitted", "dispatchOperand", "dispatcher", "Lavail/interpreter/levelTwo/L2OperandDispatcher;", "instructionWasAdded", "manifest", "Lavail/optimizer/L2ValueManifest;", "instructionWasInserted", "newInstruction", "instructionWasRemoved", "postOptimizationCleanup", "replaceRegisters", "registerRemap", "", "setInstruction", "toString", "", "transformEachRead", "transformer", "avail"})
public abstract class L2Operand
extends PublicCloneable<L2Operand> {
    @Nullable
    private L2Instruction instructionOrNull;

    @NotNull
    public final L2Instruction getInstruction() {
        L2Instruction l2Instruction = this.instructionOrNull;
        Intrinsics.checkNotNull((Object)l2Instruction);
        return l2Instruction;
    }

    public final boolean getInstructionHasBeenEmitted() {
        return this.instructionOrNull != null;
    }

    @OverridingMethodsMustInvokeSuper
    public void assertHasBeenEmitted() {
        boolean bl;
        boolean bl2 = bl = this.instructionOrNull != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public abstract L2OperandType getOperandType();

    public abstract void dispatchOperand(@NotNull L2OperandDispatcher var1);

    @OverridingMethodsMustInvokeSuper
    public void instructionWasAdded(@NotNull L2ValueManifest manifest2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)manifest2, (String)"manifest");
        boolean bl2 = bl = this.instructionOrNull != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    @OverridingMethodsMustInvokeSuper
    public void instructionWasInserted(@NotNull L2Instruction newInstruction) {
        Intrinsics.checkNotNullParameter((Object)newInstruction, (String)"newInstruction");
    }

    @OverridingMethodsMustInvokeSuper
    public void instructionWasRemoved() {
    }

    public void replaceRegisters(@NotNull Map<L2Register, ? extends L2Register> registerRemap, @NotNull L2Instruction theInstruction) {
        Intrinsics.checkNotNullParameter(registerRemap, (String)"registerRemap");
        Intrinsics.checkNotNullParameter((Object)theInstruction, (String)"theInstruction");
    }

    @NotNull
    public L2Operand transformEachRead(@NotNull Function1<? super L2ReadOperand<?>, ? extends L2ReadOperand<?>> transformer) {
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        return this;
    }

    public void addReadsTo(@NotNull List<L2ReadOperand<?>> readOperands) {
        Intrinsics.checkNotNullParameter(readOperands, (String)"readOperands");
    }

    public void addWritesTo(@NotNull List<L2WriteOperand<?>> writeOperands) {
        Intrinsics.checkNotNullParameter(writeOperands, (String)"writeOperands");
    }

    public void addSourceRegistersTo(@NotNull List<L2Register> sourceRegisters) {
        Intrinsics.checkNotNullParameter(sourceRegisters, (String)"sourceRegisters");
    }

    public void addDestinationRegistersTo(@NotNull List<L2Register> destinationRegisters) {
        Intrinsics.checkNotNullParameter(destinationRegisters, (String)"destinationRegisters");
    }

    @NotNull
    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        this.appendWithWarningsTo(builder2, 0, (Function1<? super Boolean, Unit>)((Function1)toString.1.INSTANCE));
        String string2 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
        return string2;
    }

    public final void appendWithWarningsTo(@NotNull StringBuilder builder2, int indent, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        if (this.instructionOrNull == null) {
            warningStyleChange.invoke((Object)true);
            builder2.append("DEAD-OPERAND: ");
            warningStyleChange.invoke((Object)false);
        } else if (this.isMisconnected()) {
            warningStyleChange.invoke((Object)true);
            builder2.append("MISCONNECTED: ");
            warningStyleChange.invoke((Object)false);
        }
        StringBuilder temp = new StringBuilder();
        this.appendTo(temp);
        String string2 = temp.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"temp.toString()");
        builder2.append(Strings.INSTANCE.increaseIndentation(string2, indent));
    }

    public final boolean isMisconnected() {
        if (this.instructionOrNull == null) {
            return true;
        }
        L2Instruction l2Instruction = this.instructionOrNull;
        Intrinsics.checkNotNull((Object)l2Instruction);
        Object[] operands = l2Instruction.getOperands();
        Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((Object[])operands);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            Object operand = operands[i];
            if (Intrinsics.areEqual((Object)operand, (Object)this)) {
                return false;
            }
            if (!(operand instanceof L2PcVectorOperand ? CollectionsKt.contains((Iterable)((L2PcVectorOperand)operand).getEdges(), (Object)this) : operand instanceof L2ReadVectorOperand && CollectionsKt.contains((Iterable)((L2ReadVectorOperand)operand).getElements(), (Object)this))) continue;
            return false;
        }
        return true;
    }

    public abstract void appendTo(@NotNull StringBuilder var1);

    @OverridingMethodsMustInvokeSuper
    public void adjustCloneForInstruction(@NotNull L2Instruction theInstruction) {
        Intrinsics.checkNotNullParameter((Object)theInstruction, (String)"theInstruction");
        this.setInstruction(null);
    }

    public void setInstruction(@Nullable L2Instruction theInstruction) {
        this.instructionOrNull = theInstruction;
    }

    public void postOptimizationCleanup() {
    }
}

