/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.style;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/style/P_StyleToken;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_StyleToken
extends Primitive {
    @NotNull
    public static final P_StyleToken INSTANCE = new P_StyleToken();

    private P_StyleToken() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.WritesToHiddenGlobalState};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        String styleOrNull;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(3);
        A_Token token = interpreter.argument(0);
        A_String styleName = interpreter.argument(1);
        boolean overwrite = A_Atom.Companion.getExtractBoolean(interpreter.argument(2));
        A_Fiber fiber2 = interpreter.fiber();
        if (!A_Fiber.Companion.getCanStyle(fiber2)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_STYLE);
        }
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(fiber2);
        Intrinsics.checkNotNull((Object)availLoader);
        AvailLoader loader = availLoader;
        A_Token innerToken = token.tokenType() == TokenDescriptor.TokenType.LITERAL && token.literal().isInstanceOf(PrimitiveTypeDescriptor.Types.TOKEN.getO()) ? (A_Token)token.literal() : token;
        int start = innerToken.start();
        int pastEnd = A_Token.Companion.pastEnd(innerToken);
        if (start == pastEnd) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        String string2 = styleOrNull = A_Tuple.Companion.getTupleSize(styleName) == 0 ? null : styleName.asNativeString();
        if (styleOrNull == null && !overwrite) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        AvailLoader.styleToken$default(loader, innerToken, styleOrNull, overwrite, null, 8, null);
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_STYLE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.TOKEN.getO(), TupleTypeDescriptor.Companion.getStringType(), EnumerationTypeDescriptor.Companion.getBooleanType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

