/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer;

import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.character.A_Character;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.methods.A_ChunkDependable;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.DoubleDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ByteTupleDescriptor;
import avail.descriptor.tuples.IntTupleDescriptor;
import avail.descriptor.tuples.LongTupleDescriptor;
import avail.descriptor.tuples.NybbleTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.levelTwo.L2Chunk;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.interpreter.levelTwo.L2OperandDispatcher;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ArbitraryConstantOperand;
import avail.interpreter.levelTwo.operand.L2CommentOperand;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2FloatImmediateOperand;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2PcVectorOperand;
import avail.interpreter.levelTwo.operand.L2PrimitiveOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadFloatOperand;
import avail.interpreter.levelTwo.operand.L2ReadFloatVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadOperand;
import avail.interpreter.levelTwo.operand.L2ReadVectorOperand;
import avail.interpreter.levelTwo.operand.L2SelectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteFloatOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_BOX_FLOAT;
import avail.interpreter.levelTwo.operation.L2_BOX_INT;
import avail.interpreter.levelTwo.operation.L2_CREATE_TUPLE;
import avail.interpreter.levelTwo.operation.L2_FUNCTION_PARAMETER_TYPE;
import avail.interpreter.levelTwo.operation.L2_GET_TYPE;
import avail.interpreter.levelTwo.operation.L2_JUMP;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_COMPARE_INT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_EQUALS_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_KIND_OF_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_KIND_OF_OBJECT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_OBJECTS_EQUAL;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_SUBTYPE_OF_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_SUBTYPE_OF_OBJECT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_UNBOX_FLOAT;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_UNBOX_INT;
import avail.interpreter.levelTwo.operation.L2_MAKE_IMMUTABLE;
import avail.interpreter.levelTwo.operation.L2_MOVE;
import avail.interpreter.levelTwo.operation.L2_MOVE_CONSTANT;
import avail.interpreter.levelTwo.operation.L2_RUN_INFALLIBLE_PRIMITIVE;
import avail.interpreter.levelTwo.operation.L2_TUPLE_AT_UPDATE;
import avail.interpreter.levelTwo.operation.L2_UNBOX_FLOAT;
import avail.interpreter.levelTwo.operation.L2_UNBOX_INT;
import avail.interpreter.levelTwo.operation.L2_UNREACHABLE_CODE;
import avail.interpreter.levelTwo.register.L2BoxedRegister;
import avail.interpreter.levelTwo.register.L2FloatRegister;
import avail.interpreter.levelTwo.register.L2IntRegister;
import avail.interpreter.levelTwo.register.L2Register;
import avail.interpreter.primitive.general.P_Equality;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.L2Synonym;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.OptimizationLevel;
import avail.optimizer.reoptimizer.L2Regenerator;
import avail.optimizer.values.Frame;
import avail.optimizer.values.L2SemanticConstant;
import avail.optimizer.values.L2SemanticUnboxedFloat;
import avail.optimizer.values.L2SemanticUnboxedInt;
import avail.optimizer.values.L2SemanticValue;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import avail.utility.CollectionExtensionsKt;
import avail.utility.structures.EnumMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\u0018\u0000 \u009e\u00012\u00020\u0001:\u0006\u009e\u0001\u009f\u0001\u00a0\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u0015\u0010.\u001a\u0004\u0018\u00010+2\u0006\u0010/\u001a\u000200\u00a2\u0006\u0002\u00101J)\u0010.\u001a\u0004\u0018\u00010+2\u0006\u00102\u001a\u0002032\u0012\u00104\u001a\n\u0012\u0006\b\u0001\u0012\u00020605\"\u000206\u00a2\u0006\u0002\u00107J\u0006\u00108\u001a\u00020+J\u000e\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\u0016\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020BJ\u001c\u0010=\u001a\u00020>2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020@0D2\u0006\u0010A\u001a\u00020BJ\u000e\u0010E\u001a\u00020>2\u0006\u0010A\u001a\u00020BJ\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u0007J\u0018\u0010F\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u00072\b\u0010H\u001a\u0004\u0018\u00010IJ\u000e\u0010J\u001a\u00020+2\u0006\u0010K\u001a\u00020LJ\u000e\u0010M\u001a\u00020\u00182\u0006\u0010G\u001a\u00020\u0007J\u0014\u0010N\u001a\u00020:2\f\u0010O\u001a\b\u0012\u0004\u0012\u00020:0PJ\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010Q\u001a\u00020RJ\u0010\u0010S\u001a\u0004\u0018\u00010L2\u0006\u0010T\u001a\u00020:J\u0012\u0010U\u001a\u0004\u0018\u00010V2\u0006\u0010W\u001a\u00020:H\u0002J$\u0010X\u001a\n\u0012\u0004\u0012\u00020:\u0018\u00010P2\u0006\u0010Y\u001a\u00020:2\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020V0PJ\u0016\u0010[\u001a\u00020:2\u0006\u0010\\\u001a\u00020:2\u0006\u0010]\u001a\u00020)J\u0016\u0010^\u001a\u00020:2\u0006\u0010Y\u001a\u00020:2\u0006\u0010_\u001a\u00020)J\u001c\u0010`\u001a\u00020a2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020b0D2\u0006\u0010A\u001a\u00020BJ\u000e\u0010c\u001a\u00020a2\u0006\u0010A\u001a\u00020BJ'\u0010d\u001a\u00020+2\u0006\u0010e\u001a\u00020f2\u0017\u0010g\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020+0h\u00a2\u0006\u0002\biJ\u001c\u0010j\u001a\u00020k2\f\u0010C\u001a\b\u0012\u0004\u0012\u00020l0D2\u0006\u0010A\u001a\u00020BJ\u000e\u0010m\u001a\u00020k2\u0006\u0010A\u001a\u00020BJ&\u0010n\u001a\u00020+2\u0006\u0010o\u001a\u00020:2\u0006\u0010p\u001a\u00020<2\u0006\u0010q\u001a\u00020\u00182\u0006\u0010r\u001a\u00020\u0018J&\u0010s\u001a\u00020+2\u0006\u0010t\u001a\u00020:2\u0006\u0010u\u001a\u00020V2\u0006\u0010v\u001a\u00020\u00182\u0006\u0010w\u001a\u00020\u0018J\u000e\u0010x\u001a\u00020+2\u0006\u0010y\u001a\u00020\u0018J\u000e\u0010z\u001a\u00020:2\u0006\u0010{\u001a\u00020:J\u0081\u0001\u0010|\u001a\u00020+\"\b\b\u0000\u0010}*\u00020~\"\u000f\b\u0001\u0010\u007f*\t\u0012\u0004\u0012\u0002H}0\u0080\u0001\"\u0010\b\u0002\u0010\u0081\u0001*\t\u0012\u0004\u0012\u0002H}0\u0082\u0001\"\u0016\b\u0003\u0010\u0083\u0001*\u000f\u0012\u0004\u0012\u0002H}\u0012\u0004\u0012\u0002H\u007f0\u0084\u00012\"\u0010\u0085\u0001\u001a\u001d\u0012\u0004\u0012\u0002H}\u0012\u0004\u0012\u0002H\u007f\u0012\u0005\u0012\u0003H\u0081\u0001\u0012\u0005\u0012\u0003H\u0083\u00010\u0086\u00012\u0007\u0010\u0087\u0001\u001a\u00020@2\u0007\u0010\u0088\u0001\u001a\u00020@J\u0007\u0010\u0089\u0001\u001a\u00020@J\u0007\u0010\u008a\u0001\u001a\u00020)J\u0010\u0010\u008b\u0001\u001a\u00020:2\u0007\u0010\u008c\u0001\u001a\u00020>J\u000f\u0010\u008b\u0001\u001a\u00020:2\u0006\u0010?\u001a\u00020@J\u001a\u0010\u008d\u0001\u001a\u00030\u008e\u00012\u0007\u0010\u008f\u0001\u001a\u00020b2\u0007\u0010\u0090\u0001\u001a\u00020\u0018J\u001a\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0007\u0010\u008f\u0001\u001a\u00020l2\u0007\u0010\u0090\u0001\u001a\u00020\u0018J\u0007\u0010\u0093\u0001\u001a\u00020\u0007J)\u0010\u0094\u0001\u001a\u00020+2\u0007\u0010\u0095\u0001\u001a\u00020\u00182\t\b\u0002\u0010\u0096\u0001\u001a\u00020R2\f\b\u0002\u0010\u0097\u0001\u001a\u0005\u0018\u00010\u0098\u0001J\u0013\u0010\u0099\u0001\u001a\u00030\u008e\u00012\u0007\u0010;\u001a\u00030\u009a\u0001H\u0002J\u0010\u0010\u009b\u0001\u001a\u00030\u0092\u00012\u0006\u0010;\u001a\u00020)J\u0007\u0010\u009c\u0001\u001a\u00020fJ\u0007\u0010\u009d\u0001\u001a\u00020\u0007R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001d\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u00180\"\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a1\u0001"}, d2={"Lavail/optimizer/L2Generator;", "", "optimizationLevel", "Lavail/optimizer/OptimizationLevel;", "topFrame", "Lavail/optimizer/values/Frame;", "codeName", "", "(Lavail/optimizer/OptimizationLevel;Lavail/optimizer/values/Frame;Ljava/lang/String;)V", "chunk", "Lavail/interpreter/levelTwo/L2Chunk;", "getCodeName", "()Ljava/lang/String;", "contingentValues", "Lavail/descriptor/sets/A_Set;", "getContingentValues", "()Lavail/descriptor/sets/A_Set;", "setContingentValues", "(Lavail/descriptor/sets/A_Set;)V", "controlFlowGraph", "Lavail/optimizer/L2ControlFlowGraph;", "getControlFlowGraph", "()Lavail/optimizer/L2ControlFlowGraph;", "currentBlock", "Lavail/optimizer/L2BasicBlock;", "currentManifest", "Lavail/optimizer/L2ValueManifest;", "getCurrentManifest", "()Lavail/optimizer/L2ValueManifest;", "setCurrentManifest", "(Lavail/optimizer/L2ValueManifest;)V", "getOptimizationLevel", "()Lavail/optimizer/OptimizationLevel;", "specialBlocks", "Lavail/utility/structures/EnumMap;", "Lavail/optimizer/L2Generator$SpecialBlock;", "getSpecialBlocks", "()Lavail/utility/structures/EnumMap;", "getTopFrame", "()Lavail/optimizer/values/Frame;", "uniqueCounter", "", "addContingentValue", "", "contingentValue", "Lavail/descriptor/methods/A_ChunkDependable;", "addInstruction", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "(Lavail/interpreter/levelTwo/L2Instruction;)Lkotlin/Unit;", "operation", "Lavail/interpreter/levelTwo/L2Operation;", "operands", "", "Lavail/interpreter/levelTwo/operand/L2Operand;", "(Lavail/interpreter/levelTwo/L2Operation;[Lavail/interpreter/levelTwo/operand/L2Operand;)Lkotlin/Unit;", "addUnreachableCode", "boxedConstant", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "value", "Lavail/descriptor/representation/A_BasicObject;", "boxedWrite", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "semanticValue", "Lavail/optimizer/values/L2SemanticValue;", "restriction", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "semanticValues", "", "boxedWriteTemp", "createBasicBlock", "name", "zone", "Lavail/optimizer/L2ControlFlowGraph$Zone;", "createChunk", "code", "Lavail/descriptor/functions/A_RawFunction;", "createLoopHeadBlock", "createTuple", "elements", "", "currentlyReachable", "", "determineRawFunction", "functionToCallReg", "exactFunctionSignatureFor", "Lavail/descriptor/types/A_Type;", "functionReg", "explodeTupleIfPossible", "tupleReg", "requiredTypes", "extractParameterTypeFromFunction", "functionRead", "parameterIndex", "extractTupleElement", "index", "floatWrite", "Lavail/interpreter/levelTwo/operand/L2WriteFloatOperand;", "Lavail/optimizer/values/L2SemanticUnboxedFloat;", "floatWriteTemp", "generateRetroactivelyBeforeEdge", "edge", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "body", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "intWrite", "Lavail/interpreter/levelTwo/operand/L2WriteIntOperand;", "Lavail/optimizer/values/L2SemanticUnboxedInt;", "intWriteTemp", "jumpIfEqualsConstant", "registerToTest", "constantValue", "passBlock", "failBlock", "jumpIfKindOfConstant", "valueRead", "expectedType", "passedCheck", "failedCheck", "jumpTo", "targetBlock", "makeImmutable", "read", "moveRegister", "R", "Lavail/interpreter/levelTwo/register/L2Register;", "RR", "Lavail/interpreter/levelTwo/operand/L2ReadOperand;", "WR", "Lavail/interpreter/levelTwo/operand/L2WriteOperand;", "RV", "Lavail/interpreter/levelTwo/operand/L2ReadVectorOperand;", "moveOperation", "Lavail/interpreter/levelTwo/operation/L2_MOVE;", "sourceSemanticValue", "targetSemanticValue", "newTemp", "nextUnique", "readBoxed", "write", "readFloat", "Lavail/interpreter/levelTwo/operand/L2ReadFloatOperand;", "semanticUnboxed", "onFailure", "readInt", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "simplyVisualize", "startBlock", "block", "generatePhis", "regenerator", "Lavail/optimizer/reoptimizer/L2Regenerator;", "unboxedFloatConstant", "", "unboxedIntConstant", "unreachablePcOperand", "visualize", "Companion", "RegisterCounter", "SpecialBlock", "avail"})
public final class L2Generator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final OptimizationLevel optimizationLevel;
    @NotNull
    private final Frame topFrame;
    @NotNull
    private final String codeName;
    @NotNull
    private final EnumMap<SpecialBlock, L2BasicBlock> specialBlocks;
    @NotNull
    private A_Set contingentValues;
    private int uniqueCounter;
    @Nullable
    private L2Chunk chunk;
    @Nullable
    private L2BasicBlock currentBlock;
    @NotNull
    private L2ValueManifest currentManifest;
    @NotNull
    private final L2ControlFlowGraph controlFlowGraph;
    public static final int maxPolymorphismToInlineDispatch = 8;
    public static final int maxExpandedEqualityChecks = 3;
    @NotNull
    private static final Statistic finalGenerationStat = new Statistic(StatisticReport.L2_OPTIMIZATION_TIME, "Final chunk generation");

    public L2Generator(@NotNull OptimizationLevel optimizationLevel, @NotNull Frame topFrame, @NotNull String codeName) {
        Intrinsics.checkNotNullParameter((Object)((Object)optimizationLevel), (String)"optimizationLevel");
        Intrinsics.checkNotNullParameter((Object)topFrame, (String)"topFrame");
        Intrinsics.checkNotNullParameter((Object)codeName, (String)"codeName");
        this.optimizationLevel = optimizationLevel;
        this.topFrame = topFrame;
        this.codeName = codeName;
        EnumMap.Companion this_$iv = EnumMap.Companion;
        boolean $i$f$enumMap = false;
        T[] TArray = SpecialBlock.class.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(TArray, (String)"K::class.java.enumConstants");
        this.specialBlocks = new EnumMap((Enum[])TArray);
        this.contingentValues = SetDescriptor.Companion.getEmptySet();
        this.currentManifest = new L2ValueManifest();
        this.controlFlowGraph = new L2ControlFlowGraph();
    }

    @NotNull
    public final OptimizationLevel getOptimizationLevel() {
        return this.optimizationLevel;
    }

    @NotNull
    public final Frame getTopFrame() {
        return this.topFrame;
    }

    @NotNull
    public final String getCodeName() {
        return this.codeName;
    }

    @NotNull
    public final EnumMap<SpecialBlock, L2BasicBlock> getSpecialBlocks() {
        return this.specialBlocks;
    }

    @NotNull
    public final A_Set getContingentValues() {
        return this.contingentValues;
    }

    public final void setContingentValues(@NotNull A_Set a_Set) {
        Intrinsics.checkNotNullParameter((Object)a_Set, (String)"<set-?>");
        this.contingentValues = a_Set;
    }

    public final int nextUnique() {
        int n = this.uniqueCounter;
        this.uniqueCounter = n + 1;
        return n;
    }

    @NotNull
    public final L2ValueManifest getCurrentManifest() {
        return this.currentManifest;
    }

    public final void setCurrentManifest(@NotNull L2ValueManifest l2ValueManifest) {
        Intrinsics.checkNotNullParameter((Object)l2ValueManifest, (String)"<set-?>");
        this.currentManifest = l2ValueManifest;
    }

    @NotNull
    public final L2ControlFlowGraph getControlFlowGraph() {
        return this.controlFlowGraph;
    }

    public final void addUnreachableCode() {
        this.addInstruction(L2_UNREACHABLE_CODE.INSTANCE, new L2Operand[0]);
    }

    @NotNull
    public final L2PcOperand unreachablePcOperand() {
        L2BasicBlock unreachableBlock = this.specialBlocks.getOrNull((SpecialBlock)((Enum)SpecialBlock.UNREACHABLE));
        if (unreachableBlock == null) {
            unreachableBlock = this.createBasicBlock("UNREACHABLE");
            this.specialBlocks.set((SpecialBlock)((Enum)SpecialBlock.UNREACHABLE), unreachableBlock);
        }
        L2BasicBlock it = unreachableBlock;
        boolean bl = false;
        return it.isLoopHead() ? Companion.backEdgeTo(it) : Companion.edgeTo(it);
    }

    @NotNull
    public final L2SemanticValue newTemp() {
        return this.topFrame.temp(this.nextUnique());
    }

    @NotNull
    public final L2WriteBoxedOperand boxedWriteTemp(@NotNull TypeRestriction restriction) {
        Intrinsics.checkNotNullParameter((Object)restriction, (String)"restriction");
        return this.boxedWrite(this.newTemp(), restriction);
    }

    @NotNull
    public final L2WriteBoxedOperand boxedWrite(@NotNull Set<? extends L2SemanticValue> semanticValues, @NotNull TypeRestriction restriction) {
        Intrinsics.checkNotNullParameter(semanticValues, (String)"semanticValues");
        Intrinsics.checkNotNullParameter((Object)restriction, (String)"restriction");
        boolean bl = restriction.isBoxed();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return new L2WriteBoxedOperand(semanticValues, restriction, new L2BoxedRegister(this.nextUnique()));
    }

    @NotNull
    public final L2WriteBoxedOperand boxedWrite(@NotNull L2SemanticValue semanticValue, @NotNull TypeRestriction restriction) {
        Intrinsics.checkNotNullParameter((Object)semanticValue, (String)"semanticValue");
        Intrinsics.checkNotNullParameter((Object)restriction, (String)"restriction");
        return this.boxedWrite(SetsKt.setOf((Object)semanticValue), restriction);
    }

    @NotNull
    public final L2WriteIntOperand intWriteTemp(@NotNull TypeRestriction restriction) {
        Intrinsics.checkNotNullParameter((Object)restriction, (String)"restriction");
        return this.intWrite(SetsKt.setOf((Object)new L2SemanticUnboxedInt(this.newTemp())), restriction);
    }

    @NotNull
    public final L2WriteIntOperand intWrite(@NotNull Set<L2SemanticUnboxedInt> semanticValues, @NotNull TypeRestriction restriction) {
        Intrinsics.checkNotNullParameter(semanticValues, (String)"semanticValues");
        Intrinsics.checkNotNullParameter((Object)restriction, (String)"restriction");
        boolean bl = restriction.isUnboxedInt();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return new L2WriteIntOperand(semanticValues, restriction, new L2IntRegister(this.nextUnique()));
    }

    @NotNull
    public final L2WriteFloatOperand floatWriteTemp(@NotNull TypeRestriction restriction) {
        Intrinsics.checkNotNullParameter((Object)restriction, (String)"restriction");
        return this.floatWrite(SetsKt.setOf((Object)new L2SemanticUnboxedFloat(this.newTemp())), restriction);
    }

    @NotNull
    public final L2WriteFloatOperand floatWrite(@NotNull Set<L2SemanticUnboxedFloat> semanticValues, @NotNull TypeRestriction restriction) {
        Intrinsics.checkNotNullParameter(semanticValues, (String)"semanticValues");
        Intrinsics.checkNotNullParameter((Object)restriction, (String)"restriction");
        boolean bl = restriction.isUnboxedFloat();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return new L2WriteFloatOperand(semanticValues, restriction, new L2FloatRegister(this.nextUnique()));
    }

    @NotNull
    public final L2ReadBoxedOperand boxedConstant(@NotNull A_BasicObject value) {
        TypeRestriction restriction;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        L2SemanticValue semanticConstant = L2SemanticValue.Companion.constant(value);
        if (this.currentManifest.hasSemanticValue(semanticConstant) && (restriction = this.currentManifest.restrictionFor(semanticConstant)).isBoxed() && restriction.isImmutable()) {
            return this.readBoxed(semanticConstant);
        }
        restriction = TypeRestriction.Companion.restrictionForConstant(value, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG);
        L2Operand[] l2OperandArray = new L2Operand[]{new L2ConstantOperand(value), this.boxedWrite(semanticConstant, restriction)};
        this.addInstruction(L2_MOVE_CONSTANT.boxed, l2OperandArray);
        return this.readBoxed(semanticConstant);
    }

    @NotNull
    public final L2ReadIntOperand unboxedIntConstant(int value) {
        A_Number boxedValue = IntegerDescriptor.Companion.fromInt(value);
        L2SemanticValue semanticConstant = L2SemanticValue.Companion.constant(boxedValue);
        L2SemanticUnboxedInt semanticUnboxedValue = new L2SemanticUnboxedInt(semanticConstant);
        if (this.currentManifest.hasSemanticValue(semanticUnboxedValue)) {
            return this.currentManifest.readInt(semanticUnboxedValue);
        }
        Set unboxedSet = SetsKt.setOf((Object)semanticUnboxedValue);
        L2Synonym synonym = new L2Synonym(unboxedSet);
        TypeRestriction restriction = TypeRestriction.Companion.restrictionForConstant(boxedValue, TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG);
        this.currentManifest.introduceSynonym(synonym, restriction);
        L2Operand[] l2OperandArray = new L2Operand[]{new L2IntImmediateOperand(value), this.intWrite(unboxedSet, restriction)};
        this.addInstruction(L2_MOVE_CONSTANT.unboxedInt, l2OperandArray);
        return new L2ReadIntOperand((L2SemanticValue)semanticUnboxedValue, restriction, this.currentManifest);
    }

    private final L2ReadFloatOperand unboxedFloatConstant(double value) {
        A_Number boxedValue = DoubleDescriptor.Companion.fromDouble(value);
        L2SemanticValue semanticConstant = L2SemanticValue.Companion.constant(boxedValue);
        L2SemanticUnboxedFloat semanticUnboxedValue = new L2SemanticUnboxedFloat(semanticConstant);
        if (this.currentManifest.hasSemanticValue(semanticUnboxedValue)) {
            return this.currentManifest.readFloat(semanticUnboxedValue);
        }
        Set unboxedSet = SetsKt.setOf((Object)semanticUnboxedValue);
        L2Synonym synonym = new L2Synonym(unboxedSet);
        TypeRestriction restriction = TypeRestriction.Companion.restrictionForConstant(boxedValue, TypeRestriction.RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG);
        this.currentManifest.introduceSynonym(synonym, restriction);
        L2Operand[] l2OperandArray = new L2Operand[]{new L2FloatImmediateOperand(value), this.floatWrite(unboxedSet, restriction)};
        this.addInstruction(L2_MOVE_CONSTANT.Companion.getUnboxedFloat(), l2OperandArray);
        return new L2ReadFloatOperand((L2SemanticValue)semanticUnboxedValue, restriction, this.currentManifest);
    }

    @NotNull
    public final L2ReadBoxedOperand readBoxed(@NotNull L2WriteBoxedOperand write2) {
        Intrinsics.checkNotNullParameter((Object)write2, (String)"write");
        return this.currentManifest.readBoxed(write2.pickSemanticValue());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final L2ReadBoxedOperand readBoxed(@NotNull L2SemanticValue semanticValue) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)semanticValue, (String)"semanticValue");
        boolean bl2 = bl = !(semanticValue instanceof L2SemanticUnboxedInt);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = !(semanticValue instanceof L2SemanticUnboxedFloat);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (this.currentManifest.hasSemanticValue(semanticValue)) {
            return this.currentManifest.readBoxed(semanticValue);
        }
        L2SemanticUnboxedInt unboxedInt2 = new L2SemanticUnboxedInt(semanticValue);
        if (this.currentManifest.hasSemanticValue(unboxedInt2)) {
            L2Operand[] $this$mapToSet_u24default$iv;
            TypeRestriction restriction = this.currentManifest.restrictionFor(unboxedInt2);
            Iterable iterable = this.currentManifest.semanticValueToSynonym(unboxedInt2).semanticValues();
            Set destination$iv = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            void $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                L2SemanticValue l2SemanticValue = (L2SemanticValue)item$iv$iv;
                Collection collection = destination$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type avail.optimizer.values.L2SemanticUnboxedInt");
                collection.add(((L2SemanticUnboxedInt)it).getBase());
            }
            L2BoxedRegister l2BoxedRegister = new L2BoxedRegister(this.nextUnique());
            TypeRestriction typeRestriction = restriction.forBoxed();
            Set set2 = (Set)((Collection)destination$iv);
            L2WriteBoxedOperand writer = new L2WriteBoxedOperand((Set<? extends L2SemanticValue>)set2, typeRestriction, l2BoxedRegister);
            $this$mapToSet_u24default$iv = new L2Operand[]{this.currentManifest.readInt(unboxedInt2), writer};
            this.addInstruction(L2_BOX_INT.INSTANCE, $this$mapToSet_u24default$iv);
            return this.currentManifest.readBoxed(semanticValue);
        }
        L2SemanticUnboxedFloat unboxedFloat2 = new L2SemanticUnboxedFloat(semanticValue);
        if (this.currentManifest.hasSemanticValue(unboxedFloat2)) {
            void $this$mapToSet_u24default$iv;
            TypeRestriction restriction = this.currentManifest.restrictionFor(unboxedFloat2);
            Iterable destination$iv = this.currentManifest.semanticValueToSynonym(unboxedFloat2).semanticValues();
            Set destination$iv2 = new LinkedHashSet();
            boolean $i$f$mapToSet = false;
            void $this$mapTo$iv$iv = $this$mapToSet_u24default$iv;
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                L2SemanticValue bl4 = (L2SemanticValue)item$iv$iv;
                Collection collection = destination$iv2;
                boolean bl5 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type avail.optimizer.values.L2SemanticUnboxedFloat");
                collection.add(((L2SemanticUnboxedFloat)it).getBase());
            }
            L2BoxedRegister l2BoxedRegister = new L2BoxedRegister(this.nextUnique());
            TypeRestriction typeRestriction = restriction.forBoxed();
            Set set3 = (Set)((Collection)destination$iv2);
            L2WriteBoxedOperand writer = new L2WriteBoxedOperand((Set<? extends L2SemanticValue>)set3, typeRestriction, l2BoxedRegister);
            L2Operand[] l2OperandArray = new L2Operand[]{this.currentManifest.readFloat(unboxedFloat2), writer};
            this.addInstruction(L2_BOX_FLOAT.INSTANCE, l2OperandArray);
            return this.currentManifest.readBoxed(semanticValue);
        }
        throw new IllegalStateException("Boxed value not available, even from unboxed versions".toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final L2ReadIntOperand readInt(@NotNull L2SemanticUnboxedInt semanticUnboxed, @NotNull L2BasicBlock onFailure) {
        L2Operand[] constant;
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)semanticUnboxed, (String)"semanticUnboxed");
        Intrinsics.checkNotNullParameter((Object)onFailure, (String)"onFailure");
        if (this.currentManifest.hasSemanticValue(semanticUnboxed)) {
            return this.currentManifest.readInt(semanticUnboxed);
        }
        L2SemanticValue semanticBoxed = semanticUnboxed.getBase();
        Iterable iterable = this.currentManifest.semanticValueToSynonym(semanticBoxed).semanticValues();
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv) {
            L2SemanticValue equivalentBoxedSemanticValue = (L2SemanticValue)element$iv;
            boolean bl = false;
            L2SemanticUnboxedInt equivalentUnboxed = new L2SemanticUnboxedInt(equivalentBoxedSemanticValue);
            if (!this.currentManifest.hasSemanticValue(equivalentUnboxed)) continue;
            this.moveRegister(L2_MOVE.Companion.getUnboxedInt(), equivalentUnboxed, semanticUnboxed);
            return this.currentManifest.readInt(semanticUnboxed);
        }
        TypeRestriction restriction = this.currentManifest.restrictionFor(semanticBoxed);
        if (!restriction.intersectsType(IntegerRangeTypeDescriptor.Companion.getInt32())) {
            this.jumpTo(onFailure);
            return this.unboxedIntConstant(-999);
        }
        L2Operand[] $i$f$forEach22 = restriction.getConstantOrNull();
        if ($i$f$forEach22 != null) {
            constant = $i$f$forEach22;
            boolean bl = false;
            return this.unboxedIntConstant(A_Number.Companion.getExtractInt((A_Number)constant));
        }
        L2WriteIntOperand intWrite = new L2WriteIntOperand(SetsKt.setOf((Object)semanticUnboxed), restriction.forUnboxedInt(), new L2IntRegister(this.nextUnique()));
        L2ReadBoxedOperand boxedRead = this.currentManifest.readBoxed(semanticBoxed);
        if (restriction.containedByType(IntegerRangeTypeDescriptor.Companion.getInt32())) {
            constant = new L2Operand[]{boxedRead, intWrite};
            this.addInstruction(L2_UNBOX_INT.INSTANCE, constant);
        } else {
            L2BasicBlock onSuccess = this.createBasicBlock("successfully unboxed");
            L2Operand[] l2OperandArray = new L2Operand[]{boxedRead, intWrite, Companion.edgeTo(onFailure), Companion.edgeTo(onSuccess)};
            this.addInstruction(L2_JUMP_IF_UNBOX_INT.INSTANCE, l2OperandArray);
            L2Generator.startBlock$default(this, onSuccess, false, null, 6, null);
        }
        return this.currentManifest.readInt(semanticUnboxed);
    }

    @NotNull
    public final L2ReadFloatOperand readFloat(@NotNull L2SemanticUnboxedFloat semanticUnboxed, @NotNull L2BasicBlock onFailure) {
        Intrinsics.checkNotNullParameter((Object)semanticUnboxed, (String)"semanticUnboxed");
        Intrinsics.checkNotNullParameter((Object)onFailure, (String)"onFailure");
        if (this.currentManifest.hasSemanticValue(semanticUnboxed)) {
            return this.currentManifest.readFloat(semanticUnboxed);
        }
        L2SemanticValue semanticBoxed = semanticUnboxed.getBase();
        TypeRestriction restriction = this.currentManifest.restrictionFor(semanticBoxed);
        if (!restriction.intersectsType(PrimitiveTypeDescriptor.Types.DOUBLE.getO())) {
            this.jumpTo(onFailure);
            return this.unboxedFloatConstant(-99.9);
        }
        AvailObject availObject = restriction.getConstantOrNull();
        if (availObject != null) {
            AvailObject constant = availObject;
            boolean bl = false;
            return this.unboxedFloatConstant(A_Number.Companion.getExtractDouble(constant));
        }
        Set<L2SemanticValue> $this$cast$iv = this.currentManifest.semanticValueToSynonym(semanticUnboxed).semanticValues();
        boolean $i$f$cast2 = false;
        L2WriteFloatOperand floatWrite = new L2WriteFloatOperand((Set)((Object)$this$cast$iv), restriction.intersectionWithType(PrimitiveTypeDescriptor.Types.DOUBLE.getO()).withFlag(TypeRestriction.RestrictionFlagEncoding.UNBOXED_FLOAT_FLAG), new L2FloatRegister(this.nextUnique()));
        L2ReadBoxedOperand boxedRead = this.currentManifest.readBoxed(semanticBoxed);
        if (restriction.containedByType(PrimitiveTypeDescriptor.Types.DOUBLE.getO())) {
            L2Operand[] $i$f$cast2 = new L2Operand[]{boxedRead, floatWrite};
            this.addInstruction(L2_UNBOX_FLOAT.INSTANCE, $i$f$cast2);
        } else {
            L2BasicBlock onSuccess = this.createBasicBlock("successfully unboxed");
            L2Operand[] l2OperandArray = new L2Operand[]{boxedRead, floatWrite, Companion.edgeTo(onFailure), Companion.edgeTo(onSuccess)};
            this.addInstruction(L2_JUMP_IF_UNBOX_FLOAT.INSTANCE, l2OperandArray);
            L2Generator.startBlock$default(this, onSuccess, false, null, 6, null);
        }
        return this.currentManifest.readFloat(semanticUnboxed);
    }

    /*
     * WARNING - void declaration
     */
    public final <R extends L2Register, RR extends L2ReadOperand<R>, WR extends L2WriteOperand<R>, RV extends L2ReadVectorOperand<R, RR>> void moveRegister(@NotNull L2_MOVE<R, RR, WR, RV> moveOperation, @NotNull L2SemanticValue sourceSemanticValue, @NotNull L2SemanticValue targetSemanticValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        L2WriteOperand it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        L2Register p0;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter(moveOperation, (String)"moveOperation");
        Intrinsics.checkNotNullParameter((Object)sourceSemanticValue, (String)"sourceSemanticValue");
        Intrinsics.checkNotNullParameter((Object)targetSemanticValue, (String)"targetSemanticValue");
        boolean bl2 = bl = !this.currentManifest.hasSemanticValue(targetSemanticValue);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2BasicBlock block = this.currentBlock();
        List sourceRegisters = this.currentManifest.getDefinitions(sourceSemanticValue);
        Iterable iterable = sourceRegisters;
        boolean $i$f$flatMap = false;
        void var9_13 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            p0 = (L2Register)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = p0.definitions();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$flatMapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (L2WriteOperand)element$iv$iv;
            boolean bl4 = false;
            if (!Intrinsics.areEqual((Object)it.getInstruction().basicBlock(), (Object)block)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (L2WriteOperand)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            L2Register $this$cast$iv = p0;
            boolean $i$f$cast = false;
            collection.add((L2WriteOperand)((Object)$this$cast$iv));
        }
        List sourceWritesInBlock = (List)destination$iv$iv;
        if (!((Collection)sourceWritesInBlock).isEmpty()) {
            Object v1;
            Iterable $this$maxByOrNull$iv = sourceWritesInBlock;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v1 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v1 = maxElem$iv;
                } else {
                    L2WriteOperand it2 = (L2WriteOperand)maxElem$iv;
                    boolean bl6 = false;
                    L2WriteOperand l2WriteOperand = it2;
                    Intrinsics.checkNotNull((Object)l2WriteOperand);
                    int maxValue$iv = l2WriteOperand.getInstruction().basicBlock().instructions().indexOf(it2.getInstruction());
                    do {
                        Object e$iv = iterator$iv.next();
                        L2WriteOperand it3 = (L2WriteOperand)e$iv;
                        $i$a$-maxByOrNull-L2Generator$moveRegister$latestWrite$1 = false;
                        L2WriteOperand l2WriteOperand2 = it3;
                        Intrinsics.checkNotNull((Object)l2WriteOperand2);
                        int v$iv = l2WriteOperand2.getInstruction().basicBlock().instructions().indexOf(it3.getInstruction());
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v1 = maxElem$iv;
                }
            }
            Intrinsics.checkNotNull(v1);
            L2WriteOperand latestWrite = v1;
            if (!latestWrite.getInstruction().getOperation().isPhi() && 0 <= ($this$maxByOrNull$iv = block.instructions().size() + -1)) {
                do {
                    int i = $this$maxByOrNull$iv--;
                    L2Instruction eachInstruction = block.instructions().get(i);
                    if (!Intrinsics.areEqual((Object)eachInstruction, (Object)latestWrite.getInstruction())) continue;
                    L2SemanticValue pickedSemanticValue = latestWrite.pickSemanticValue();
                    latestWrite.retroactivelyIncludeSemanticValue(targetSemanticValue);
                    this.currentManifest.extendSynonym(this.currentManifest.semanticValueToSynonym(pickedSemanticValue), targetSemanticValue);
                    return;
                } while (0 <= $this$maxByOrNull$iv);
            }
        }
        TypeRestriction restriction = this.currentManifest.restrictionFor(sourceSemanticValue);
        Object register = this.currentManifest.getDefinition(sourceSemanticValue, moveOperation.getKind());
        Object operand = moveOperation.getKind().readOperand(sourceSemanticValue, restriction, register);
        L2Operand[] l2OperandArray = new L2Operand[]{(L2Operand)operand, (L2Operand)moveOperation.createWrite(this, SetsKt.setOf((Object)targetSemanticValue), restriction)};
        this.addInstruction(moveOperation, l2OperandArray);
    }

    @NotNull
    public final L2ReadBoxedOperand makeImmutable(@NotNull L2ReadBoxedOperand read2) {
        Intrinsics.checkNotNullParameter((Object)read2, (String)"read");
        TypeRestriction restriction = read2.restriction();
        L2Synonym readSynonym = this.currentManifest.semanticValueToSynonym(read2.semanticValue());
        boolean bl = restriction.isBoxed();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (restriction.isImmutable()) {
            return read2;
        }
        L2SemanticValue temp = this.newTemp();
        Set writeSemanticValues = CollectionsKt.toMutableSet((Iterable)readSynonym.semanticValues());
        writeSemanticValues.add(temp);
        TypeRestriction immutableRestriction = restriction.withFlag(TypeRestriction.RestrictionFlagEncoding.IMMUTABLE_FLAG);
        boolean bl2 = immutableRestriction.isBoxed();
        if (_Assertions.ENABLED && !bl2) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        L2Operand[] l2OperandArray = new L2Operand[]{read2, this.boxedWrite(writeSemanticValues, immutableRestriction)};
        this.addInstruction(L2_MAKE_IMMUTABLE.INSTANCE, l2OperandArray);
        return this.currentManifest.readBoxed(temp);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final L2ReadBoxedOperand createTuple(@NotNull List<L2ReadBoxedOperand> elements) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        L2ReadBoxedOperand it;
        Collection collection;
        AbstractEnumerationTypeDescriptor.Companion $this$mapTo$iv$iv2;
        A_String a_String;
        Iterator t;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        int size = elements.size();
        if (size == 0) {
            return this.boxedConstant(TupleDescriptor.Companion.emptyTuple());
        }
        Iterable iterable = elements;
        A_Type initial$iv = BottomTypeDescriptor.Companion.getBottom();
        boolean $i$f$fold = false;
        A_Type accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void read2;
            L2ReadBoxedOperand l2ReadBoxedOperand = (L2ReadBoxedOperand)element$iv;
            t = accumulator$iv;
            boolean bl = false;
            accumulator$iv = A_Type.Companion.typeUnion((A_Type)((Object)t), read2.type());
        }
        A_Type unionType = accumulator$iv;
        if (A_Type.Companion.isSubtypeOf(unionType, PrimitiveTypeDescriptor.Types.CHARACTER.getO())) {
            a_String = StringDescriptor.Companion.generateStringFromCodePoints(size, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(elements){
                final /* synthetic */ List<L2ReadBoxedOperand> $elements;
                {
                    this.$elements = $elements;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int oneBasedIndex) {
                    AvailObject it = this.$elements.get(oneBasedIndex - 1).constantOrNull();
                    boolean bl = false;
                    return it == null ? 63 : A_Character.Companion.getCodePoint(it);
                }
            }));
        } else if (A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getInt64())) {
            Iterable $this$map$iv2 = elements;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            t = $this$mapTo$iv$iv2.iterator();
            while (t.hasNext()) {
                Object item$iv$iv = t.next();
                L2ReadBoxedOperand l2ReadBoxedOperand = (L2ReadBoxedOperand)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                AvailObject availObject = it.constantOrNull();
                if (availObject == null) {
                    availObject = IntegerDescriptor.Companion.getZero();
                }
                collection.add(availObject);
            }
            List constantsWithZeros = (List)destination$iv$iv;
            a_String = A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getNybbles()) ? NybbleTupleDescriptor.Companion.generateNybbleTupleFrom(size, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>((List<AvailObject>)constantsWithZeros){
                final /* synthetic */ List<AvailObject> $constantsWithZeros;
                {
                    this.$constantsWithZeros = $constantsWithZeros;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int oneIndex) {
                    return A_Number.Companion.getExtractInt(this.$constantsWithZeros.get(oneIndex - 1));
                }
            })) : (A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getBytes()) ? ByteTupleDescriptor.Companion.generateByteTupleFrom(size, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>((List<AvailObject>)constantsWithZeros){
                final /* synthetic */ List<AvailObject> $constantsWithZeros;
                {
                    this.$constantsWithZeros = $constantsWithZeros;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int oneIndex) {
                    return A_Number.Companion.getExtractInt(this.$constantsWithZeros.get(oneIndex - 1));
                }
            })) : (A_Type.Companion.isSubtypeOf(unionType, IntegerRangeTypeDescriptor.Companion.getInt32()) ? IntTupleDescriptor.Companion.generateIntTupleFrom(size, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>((List<AvailObject>)constantsWithZeros){
                final /* synthetic */ List<AvailObject> $constantsWithZeros;
                {
                    this.$constantsWithZeros = $constantsWithZeros;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int oneIndex) {
                    return A_Number.Companion.getExtractInt(this.$constantsWithZeros.get(oneIndex - 1));
                }
            })) : LongTupleDescriptor.Companion.generateLongTupleFrom(size, (Function1<? super Integer, Long>)((Function1)new Function1<Integer, Long>((List<AvailObject>)constantsWithZeros){
                final /* synthetic */ List<AvailObject> $constantsWithZeros;
                {
                    this.$constantsWithZeros = $constantsWithZeros;
                    super(1);
                }

                @NotNull
                public final Long invoke(int oneIndex) {
                    return A_Number.Companion.getExtractLong(this.$constantsWithZeros.get(oneIndex - 1));
                }
            }))));
        } else {
            boolean bl;
            block16: {
                Iterable $this$all$iv = elements;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        L2ReadBoxedOperand it2 = (L2ReadBoxedOperand)element$iv;
                        boolean bl2 = false;
                        if (it2.constantOrNull() == null) continue;
                        bl = false;
                        break block16;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Collection<A_Type> collection2;
                L2Operand[] $this$map$iv3;
                Object element$iv;
                Iterable $i$f$all = elements;
                TupleTypeDescriptor.Companion companion = TupleTypeDescriptor.Companion;
                TypeRestriction.Companion companion2 = TypeRestriction.Companion;
                L2Generator l2Generator = this;
                boolean $i$f$map = false;
                element$iv = $this$map$iv3;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
                boolean $i$f$mapTo = false;
                t = $this$mapTo$iv$iv2.iterator();
                while (t.hasNext()) {
                    Object item$iv$iv = t.next();
                    L2ReadBoxedOperand it3 = (L2ReadBoxedOperand)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    collection2.add(it3.type());
                }
                collection2 = (List)destination$iv$iv;
                L2WriteBoxedOperand write2 = l2Generator.boxedWriteTemp(companion2.restrictionForType(companion.tupleTypeForTypesList((List<? extends A_Type>)collection2), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
                $this$map$iv3 = new L2Operand[]{new L2ReadBoxedVectorOperand(elements), write2};
                this.addInstruction(L2_CREATE_TUPLE.INSTANCE, $this$map$iv3);
                return this.readBoxed(write2);
            }
            a_String = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(size, (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(elements){
                final /* synthetic */ List<L2ReadBoxedOperand> $elements;
                {
                    this.$elements = $elements;
                    super(1);
                }

                @NotNull
                public final A_BasicObject invoke(int oneIndex) {
                    AvailObject availObject = this.$elements.get(oneIndex - 1).constantOrNull();
                    return availObject != null ? (A_BasicObject)availObject : (A_BasicObject)AtomDescriptor.Companion.getFalseObject();
                }
            }));
        }
        AvailObject template2 = a_String.makeShared();
        L2ReadBoxedOperand latestRead = null;
        latestRead = this.boxedConstant(template2);
        Iterable $i$f$map = template2;
        $this$mapTo$iv$iv2 = AbstractEnumerationTypeDescriptor.Companion;
        boolean $i$f$map2 = false;
        void $i$f$mapTo = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            A_BasicObject a_BasicObject = (A_BasicObject)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add($this$mapTo$iv$iv2.instanceTypeOrMetaOn((A_BasicObject)p0));
        }
        List typesList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        Iterable $this$forEachIndexed$iv = elements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void read3;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            it = (L2ReadBoxedOperand)item$iv;
            int zeroIndex = n;
            boolean bl = false;
            if (read3.constantOrNull() != null) continue;
            typesList.set(zeroIndex, read3.type());
            L2WriteBoxedOperand newWrite = this.boxedWriteTemp(TypeRestriction.Companion.restrictionForType(TupleTypeDescriptor.Companion.tupleTypeForTypesList(typesList), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
            L2Operand[] l2OperandArray = new L2Operand[]{latestRead, new L2IntImmediateOperand(zeroIndex + 1), (L2Operand)read3, newWrite};
            this.addInstruction(L2_TUPLE_AT_UPDATE.INSTANCE, l2OperandArray);
            latestRead = this.readBoxed(newWrite);
        }
        return latestRead;
    }

    @NotNull
    public final L2ReadBoxedOperand extractTupleElement(@NotNull L2ReadBoxedOperand tupleReg, int index2) {
        Intrinsics.checkNotNullParameter((Object)tupleReg, (String)"tupleReg");
        return tupleReg.definition().getInstruction().getOperation().extractTupleElement(tupleReg, index2, this);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<L2ReadBoxedOperand> explodeTupleIfPossible(@NotNull L2ReadBoxedOperand tupleReg, @NotNull List<? extends A_Type> requiredTypes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)tupleReg, (String)"tupleReg");
        Intrinsics.checkNotNullParameter(requiredTypes, (String)"requiredTypes");
        A_Type tupleType = tupleReg.type();
        A_Type tupleTypeSizes = A_Type.Companion.getSizeRange(tupleType);
        if (!A_Number.Companion.isInt(A_Type.Companion.getUpperBound(tupleTypeSizes)) || !A_Type.Companion.getLowerBound(tupleTypeSizes).equals(A_Type.Companion.getUpperBound(tupleTypeSizes))) {
            return null;
        }
        int tupleSize = A_Number.Companion.getExtractInt(A_Type.Companion.getUpperBound(tupleTypeSizes));
        if (tupleSize != requiredTypes.size()) {
            return null;
        }
        int i = 1;
        if (i <= tupleSize) {
            while (true) {
                if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.typeAtIndex(tupleType, i), requiredTypes.get(i - 1))) {
                    return null;
                }
                if (i == tupleSize) break;
                ++i;
            }
        }
        Iterable $this$map$iv = (Iterable)new IntRange(1, tupleSize);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.extractTupleElement(tupleReg, (int)it));
        }
        return (List)destination$iv$iv;
    }

    private final A_Type exactFunctionSignatureFor(L2ReadBoxedOperand functionReg) {
        return functionReg.exactFunctionType();
    }

    @NotNull
    public final L2ReadBoxedOperand extractParameterTypeFromFunction(@NotNull L2ReadBoxedOperand functionRead, int parameterIndex) {
        Intrinsics.checkNotNullParameter((Object)functionRead, (String)"functionRead");
        A_Type exactFunctionType = this.exactFunctionSignatureFor(functionRead);
        if (exactFunctionType != null) {
            return this.boxedConstant(A_Type.Companion.typeAtIndex(A_Type.Companion.getArgsTupleType(exactFunctionType), parameterIndex));
        }
        L2WriteBoxedOperand parameterTypeWrite = this.boxedWriteTemp(TypeRestriction.Companion.restrictionForType(InstanceMetaDescriptor.Companion.anyMeta(), TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
        L2Operand[] l2OperandArray = new L2Operand[]{functionRead, new L2IntImmediateOperand(parameterIndex), parameterTypeWrite};
        this.addInstruction(L2_FUNCTION_PARAMETER_TYPE.INSTANCE, l2OperandArray);
        return this.readBoxed(parameterTypeWrite);
    }

    @NotNull
    public final L2BasicBlock createBasicBlock(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new L2BasicBlock(name, false, null, 6, null);
    }

    @NotNull
    public final L2BasicBlock createLoopHeadBlock(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new L2BasicBlock(name, true, null);
    }

    @NotNull
    public final L2BasicBlock createBasicBlock(@NotNull String name, @Nullable L2ControlFlowGraph.Zone zone) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new L2BasicBlock(name, false, zone);
    }

    public final void startBlock(@NotNull L2BasicBlock block, boolean generatePhis, @Nullable L2Regenerator regenerator2) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        if (!block.isIrremovable()) {
            L2PcOperand predecessorEdge;
            L2BasicBlock predecessorBlock;
            L2Instruction jump;
            int predecessorCount = block.predecessorEdges().size();
            if (predecessorCount == 0) {
                this.currentBlock = null;
                return;
            }
            if (!block.isLoopHead() && predecessorCount == 1 && (jump = (predecessorBlock = (predecessorEdge = block.predecessorEdges().get(0)).sourceBlock()).finalInstruction()).getOperation() == L2_JUMP.INSTANCE) {
                this.currentManifest.clear();
                L2ValueManifest.populateFromIntersection$default(this.currentManifest, CollectionsKt.listOf((Object)predecessorEdge.manifest()), this, false, false, null, 16, null);
                predecessorBlock.instructions().remove(predecessorBlock.instructions().size() - 1);
                jump.justRemoved();
                this.currentBlock = predecessorBlock;
                return;
            }
        }
        this.currentBlock = block;
        this.controlFlowGraph.startBlock(block);
        block.startIn(this, generatePhis, regenerator2);
    }

    public static /* synthetic */ void startBlock$default(L2Generator l2Generator, L2BasicBlock l2BasicBlock, boolean bl, L2Regenerator l2Regenerator, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            l2Regenerator = null;
        }
        l2Generator.startBlock(l2BasicBlock, bl, l2Regenerator);
    }

    @NotNull
    public final L2BasicBlock currentBlock() {
        L2BasicBlock l2BasicBlock = this.currentBlock;
        Intrinsics.checkNotNull((Object)l2BasicBlock);
        return l2BasicBlock;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean currentlyReachable() {
        L2BasicBlock $this$notNullAnd$iv = this.currentBlock;
        boolean $i$f$notNullAnd = false;
        if ($this$notNullAnd$iv == null) return false;
        L2BasicBlock p0 = $this$notNullAnd$iv;
        boolean bl = false;
        if (!p0.currentlyReachable()) return false;
        return true;
    }

    @Nullable
    public final Unit addInstruction(@NotNull L2Operation operation, L2Operand ... operands) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)operands, (String)"operands");
        L2BasicBlock l2BasicBlock = this.currentBlock;
        if (l2BasicBlock != null) {
            L2BasicBlock $this$addInstruction_u24lambda_u2d17 = l2BasicBlock;
            boolean bl = false;
            $this$addInstruction_u24lambda_u2d17.addInstruction(new L2Instruction(this.currentBlock, operation, Arrays.copyOf(operands, operands.length)), this.currentManifest);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final Unit addInstruction(@NotNull L2Instruction instruction2) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2BasicBlock l2BasicBlock = this.currentBlock;
        if (l2BasicBlock != null) {
            L2BasicBlock $this$addInstruction_u24lambda_u2d18 = l2BasicBlock;
            boolean bl = false;
            $this$addInstruction_u24lambda_u2d18.addInstruction(instruction2, this.currentManifest);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void jumpTo(@NotNull L2BasicBlock targetBlock) {
        Intrinsics.checkNotNullParameter((Object)targetBlock, (String)"targetBlock");
        L2Operand[] l2OperandArray = new L2Operand[]{Companion.edgeTo(targetBlock)};
        this.addInstruction(L2_JUMP.INSTANCE, l2OperandArray);
    }

    public final void jumpIfEqualsConstant(@NotNull L2ReadBoxedOperand registerToTest, @NotNull A_BasicObject constantValue, @NotNull L2BasicBlock passBlock, @NotNull L2BasicBlock failBlock) {
        Intrinsics.checkNotNullParameter((Object)registerToTest, (String)"registerToTest");
        Intrinsics.checkNotNullParameter((Object)constantValue, (String)"constantValue");
        Intrinsics.checkNotNullParameter((Object)passBlock, (String)"passBlock");
        Intrinsics.checkNotNullParameter((Object)failBlock, (String)"failBlock");
        TypeRestriction restriction = registerToTest.restriction();
        AvailObject availObject = restriction.getConstantOrNull();
        if (Intrinsics.areEqual((Object)availObject, (Object)constantValue)) {
            this.jumpTo(passBlock);
            return;
        }
        if (availObject instanceof Object) {
            this.jumpTo(failBlock);
            return;
        }
        if (constantValue.isBoolean()) {
            boolean constantBool = constantValue.equals(AtomDescriptor.Companion.getTrueObject());
            L2Instruction boolSource = registerToTest.definitionSkippingMoves(true);
            if (boolSource.getOperation() instanceof L2_RUN_INFALLIBLE_PRIMITIVE) {
                if (L2_RUN_INFALLIBLE_PRIMITIVE.Companion.primitiveOf(boolSource) == P_Equality.INSTANCE) {
                    List<L2ReadBoxedOperand> list2 = L2_RUN_INFALLIBLE_PRIMITIVE.Companion.argsOf(boolSource);
                    L2ReadBoxedOperand read1 = list2.get(0);
                    L2ReadBoxedOperand read2 = list2.get(1);
                    AvailObject previousConstant = read1.constantOrNull();
                    L2ReadBoxedOperand previousRegister = null;
                    if (previousConstant != null) {
                        previousRegister = read2;
                    } else {
                        previousConstant = read2.constantOrNull();
                        previousRegister = read1;
                    }
                    if (previousConstant != null) {
                        this.jumpIfEqualsConstant(previousRegister, previousConstant, constantBool ? passBlock : failBlock, constantBool ? failBlock : passBlock);
                        return;
                    }
                    L2Operand[] l2OperandArray = new L2Operand[]{read1, read2, Companion.edgeTo(constantBool ? passBlock : failBlock), Companion.edgeTo(constantBool ? failBlock : passBlock)};
                    this.addInstruction(L2_JUMP_IF_OBJECTS_EQUAL.INSTANCE, l2OperandArray);
                    return;
                }
                if (boolSource.getOperation() == L2_JUMP_IF_SUBTYPE_OF_CONSTANT.INSTANCE) {
                    L2ReadBoxedOperand firstTypeOperand = (L2ReadBoxedOperand)boolSource.operand(0);
                    L2ConstantOperand secondConstantOperand = (L2ConstantOperand)boolSource.operand(1);
                    L2Instruction firstTypeSource = firstTypeOperand.definitionSkippingMoves(true);
                    if (firstTypeSource.getOperation() == L2_GET_TYPE.INSTANCE) {
                        L2ReadBoxedOperand valueSource = L2_GET_TYPE.sourceValueOf(firstTypeSource);
                        this.jumpIfKindOfConstant(valueSource, secondConstantOperand.getConstant(), constantBool ? passBlock : failBlock, constantBool ? failBlock : passBlock);
                        return;
                    }
                    L2Operand[] valueSource = new L2Operand[]{firstTypeOperand, secondConstantOperand, Companion.edgeTo(constantBool ? passBlock : failBlock), Companion.edgeTo(constantBool ? failBlock : passBlock)};
                    this.addInstruction(L2_JUMP_IF_SUBTYPE_OF_CONSTANT.INSTANCE, valueSource);
                    return;
                }
                if (boolSource.getOperation() == L2_JUMP_IF_SUBTYPE_OF_OBJECT.INSTANCE) {
                    L2ReadBoxedOperand firstTypeOperand = (L2ReadBoxedOperand)boolSource.operand(0);
                    L2ReadBoxedOperand secondTypeOperand = (L2ReadBoxedOperand)boolSource.operand(0);
                    L2Instruction firstTypeSource = firstTypeOperand.definitionSkippingMoves(true);
                    if (firstTypeSource.getOperation() == L2_GET_TYPE.INSTANCE) {
                        L2ReadBoxedOperand valueSource = L2_GET_TYPE.sourceValueOf(firstTypeSource);
                        L2Operand[] l2OperandArray = new L2Operand[]{valueSource, secondTypeOperand, Companion.edgeTo(constantBool ? passBlock : failBlock), Companion.edgeTo(constantBool ? failBlock : passBlock)};
                        this.addInstruction(L2_JUMP_IF_KIND_OF_OBJECT.INSTANCE, l2OperandArray);
                        return;
                    }
                    L2Operand[] l2OperandArray = new L2Operand[]{firstTypeOperand, secondTypeOperand, Companion.edgeTo(constantBool ? passBlock : failBlock), Companion.edgeTo(constantBool ? failBlock : passBlock)};
                    this.addInstruction(L2_JUMP_IF_SUBTYPE_OF_OBJECT.INSTANCE, l2OperandArray);
                    return;
                }
            }
        }
        L2BasicBlock innerPass = new L2BasicBlock("strengthen to constant", false, null, 6, null);
        AvailObject constantValueStrong = (AvailObject)constantValue;
        if (A_Number.Companion.isInt(constantValueStrong) && registerToTest.restriction().containedByType(IntegerRangeTypeDescriptor.Companion.getInt32())) {
            trulyUnreachable = new L2BasicBlock("truly unreachable", false, null, 6, null);
            L2_JUMP_IF_COMPARE_INT.Companion.getEqual().compareAndBranch(this, this.readInt(new L2SemanticUnboxedInt(registerToTest.semanticValue()), (L2BasicBlock)trulyUnreachable), this.unboxedIntConstant(A_Number.Companion.getExtractInt(constantValueStrong)), Companion.edgeTo(innerPass), Companion.edgeTo(failBlock));
            boolean bl = trulyUnreachable.predecessorEdges().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        } else {
            trulyUnreachable = new L2Operand[]{registerToTest, new L2ConstantOperand(constantValue), Companion.edgeTo(innerPass), Companion.edgeTo(failBlock)};
            this.addInstruction(L2_JUMP_IF_EQUALS_CONSTANT.INSTANCE, trulyUnreachable);
        }
        L2Generator.startBlock$default(this, innerPass, false, null, 6, null);
        L2SemanticConstant semanticConstant = new L2SemanticConstant(constantValue);
        if (!this.currentManifest.hasSemanticValue(semanticConstant)) {
            this.moveRegister(L2_MOVE.Companion.getBoxed(), registerToTest.semanticValue(), semanticConstant);
        }
        this.jumpTo(passBlock);
    }

    public final void jumpIfKindOfConstant(@NotNull L2ReadBoxedOperand valueRead, @NotNull A_Type expectedType, @NotNull L2BasicBlock passedCheck, @NotNull L2BasicBlock failedCheck) {
        Intrinsics.checkNotNullParameter((Object)valueRead, (String)"valueRead");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)passedCheck, (String)"passedCheck");
        Intrinsics.checkNotNullParameter((Object)failedCheck, (String)"failedCheck");
        if (valueRead.restriction().containedByType(expectedType)) {
            this.jumpTo(passedCheck);
            return;
        }
        if (!valueRead.restriction().intersectsType(expectedType)) {
            this.jumpTo(failedCheck);
            return;
        }
        A_RawFunction rawFunction = this.determineRawFunction(valueRead);
        if (rawFunction != null) {
            A_Type exactKind = rawFunction.functionType();
            if (A_Type.Companion.isSubtypeOf(exactKind, expectedType)) {
                this.jumpTo(passedCheck);
                return;
            }
            if (!expectedType.isEnumeration()) {
                this.jumpTo(failedCheck);
                return;
            }
        }
        L2Operand[] l2OperandArray = new L2Operand[]{valueRead, new L2ConstantOperand(expectedType), Companion.edgeTo(passedCheck), Companion.edgeTo(failedCheck)};
        this.addInstruction(L2_JUMP_IF_KIND_OF_CONSTANT.INSTANCE, l2OperandArray);
    }

    @Nullable
    public final A_RawFunction determineRawFunction(@NotNull L2ReadBoxedOperand functionToCallReg) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        A_Function functionIfKnown = functionToCallReg.constantOrNull();
        if (functionIfKnown != null) {
            return functionIfKnown.code();
        }
        L2Instruction functionDefinition = functionToCallReg.definitionSkippingMoves(true);
        return functionDefinition.getOperation().getConstantCodeFrom(functionDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateRetroactivelyBeforeEdge(@NotNull L2PcOperand edge2, @NotNull Function1<? super L2Generator, Unit> body2) {
        Intrinsics.checkNotNullParameter((Object)edge2, (String)"edge");
        Intrinsics.checkNotNullParameter(body2, (String)"body");
        L2BasicBlock sourceBlock = edge2.sourceBlock();
        L2ValueManifest savedManifest = this.currentManifest;
        L2BasicBlock savedBlock = this.currentBlock;
        L2Instruction savedFinalInstruction = CollectionExtensionsKt.removeLast(sourceBlock.instructions());
        this.currentManifest = edge2.manifest();
        this.currentBlock = sourceBlock;
        sourceBlock.removedControlFlowInstruction();
        try {
            body2.invoke((Object)this);
        }
        finally {
            sourceBlock.instructions().add(savedFinalInstruction);
            sourceBlock.readdedControlFlowInstruction();
            this.currentManifest = savedManifest;
            this.currentBlock = savedBlock;
        }
    }

    public final void addContingentValue(@NotNull A_ChunkDependable contingentValue) {
        Intrinsics.checkNotNullParameter((Object)contingentValue, (String)"contingentValue");
        this.contingentValues = A_Set.Companion.setWithElementCanDestroy(this.contingentValues, contingentValue, true);
    }

    public final void createChunk(@NotNull A_RawFunction code) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        boolean bl3 = bl2 = this.chunk == null;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List instructions = new ArrayList();
        this.controlFlowGraph.generateOn(instructions);
        RegisterCounter registerCounter = new RegisterCounter();
        Iterable $this$forEach$iv = instructions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            L2Instruction instruction2 = (L2Instruction)element$iv;
            boolean bl4 = false;
            L2Operand[] $this$forEach$iv2 = instruction2.getOperands();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                L2Operand element$iv2;
                L2Operand it = element$iv2 = $this$forEach$iv2[i];
                boolean bl5 = false;
                it.dispatchOperand(registerCounter);
            }
        }
        L2BasicBlock l2BasicBlock = this.specialBlocks.get((Object)SpecialBlock.AFTER_OPTIONAL_PRIMITIVE);
        Intrinsics.checkNotNull((Object)l2BasicBlock);
        int afterPrimitiveOffset = l2BasicBlock.offset();
        boolean bl6 = bl = afterPrimitiveOffset >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        L2Chunk l2Chunk = this.chunk = (L2Chunk)L2JVMChunk.Companion.allocate(code, afterPrimitiveOffset, instructions, this.controlFlowGraph, this.contingentValues);
        Intrinsics.checkNotNull((Object)l2Chunk);
        A_RawFunction.Companion.setStartingChunkAndReoptimizationCountdown(code, l2Chunk, this.optimizationLevel.getCountdown());
    }

    @NotNull
    public final L2Chunk chunk() {
        L2Chunk l2Chunk = this.chunk;
        Intrinsics.checkNotNull((Object)l2Chunk);
        return l2Chunk;
    }

    @NotNull
    public final String visualize() {
        return this.controlFlowGraph.visualize();
    }

    @NotNull
    public final String simplyVisualize() {
        return this.controlFlowGraph.simplyVisualize();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/optimizer/L2Generator$SpecialBlock;", "", "(Ljava/lang/String;I)V", "START", "AFTER_OPTIONAL_PRIMITIVE", "RESTART_LOOP_HEAD", "UNREACHABLE", "avail"})
    public static final class SpecialBlock
    extends Enum<SpecialBlock> {
        public static final /* enum */ SpecialBlock START = new SpecialBlock();
        public static final /* enum */ SpecialBlock AFTER_OPTIONAL_PRIMITIVE = new SpecialBlock();
        public static final /* enum */ SpecialBlock RESTART_LOOP_HEAD = new SpecialBlock();
        public static final /* enum */ SpecialBlock UNREACHABLE = new SpecialBlock();
        private static final /* synthetic */ SpecialBlock[] $VALUES;

        public static SpecialBlock[] values() {
            return (SpecialBlock[])$VALUES.clone();
        }

        public static SpecialBlock valueOf(String value) {
            return Enum.valueOf(SpecialBlock.class, value);
        }

        static {
            $VALUES = specialBlockArray = new SpecialBlock[]{SpecialBlock.START, SpecialBlock.AFTER_OPTIONAL_PRIMITIVE, SpecialBlock.RESTART_LOOP_HEAD, SpecialBlock.UNREACHABLE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000bH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\rH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000fH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0011H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0012H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0013H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0014H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0015H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0016H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0017H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0018H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0019H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001aH\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u001bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lavail/optimizer/L2Generator$RegisterCounter;", "Lavail/interpreter/levelTwo/L2OperandDispatcher;", "()V", "floatMax", "", "intMax", "objectMax", "doOperand", "", "operand", "Lavail/interpreter/levelTwo/operand/L2ArbitraryConstantOperand;", "Lavail/interpreter/levelTwo/operand/L2CommentOperand;", "Lavail/interpreter/levelTwo/operand/L2ConstantOperand;", "Lavail/interpreter/levelTwo/operand/L2FloatImmediateOperand;", "Lavail/interpreter/levelTwo/operand/L2IntImmediateOperand;", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "Lavail/interpreter/levelTwo/operand/L2PcVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2PrimitiveOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2SelectorOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteIntOperand;", "avail"})
    public static final class RegisterCounter
    implements L2OperandDispatcher {
        private int objectMax = -1;
        private int intMax = -1;
        private int floatMax = -1;

        @Override
        public void doOperand(@NotNull L2ArbitraryConstantOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        }

        @Override
        public void doOperand(@NotNull L2CommentOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        }

        @Override
        public void doOperand(@NotNull L2ConstantOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        }

        @Override
        public void doOperand(@NotNull L2IntImmediateOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        }

        @Override
        public void doOperand(@NotNull L2FloatImmediateOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        }

        @Override
        public void doOperand(@NotNull L2PcOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        }

        @Override
        public void doOperand(@NotNull L2PrimitiveOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        }

        @Override
        public void doOperand(@NotNull L2ReadIntOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            this.intMax = RangesKt.coerceAtLeast((int)this.intMax, (int)operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2ReadFloatOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            this.floatMax = RangesKt.coerceAtLeast((int)this.floatMax, (int)operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2ReadBoxedOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            this.objectMax = RangesKt.coerceAtLeast((int)this.objectMax, (int)operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2ReadBoxedVectorOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            for (L2ReadBoxedOperand register : operand.getElements()) {
                this.objectMax = RangesKt.coerceAtLeast((int)this.objectMax, (int)register.finalIndex());
            }
        }

        @Override
        public void doOperand(@NotNull L2ReadIntVectorOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            for (L2ReadIntOperand register : operand.getElements()) {
                this.intMax = RangesKt.coerceAtLeast((int)this.intMax, (int)register.finalIndex());
            }
        }

        @Override
        public void doOperand(@NotNull L2ReadFloatVectorOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            for (L2ReadFloatOperand register : operand.getElements()) {
                this.floatMax = RangesKt.coerceAtLeast((int)this.floatMax, (int)register.finalIndex());
            }
        }

        @Override
        public void doOperand(@NotNull L2SelectorOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        }

        @Override
        public void doOperand(@NotNull L2WriteIntOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            this.intMax = RangesKt.coerceAtLeast((int)this.intMax, (int)operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2WriteFloatOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            this.floatMax = RangesKt.coerceAtLeast((int)this.floatMax, (int)operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2WriteBoxedOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            this.objectMax = RangesKt.coerceAtLeast((int)this.objectMax, (int)operand.finalIndex());
        }

        @Override
        public void doOperand(@NotNull L2PcVectorOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lavail/optimizer/L2Generator$Companion;", "", "()V", "finalGenerationStat", "Lavail/performance/Statistic;", "getFinalGenerationStat", "()Lavail/performance/Statistic;", "maxExpandedEqualityChecks", "", "maxPolymorphismToInlineDispatch", "backEdgeTo", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "targetBlock", "Lavail/optimizer/L2BasicBlock;", "edgeTo", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final L2PcOperand edgeTo(@NotNull L2BasicBlock targetBlock) {
            Intrinsics.checkNotNullParameter((Object)targetBlock, (String)"targetBlock");
            boolean bl = targetBlock.instructions().isEmpty();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return new L2PcOperand(targetBlock, false, null, null, 12, null);
        }

        @NotNull
        public final L2PcOperand backEdgeTo(@NotNull L2BasicBlock targetBlock) {
            Intrinsics.checkNotNullParameter((Object)targetBlock, (String)"targetBlock");
            boolean bl = targetBlock.isLoopHead();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return new L2PcOperand(targetBlock, true, null, null, 12, null);
        }

        @NotNull
        public final Statistic getFinalGenerationStat() {
            return finalGenerationStat;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

