/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0012\u001a\u0004\u0018\u00010\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lavail/stacks/StacksErrorLog;", "", "outputPath", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "errorCount", "", "errorFilePosition", "", "errorLog", "Ljava/nio/channels/AsynchronousFileChannel;", "getOutputPath$avail", "()Ljava/nio/file/Path;", "addLogEntry", "", "buffer", "Ljava/nio/ByteBuffer;", "addToErrorCount", "file", "avail"})
public final class StacksErrorLog {
    @NotNull
    private final Path outputPath;
    @Nullable
    private AsynchronousFileChannel errorLog;
    private int errorCount;
    private long errorFilePosition;

    public StacksErrorLog(@NotNull Path outputPath) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        this.outputPath = outputPath;
        this.errorFilePosition = 0L;
        this.errorCount = 0;
        try {
            Path errorLogPath = this.outputPath.resolve("errorlog.html");
            Files.createDirectories(this.outputPath, new FileAttribute[0]);
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            this.errorLog = AsynchronousFileChannel.open(errorLogPath, openOptionArray);
            String string2 = "<!DOCTYPE html>\n<head><meta charset=\"UTF-8\"><style>h3 {text-decoration:underline;}\n strong, em {color:blue;}</style>\n</head>\n<body>\n";
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            ByteBuffer openHTML = ByteBuffer.wrap(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)openHTML, (String)"openHTML");
            this.addLogEntry(openHTML, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final Path getOutputPath$avail() {
        return this.outputPath;
    }

    @Nullable
    public final AsynchronousFileChannel file() {
        return this.errorLog;
    }

    public final synchronized void addLogEntry(@NotNull ByteBuffer buffer, int addToErrorCount) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.errorCount += addToErrorCount;
        long position = this.errorFilePosition;
        this.errorFilePosition += (long)buffer.limit();
        AsynchronousFileChannel asynchronousFileChannel = this.errorLog;
        Intrinsics.checkNotNull((Object)asynchronousFileChannel);
        asynchronousFileChannel.write(buffer, position);
    }

    public final int errorCount() {
        return this.errorCount;
    }
}

