/*
 * Decompiled with CFR 0.152.
 */
package avail.builder;

import avail.builder.AvailBuilder;
import avail.builder.BuildDirectoryTracer;
import avail.builder.BuilderProblemHandler;
import avail.builder.ModuleName;
import avail.builder.ModuleRoot;
import avail.builder.ModuleRoots;
import avail.builder.ResolvedModuleName;
import avail.compiler.AvailCompiler;
import avail.compiler.ModuleHeader;
import avail.compiler.ParserState;
import avail.compiler.problems.Problem;
import avail.descriptor.phrases.A_Phrase;
import avail.error.ErrorCode;
import avail.persistence.cache.Repository;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ResolverReference;
import avail.utility.CollectionExtensionsKt;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0013J\b\u0010\u001a\u001a\u00020\u0006H\u0002J\u0016\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0013J0\u0010\u001c\u001a\u00020\u00062(\u0010\u001d\u001a$\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 R\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00060\u001eJp\u0010\u001c\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00122(\u0010\u001d\u001a$\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 R\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00060\u001e2 \u0010#\u001a\u001c\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020%\u0012\u0006\u0012\u0004\u0018\u00010&\u0012\u0004\u0012\u00020\u00060\u001e2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00060(H\u0002JH\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\u001f2(\u0010,\u001a$\u0012\u0004\u0012\u00020\u001f\u0012\b\u0012\u00060 R\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00060\u001e2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00020\n8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eRd\u0010\u000f\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013 \u0014*\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00110\u0011 \u0014**\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013 \u0014*\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00110\u0011\u0018\u00010\u00150\u00108\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000Rd\u0010\u0016\u001aV\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013 \u0014*\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00110\u0011 \u0014**\u0012$\u0012\"\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013 \u0014*\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00110\u0011\u0018\u00010\u00150\u00108\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lavail/builder/BuildDirectoryTracer;", "", "availBuilder", "Lavail/builder/AvailBuilder;", "originalAfterTraceCompletes", "Lkotlin/Function0;", "", "(Lavail/builder/AvailBuilder;Lkotlin/jvm/functions/Function0;)V", "afterTraceCompletes", "allQueued", "", "getAvailBuilder", "()Lavail/builder/AvailBuilder;", "setAvailBuilder", "(Lavail/builder/AvailBuilder;)V", "traceCompletions", "", "Lkotlin/Pair;", "Lavail/resolver/ModuleRootResolver;", "Ljava/net/URI;", "kotlin.jvm.PlatformType", "", "traceRequests", "addTraceRequest", "moduleRootResolver", "moduleURI", "checkForCompletion", "indicateFileCompleted", "traceAllModuleHeaders", "moduleAction", "Lkotlin/Function3;", "Lavail/builder/ResolvedModuleName;", "Lavail/persistence/cache/Repository$ModuleVersion;", "Lavail/persistence/cache/Repository;", "resolver", "moduleFailureHandler", "", "Lavail/error/ErrorCode;", "", "afterAllQueued", "Lkotlin/Function1;", "", "traceOneModuleHeader", "resolvedName", "action", "completedAction", "avail"})
public final class BuildDirectoryTracer {
    @NotNull
    private AvailBuilder availBuilder;
    @GuardedBy(value="this")
    private final Set<Pair<ModuleRootResolver, URI>> traceRequests;
    @GuardedBy(value="this")
    private final Set<Pair<ModuleRootResolver, URI>> traceCompletions;
    @GuardedBy(value="this")
    private boolean allQueued;
    @NotNull
    private final Function0<Unit> afterTraceCompletes;

    public BuildDirectoryTracer(@NotNull AvailBuilder availBuilder, @NotNull Function0<Unit> originalAfterTraceCompletes) {
        Intrinsics.checkNotNullParameter(availBuilder, "availBuilder");
        Intrinsics.checkNotNullParameter(originalAfterTraceCompletes, "originalAfterTraceCompletes");
        this.availBuilder = availBuilder;
        this.traceRequests = Collections.synchronizedSet(new LinkedHashSet());
        this.traceCompletions = Collections.synchronizedSet(new LinkedHashSet());
        this.afterTraceCompletes = new Function0<Unit>(this, originalAfterTraceCompletes){
            final /* synthetic */ BuildDirectoryTracer this$0;
            final /* synthetic */ Function0<Unit> $originalAfterTraceCompletes;
            {
                this.this$0 = $receiver;
                this.$originalAfterTraceCompletes = $originalAfterTraceCompletes;
                super(0);
            }

            public final void invoke() {
                ModuleRoots moduleRoots = this.this$0.getAvailBuilder().getRuntime().moduleRoots();
                for (ModuleRoot root : moduleRoots.getRoots()) {
                    root.getRepository().commit();
                }
                this.$originalAfterTraceCompletes.invoke();
            }
        };
    }

    @NotNull
    public final AvailBuilder getAvailBuilder() {
        return this.availBuilder;
    }

    public final void setAvailBuilder(@NotNull AvailBuilder availBuilder) {
        Intrinsics.checkNotNullParameter(availBuilder, "<set-?>");
        this.availBuilder = availBuilder;
    }

    public final void traceAllModuleHeaders(@NotNull Function3<? super ResolvedModuleName, ? super Repository.ModuleVersion, ? super Function0<Unit>, Unit> moduleAction) {
        Intrinsics.checkNotNullParameter(moduleAction, "moduleAction");
        ModuleRoots moduleRoots = this.availBuilder.getRuntime().moduleRoots();
        CollectionExtensionsKt.parallelDoThen(CollectionsKt.toList(moduleRoots), (Function2)new Function2<ModuleRoot, Function0<? extends Unit>, Unit>(this, moduleAction){
            final /* synthetic */ BuildDirectoryTracer this$0;
            final /* synthetic */ Function3<ResolvedModuleName, Repository.ModuleVersion, Function0<Unit>, Unit> $moduleAction;
            {
                this.this$0 = $receiver;
                this.$moduleAction = $moduleAction;
                super(2);
            }

            public final void invoke(@NotNull ModuleRoot root, @NotNull Function0<Unit> after) {
                Intrinsics.checkNotNullParameter(root, "root");
                Intrinsics.checkNotNullParameter(after, "after");
                BuildDirectoryTracer.access$traceAllModuleHeaders(this.this$0, root.getResolver(), this.$moduleAction, traceAllModuleHeaders.1.INSTANCE, new Function1<Integer, Unit>(after){
                    final /* synthetic */ Function0<Unit> $after;
                    {
                        this.$after = $after;
                        super(1);
                    }

                    public final void invoke(int it) {
                        this.$after.invoke();
                    }
                });
            }
        }, new Function0<Unit>(this){
            final /* synthetic */ BuildDirectoryTracer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                BuildDirectoryTracer buildDirectoryTracer = this.this$0;
                BuildDirectoryTracer buildDirectoryTracer2 = this.this$0;
                BuildDirectoryTracer buildDirectoryTracer3 = buildDirectoryTracer;
                synchronized (buildDirectoryTracer3) {
                    boolean bl = false;
                    BuildDirectoryTracer.access$setAllQueued$p(buildDirectoryTracer2, true);
                    BuildDirectoryTracer.access$checkForCompletion(buildDirectoryTracer2);
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
    }

    private final void traceAllModuleHeaders(ModuleRootResolver resolver, Function3<? super ResolvedModuleName, ? super Repository.ModuleVersion, ? super Function0<Unit>, Unit> moduleAction, Function3<? super String, ? super ErrorCode, ? super Throwable, Unit> moduleFailureHandler, Function1<? super Integer, Unit> afterAllQueued) {
        resolver.provideModuleRootTree((Function1<? super ResolverReference, Unit>)new Function1<ResolverReference, Unit>(afterAllQueued, this, resolver, moduleAction){
            final /* synthetic */ Function1<Integer, Unit> $afterAllQueued;
            final /* synthetic */ BuildDirectoryTracer this$0;
            final /* synthetic */ ModuleRootResolver $resolver;
            final /* synthetic */ Function3<ResolvedModuleName, Repository.ModuleVersion, Function0<Unit>, Unit> $moduleAction;
            {
                this.$afterAllQueued = $afterAllQueued;
                this.this$0 = $receiver;
                this.$resolver = $resolver;
                this.$moduleAction = $moduleAction;
                super(1);
            }

            public final void invoke(@NotNull ResolverReference refRoot) {
                Intrinsics.checkNotNullParameter(refRoot, "refRoot");
                refRoot.walkChildrenThen(false, (Function1<? super ResolverReference, Unit>)new Function1<ResolverReference, Unit>(this.this$0, this.$resolver, this.$moduleAction){
                    final /* synthetic */ BuildDirectoryTracer this$0;
                    final /* synthetic */ ModuleRootResolver $resolver;
                    final /* synthetic */ Function3<ResolvedModuleName, Repository.ModuleVersion, Function0<Unit>, Unit> $moduleAction;
                    {
                        this.this$0 = $receiver;
                        this.$resolver = $resolver;
                        this.$moduleAction = $moduleAction;
                        super(1);
                    }

                    public final void invoke(@NotNull ResolverReference visited) {
                        Intrinsics.checkNotNullParameter(visited, "visited");
                        if (visited.isRoot() || visited.isPackage()) {
                            return;
                        }
                        if (!visited.isModule()) {
                            boolean bl = false;
                            String string2 = "BuildDirectoryTracer only operates on packages and modules, but received " + visited;
                            throw new IllegalArgumentException(string2.toString());
                        }
                        this.this$0.addTraceRequest(this.$resolver, visited.getUri());
                        this.this$0.getAvailBuilder().getRuntime().execute(50, new Function0<Unit>(visited, this.this$0, this.$moduleAction, this.$resolver){
                            final /* synthetic */ ResolverReference $visited;
                            final /* synthetic */ BuildDirectoryTracer this$0;
                            final /* synthetic */ Function3<ResolvedModuleName, Repository.ModuleVersion, Function0<Unit>, Unit> $moduleAction;
                            final /* synthetic */ ModuleRootResolver $resolver;
                            {
                                this.$visited = $visited;
                                this.this$0 = $receiver;
                                this.$moduleAction = $moduleAction;
                                this.$resolver = $resolver;
                                super(0);
                            }

                            public final void invoke() {
                                ResolvedModuleName resolved = new ResolvedModuleName(new ModuleName(this.$visited.getQualifiedName(), false, 2, null), this.this$0.getAvailBuilder().getRuntime().moduleRoots(), this.$visited, false);
                                AtomicBoolean ran = new AtomicBoolean(false);
                                BuildDirectoryTracer.access$traceOneModuleHeader(this.this$0, resolved, this.$moduleAction, new Function0<Unit>(ran, this.this$0, this.$resolver, this.$visited){
                                    final /* synthetic */ AtomicBoolean $ran;
                                    final /* synthetic */ BuildDirectoryTracer this$0;
                                    final /* synthetic */ ModuleRootResolver $resolver;
                                    final /* synthetic */ ResolverReference $visited;
                                    {
                                        this.$ran = $ran;
                                        this.this$0 = $receiver;
                                        this.$resolver = $resolver;
                                        this.$visited = $visited;
                                        super(0);
                                    }

                                    public final void invoke() {
                                        boolean oldRan = this.$ran.getAndSet(true);
                                        boolean bl = !oldRan;
                                        ResolverReference resolverReference = this.$visited;
                                        if (_Assertions.ENABLED && !bl) {
                                            boolean bl2 = false;
                                            String string2 = resolverReference.getLocalName() + " already ran BuildDirectoryTracer.traceOneModuleHeader";
                                            throw new AssertionError((Object)string2);
                                        }
                                        this.this$0.indicateFileCompleted(this.$resolver, this.$visited.getUri());
                                    }
                                });
                            }
                        });
                    }
                }, this.$afterAllQueued);
            }
        }, (Function2<? super ErrorCode, ? super Throwable, Unit>)new Function2<ErrorCode, Throwable, Unit>(moduleFailureHandler, resolver){
            final /* synthetic */ Function3<String, ErrorCode, Throwable, Unit> $moduleFailureHandler;
            final /* synthetic */ ModuleRootResolver $resolver;
            {
                this.$moduleFailureHandler = $moduleFailureHandler;
                this.$resolver = $resolver;
                super(2);
            }

            public final void invoke(@NotNull ErrorCode code, @Nullable Throwable ex) {
                Intrinsics.checkNotNullParameter(code, "code");
                this.$moduleFailureHandler.invoke("Could not get " + this.$resolver.getName() + " ResolverReference", code, ex);
            }
        });
    }

    public final synchronized void addTraceRequest(@NotNull ModuleRootResolver moduleRootResolver, @NotNull URI moduleURI) {
        Intrinsics.checkNotNullParameter(moduleRootResolver, "moduleRootResolver");
        Intrinsics.checkNotNullParameter(moduleURI, "moduleURI");
        boolean added = this.traceRequests.add(TuplesKt.to(moduleRootResolver, moduleURI));
        if (_Assertions.ENABLED && !added) {
            boolean bl = false;
            String string2 = "Attempting to trace file " + moduleURI + " twice";
            throw new AssertionError((Object)string2);
        }
    }

    private final void traceOneModuleHeader(ResolvedModuleName resolvedName, Function3<? super ResolvedModuleName, ? super Repository.ModuleVersion, ? super Function0<Unit>, Unit> action2, Function0<Unit> completedAction) {
        Repository repository = resolvedName.getRepository();
        repository.commitIfStaleChanges(2000L);
        ResolverReference sourceReference = resolvedName.getResolverReference();
        Repository.ModuleArchive archive = repository.getArchive(resolvedName.getRootRelativeName());
        archive.digestForFile(resolvedName, false, (Function1<? super byte[], Unit>)new Function1<byte[], Unit>(resolvedName, archive, action2, completedAction, this, repository, sourceReference){
            final /* synthetic */ ResolvedModuleName $resolvedName;
            final /* synthetic */ Repository.ModuleArchive $archive;
            final /* synthetic */ Function3<ResolvedModuleName, Repository.ModuleVersion, Function0<Unit>, Unit> $action;
            final /* synthetic */ Function0<Unit> $completedAction;
            final /* synthetic */ BuildDirectoryTracer this$0;
            final /* synthetic */ Repository $repository;
            final /* synthetic */ ResolverReference $sourceReference;
            {
                this.$resolvedName = $resolvedName;
                this.$archive = $archive;
                this.$action = $action;
                this.$completedAction = $completedAction;
                this.this$0 = $receiver;
                this.$repository = $repository;
                this.$sourceReference = $sourceReference;
                super(1);
            }

            public final void invoke(@NotNull byte[] digest) {
                Intrinsics.checkNotNullParameter(digest, "digest");
                Repository.ModuleVersionKey versionKey = new Repository.ModuleVersionKey(this.$resolvedName, digest);
                Repository.ModuleVersion existingVersion = this.$archive.getVersion(versionKey);
                if (existingVersion != null) {
                    this.$action.invoke(this.$resolvedName, existingVersion, this.$completedAction);
                    return;
                }
                AvailBuilder availBuilder = this.this$0.getAvailBuilder();
                AvailCompiler.Companion.create(this.$resolvedName, this.this$0.getAvailBuilder().getRuntime(), this.this$0.getAvailBuilder().getTextInterface(), this.this$0.getAvailBuilder().getPollForAbort(), traceOneModuleHeader.1.INSTANCE, this.$completedAction, new BuilderProblemHandler(availBuilder){

                    public void handleGeneric(@NotNull Problem problem2, @NotNull Function1<? super Boolean, Unit> decider) {
                        Intrinsics.checkNotNullParameter(problem2, "problem");
                        Intrinsics.checkNotNullParameter(decider, "decider");
                        decider.invoke((Boolean)false);
                    }
                }, (Function1<? super AvailCompiler, Unit>)new Function1<AvailCompiler, Unit>(this.$completedAction, this.$repository, this.$sourceReference, this.this$0, this.$archive, versionKey, this.$action, this.$resolvedName){
                    final /* synthetic */ Function0<Unit> $completedAction;
                    final /* synthetic */ Repository $repository;
                    final /* synthetic */ ResolverReference $sourceReference;
                    final /* synthetic */ BuildDirectoryTracer this$0;
                    final /* synthetic */ Repository.ModuleArchive $archive;
                    final /* synthetic */ Repository.ModuleVersionKey $versionKey;
                    final /* synthetic */ Function3<ResolvedModuleName, Repository.ModuleVersion, Function0<Unit>, Unit> $action;
                    final /* synthetic */ ResolvedModuleName $resolvedName;
                    {
                        this.$completedAction = $completedAction;
                        this.$repository = $repository;
                        this.$sourceReference = $sourceReference;
                        this.this$0 = $receiver;
                        this.$archive = $archive;
                        this.$versionKey = $versionKey;
                        this.$action = $action;
                        this.$resolvedName = $resolvedName;
                        super(1);
                    }

                    public final void invoke(@NotNull AvailCompiler compiler2) {
                        Intrinsics.checkNotNullParameter(compiler2, "compiler");
                        compiler2.getCompilationContext().getDiagnostics().setSuccessAndFailureReporters(traceOneModuleHeader.1.INSTANCE, this.$completedAction);
                        compiler2.parseModuleHeader((Function2<? super A_Phrase, ? super ParserState, Unit>)new Function2<A_Phrase, ParserState, Unit>(compiler2, this.$repository, this.$sourceReference, this.this$0, this.$archive, this.$versionKey, this.$action, this.$resolvedName, this.$completedAction){
                            final /* synthetic */ AvailCompiler $compiler;
                            final /* synthetic */ Repository $repository;
                            final /* synthetic */ ResolverReference $sourceReference;
                            final /* synthetic */ BuildDirectoryTracer this$0;
                            final /* synthetic */ Repository.ModuleArchive $archive;
                            final /* synthetic */ Repository.ModuleVersionKey $versionKey;
                            final /* synthetic */ Function3<ResolvedModuleName, Repository.ModuleVersion, Function0<Unit>, Unit> $action;
                            final /* synthetic */ ResolvedModuleName $resolvedName;
                            final /* synthetic */ Function0<Unit> $completedAction;
                            {
                                this.$compiler = $compiler;
                                this.$repository = $repository;
                                this.$sourceReference = $sourceReference;
                                this.this$0 = $receiver;
                                this.$archive = $archive;
                                this.$versionKey = $versionKey;
                                this.$action = $action;
                                this.$resolvedName = $resolvedName;
                                this.$completedAction = $completedAction;
                                super(2);
                            }

                            public final void invoke(@NotNull A_Phrase a_Phrase, @NotNull ParserState parserState) {
                                Intrinsics.checkNotNullParameter(a_Phrase, "<anonymous parameter 0>");
                                Intrinsics.checkNotNullParameter(parserState, "<anonymous parameter 1>");
                                ModuleHeader moduleHeader = this.$compiler.getCompilationContext().getModuleHeader();
                                Intrinsics.checkNotNull(moduleHeader);
                                ModuleHeader header = moduleHeader;
                                List<String> importNames = header.getImportedModuleNames();
                                List<String> entryPoints = header.getEntryPointNames();
                                Repository.ModuleVersion newVersion = this.$repository.new Repository.ModuleVersion(this.$sourceReference.getSize(), importNames, entryPoints);
                                this.this$0.getAvailBuilder().serialize$avail(header, newVersion);
                                this.$archive.putVersion(this.$versionKey, newVersion);
                                this.$action.invoke(this.$resolvedName, newVersion, this.$completedAction);
                            }
                        });
                    }
                });
            }
        }, traceOneModuleHeader.2.INSTANCE);
    }

    public final synchronized void indicateFileCompleted(@NotNull ModuleRootResolver moduleRootResolver, @NotNull URI moduleURI) {
        Intrinsics.checkNotNullParameter(moduleRootResolver, "moduleRootResolver");
        Intrinsics.checkNotNullParameter(moduleURI, "moduleURI");
        boolean added = this.traceCompletions.add(TuplesKt.to(moduleRootResolver, moduleURI));
        if (!added) {
            boolean bl = false;
            String string2 = "Completed trace of file " + moduleURI + " twice";
            throw new IllegalArgumentException(string2.toString());
        }
        Level level = Level.FINEST;
        Intrinsics.checkNotNullExpressionValue(level, "FINEST");
        Object[] objectArray = new Object[]{this.traceCompletions.size(), this.traceRequests.size()};
        AvailBuilder.Companion.log$avail(level, "Build-directory traced one (%d/%d)", objectArray);
        this.checkForCompletion();
    }

    private final void checkForCompletion() {
        boolean bl = Thread.holdsLock(this);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (this.allQueued) {
            Set<Pair<ModuleRootResolver, URI>> set2 = this.traceRequests;
            Intrinsics.checkNotNullExpressionValue(set2, "traceRequests");
            Set<Pair<ModuleRootResolver, URI>> set3 = this.traceCompletions;
            Intrinsics.checkNotNullExpressionValue(set3, "traceCompletions");
            if (SetsKt.minus(set2, (Iterable)set3).isEmpty()) {
                this.afterTraceCompletes.invoke();
            }
        }
    }

    public static final /* synthetic */ void access$traceAllModuleHeaders(BuildDirectoryTracer $this, ModuleRootResolver resolver, Function3 moduleAction, Function3 moduleFailureHandler, Function1 afterAllQueued) {
        $this.traceAllModuleHeaders(resolver, moduleAction, moduleFailureHandler, afterAllQueued);
    }

    public static final /* synthetic */ void access$setAllQueued$p(BuildDirectoryTracer $this, boolean bl) {
        $this.allQueued = bl;
    }

    public static final /* synthetic */ void access$checkForCompletion(BuildDirectoryTracer $this) {
        $this.checkForCompletion();
    }

    public static final /* synthetic */ void access$traceOneModuleHeader(BuildDirectoryTracer $this, ResolvedModuleName resolvedName, Function3 action2, Function0 completedAction) {
        $this.traceOneModuleHeader(resolvedName, action2, completedAction);
    }
}

