/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.atoms;

import avail.AvailRuntimeSupport;
import avail.annotations.HideFieldInDebugger;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.atoms.AtomWithPropertiesDescriptor;
import avail.descriptor.atoms.AtomWithPropertiesSharedDescriptor;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.module.A_Module;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AbstractSlotsEnum;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.Descriptor;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.exceptions.MalformedMessageException;
import avail.serialization.SerializerOperation;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u0000 B2\u00020\u0001:\u0004BCDEB7\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u0012\u000e\u0010\t\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\u0007\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0000H\u0016J\b\u0010\u0011\u001a\u00020\u0000H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J2\u0010)\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00150,2\u0012\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0.0,H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u00101\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00102\u001a\u00020\u0017H\u0016J \u00103\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00104\u001a\u00020\u001bH\u0016J\u0018\u00105\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00106\u001a\u000207H\u0016J8\u00108\u001a\u00020*2\u0006\u0010\u0014\u001a\u00020\u00152\n\u00109\u001a\u00060:j\u0002`;2\u0012\u0010<\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020>0=2\u0006\u0010?\u001a\u00020 H\u0016J\u0010\u0010@\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010A\u001a\u00020\u0000H\u0017\u00a8\u0006F"}, d2={"Lavail/descriptor/atoms/AtomDescriptor;", "Lavail/descriptor/representation/Descriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "typeTag", "Lavail/descriptor/types/TypeTag;", "objectSlotsEnumClass", "Ljava/lang/Class;", "Lavail/descriptor/representation/ObjectSlotsEnum;", "integerSlotsEnumClass", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Lavail/descriptor/representation/Mutability;Lavail/descriptor/types/TypeTag;Ljava/lang/Class;Ljava/lang/Class;)V", "allowsImmutableToMutableReferenceInField", "", "e", "Lavail/descriptor/representation/AbstractSlotsEnum;", "immutable", "mutable", "o_AtomName", "Lavail/descriptor/tuples/A_String;", "self", "Lavail/descriptor/representation/AvailObject;", "o_BundleOrCreate", "Lavail/descriptor/bundles/A_Bundle;", "o_BundleOrNil", "o_Equals", "another", "Lavail/descriptor/representation/A_BasicObject;", "o_GetAtomProperty", "key", "Lavail/descriptor/atoms/A_Atom;", "o_Hash", "", "o_IsAtom", "o_IsAtomSpecial", "o_IsInstanceOfKind", "aType", "Lavail/descriptor/types/A_Type;", "o_IssuingModule", "Lavail/descriptor/module/A_Module;", "o_Kind", "o_MakeSharedInternal", "", "queueToProcess", "", "fixups", "Lkotlin/Function0;", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_SetAtomBundle", "bundle", "o_SetAtomProperty", "value", "o_WriteTo", "writer", "Lorg/availlang/json/JSONWriter;", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "propertyMapOrNil", "shared", "Companion", "IntegerSlots", "ObjectSlots", "SpecialAtom", "avail"})
public class AtomDescriptor
extends Descriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final AtomDescriptor mutable = new AtomDescriptor(Mutability.MUTABLE, TypeTag.ATOM_TAG, ObjectSlots.class, IntegerSlots.class);
    @NotNull
    private static final AtomDescriptor immutable = new AtomDescriptor(Mutability.IMMUTABLE, TypeTag.ATOM_TAG, ObjectSlots.class, IntegerSlots.class);
    @NotNull
    private static final AtomDescriptor transientShared = new AtomDescriptor(Mutability.SHARED, TypeTag.ATOM_TAG, ObjectSlots.class, IntegerSlots.class);
    private static final Pattern wordPattern = Pattern.compile("\\w(\\w|\\d|_)*");

    protected AtomDescriptor(@NotNull Mutability mutability, @NotNull TypeTag typeTag, @NotNull Class<? extends ObjectSlotsEnum> objectSlotsEnumClass, @NotNull Class<? extends IntegerSlotsEnum> integerSlotsEnumClass) {
        Intrinsics.checkNotNullParameter((Object)mutability, "mutability");
        Intrinsics.checkNotNullParameter((Object)typeTag, "typeTag");
        Intrinsics.checkNotNullParameter(objectSlotsEnumClass, "objectSlotsEnumClass");
        Intrinsics.checkNotNullParameter(integerSlotsEnumClass, "integerSlotsEnumClass");
        super(mutability, typeTag, objectSlotsEnumClass, integerSlotsEnumClass);
    }

    @Override
    protected boolean allowsImmutableToMutableReferenceInField(@NotNull AbstractSlotsEnum e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return e == IntegerSlots.HASH_AND_MORE;
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder2, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(recursionMap, "recursionMap");
        StringBuilder $this$printObjectOnAvoidingIndent_u24lambda_u2d0 = builder2;
        boolean bl = false;
        String nativeName = A_Atom.Companion.getAtomName(self).asNativeString();
        if (A_Atom.Companion.isAtomSpecial(self)) {
            $this$printObjectOnAvoidingIndent_u24lambda_u2d0.append(nativeName);
            return;
        }
        if (wordPattern.matcher(nativeName).matches()) {
            $this$printObjectOnAvoidingIndent_u24lambda_u2d0.append("$" + nativeName);
        } else {
            $this$printObjectOnAvoidingIndent_u24lambda_u2d0.append("$\"" + nativeName + "\"");
        }
        A_Module issuer = self.slot(ObjectSlots.ISSUING_MODULE);
        if (issuer.getNotNil()) {
            String issuerName = A_Module.Companion.getModuleNameNative(issuer);
            String string2 = issuerName.substring(StringsKt.lastIndexOf$default((CharSequence)issuerName, '/', 0, false, 6, null) + 1);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            String localIssuer = string2;
            $this$printObjectOnAvoidingIndent_u24lambda_u2d0.append(" (from " + localIssuer + ")");
        }
    }

    @Override
    @NotNull
    public A_String o_AtomName(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(ObjectSlots.NAME);
    }

    @Override
    @NotNull
    public A_Bundle o_BundleOrCreate(@NotNull AvailObject self) throws MalformedMessageException {
        Intrinsics.checkNotNullParameter(self, "self");
        return A_Atom.Companion.bundleOrCreate(self.makeShared());
    }

    @Override
    @NotNull
    public A_Bundle o_BundleOrNil(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return NilDescriptor.Companion.getNil();
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return another.traversed().sameAddressAs(self);
    }

    @Override
    @NotNull
    public AvailObject o_GetAtomProperty(@NotNull AvailObject self, @NotNull A_Atom key) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(key, "key");
        return NilDescriptor.Companion.getNil();
    }

    @Override
    public int o_Hash(@NotNull AvailObject self) {
        int n;
        Intrinsics.checkNotNullParameter(self, "self");
        int $this$ifZero$iv = self.slot(IntegerSlots.Companion.getHASH_OR_ZERO());
        boolean $i$f$ifZero = false;
        if ($this$ifZero$iv != 0) {
            n = $this$ifZero$iv;
        } else {
            int n2;
            boolean bl = false;
            int hash = n2 = AvailRuntimeSupport.INSTANCE.nextNonzeroHash();
            boolean bl2 = false;
            self.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), hash);
            n = n2;
        }
        return n;
    }

    @Override
    public boolean o_IsAtom(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return true;
    }

    @Override
    public boolean o_IsAtomSpecial(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return false;
    }

    @Override
    public boolean o_IsInstanceOfKind(@NotNull AvailObject self, @NotNull A_Type aType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aType, "aType");
        return A_Type.Companion.isSupertypeOfPrimitiveTypeEnum(aType, PrimitiveTypeDescriptor.Types.ATOM);
    }

    @Override
    @NotNull
    public A_Module o_IssuingModule(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(ObjectSlots.ISSUING_MODULE);
    }

    @Override
    @NotNull
    public AvailObject o_Kind(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return PrimitiveTypeDescriptor.Types.ATOM.getO();
    }

    @Override
    public void o_MakeSharedInternal(@NotNull AvailObject self, @NotNull List<AvailObject> queueToProcess, @NotNull List<Function0<Unit>> fixups) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(queueToProcess, "queueToProcess");
        Intrinsics.checkNotNullParameter(fixups, "fixups");
        boolean bl = this.isShared();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        super.o_MakeSharedInternal(self, queueToProcess, fixups);
        AvailObject map = this.propertyMapOrNil(self);
        if (map.getNotNil()) {
            Map propertyMap;
            Map $this$forEach$iv = propertyMap = (Map)map.javaObjectNotNull();
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl2 = false;
                A_Atom key = (A_Atom)entry.getKey();
                AvailObject value = (AvailObject)entry.getValue();
                if (!key.descriptor().isShared()) {
                    key.setDescriptor(key.descriptor().shared());
                    Intrinsics.checkNotNull(key, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                    queueToProcess.add((AvailObject)key);
                }
                if (value.descriptor().isShared()) continue;
                value.setDescriptor(value.descriptor().shared());
                queueToProcess.add(value);
            }
        }
        AvailObject substituteAtom = AtomWithPropertiesSharedDescriptor.Companion.getShared().createInitialized(self.slot(ObjectSlots.NAME), self.slot(ObjectSlots.ISSUING_MODULE), map, self.slot(IntegerSlots.Companion.getHASH_OR_ZERO()));
        boolean bl3 = substituteAtom.descriptor().isShared();
        if (_Assertions.ENABLED && !bl3) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        self.setDescriptor(self.descriptor().mutable());
        self.becomeIndirectionTo(substituteAtom);
        self.setDescriptor(self.descriptor().shared());
    }

    @Override
    public void o_SetAtomBundle(@NotNull AvailObject self, @NotNull A_Bundle bundle) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(bundle, "bundle");
        A_Atom.Companion.setAtomBundle(self.makeShared(), bundle);
    }

    @Override
    public void o_SetAtomProperty(@NotNull AvailObject self, @NotNull A_Atom key, @NotNull A_BasicObject value) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        boolean bl2 = bl = !this.isShared();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject substituteAtom = AtomWithPropertiesDescriptor.Companion.createWithProperties(self.slot(ObjectSlots.NAME), self.slot(ObjectSlots.ISSUING_MODULE), self.slot(IntegerSlots.Companion.getHASH_OR_ZERO()));
        self.becomeIndirectionTo(substituteAtom);
        A_Atom.Companion.setAtomProperty(substituteAtom, key, value);
    }

    @Override
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return SerializerOperation.ATOM;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(writer, "writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter this_$iv2;
            JSONWriter $this$o_WriteTo_u24lambda_u2d7 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$o_WriteTo_u24lambda_u2d7;
            Object key$iv = "kind";
            boolean $i$f$at = false;
            this_$iv2.write((String)key$iv);
            void $this$o_WriteTo_u24lambda_u2d7_u24lambda_u2d4 = this_$iv2;
            boolean bl2 = false;
            $this$o_WriteTo_u24lambda_u2d7_u24lambda_u2d4.write("atom");
            this_$iv2 = $this$o_WriteTo_u24lambda_u2d7;
            key$iv = "atom name";
            $i$f$at = false;
            this_$iv2.write((String)key$iv);
            JSONWriter $this$o_WriteTo_u24lambda_u2d7_u24lambda_u2d5 = this_$iv2;
            boolean bl3 = false;
            self.slot(ObjectSlots.NAME).writeTo(writer);
            AvailObject module = self.slot(ObjectSlots.ISSUING_MODULE);
            if (module.getNotNil()) {
                void this_$iv3;
                key$iv = $this$o_WriteTo_u24lambda_u2d7;
                String key$iv2 = "issuing module";
                boolean $i$f$at2 = false;
                this_$iv3.write(key$iv2);
                void $this$o_WriteTo_u24lambda_u2d7_u24lambda_u2d6 = this_$iv3;
                boolean bl4 = false;
                module.writeSummaryTo(writer);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    @NotNull
    protected AvailObject propertyMapOrNil(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return NilDescriptor.Companion.getNil();
    }

    @Override
    @NotNull
    public AtomDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public AtomDescriptor immutable() {
        return immutable;
    }

    @Override
    @Deprecated(message="Shared atoms are implemented in subclasses", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ AtomDescriptor shared() {
        return transientShared;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            HASH_AND_MORE = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE};
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, Companion.HASH_OR_ZERO.1.INSTANCE);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "NAME", "ISSUING_MODULE", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots NAME = new ObjectSlots();
        public static final /* enum */ ObjectSlots ISSUING_MODULE = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.NAME, ObjectSlots.ISSUING_MODULE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0018\b\u0086\u0001\u0018\u0000 \u001f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001fB\u0019\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001cj\u0002\b\u001dj\u0002\b\u001e\u00a8\u0006 "}, d2={"Lavail/descriptor/atoms/AtomDescriptor$SpecialAtom;", "", "name", "", "heritable", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "atom", "Lavail/descriptor/atoms/A_Atom;", "(Ljava/lang/String;ILavail/descriptor/atoms/A_Atom;Z)V", "getAtom", "()Lavail/descriptor/atoms/A_Atom;", "getHeritable", "()Z", "TRUE", "FALSE", "OBJECT_TYPE_NAME_PROPERTY_KEY", "COMPILER_SCOPE_MAP_KEY", "COMPILER_SCOPE_STACK_KEY", "ALL_TOKENS_KEY", "STATIC_TOKENS_KEY", "MACRO_BUNDLE_KEY", "RUNNING_LEXER", "IS_STYLING", "CLIENT_DATA_GLOBAL_KEY", "FILE_KEY", "SERVER_SOCKET_KEY", "SOCKET_KEY", "HERITABLE_KEY", "EXPLICIT_SUBCLASSING_KEY", "DONT_DEBUG_KEY", "Companion", "avail"})
    public static final class SpecialAtom
    extends Enum<SpecialAtom> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final A_Atom atom;
        private final boolean heritable;
        public static final /* enum */ SpecialAtom TRUE;
        public static final /* enum */ SpecialAtom FALSE;
        public static final /* enum */ SpecialAtom OBJECT_TYPE_NAME_PROPERTY_KEY;
        public static final /* enum */ SpecialAtom COMPILER_SCOPE_MAP_KEY;
        public static final /* enum */ SpecialAtom COMPILER_SCOPE_STACK_KEY;
        public static final /* enum */ SpecialAtom ALL_TOKENS_KEY;
        public static final /* enum */ SpecialAtom STATIC_TOKENS_KEY;
        public static final /* enum */ SpecialAtom MACRO_BUNDLE_KEY;
        public static final /* enum */ SpecialAtom RUNNING_LEXER;
        public static final /* enum */ SpecialAtom IS_STYLING;
        public static final /* enum */ SpecialAtom CLIENT_DATA_GLOBAL_KEY;
        public static final /* enum */ SpecialAtom FILE_KEY;
        public static final /* enum */ SpecialAtom SERVER_SOCKET_KEY;
        public static final /* enum */ SpecialAtom SOCKET_KEY;
        public static final /* enum */ SpecialAtom HERITABLE_KEY;
        public static final /* enum */ SpecialAtom EXPLICIT_SUBCLASSING_KEY;
        public static final /* enum */ SpecialAtom DONT_DEBUG_KEY;
        private static final /* synthetic */ SpecialAtom[] $VALUES;

        private SpecialAtom(A_Atom atom, boolean heritable) {
            this.atom = atom;
            this.heritable = heritable;
        }

        /* synthetic */ SpecialAtom(String string2, int n, A_Atom a_Atom, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            this(a_Atom, bl);
        }

        @NotNull
        public final A_Atom getAtom() {
            return this.atom;
        }

        public final boolean getHeritable() {
            return this.heritable;
        }

        private SpecialAtom(String name, boolean heritable) {
            this(Companion.createSpecialAtom(name), heritable);
        }

        /* synthetic */ SpecialAtom(String string2, int n, String string3, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                bl = false;
            }
            this(string3, bl);
        }

        public static SpecialAtom[] values() {
            return (SpecialAtom[])$VALUES.clone();
        }

        public static SpecialAtom valueOf(String value) {
            return Enum.valueOf(SpecialAtom.class, value);
        }

        static {
            TRUE = new SpecialAtom("TRUE", 0, AtomWithPropertiesSharedDescriptor.Companion.getSharedForTrue().createInitialized(StringDescriptor.Companion.stringFrom("true").makeShared(), NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), 0), false, 2, null);
            FALSE = new SpecialAtom("FALSE", 1, AtomWithPropertiesSharedDescriptor.Companion.getSharedForFalse().createInitialized(StringDescriptor.Companion.stringFrom("false").makeShared(), NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), 0), false, 2, null);
            OBJECT_TYPE_NAME_PROPERTY_KEY = new SpecialAtom("OBJECT_TYPE_NAME_PROPERTY_KEY", 2, "object names", false, 2, null);
            COMPILER_SCOPE_MAP_KEY = new SpecialAtom("COMPILER_SCOPE_MAP_KEY", 3, "Compilation scope", false, 2, null);
            COMPILER_SCOPE_STACK_KEY = new SpecialAtom("COMPILER_SCOPE_STACK_KEY", 4, "Compilation scope stack", false, 2, null);
            ALL_TOKENS_KEY = new SpecialAtom("ALL_TOKENS_KEY", 5, "All tokens", false, 2, null);
            STATIC_TOKENS_KEY = new SpecialAtom("STATIC_TOKENS_KEY", 6, "Static tokens", false, 2, null);
            MACRO_BUNDLE_KEY = new SpecialAtom("MACRO_BUNDLE_KEY", 7, "Macro bundle", false, 2, null);
            RUNNING_LEXER = new SpecialAtom("running lexer", true);
            IS_STYLING = new SpecialAtom("IS_STYLING", 9, "is styling", false, 2, null);
            CLIENT_DATA_GLOBAL_KEY = new SpecialAtom("CLIENT_DATA_GLOBAL_KEY", 10, "Compiler client data", false, 2, null);
            FILE_KEY = new SpecialAtom("FILE_KEY", 11, "file key", false, 2, null);
            SERVER_SOCKET_KEY = new SpecialAtom("SERVER_SOCKET_KEY", 12, "server socket key", false, 2, null);
            SOCKET_KEY = new SpecialAtom("SOCKET_KEY", 13, "socket key", false, 2, null);
            HERITABLE_KEY = new SpecialAtom("HERITABLE_KEY", 14, "heritability", false, 2, null);
            EXPLICIT_SUBCLASSING_KEY = new SpecialAtom("EXPLICIT_SUBCLASSING_KEY", 15, "explicit subclassing", false, 2, null);
            DONT_DEBUG_KEY = new SpecialAtom("don't debug", true);
            $VALUES = specialAtomArray = new SpecialAtom[]{SpecialAtom.TRUE, SpecialAtom.FALSE, SpecialAtom.OBJECT_TYPE_NAME_PROPERTY_KEY, SpecialAtom.COMPILER_SCOPE_MAP_KEY, SpecialAtom.COMPILER_SCOPE_STACK_KEY, SpecialAtom.ALL_TOKENS_KEY, SpecialAtom.STATIC_TOKENS_KEY, SpecialAtom.MACRO_BUNDLE_KEY, SpecialAtom.RUNNING_LEXER, SpecialAtom.IS_STYLING, SpecialAtom.CLIENT_DATA_GLOBAL_KEY, SpecialAtom.FILE_KEY, SpecialAtom.SERVER_SOCKET_KEY, SpecialAtom.SOCKET_KEY, SpecialAtom.HERITABLE_KEY, SpecialAtom.EXPLICIT_SUBCLASSING_KEY, SpecialAtom.DONT_DEBUG_KEY};
            Companion = new Companion(null);
            SpecialAtom[] $this$forEach$iv = SpecialAtom.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                SpecialAtom element$iv;
                SpecialAtom specialAtom = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (!specialAtom.heritable) continue;
                A_Atom.Companion.setAtomProperty(specialAtom.atom, SpecialAtom.HERITABLE_KEY.atom, Companion.getTrueObject());
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$SpecialAtom$Companion;", "", "()V", "avail"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lavail/descriptor/atoms/AtomDescriptor$Companion;", "", "()V", "falseObject", "Lavail/descriptor/atoms/A_Atom;", "getFalseObject", "()Lavail/descriptor/atoms/A_Atom;", "immutable", "Lavail/descriptor/atoms/AtomDescriptor;", "mutable", "transientShared", "trueObject", "getTrueObject", "wordPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "createAtom", "Lavail/descriptor/representation/AvailObject;", "name", "Lavail/descriptor/tuples/A_String;", "issuingModule", "Lavail/descriptor/module/A_Module;", "createSpecialAtom", "", "objectFromBoolean", "aBoolean", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AvailObject createAtom(@NotNull A_String name, @NotNull A_Module issuingModule) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(issuingModule, "issuingModule");
            AbstractDescriptor $this$iv = mutable;
            int indexedSlotCount$iv = 0;
            boolean $i$f$createImmutable = false;
            AvailObject $this$createImmutable_u24lambda_u2d4$iv = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
            boolean bl = false;
            AvailObject $this$createAtom_u24lambda_u2d0 = $this$createImmutable_u24lambda_u2d4$iv;
            boolean bl2 = false;
            $this$createAtom_u24lambda_u2d0.setSlot(ObjectSlots.NAME, name.makeShared());
            $this$createAtom_u24lambda_u2d0.setSlot(ObjectSlots.ISSUING_MODULE, issuingModule);
            $this$createAtom_u24lambda_u2d0.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return $this$createImmutable_u24lambda_u2d4$iv.makeImmutable();
        }

        @NotNull
        public final AvailObject createSpecialAtom(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            return AtomWithPropertiesSharedDescriptor.Companion.getSharedSpecial().createInitialized(StringDescriptor.Companion.stringFrom(name), NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), 0);
        }

        @NotNull
        public final A_Atom getTrueObject() {
            return SpecialAtom.TRUE.getAtom();
        }

        @NotNull
        public final A_Atom getFalseObject() {
            return SpecialAtom.FALSE.getAtom();
        }

        @NotNull
        public final A_Atom objectFromBoolean(boolean aBoolean) {
            return aBoolean ? this.getTrueObject() : this.getFalseObject();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

