/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.tuples;

import avail.annotations.HideFieldInDebugger;
import avail.descriptor.character.A_Character;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ByteStringDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.RepeatedElementTupleDescriptor;
import avail.descriptor.tuples.TreeTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.tuples.TwoByteStringDescriptor;
import avail.descriptor.types.A_Type;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.UShort;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 92\u00020\u0001:\u00039:;B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\b\u0010\u0006\u001a\u00020\u0000H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J0\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J \u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\fH\u0016J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0010\u0010 \u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010!\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0010H\u0016J(\u0010#\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u0010%\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00102\u0006\u0010(\u001a\u00020)H\u0016J\u0018\u0010*\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\u0010H\u0016J\u0010\u0010-\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010.\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J8\u0010/\u001a\u0002002\u0006\u0010\t\u001a\u00020\n2\n\u00101\u001a\u000602j\u0002`32\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u000206052\u0006\u00107\u001a\u00020\u0010H\u0016J\b\u00108\u001a\u00020\u0000H\u0016\u00a8\u0006<"}, d2={"Lavail/descriptor/tuples/RepeatedElementTupleDescriptor;", "Lavail/descriptor/tuples/TupleDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "(Lavail/descriptor/representation/Mutability;)V", "immutable", "mutable", "o_AppendCanDestroy", "Lavail/descriptor/tuples/A_Tuple;", "self", "Lavail/descriptor/representation/AvailObject;", "newElement", "Lavail/descriptor/representation/A_BasicObject;", "canDestroy", "", "o_BitsPerEntry", "", "o_CompareFromToWithRepeatedElementTupleStartingAt", "startIndex1", "endIndex1", "aRepeatedElementTuple", "startIndex2", "o_CompareFromToWithStartingAt", "anotherObject", "o_ConcatenateWith", "otherTuple", "o_CopyTupleFromToCanDestroy", "start", "end", "o_Equals", "another", "o_EqualsRepeatedElementTuple", "o_IsRepeatedElementTuple", "o_TupleAt", "index", "o_TupleAtPuttingCanDestroy", "newValueObject", "o_TupleElementsInRangeAreInstancesOf", "startIndex", "endIndex", "type", "Lavail/descriptor/types/A_Type;", "o_TupleIntAt", "o_TupleLongAt", "", "o_TupleReverse", "o_TupleSize", "printObjectOnAvoidingIndent", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "Companion", "IntegerSlots", "ObjectSlots", "avail"})
public final class RepeatedElementTupleDescriptor
extends TupleDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int minimumRepeatSize = 2;
    @NotNull
    private static final RepeatedElementTupleDescriptor mutable = new RepeatedElementTupleDescriptor(Mutability.MUTABLE);
    @NotNull
    private static final RepeatedElementTupleDescriptor immutable = new RepeatedElementTupleDescriptor(Mutability.IMMUTABLE);
    @NotNull
    private static final RepeatedElementTupleDescriptor shared = new RepeatedElementTupleDescriptor(Mutability.SHARED);

    private RepeatedElementTupleDescriptor(Mutability mutability) {
        super(mutability, ObjectSlots.class, IntegerSlots.class);
    }

    @Override
    public boolean o_IsRepeatedElementTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return true;
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder2, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(recursionMap, "recursionMap");
        int size = self.slot(IntegerSlots.Companion.getSIZE());
        if (size < 2) {
            super.printObjectOnAvoidingIndent(self, builder2, recursionMap, indent);
        } else {
            builder2.append(size);
            builder2.append(" of ");
            self.slot(ObjectSlots.ELEMENT).printOnAvoidingIndent(builder2, recursionMap, indent + 1);
        }
    }

    @Override
    @NotNull
    public A_Tuple o_CopyTupleFromToCanDestroy(@NotNull AvailObject self, int start, int end, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        int oldSize = self.slot(IntegerSlots.Companion.getSIZE());
        boolean bl2 = bl = (1 <= start ? start <= end + 1 : false) && end <= oldSize;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int newSize = end - start + 1;
        if (newSize != oldSize) {
            if (this.isMutable() && canDestroy) {
                self.setSlot(IntegerSlots.Companion.getSIZE(), newSize);
                return self;
            }
            return Companion.createRepeatedElementTuple(newSize, self.slot(ObjectSlots.ELEMENT));
        }
        if (this.isMutable() && !canDestroy) {
            self.makeImmutable();
        }
        return self;
    }

    @Override
    public boolean o_CompareFromToWithStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anotherObject, int startIndex2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anotherObject, "anotherObject");
        return A_Tuple.Companion.compareFromToWithRepeatedElementTupleStartingAt(anotherObject, startIndex2, startIndex2 + endIndex1 - startIndex1, self, startIndex1);
    }

    @Override
    public boolean o_CompareFromToWithRepeatedElementTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple aRepeatedElementTuple, int startIndex2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aRepeatedElementTuple, "aRepeatedElementTuple");
        if (self.sameAddressAs(aRepeatedElementTuple)) {
            return true;
        }
        if (self.slot(ObjectSlots.ELEMENT).equals(A_Tuple.Companion.tupleAt(aRepeatedElementTuple, 1))) {
            if (self.slot(IntegerSlots.Companion.getSIZE()) == A_Tuple.Companion.getTupleSize(aRepeatedElementTuple)) {
                if (!this.isShared()) {
                    aRepeatedElementTuple.makeImmutable();
                    self.becomeIndirectionTo(aRepeatedElementTuple);
                } else if (!aRepeatedElementTuple.descriptor().isShared()) {
                    self.makeImmutable();
                    aRepeatedElementTuple.becomeIndirectionTo(self);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public A_Tuple o_ConcatenateWith(@NotNull AvailObject self, @NotNull A_Tuple otherTuple, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(otherTuple, "otherTuple");
        if (!canDestroy) {
            self.makeImmutable();
            otherTuple.makeImmutable();
        }
        if (A_Tuple.Companion.getTupleSize(otherTuple) == 0) {
            return self;
        }
        if (otherTuple.isRepeatedElementTuple()) {
            AvailObject otherDirect = otherTuple.traversed();
            AvailObject element = self.slot(ObjectSlots.ELEMENT);
            if (element.equals(otherDirect.slot(ObjectSlots.ELEMENT))) {
                int newSize = self.slot(IntegerSlots.Companion.getSIZE()) + otherDirect.slot(IntegerSlots.Companion.getSIZE());
                if (this.isMutable()) {
                    self.setSlot(IntegerSlots.Companion.getSIZE(), newSize);
                    self.setHashOrZero(0);
                    return self;
                }
                if (otherTuple.descriptor().isMutable()) {
                    otherDirect.setSlot(IntegerSlots.Companion.getSIZE(), newSize);
                    otherDirect.setHashOrZero(0);
                    return otherDirect;
                }
                return Companion.createRepeatedElementTuple(newSize, element);
            }
        }
        return A_Tuple.Companion.getTreeTupleLevel(otherTuple) == 0 ? (A_Tuple)(A_Tuple.Companion.getTupleSize(otherTuple) == 0 ? self : TreeTupleDescriptor.Companion.createTwoPartTreeTuple(self, otherTuple, 1, 0)) : TreeTupleDescriptor.Companion.concatenateAtLeastOneTree(self, otherTuple, true);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return another.equalsRepeatedElementTuple(self);
    }

    @Override
    public boolean o_EqualsRepeatedElementTuple(@NotNull AvailObject self, @NotNull A_Tuple aRepeatedElementTuple) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aRepeatedElementTuple, "aRepeatedElementTuple");
        if (self.sameAddressAs(aRepeatedElementTuple)) {
            return true;
        }
        AvailObject secondTraversed = aRepeatedElementTuple.traversed();
        int firstHash = self.slot(IntegerSlots.Companion.getHASH_OR_ZERO());
        int secondHash = secondTraversed.slot(IntegerSlots.Companion.getHASH_OR_ZERO());
        if (firstHash != 0 && secondHash != 0 && firstHash != secondHash) {
            return false;
        }
        if (self.slot(IntegerSlots.Companion.getSIZE()) != secondTraversed.slot(IntegerSlots.Companion.getSIZE())) {
            return false;
        }
        if (!self.slot(ObjectSlots.ELEMENT).equals(secondTraversed.slot(ObjectSlots.ELEMENT))) {
            return false;
        }
        if (!this.isShared()) {
            aRepeatedElementTuple.makeImmutable();
            self.becomeIndirectionTo(aRepeatedElementTuple);
        } else if (!aRepeatedElementTuple.descriptor().isShared()) {
            self.makeImmutable();
            aRepeatedElementTuple.becomeIndirectionTo(self);
        }
        return true;
    }

    @Override
    public int o_BitsPerEntry(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return 0;
    }

    @Override
    @NotNull
    public AvailObject o_TupleAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        boolean bl2 = bl = index2 >= 1 && index2 <= self.slot(IntegerSlots.Companion.getSIZE());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return self.slot(ObjectSlots.ELEMENT);
    }

    @Override
    @NotNull
    public A_Tuple o_TupleAtPuttingCanDestroy(@NotNull AvailObject self, int index2, @NotNull A_BasicObject newValueObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(newValueObject, "newValueObject");
        int size = self.slot(IntegerSlots.Companion.getSIZE());
        boolean bl2 = 1 <= index2 ? index2 <= size : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject element = self.slot(ObjectSlots.ELEMENT);
        if (element.equals(newValueObject)) {
            if (!canDestroy) {
                self.makeImmutable();
            }
            return self;
        }
        if (size < 64) {
            element.makeImmutable();
            A_Tuple result2 = null;
            if (A_Number.Companion.isInt(element)) {
                List<Integer> list2 = Collections.nCopies(size, A_Number.Companion.getExtractInt(element));
                Intrinsics.checkNotNullExpressionValue(list2, "nCopies(size, element.extractInt)");
                result2 = TupleDescriptor.Companion.tupleFromIntegerList(list2);
            } else if (A_Character.Companion.isCharacter(element)) {
                int codePoint = A_Character.Companion.getCodePoint(element);
                boolean bl3 = 0 <= codePoint ? codePoint < 256 : false;
                if (bl3) {
                    result2 = ByteStringDescriptor.Companion.generateByteString(size, (Function1<? super Integer, Integer>)new Function1<Integer, Integer>(codePoint){
                        final /* synthetic */ int $codePoint;
                        {
                            this.$codePoint = $codePoint;
                            super(1);
                        }

                        @NotNull
                        public final Integer invoke(int it) {
                            return this.$codePoint;
                        }
                    });
                } else {
                    boolean bl4 = 0 <= codePoint ? codePoint < 65536 : false;
                    if (bl4) {
                        result2 = TwoByteStringDescriptor.Companion.generateTwoByteString(size, (Function1<? super Integer, UShort>)new Function1<Integer, UShort>(codePoint){
                            final /* synthetic */ int $codePoint;
                            {
                                this.$codePoint = $codePoint;
                                super(1);
                            }

                            public final short invoke-BwKQO78(int it) {
                                return UShort.constructor-impl((short)this.$codePoint);
                            }
                        });
                    }
                }
            }
            if (result2 == null) {
                result2 = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(size, (Function1<? super Integer, ? extends A_BasicObject>)new Function1<Integer, A_BasicObject>(element){
                    final /* synthetic */ AvailObject $element;
                    {
                        this.$element = $element;
                        super(1);
                    }

                    @NotNull
                    public final A_BasicObject invoke(int it) {
                        return this.$element;
                    }
                });
            }
            return A_Tuple.Companion.tupleAtPuttingCanDestroy(result2, index2, newValueObject, true);
        }
        A_Tuple left = A_Tuple.Companion.copyTupleFromToCanDestroy(self, 1, index2 - 1, false);
        A_Tuple right = A_Tuple.Companion.copyTupleFromToCanDestroy(self, index2 + 1, size, false);
        return A_Tuple.Companion.concatenateWith(A_Tuple.Companion.appendCanDestroy(left, newValueObject, true), right, true);
    }

    @Override
    @NotNull
    public A_Tuple o_AppendCanDestroy(@NotNull AvailObject self, @NotNull A_BasicObject newElement, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(newElement, "newElement");
        if (self.slot(ObjectSlots.ELEMENT).equals(newElement)) {
            AvailObject result2 = canDestroy && this.isMutable() ? self : AvailObjectRepresentation.Companion.newLike(mutable, self, 0, 0);
            result2.setSlot(IntegerSlots.Companion.getSIZE(), self.slot(IntegerSlots.Companion.getSIZE()) + 1);
            result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return result2;
        }
        A_Tuple singleton2 = ObjectTupleDescriptor.Companion.tuple(newElement);
        return A_Tuple.Companion.concatenateWith(self, singleton2, canDestroy);
    }

    @Override
    public int o_TupleIntAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        boolean bl2 = 1 <= index2 ? index2 <= self.slot(IntegerSlots.Companion.getSIZE()) : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return A_Number.Companion.getExtractInt(self.slot(ObjectSlots.ELEMENT));
    }

    @Override
    public long o_TupleLongAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        boolean bl2 = 1 <= index2 ? index2 <= self.slot(IntegerSlots.Companion.getSIZE()) : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return A_Number.Companion.getExtractLong(self.slot(ObjectSlots.ELEMENT));
    }

    @Override
    @NotNull
    public A_Tuple o_TupleReverse(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self;
    }

    @Override
    public int o_TupleSize(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(IntegerSlots.Companion.getSIZE());
    }

    @Override
    public boolean o_TupleElementsInRangeAreInstancesOf(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull A_Type type2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(type2, "type");
        return self.slot(ObjectSlots.ELEMENT).isInstanceOf(type2);
    }

    @Override
    @NotNull
    public RepeatedElementTupleDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public RepeatedElementTupleDescriptor immutable() {
        return immutable;
    }

    @Override
    @NotNull
    public RepeatedElementTupleDescriptor shared() {
        return shared;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/tuples/RepeatedElementTupleDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField SIZE;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            boolean bl;
            HASH_AND_MORE = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE};
            Companion = new Companion(null);
            SIZE = new BitField(HASH_AND_MORE, 32, 32, Companion.SIZE.1.INSTANCE);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, Companion.HASH_OR_ZERO.1.INSTANCE);
            boolean bl2 = bl = TupleDescriptor.IntegerSlots.HASH_AND_MORE.ordinal() == HASH_AND_MORE.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl = TupleDescriptor.IntegerSlots.Companion.getHASH_OR_ZERO().isSamePlaceAs(HASH_OR_ZERO);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lavail/descriptor/tuples/RepeatedElementTupleDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "SIZE", "getSIZE", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getSIZE() {
                return SIZE;
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lavail/descriptor/tuples/RepeatedElementTupleDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "ELEMENT", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots ELEMENT = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.ELEMENT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/descriptor/tuples/RepeatedElementTupleDescriptor$Companion;", "", "()V", "immutable", "Lavail/descriptor/tuples/RepeatedElementTupleDescriptor;", "minimumRepeatSize", "", "mutable", "getMutable", "()Lavail/descriptor/tuples/RepeatedElementTupleDescriptor;", "shared", "createRepeatedElementTuple", "Lavail/descriptor/tuples/A_Tuple;", "size", "element", "Lavail/descriptor/representation/A_BasicObject;", "forceCreate", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RepeatedElementTupleDescriptor getMutable() {
            return mutable;
        }

        @NotNull
        public final A_Tuple createRepeatedElementTuple(int size, @NotNull A_BasicObject element) {
            A_Tuple a_Tuple;
            Intrinsics.checkNotNullParameter(element, "element");
            if (size == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            if (size < 2) {
                List<A_BasicObject> list2 = Collections.nCopies(size, element);
                Intrinsics.checkNotNullExpressionValue(list2, "nCopies(size, element)");
                a_Tuple = ObjectTupleDescriptor.Companion.tupleFromList(list2);
            } else {
                a_Tuple = this.forceCreate(size, element);
            }
            return a_Tuple;
        }

        private final A_Tuple forceCreate(int size, A_BasicObject element) {
            AvailObject availObject;
            AbstractDescriptor $this$iv = this.getMutable();
            int indexedSlotCount$iv = 0;
            boolean $i$f$create = false;
            AvailObject $this$forceCreate_u24lambda_u2d0 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
            boolean bl = false;
            $this$forceCreate_u24lambda_u2d0.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            $this$forceCreate_u24lambda_u2d0.setSlot(IntegerSlots.Companion.getSIZE(), size);
            ObjectSlotsEnum objectSlotsEnum = ObjectSlots.ELEMENT;
            A_BasicObject a_BasicObject = element;
            Intrinsics.checkNotNull(a_BasicObject);
            $this$forceCreate_u24lambda_u2d0.setSlot(objectSlotsEnum, a_BasicObject);
            return availObject;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

