/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.types;

import avail.annotations.HideFieldInDebugger;
import avail.annotations.ThreadSafe;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AbstractSlotsEnum;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.descriptor.types.TypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.serialization.SerializerOperation;
import avail.utility.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ?2\u00020\u0001:\u0003?@AB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0000H\u0016J\b\u0010\n\u001a\u00020\u0000H\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012H\u0016J\u001e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u001b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0012H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u0015H\u0016J\u0018\u0010\"\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000fH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010&\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u000fH\u0016J\u0018\u0010(\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000fH\u0016J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010*\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010\f\u001a\u00020\rH\u0017J\u0018\u0010-\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000fH\u0016J\u0018\u0010.\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000fH\u0016J\u0018\u0010/\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010!\u001a\u00020\u000fH\u0016J\u0018\u00100\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u000fH\u0016J\u0018\u00101\u001a\u0002022\u0006\u0010\f\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u0002022\u0006\u0010\f\u001a\u00020\r2\u0006\u00103\u001a\u000204H\u0016J8\u00106\u001a\u0002022\u0006\u0010\f\u001a\u00020\r2\n\u00107\u001a\u000608j\u0002`92\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020<0;2\u0006\u0010=\u001a\u00020%H\u0016J\b\u0010>\u001a\u00020\u0000H\u0016\u00a8\u0006B"}, d2={"Lavail/descriptor/types/FunctionTypeDescriptor;", "Lavail/descriptor/types/TypeDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "(Lavail/descriptor/representation/Mutability;)V", "allowsImmutableToMutableReferenceInField", "", "e", "Lavail/descriptor/representation/AbstractSlotsEnum;", "immutable", "mutable", "o_AcceptsArgTypesFromFunctionType", "self", "Lavail/descriptor/representation/AvailObject;", "functionType", "Lavail/descriptor/types/A_Type;", "o_AcceptsListOfArgTypes", "argTypes", "", "o_AcceptsListOfArgValues", "argValues", "Lavail/descriptor/representation/A_BasicObject;", "o_AcceptsTupleOfArgTypes", "Lavail/descriptor/tuples/A_Tuple;", "o_AcceptsTupleOfArguments", "arguments", "o_ArgsTupleType", "o_CouldEverBeInvokedWith", "argRestrictions", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "o_DeclaredExceptions", "Lavail/descriptor/sets/A_Set;", "o_Equals", "another", "o_EqualsFunctionType", "aFunctionType", "o_Hash", "", "o_IsSubtypeOf", "aType", "o_IsSupertypeOfFunctionType", "o_IsVacuousType", "o_ReturnType", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_TypeIntersection", "o_TypeIntersectionOfFunctionType", "o_TypeUnion", "o_TypeUnionOfFunctionType", "o_WriteSummaryTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "o_WriteTo", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "Companion", "IntegerSlots", "ObjectSlots", "avail"})
public final class FunctionTypeDescriptor
extends TypeDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final FunctionTypeDescriptor mutable = new FunctionTypeDescriptor(Mutability.MUTABLE);
    @NotNull
    private static final FunctionTypeDescriptor immutable = new FunctionTypeDescriptor(Mutability.IMMUTABLE);
    @NotNull
    private static final FunctionTypeDescriptor shared = new FunctionTypeDescriptor(Mutability.SHARED);
    @NotNull
    private static final A_Type mostGeneralType = Companion.functionTypeReturning(PrimitiveTypeDescriptor.Types.TOP.getO()).makeShared();
    @NotNull
    private static final A_Type meta = InstanceMetaDescriptor.Companion.instanceMeta(mostGeneralType).makeShared();

    private FunctionTypeDescriptor(Mutability mutability) {
        super(mutability, TypeTag.FUNCTION_TYPE_TAG, TypeTag.FUNCTION_TAG, ObjectSlots.class, IntegerSlots.class);
    }

    @Override
    public boolean allowsImmutableToMutableReferenceInField(@NotNull AbstractSlotsEnum e) {
        Intrinsics.checkNotNullParameter(e, "e");
        return e == IntegerSlots.HASH_AND_MORE;
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder2, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        Intrinsics.checkNotNullParameter(recursionMap, "recursionMap");
        builder2.append('[');
        List list2 = new ArrayList();
        A_Type tupleType = A_Type.Companion.getArgsTupleType(self);
        if (tupleType.isBottom()) {
            builder2.append("\u2026");
        } else {
            A_Number minObject = A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(tupleType));
            A_Number maxObject = A_Type.Companion.getUpperBound(A_Type.Companion.getSizeRange(tupleType));
            if (A_Number.Companion.isInt(minObject)) {
                int i = 1;
                int min = A_Number.Companion.getExtractInt(minObject);
                if (i <= min) {
                    while (true) {
                        list2.add(A_Type.Companion.typeAtIndex(tupleType, i));
                        if (i == min) break;
                        ++i;
                    }
                }
                if (!minObject.equals(maxObject)) {
                    list2.add(null);
                    int max = A_Tuple.Companion.getTupleSize(A_Type.Companion.getTypeTuple(tupleType)) + 1;
                    max = Integer.max(max, min + 1);
                    int i2 = min + 1;
                    int n = max;
                    if (i2 <= n) {
                        while (true) {
                            list2.add(A_Type.Companion.typeAtIndex(tupleType, i2));
                            if (i2 == n) break;
                            ++i2;
                        }
                    }
                    if (!A_Number.Companion.equalsInt(maxObject, max)) {
                        list2.add(null);
                        list2.add(maxObject);
                    }
                }
                FunctionTypeDescriptor.Companion.printListOnAvoidingIndent(list2, builder2, recursionMap, indent);
            } else {
                builder2.append("?");
            }
        }
        builder2.append("]\u2192");
        A_Type.Companion.getReturnType(self).printOnAvoidingIndent(builder2, recursionMap, indent + 1);
        if (A_Set.Companion.getSetSize(A_Type.Companion.getDeclaredExceptions(self)) > 0) {
            builder2.append("^");
            list2.clear();
            for (AvailObject elem : A_Type.Companion.getDeclaredExceptions(self)) {
                list2.add(elem);
            }
            FunctionTypeDescriptor.Companion.printListOnAvoidingIndent(list2, builder2, recursionMap, indent);
        }
    }

    @Override
    public boolean o_AcceptsArgTypesFromFunctionType(@NotNull AvailObject self, @NotNull A_Type functionType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(functionType, "functionType");
        return A_Type.Companion.isSubtypeOf(A_Type.Companion.getArgsTupleType(functionType), self.slot(ObjectSlots.ARGS_TUPLE_TYPE));
    }

    @Override
    public boolean o_AcceptsListOfArgTypes(@NotNull AvailObject self, @NotNull List<? extends A_Type> argTypes2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(argTypes2, "argTypes");
        A_Type tupleType = self.slot(ObjectSlots.ARGS_TUPLE_TYPE);
        int end = argTypes2.size();
        for (int i = 1; i <= end; ++i) {
            if (A_Type.Companion.isSubtypeOf(argTypes2.get(i - 1), A_Type.Companion.typeAtIndex(tupleType, i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean o_AcceptsListOfArgValues(@NotNull AvailObject self, @NotNull List<? extends A_BasicObject> argValues) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(argValues, "argValues");
        A_Type tupleType = self.slot(ObjectSlots.ARGS_TUPLE_TYPE);
        int end = argValues.size();
        for (int i = 1; i <= end; ++i) {
            A_BasicObject arg = argValues.get(i - 1);
            if (arg.isInstanceOf(A_Type.Companion.typeAtIndex(tupleType, i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean o_AcceptsTupleOfArgTypes(@NotNull AvailObject self, @NotNull A_Tuple argTypes2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(argTypes2, "argTypes");
        A_Type tupleType = self.slot(ObjectSlots.ARGS_TUPLE_TYPE);
        int end = A_Tuple.Companion.getTupleSize(argTypes2);
        for (int i = 1; i <= end; ++i) {
            if (A_Type.Companion.isSubtypeOf(A_Tuple.Companion.tupleAt(argTypes2, i), A_Type.Companion.typeAtIndex(tupleType, i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean o_AcceptsTupleOfArguments(@NotNull AvailObject self, @NotNull A_Tuple arguments2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        return arguments2.isInstanceOf(self.slot(ObjectSlots.ARGS_TUPLE_TYPE));
    }

    @Override
    @NotNull
    public A_Type o_ArgsTupleType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(ObjectSlots.ARGS_TUPLE_TYPE);
    }

    @Override
    public boolean o_CouldEverBeInvokedWith(@NotNull AvailObject self, @NotNull List<TypeRestriction> argRestrictions) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(self, "self");
            Intrinsics.checkNotNullParameter(argRestrictions, "argRestrictions");
            A_Type tupleType = self.slot(ObjectSlots.ARGS_TUPLE_TYPE);
            Iterable $this$all$iv = new IntRange(1, argRestrictions.size());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (argRestrictions.get(it - 1).intersectsType(A_Type.Companion.typeAtIndex(tupleType, it))) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public A_Set o_DeclaredExceptions(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(ObjectSlots.DECLARED_EXCEPTIONS);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return another.equalsFunctionType(self);
    }

    @Override
    public boolean o_EqualsFunctionType(@NotNull AvailObject self, @NotNull A_Type aFunctionType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aFunctionType, "aFunctionType");
        if (self.sameAddressAs(aFunctionType)) {
            return true;
        }
        if (self.hash() != aFunctionType.hash()) {
            return false;
        }
        if (!self.slot(ObjectSlots.ARGS_TUPLE_TYPE).equals(A_Type.Companion.getArgsTupleType(aFunctionType))) {
            return false;
        }
        if (!self.slot(ObjectSlots.RETURN_TYPE).equals(A_Type.Companion.getReturnType(aFunctionType))) {
            return false;
        }
        if (!self.slot(ObjectSlots.DECLARED_EXCEPTIONS).equals(A_Type.Companion.getDeclaredExceptions(aFunctionType))) {
            return false;
        }
        if (!this.isShared()) {
            aFunctionType.makeImmutable();
            self.becomeIndirectionTo(aFunctionType);
        } else if (!aFunctionType.descriptor().isShared()) {
            self.makeImmutable();
            aFunctionType.becomeIndirectionTo(self);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int o_Hash(@NotNull AvailObject self) {
        int n;
        Intrinsics.checkNotNullParameter(self, "self");
        A_BasicObject.Companion companion = A_BasicObject.Companion;
        A_BasicObject a_BasicObject = self;
        boolean syncCondition$iv = this.isShared();
        boolean $i$f$synchronizeIf = false;
        if (syncCondition$iv) {
            void var6_6 = $this$synchronizeIf$iv;
            synchronized (var6_6) {
                boolean bl = false;
                void $this$o_Hash_u24lambda_u2d1 = $this$synchronizeIf$iv;
                boolean bl2 = false;
                int n2 = FunctionTypeDescriptor.Companion.hash(self);
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl16 : MonitorExitStatement: MONITOREXIT : var6_6
                n = n2;
            }
        } else {
            void $this$o_Hash_u24lambda_u2d1 = $this$synchronizeIf$iv;
            boolean bl = false;
            n = FunctionTypeDescriptor.Companion.hash(self);
        }
        return n;
    }

    @Override
    public boolean o_IsSubtypeOf(@NotNull AvailObject self, @NotNull A_Type aType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aType, "aType");
        return A_Type.Companion.isSupertypeOfFunctionType(aType, self);
    }

    @Override
    public boolean o_IsSupertypeOfFunctionType(@NotNull AvailObject self, @NotNull A_Type aFunctionType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aFunctionType, "aFunctionType");
        if (self.equals(aFunctionType)) {
            return true;
        }
        if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.getReturnType(aFunctionType), self.slot(ObjectSlots.RETURN_TYPE))) {
            return false;
        }
        A_Set inners = self.slot(ObjectSlots.DECLARED_EXCEPTIONS);
        block0: for (AvailObject outer : A_Type.Companion.getDeclaredExceptions(aFunctionType)) {
            for (AvailObject inner : inners) {
                if (!A_Type.Companion.isSubtypeOf(outer, inner)) continue;
                continue block0;
            }
            return false;
        }
        return A_Type.Companion.isSubtypeOf(self.slot(ObjectSlots.ARGS_TUPLE_TYPE), A_Type.Companion.getArgsTupleType(aFunctionType));
    }

    @Override
    public boolean o_IsVacuousType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        A_Type argsTupleType = self.slot(ObjectSlots.ARGS_TUPLE_TYPE);
        A_Type sizeRange = A_Type.Companion.getSizeRange(argsTupleType);
        return A_Number.Companion.lessThan(A_Type.Companion.getLowerBound(sizeRange), A_Type.Companion.getUpperBound(sizeRange));
    }

    @Override
    @NotNull
    public A_Type o_ReturnType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(ObjectSlots.RETURN_TYPE);
    }

    @Override
    @NotNull
    public A_Type o_TypeIntersection(@NotNull AvailObject self, @NotNull A_Type another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return A_Type.Companion.isSubtypeOf(self, another) ? (A_Type)self : (A_Type.Companion.isSubtypeOf(another, self) ? another : A_Type.Companion.typeIntersectionOfFunctionType(another, self));
    }

    @Override
    @NotNull
    public A_Type o_TypeIntersectionOfFunctionType(@NotNull AvailObject self, @NotNull A_Type aFunctionType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aFunctionType, "aFunctionType");
        A_Type tupleTypeUnion = A_Type.Companion.typeUnion(self.slot(ObjectSlots.ARGS_TUPLE_TYPE), A_Type.Companion.getArgsTupleType(aFunctionType));
        A_Type returnType = A_Type.Companion.typeIntersection(self.slot(ObjectSlots.RETURN_TYPE), A_Type.Companion.getReturnType(aFunctionType));
        A_Set exceptions = SetDescriptor.Companion.getEmptySet();
        for (AvailObject outer : self.slot(ObjectSlots.DECLARED_EXCEPTIONS)) {
            for (AvailObject inner : A_Type.Companion.getDeclaredExceptions(aFunctionType)) {
                exceptions = A_Set.Companion.setWithElementCanDestroy(exceptions, A_Type.Companion.typeIntersection(outer, inner), true);
            }
        }
        exceptions = FunctionTypeDescriptor.Companion.normalizeExceptionSet(exceptions);
        return Companion.functionTypeFromArgumentTupleType(tupleTypeUnion, returnType, exceptions);
    }

    @Override
    @NotNull
    public A_Type o_TypeUnion(@NotNull AvailObject self, @NotNull A_Type another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return A_Type.Companion.isSubtypeOf(self, another) ? another : (A_Type.Companion.isSubtypeOf(another, self) ? (A_Type)self : A_Type.Companion.typeUnionOfFunctionType(another, self));
    }

    @Override
    @NotNull
    public A_Type o_TypeUnionOfFunctionType(@NotNull AvailObject self, @NotNull A_Type aFunctionType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aFunctionType, "aFunctionType");
        self.makeSubobjectsImmutable();
        A_Type tupleTypeIntersection = A_Type.Companion.typeIntersection(self.slot(ObjectSlots.ARGS_TUPLE_TYPE), A_Type.Companion.getArgsTupleType(aFunctionType));
        A_Type returnType = A_Type.Companion.typeUnion(self.slot(ObjectSlots.RETURN_TYPE), A_Type.Companion.getReturnType(aFunctionType));
        A_Set exceptions = FunctionTypeDescriptor.Companion.normalizeExceptionSet(A_Set.Companion.setUnionCanDestroy(self.slot(ObjectSlots.DECLARED_EXCEPTIONS), A_Type.Companion.getDeclaredExceptions(aFunctionType), true));
        return Companion.functionTypeFromArgumentTupleType(tupleTypeIntersection, returnType, exceptions);
    }

    @Override
    @ThreadSafe
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return SerializerOperation.FUNCTION_TYPE;
    }

    @Override
    public void o_WriteSummaryTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.startObject();
        writer.write("kind");
        writer.write("function type");
        writer.write("arguments type");
        self.slot(ObjectSlots.ARGS_TUPLE_TYPE).writeSummaryTo(writer);
        writer.write("return type");
        self.slot(ObjectSlots.RETURN_TYPE).writeSummaryTo(writer);
        writer.write("declared exceptions");
        self.slot(ObjectSlots.DECLARED_EXCEPTIONS).writeSummaryTo(writer);
        writer.endObject();
    }

    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.startObject();
        writer.write("kind");
        writer.write("function type");
        writer.write("arguments type");
        self.slot(ObjectSlots.ARGS_TUPLE_TYPE).writeTo(writer);
        writer.write("return type");
        self.slot(ObjectSlots.RETURN_TYPE).writeTo(writer);
        writer.write("declared exceptions");
        self.slot(ObjectSlots.DECLARED_EXCEPTIONS).writeTo(writer);
        writer.endObject();
    }

    @Override
    @NotNull
    public FunctionTypeDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public FunctionTypeDescriptor immutable() {
        return immutable;
    }

    @Override
    @NotNull
    public FunctionTypeDescriptor shared() {
        return shared;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/types/FunctionTypeDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            HASH_AND_MORE = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE};
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, Companion.HASH_OR_ZERO.1.INSTANCE);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/types/FunctionTypeDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/types/FunctionTypeDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "DECLARED_EXCEPTIONS", "RETURN_TYPE", "ARGS_TUPLE_TYPE", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots DECLARED_EXCEPTIONS = new ObjectSlots();
        public static final /* enum */ ObjectSlots RETURN_TYPE = new ObjectSlots();
        public static final /* enum */ ObjectSlots ARGS_TUPLE_TYPE = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.DECLARED_EXCEPTIONS, ObjectSlots.RETURN_TYPE, ObjectSlots.ARGS_TUPLE_TYPE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\n\u001a\u00020\u0006J\"\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u0010H\u0007J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00062\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0006J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J@\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\n\u0010\u001f\u001a\u00060 j\u0002`!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\u0015H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lavail/descriptor/types/FunctionTypeDescriptor$Companion;", "", "()V", "immutable", "Lavail/descriptor/types/FunctionTypeDescriptor;", "meta", "Lavail/descriptor/types/A_Type;", "mostGeneralType", "mutable", "shared", "functionMeta", "functionType", "argTypes", "Lavail/descriptor/tuples/A_Tuple;", "returnType", "exceptionSet", "Lavail/descriptor/sets/A_Set;", "functionTypeFromArgumentTupleType", "argsTupleType", "functionTypeReturning", "hash", "", "self", "Lavail/descriptor/representation/AvailObject;", "mostGeneralFunctionType", "normalizeExceptionSet", "printListOnAvoidingIndent", "", "objects", "", "Lavail/descriptor/representation/A_BasicObject;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final void printListOnAvoidingIndent(List<? extends A_BasicObject> objects, StringBuilder builder2, IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
            StringBuilder $this$printListOnAvoidingIndent_u24lambda_u2d0 = builder2;
            boolean bl = false;
            int objectCount = objects.size();
            boolean anyBreaks = false;
            List tempStrings = new ArrayList();
            for (A_BasicObject a_BasicObject : objects) {
                Object object = a_BasicObject;
                if (object == null || (object = object.toString()) == null) {
                    object = "\u2026";
                }
                Object str = object;
                tempStrings.add(str);
                if (StringsKt.indexOf$default((CharSequence)str, '\n', 0, false, 6, null) <= -1) continue;
                anyBreaks = true;
            }
            if (anyBreaks) {
                for (int i = 0; i < objectCount; ++i) {
                    A_BasicObject a_BasicObject;
                    if (i > 0) {
                        $this$printListOnAvoidingIndent_u24lambda_u2d0.append(',');
                    }
                    Strings.INSTANCE.newlineTab($this$printListOnAvoidingIndent_u24lambda_u2d0, indent);
                    A_BasicObject a_BasicObject2 = a_BasicObject = objects.get(i);
                    if (a_BasicObject2 != null) {
                        a_BasicObject2.printOnAvoidingIndent(builder2, recursionMap, indent + 1);
                        continue;
                    }
                    $this$printListOnAvoidingIndent_u24lambda_u2d0.append("\u2026");
                }
            } else {
                for (int i = 0; i < objectCount; ++i) {
                    if (i > 0) {
                        $this$printListOnAvoidingIndent_u24lambda_u2d0.append(", ");
                    }
                    $this$printListOnAvoidingIndent_u24lambda_u2d0.append((String)tempStrings.get(i));
                }
            }
        }

        private final int hash(AvailObject self) {
            int hash = self.slot(IntegerSlots.Companion.getHASH_OR_ZERO());
            if (hash == 0) {
                hash = AvailObject.Companion.combine4(self.slot(ObjectSlots.RETURN_TYPE).hash(), self.slot(ObjectSlots.DECLARED_EXCEPTIONS).hash(), self.slot(ObjectSlots.ARGS_TUPLE_TYPE).hash(), 272920839);
                self.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), hash);
            }
            return hash;
        }

        @NotNull
        public final A_Type mostGeneralFunctionType() {
            return mostGeneralType;
        }

        @NotNull
        public final A_Type functionMeta() {
            return meta;
        }

        /*
         * WARNING - void declaration
         */
        private final A_Set normalizeExceptionSet(A_Set exceptionSet) {
            A_Set a_Set;
            int setSize = A_Set.Companion.getSetSize(exceptionSet);
            if (setSize == 0) {
                a_Set = SetDescriptor.Companion.getEmptySet();
            } else if (setSize == 1 && ((AvailObject)CollectionsKt.single(exceptionSet)).isBottom()) {
                a_Set = SetDescriptor.Companion.getEmptySet();
            } else if (setSize == 1) {
                a_Set = exceptionSet;
            } else {
                void var3_3;
                A_Set normalizedSet = SetDescriptor.Companion.getEmptySet();
                block0: for (AvailObject outer : exceptionSet) {
                    if (outer.isBottom()) continue;
                    for (AvailObject inner : exceptionSet) {
                        if (!A_Type.Companion.isSubtypeOf(outer, inner)) continue;
                        continue block0;
                    }
                    normalizedSet = A_Set.Companion.setWithElementCanDestroy(normalizedSet, outer, true);
                }
                a_Set = var3_3;
            }
            return a_Set;
        }

        @NotNull
        public final A_Type functionTypeFromArgumentTupleType(@NotNull A_Type argsTupleType, @Nullable A_Type returnType, @NotNull A_Set exceptionSet) {
            Intrinsics.checkNotNullParameter(argsTupleType, "argsTupleType");
            Intrinsics.checkNotNullParameter(exceptionSet, "exceptionSet");
            boolean bl = argsTupleType.isTupleType();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Set exceptionsReduced = this.normalizeExceptionSet(exceptionSet);
            AbstractDescriptor $this$iv = mutable;
            int indexedSlotCount$iv = 0;
            boolean $i$f$createImmutable = false;
            AvailObject $this$createImmutable_u24lambda_u2d4$iv = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
            boolean bl2 = false;
            AvailObject $this$functionTypeFromArgumentTupleType_u24lambda_u2d1 = $this$createImmutable_u24lambda_u2d4$iv;
            boolean bl3 = false;
            $this$functionTypeFromArgumentTupleType_u24lambda_u2d1.setSlot(ObjectSlots.ARGS_TUPLE_TYPE, argsTupleType);
            $this$functionTypeFromArgumentTupleType_u24lambda_u2d1.setSlot(ObjectSlots.DECLARED_EXCEPTIONS, exceptionsReduced);
            ObjectSlotsEnum objectSlotsEnum = ObjectSlots.RETURN_TYPE;
            A_Type a_Type = returnType;
            Intrinsics.checkNotNull(a_Type);
            $this$functionTypeFromArgumentTupleType_u24lambda_u2d1.setSlot(objectSlotsEnum, a_Type);
            $this$functionTypeFromArgumentTupleType_u24lambda_u2d1.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return $this$createImmutable_u24lambda_u2d4$iv.makeImmutable();
        }

        @JvmOverloads
        @NotNull
        public final A_Type functionType(@NotNull A_Tuple argTypes2, @NotNull A_Type returnType, @NotNull A_Set exceptionSet) {
            Intrinsics.checkNotNullParameter(argTypes2, "argTypes");
            Intrinsics.checkNotNullParameter(returnType, "returnType");
            Intrinsics.checkNotNullParameter(exceptionSet, "exceptionSet");
            A_Type tupleType = TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(IntegerRangeTypeDescriptor.Companion.singleInt(A_Tuple.Companion.getTupleSize(argTypes2)), argTypes2, BottomTypeDescriptor.Companion.getBottom());
            return this.functionTypeFromArgumentTupleType(tupleType, returnType, exceptionSet);
        }

        public static /* synthetic */ A_Type functionType$default(Companion companion, A_Tuple a_Tuple, A_Type a_Type, A_Set a_Set, int n, Object object) {
            if ((n & 4) != 0) {
                a_Set = SetDescriptor.Companion.getEmptySet();
            }
            return companion.functionType(a_Tuple, a_Type, a_Set);
        }

        @NotNull
        public final A_Type functionTypeReturning(@NotNull A_Type returnType) {
            Intrinsics.checkNotNullParameter(returnType, "returnType");
            return this.functionTypeFromArgumentTupleType(BottomTypeDescriptor.Companion.getBottom(), returnType, SetDescriptor.Companion.getEmptySet());
        }

        @JvmOverloads
        @NotNull
        public final A_Type functionType(@NotNull A_Tuple argTypes2, @NotNull A_Type returnType) {
            Intrinsics.checkNotNullParameter(argTypes2, "argTypes");
            Intrinsics.checkNotNullParameter(returnType, "returnType");
            return avail.descriptor.types.FunctionTypeDescriptor$Companion.functionType$default(this, argTypes2, returnType, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

