/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.DeclarationPhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapPrefixBlockArgument;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_BootstrapPrefixBlockArgument
extends Primitive {
    @NotNull
    public static final P_BootstrapPrefixBlockArgument INSTANCE = new P_BootstrapPrefixBlockArgument();

    private P_BootstrapPrefixBlockArgument() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject optionalBlockArgumentsList = interpreter.argument(0);
        if (interpreter.availLoaderOrNull() == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        boolean bl4 = bl3 = A_Phrase.Companion.getExpressionsSize(optionalBlockArgumentsList) == 1;
        if (_Assertions.ENABLED && !bl3) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Phrase blockArgumentsList = A_Phrase.Companion.getLastExpression(optionalBlockArgumentsList);
        boolean bl5 = bl2 = A_Phrase.Companion.getExpressionsSize(blockArgumentsList) >= 1;
        if (_Assertions.ENABLED && !bl2) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        A_Phrase lastPair = A_Phrase.Companion.getLastExpression(blockArgumentsList);
        boolean bl6 = bl = A_Phrase.Companion.getExpressionsSize(lastPair) == 2;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        A_Phrase namePhrase = A_Phrase.Companion.expressionAt(lastPair, 1);
        A_Phrase typePhrase = A_Phrase.Companion.expressionAt(lastPair, 2);
        boolean bl7 = namePhrase.isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(PrimitiveTypeDescriptor.Types.TOKEN.getO()));
        if (_Assertions.ENABLED && !bl7) {
            String string5 = "Assertion failed";
            throw new AssertionError((Object)string5);
        }
        bl7 = typePhrase.isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(InstanceMetaDescriptor.Companion.anyMeta()));
        if (_Assertions.ENABLED && !bl7) {
            String string6 = "Assertion failed";
            throw new AssertionError((Object)string6);
        }
        A_Token outerArgToken = A_Phrase.Companion.getToken(namePhrase);
        AvailObject argToken = outerArgToken.literal();
        A_String argName = argToken.string();
        if (argToken.tokenType() != TokenDescriptor.TokenType.KEYWORD) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "argument name to be alphanumeric, not " + argName, new Object[0]);
        }
        AvailObject argType = A_Phrase.Companion.getToken(typePhrase).literal();
        boolean bl8 = argType.isType();
        if (_Assertions.ENABLED && !bl8) {
            String string7 = "Assertion failed";
            throw new AssertionError((Object)string7);
        }
        if (argType.isBottom()) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.WEAK, "block parameter type not to be \u22a5", new Object[0]);
        }
        A_Phrase argDeclaration = DeclarationPhraseDescriptor.Companion.newArgument(argToken, argType, typePhrase);
        A_Phrase conflictingDeclaration = FiberDescriptor.Companion.addDeclaration(argDeclaration);
        if (conflictingDeclaration != null) {
            String kind2 = conflictingDeclaration.declarationKind().nativeKindName();
            int lineNumber = A_Phrase.Companion.getToken(conflictingDeclaration).lineNumber();
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "block argument declaration " + argName + " to have a name that doesn't shadow an existing " + kind2 + " (from line " + lineNumber + ")", new Object[0]);
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_Type[] a_TypeArray = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), InstanceMetaDescriptor.Companion.anyMeta()};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.oneOrMoreOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray))))), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

