/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.methods;

import avail.compiler.ModuleManifestEntry;
import avail.compiler.SideEffectKind;
import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_Styler;
import avail.descriptor.methods.MethodDescriptor;
import avail.descriptor.parsing.A_Lexer;
import avail.descriptor.parsing.LexerDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.interpreter.Primitive;
import avail.interpreter.effects.LoadingEffectToRunPrimitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.execution.LexicalScanner;
import avail.interpreter.primitive.style.P_BootstrapDefinitionStyler;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014\u00a8\u0006\f"}, d2={"Lavail/interpreter/primitive/methods/P_SimpleLexerDefinitionForAtom;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "bootstrapStyler", "Lavail/interpreter/primitive/style/P_BootstrapDefinitionStyler;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_SimpleLexerDefinitionForAtom
extends Primitive {
    @NotNull
    public static final P_SimpleLexerDefinitionForAtom INSTANCE = new P_SimpleLexerDefinitionForAtom();

    private P_SimpleLexerDefinitionForAtom() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanSuspend, Primitive.Flag.Unknown};
        super(4, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        A_Bundle a_Bundle;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(4);
        AvailObject atom = interpreter.argument(0);
        AvailObject filterFunction = interpreter.argument(1);
        AvailObject bodyFunction = interpreter.argument(2);
        AvailObject optionalStylerFunction = interpreter.argument(3);
        A_Fiber fiber2 = interpreter.fiber();
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(fiber2);
        if (availLoader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        AvailLoader loader = availLoader;
        if (!loader.getPhase().isExecuting()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION);
        }
        try {
            a_Bundle = A_Atom.Companion.bundleOrCreate(atom);
        }
        catch (MalformedMessageException e) {
            return interpreter.primitiveFailure(e.getErrorCode());
        }
        A_Bundle bundle = a_Bundle;
        A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
        A_Lexer lexer = LexerDescriptor.Companion.newLexer(filterFunction, bodyFunction, method, loader.getModule());
        return interpreter.suspendInSafePointThen((Function1<? super Interpreter.SuspensionHelper<A_BasicObject>, Unit>)new Function1<Interpreter.SuspensionHelper<A_BasicObject>, Unit>(filterFunction, atom, bodyFunction, loader, lexer, optionalStylerFunction){
            final /* synthetic */ AvailObject $filterFunction;
            final /* synthetic */ AvailObject $atom;
            final /* synthetic */ AvailObject $bodyFunction;
            final /* synthetic */ AvailLoader $loader;
            final /* synthetic */ A_Lexer $lexer;
            final /* synthetic */ AvailObject $optionalStylerFunction;
            {
                this.$filterFunction = $filterFunction;
                this.$atom = $atom;
                this.$bodyFunction = $bodyFunction;
                this.$loader = $loader;
                this.$lexer = $lexer;
                this.$optionalStylerFunction = $optionalStylerFunction;
                super(1);
            }

            public final void invoke(@NotNull Interpreter.SuspensionHelper<A_BasicObject> $this$suspendInSafePointThen) {
                Intrinsics.checkNotNullParameter($this$suspendInSafePointThen, "$this$suspendInSafePointThen");
                A_RawFunction.Companion.setMethodName(this.$filterFunction.code(), StringDescriptor.Companion.stringFrom("Filter for lexer " + A_Atom.Companion.getAtomName(this.$atom)));
                A_RawFunction.Companion.setMethodName(this.$bodyFunction.code(), StringDescriptor.Companion.stringFrom("Body for lexer " + A_Atom.Companion.getAtomName(this.$atom)));
                if (this.$loader.getPhase() == AvailLoader.Phase.EXECUTING_FOR_COMPILE) {
                    LexicalScanner lexicalScanner2 = this.$loader.getLexicalScanner();
                    Intrinsics.checkNotNull(lexicalScanner2);
                    lexicalScanner2.addLexer(this.$lexer);
                    List<ModuleManifestEntry> list2 = this.$loader.getManifestEntries();
                    Intrinsics.checkNotNull(list2);
                    String string2 = A_Atom.Companion.getAtomName(this.$atom).asNativeString();
                    A_Phrase a_Phrase = this.$loader.getTopLevelStatementBeingCompiled();
                    Intrinsics.checkNotNull(a_Phrase);
                    list2.add(new ModuleManifestEntry(SideEffectKind.LEXER_KIND, string2, A_Phrase.Companion.getStartingLineNumber(a_Phrase), A_RawFunction.Companion.getCodeStartingLineNumber(this.$bodyFunction.code()), this.$bodyFunction, 0, 32, null));
                }
                A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{this.$atom, this.$filterFunction, this.$bodyFunction, TupleDescriptor.Companion.getEmptyTuple()};
                this.$loader.recordEffect(new LoadingEffectToRunPrimitive(MethodDescriptor.SpecialMethodAtom.LEXER_DEFINER.getBundle(), a_BasicObjectArray));
                if (A_Tuple.Companion.getTupleSize(this.$optionalStylerFunction) == 1) {
                    AvailObject stylerFunction = A_Tuple.Companion.tupleAt(this.$optionalStylerFunction, 1);
                    this.$loader.addStyler(A_Atom.Companion.bundleOrCreate(this.$atom), stylerFunction);
                } else {
                    AvailLoader.Companion.addBootstrapStyler(this.$bodyFunction.code(), this.$atom, this.$loader.getModule());
                }
                $this$suspendInSafePointThen.succeed(NilDescriptor.Companion.getNil());
            }
        });
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), LexerDescriptor.Companion.lexerFilterFunctionType(), LexerDescriptor.Companion.lexerBodyFunctionType(), TupleTypeDescriptor.Companion.zeroOrOneOf(A_Styler.Companion.getStylerFunctionType())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Set.Companion.setUnionCanDestroy(SetDescriptor.Companion.set(availErrorCodeArray), MessageSplitter.Companion.getPossibleErrors(), true));
    }

    @Override
    @NotNull
    public P_BootstrapDefinitionStyler bootstrapStyler() {
        return P_BootstrapDefinitionStyler.INSTANCE;
    }
}

