/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014J\u001e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/interpreter/primitive/tuples/P_TupleReplaceAt;", "Lavail/interpreter/Primitive;", "()V", "maximumComplexity", "Lavail/descriptor/representation/AvailObject;", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_TupleReplaceAt
extends Primitive {
    @NotNull
    public static final P_TupleReplaceAt INSTANCE = new P_TupleReplaceAt();
    @NotNull
    private static final AvailObject maximumComplexity = IntegerDescriptor.Companion.fromInt(1000);

    private P_TupleReplaceAt() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject tuple2 = interpreter.argument(0);
        AvailObject indexObject = interpreter.argument(1);
        AvailObject value = interpreter.argument(2);
        if (!A_Number.Companion.isInt(indexObject)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS);
        }
        int index2 = A_Number.Companion.getExtractInt(indexObject);
        return index2 > A_Tuple.Companion.getTupleSize(tuple2) ? interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS) : interpreter.primitiveSuccess(A_Tuple.Companion.tupleAtPuttingCanDestroy(tuple2, index2, value, true));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getMostGeneralTupleType(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), PrimitiveTypeDescriptor.Types.ANY.getO()), TupleTypeDescriptor.Companion.getMostGeneralTupleType(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type originalTupleType = argumentTypes.get(0);
        A_Type subscripts = argumentTypes.get(1);
        A_Type newElementType = argumentTypes.get(2);
        A_Number lowerBound = A_Type.Companion.getLowerBound(subscripts);
        A_Number upperBound = A_Type.Companion.getUpperBound(subscripts);
        boolean singleSubscript = lowerBound.equals(upperBound);
        if (A_Number.Companion.greaterThan(lowerBound, maximumComplexity) || upperBound.isFinite() && A_Number.Companion.greaterThan(upperBound, maximumComplexity)) {
            return super.returnTypeGuaranteedByVM(rawFunction, argumentTypes);
        }
        A_Tuple originalTypeTuple = A_Type.Companion.getTypeTuple(originalTupleType);
        int originalTypeTupleSize = A_Tuple.Companion.getTupleSize(originalTypeTuple);
        int minSubscript = A_Number.Companion.isInt(lowerBound) ? Math.max(A_Number.Companion.getExtractInt(lowerBound), 1) : 1;
        int maxSubscript = upperBound.isFinite() ? Math.min(A_Number.Companion.getExtractInt(upperBound), originalTypeTupleSize) : Integer.MAX_VALUE;
        List typeList = new ArrayList();
        CollectionsKt.addAll((Collection)typeList, originalTypeTuple);
        for (int i = 1; i < minSubscript; ++i) {
            typeList.add(A_Type.Companion.typeAtIndex(originalTupleType, i));
        }
        int i = minSubscript;
        int limit = Math.min(maxSubscript, originalTypeTupleSize);
        if (i <= limit) {
            while (true) {
                if (singleSubscript) {
                    boolean bl;
                    boolean bl2 = bl = minSubscript == limit;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    typeList.add(newElementType);
                } else {
                    typeList.add(A_Type.Companion.typeUnion(A_Type.Companion.typeAtIndex(originalTupleType, i), newElementType));
                }
                if (i == limit) break;
                ++i;
            }
        }
        if ((i = limit + 1) <= originalTypeTupleSize) {
            while (true) {
                typeList.add(A_Type.Companion.typeAtIndex(originalTupleType, i));
                if (i == originalTypeTupleSize) break;
                ++i;
            }
        }
        A_Type newDefaultType = upperBound.isFinite() ? A_Type.Companion.getDefaultType(originalTupleType) : A_Type.Companion.typeUnion(A_Type.Companion.getDefaultType(originalTupleType), newElementType);
        return TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(A_Type.Companion.getSizeRange(originalTupleType), ObjectTupleDescriptor.Companion.tupleFromList(typeList), newDefaultType);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

