/*
 * Decompiled with CFR 0.152.
 */
package avail.resolver;

import avail.builder.AvailBuilder;
import avail.builder.ModuleName;
import avail.builder.ModuleNameResolver;
import avail.builder.ResolvedModuleName;
import avail.builder.UnresolvedModuleException;
import avail.error.ErrorCode;
import avail.files.AvailFile;
import avail.files.AvailModuleFile;
import avail.files.NullFileWrapper;
import avail.persistence.cache.Repository;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ResolverReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.artifact.ResourceType;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0013\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 r2\u00020\u0001:\u0001rBS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0011J\u0014\u0010K\u001a\b\u0012\u0004\u0012\u00020\u00000L2\u0006\u0010M\u001a\u00020\"JM\u0010\u001d\u001a\u00020N2\b\b\u0002\u0010O\u001a\u00020\"2\u0018\u0010P\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020N0Q2\u001a\u0010R\u001a\u0016\u0012\u0004\u0012\u00020S\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020N0QH\u0000\u00a2\u0006\u0002\bTJ\u0013\u0010U\u001a\u00020\"2\b\u0010V\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0010J\b\u0010Z\u001a\u00020[H\u0016J\u000e\u0010\\\u001a\u00020\"2\u0006\u0010]\u001a\u00020\u0000J\u000e\u0010^\u001a\u00020\"2\u0006\u0010]\u001a\u00020\u0000JF\u0010_\u001a\u00020N2\u0006\u0010`\u001a\u00020\"2\u001a\u0010a\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010b\u0012\u0004\u0012\u00020N0Q2\u001a\u0010R\u001a\u0016\u0012\u0004\u0012\u00020S\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020N0QJF\u0010c\u001a\u00020N2\u0006\u0010`\u001a\u00020\"2\u001a\u0010a\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010b\u0012\u0004\u0012\u00020N0Q2\u001a\u0010R\u001a\u0016\u0012\u0004\u0012\u00020S\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u00020N0QJ\u0018\u0010d\u001a\u00020N2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hH\u0002J\u0016\u0010O\u001a\u00020N2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\b\u0010i\u001a\u00020\u0007H\u0016J8\u0010j\u001a\u00020N2\u0006\u0010k\u001a\u00020\"2\u0012\u0010l\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020N0m2\u0014\b\u0002\u0010n\u001a\u000e\u0012\u0004\u0012\u00020[\u0012\u0004\u0012\u00020N0mJ\u0016\u0010o\u001a\u00020N2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hJ\u001f\u0010p\u001a\u0004\u0018\u00010N2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020hH\u0002\u00a2\u0006\u0002\u0010qR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0018\u0010\u0018\u001a\u00060\u0019R\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010$R\u0011\u0010&\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u0011\u0010'\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010$R\u0011\u0010(\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010$R\u0011\u0010)\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010$R\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001b\u0010\u000e\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b-\u0010.R\u001e\u0010\n\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010.R\u001b\u00102\u001a\u0002038FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b6\u00100\u001a\u0004\b4\u00105R\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020\u000008\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001b\u0010;\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b=\u00100\u001a\u0004\b<\u0010.R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010.R\u0014\u0010?\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0017\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000008\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010:R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010*\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010,R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010HR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010J\u00a8\u0006s"}, d2={"Lavail/resolver/ResolverReference;", "", "resolver", "Lavail/resolver/ModuleRootResolver;", "uri", "Ljava/net/URI;", "qualifiedName", "", "type", "Lorg/availlang/artifact/ResourceType;", "mimeType", "lastModified", "", "size", "localName", "forcedDigest", "", "(Lavail/resolver/ModuleRootResolver;Ljava/net/URI;Ljava/lang/String;Lorg/availlang/artifact/ResourceType;Ljava/lang/String;JJLjava/lang/String;[B)V", "accessException", "", "getAccessException", "()Ljava/lang/Throwable;", "setAccessException", "(Ljava/lang/Throwable;)V", "archive", "Lavail/persistence/cache/Repository$ModuleArchive;", "Lavail/persistence/cache/Repository;", "getArchive", "()Lavail/persistence/cache/Repository$ModuleArchive;", "digest", "getDigest", "()[B", "getForcedDigest", "hasChildren", "", "getHasChildren", "()Z", "isModule", "isPackage", "isPackageRepresentative", "isResource", "isRoot", "<set-?>", "getLastModified", "()J", "getLocalName", "()Ljava/lang/String;", "localName$delegate", "Lkotlin/Lazy;", "getMimeType", "moduleName", "Lavail/builder/ModuleName;", "getModuleName", "()Lavail/builder/ModuleName;", "moduleName$delegate", "modules", "", "getModules", "()Ljava/util/List;", "parentName", "getParentName", "parentName$delegate", "getQualifiedName", "repository", "getRepository", "()Lavail/persistence/cache/Repository;", "getResolver", "()Lavail/resolver/ModuleRootResolver;", "resources", "getResources", "getSize", "getType", "()Lorg/availlang/artifact/ResourceType;", "getUri", "()Ljava/net/URI;", "childReferences", "", "includeResources", "", "refresh", "withDigest", "Lkotlin/Function2;", "failureHandler", "Lavail/error/ErrorCode;", "digest$avail", "equals", "other", "file", "Lavail/files/AvailFile;", "rawBytes", "hashCode", "", "isChildOf", "reference", "isDescendantOf", "readFileBytes", "bypassFileManager", "withContents", "Ljava/util/UUID;", "readFileString", "recursivelyWriteOn", "writer", "Lorg/availlang/json/JSONWriter;", "builder", "Lavail/builder/AvailBuilder;", "toString", "walkChildrenThen", "visitResources", "withReference", "Lkotlin/Function1;", "afterAllVisited", "writeOn", "writeResolutionInformationOn", "(Lorg/availlang/json/JSONWriter;Lavail/builder/AvailBuilder;)Lkotlin/Unit;", "Companion", "avail"})
public final class ResolverReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleRootResolver resolver;
    @NotNull
    private final URI uri;
    @NotNull
    private final String qualifiedName;
    @NotNull
    private final ResourceType type;
    @Nullable
    private final byte[] forcedDigest;
    @NotNull
    private final List<ResolverReference> modules;
    @NotNull
    private final List<ResolverReference> resources;
    @NotNull
    private String mimeType;
    @NotNull
    private final Lazy moduleName$delegate;
    @NotNull
    private final Lazy localName$delegate;
    @NotNull
    private final Lazy parentName$delegate;
    private long lastModified;
    private long size;
    @Nullable
    private Throwable accessException;
    @NotNull
    public static final String DIGEST_ALGORITHM = "SHA-256";

    public ResolverReference(@NotNull ModuleRootResolver resolver, @NotNull URI uri, @NotNull String qualifiedName2, @NotNull ResourceType type2, @NotNull String mimeType, long lastModified, long size, @NotNull String localName2, @Nullable byte[] forcedDigest) {
        Intrinsics.checkNotNullParameter(resolver, "resolver");
        Intrinsics.checkNotNullParameter(uri, "uri");
        Intrinsics.checkNotNullParameter(qualifiedName2, "qualifiedName");
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(mimeType, "mimeType");
        Intrinsics.checkNotNullParameter(localName2, "localName");
        this.resolver = resolver;
        this.uri = uri;
        this.qualifiedName = qualifiedName2;
        this.type = type2;
        this.forcedDigest = forcedDigest;
        this.modules = new ArrayList();
        this.resources = new ArrayList();
        this.mimeType = mimeType;
        this.moduleName$delegate = LazyKt.lazy((Function0)new Function0<ModuleName>(this){
            final /* synthetic */ ResolverReference this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ModuleName invoke() {
                return new ModuleName(this.this$0.getQualifiedName(), false);
            }
        });
        this.localName$delegate = LazyKt.lazy((Function0)new Function0<String>(localName2, this){
            final /* synthetic */ String $localName;
            final /* synthetic */ ResolverReference this$0;
            {
                this.$localName = $localName;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                CharSequence charSequence;
                CharSequence charSequence2 = this.$localName;
                ResolverReference resolverReference = this.this$0;
                if (charSequence2.length() == 0) {
                    boolean bl = false;
                    charSequence = resolverReference.getModuleName().getLocalName();
                } else {
                    charSequence = charSequence2;
                }
                return (String)charSequence;
            }
        });
        this.parentName$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ ResolverReference this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return StringsKt.substringBeforeLast$default(this.this$0.getQualifiedName(), "/", null, 2, null);
            }
        });
        this.lastModified = lastModified;
        this.size = size;
    }

    public /* synthetic */ ResolverReference(ModuleRootResolver moduleRootResolver, URI uRI, String string2, ResourceType resourceType, String string3, long l, long l2, String string4, byte[] byArray, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            string4 = "";
        }
        if ((n & 0x100) != 0) {
            byArray = null;
        }
        this(moduleRootResolver, uRI, string2, resourceType, string3, l, l2, string4, byArray);
    }

    @NotNull
    public final ModuleRootResolver getResolver() {
        return this.resolver;
    }

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    @NotNull
    public final String getQualifiedName() {
        return this.qualifiedName;
    }

    @NotNull
    public final ResourceType getType() {
        return this.type;
    }

    @Nullable
    public final byte[] getForcedDigest() {
        return this.forcedDigest;
    }

    public final boolean isRoot() {
        return this.type == ResourceType.ROOT;
    }

    public final boolean isPackage() {
        return this.type == ResourceType.PACKAGE;
    }

    public final boolean isPackageRepresentative() {
        return this.type == ResourceType.REPRESENTATIVE;
    }

    public final boolean isModule() {
        return this.type == ResourceType.MODULE || this.type == ResourceType.REPRESENTATIVE;
    }

    public final boolean isResource() {
        return this.type == ResourceType.RESOURCE || this.type == ResourceType.DIRECTORY;
    }

    public final boolean getHasChildren() {
        return !((Collection)this.modules).isEmpty() || !((Collection)this.resources).isEmpty();
    }

    @NotNull
    public final List<ResolverReference> getModules() {
        return this.modules;
    }

    @NotNull
    public final List<ResolverReference> getResources() {
        return this.resources;
    }

    @NotNull
    public final List<ResolverReference> childReferences(boolean includeResources) {
        return includeResources ? CollectionsKt.plus((Collection)this.modules, (Iterable)this.resources) : this.modules;
    }

    public final boolean isDescendantOf(@NotNull ResolverReference reference) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        return reference.getHasChildren() && StringsKt.startsWith$default(this.qualifiedName, reference.qualifiedName, false, 2, null);
    }

    public final boolean isChildOf(@NotNull ResolverReference reference) {
        Intrinsics.checkNotNullParameter(reference, "reference");
        return reference.getHasChildren() && this.childReferences(true).contains(this);
    }

    private final Repository getRepository() {
        return this.resolver.getModuleRoot().getRepository();
    }

    private final Repository.ModuleArchive getArchive() {
        return this.getRepository().getArchive(this.getModuleName().getRootRelativeName());
    }

    @NotNull
    public final String getMimeType() {
        return this.mimeType;
    }

    @NotNull
    public final ModuleName getModuleName() {
        Lazy lazy = this.moduleName$delegate;
        return (ModuleName)lazy.getValue();
    }

    @NotNull
    public final String getLocalName() {
        Lazy lazy = this.localName$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String getParentName() {
        Lazy lazy = this.parentName$delegate;
        return (String)lazy.getValue();
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    public final long getSize() {
        return this.size;
    }

    private final byte[] getDigest() {
        byte[] byArray = this.forcedDigest;
        if (this.forcedDigest == null) {
            byArray = this.getArchive().provideDigest$avail(this);
        }
        return byArray;
    }

    @Nullable
    public final Throwable getAccessException() {
        return this.accessException;
    }

    public final void setAccessException(@Nullable Throwable throwable) {
        this.accessException = throwable;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final AvailFile file(@NotNull byte[] rawBytes) {
        Intrinsics.checkNotNullParameter(rawBytes, "rawBytes");
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return new AvailModuleFile(rawBytes, new NullFileWrapper(rawBytes, this, this.resolver.getFileManager()), null, 4, null);
            }
            case 5: 
            case 6: 
            case 7: {
                throw new UnsupportedOperationException(this.qualifiedName + " (" + this.type + ") cannot be an AvailFile");
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final void recursivelyWriteOn(JSONWriter writer, AvailBuilder builder) {
        block17: {
            if (this.type == ResourceType.REPRESENTATIVE) break block17;
            this_$iv = writer;
            $i$f$writeObject = false;
            this_$iv.startObject();
            try {
                $this$recursivelyWriteOn_u24lambda_u2d11 = this_$iv;
                $i$a$-writeObject-ResolverReference$recursivelyWriteOn$1 = false;
                var7_7 = $this$recursivelyWriteOn_u24lambda_u2d11;
                key$iv = "localName";
                $i$f$at = false;
                this_$iv.write(key$iv);
                $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d0 = this_$iv;
                $i$a$-at-ResolverReference$recursivelyWriteOn$1$1 = false;
                $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d0.write(this.getLocalName());
                this_$iv = $this$recursivelyWriteOn_u24lambda_u2d11;
                key$iv = "qualifiedName";
                $i$f$at = false;
                this_$iv.write(key$iv);
                $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d1 = this_$iv;
                $i$a$-at-ResolverReference$recursivelyWriteOn$1$2 = false;
                $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d1.write(this.qualifiedName);
                this_$iv = $this$recursivelyWriteOn_u24lambda_u2d11;
                key$iv = "type";
                $i$f$at = false;
                this_$iv.write(key$iv);
                $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d2 = this_$iv;
                $i$a$-at-ResolverReference$recursivelyWriteOn$1$3 = false;
                $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d2.write(this.type.getLabel());
                v0 = this.accessException;
                if (v0 != null) {
                    it = v0;
                    $i$a$-let-ResolverReference$recursivelyWriteOn$1$4 = false;
                    $i$a$-at-ResolverReference$recursivelyWriteOn$1$3 = $this$recursivelyWriteOn_u24lambda_u2d11;
                    key$iv = "error";
                    $i$f$at = false;
                    this_$iv.write(key$iv);
                    $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d4_u24lambda_u2d3 = this_$iv;
                    $i$a$-at-ResolverReference$recursivelyWriteOn$1$4$1 = false;
                    $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d4_u24lambda_u2d3.write(it.getLocalizedMessage());
                }
                switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
                    case 5: {
                        if (this.accessException != null) ** GOTO lbl68
                        $this$none$iv = this.modules;
                        $i$f$none = false;
                        if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) ** GOTO lbl50
                        v1 = true;
                        ** GOTO lbl59
lbl50:
                        // 1 sources

                        this_$iv = $this$none$iv.iterator();
                        while (this_$iv.hasNext()) {
                            element$iv = this_$iv.next();
                            it = (ResolverReference)element$iv;
                            $i$a$-none-ResolverReference$recursivelyWriteOn$1$5 = false;
                            if (!Intrinsics.areEqual(it.getLocalName(), this.getLocalName())) continue;
                            v1 = false;
                            ** GOTO lbl59
                        }
                        v1 = true;
lbl59:
                        // 3 sources

                        if (v1) {
                            $this$none$iv = $this$recursivelyWriteOn_u24lambda_u2d11;
                            key$iv = "error";
                            $i$f$at = false;
                            this_$iv.write(key$iv);
                            $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d6 = this_$iv;
                            $i$a$-at-ResolverReference$recursivelyWriteOn$1$6 = false;
                            $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d6.write("Missing representative");
                        }
lbl68:
                        // 4 sources

                        v2 = this.writeResolutionInformationOn(writer, builder);
                        break;
                    }
                    case 1: {
                        v2 = this.writeResolutionInformationOn(writer, builder);
                        break;
                    }
                    default: {
                        v2 = Unit.INSTANCE;
                    }
                }
                if (((Collection)this.modules).isEmpty() == false || ((Collection)this.resources).isEmpty() == false) {
                    this_$iv = $this$recursivelyWriteOn_u24lambda_u2d11;
                    key$iv = "childNodes";
                    $i$f$at = false;
                    this_$iv.write(key$iv);
                    $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d10 = this_$iv;
                    $i$a$-at-ResolverReference$recursivelyWriteOn$1$7 = false;
                    this_$iv = $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d10;
                    $i$f$writeArray = false;
                    this_$iv.startArray();
                    try {
                        $this$recursivelyWriteOn_u24lambda_u2d11_u24lambda_u2d10_u24lambda_u2d9 = this_$iv;
                        $i$a$-writeArray-ResolverReference$recursivelyWriteOn$1$7$1 = false;
                        $this$forEach$iv = this.modules;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            module = (ResolverReference)element$iv;
                            $i$a$-forEach-ResolverReference$recursivelyWriteOn$1$7$1$1 = false;
                            module.recursivelyWriteOn(writer, builder);
                        }
                        $this$forEach$iv = this.resources;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            resource = (ResolverReference)element$iv;
                            $i$a$-forEach-ResolverReference$recursivelyWriteOn$1$7$1$2 = false;
                            resource.recursivelyWriteOn(writer, builder);
                        }
                        var22_35 = Unit.INSTANCE;
                    }
                    finally {
                        this_$iv.endArray();
                    }
                }
                var23_37 = Unit.INSTANCE;
            }
            finally {
                this_$iv.endObject();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Unit writeResolutionInformationOn(JSONWriter writer, AvailBuilder builder2) {
        Unit unit;
        JSONWriter this_$iv;
        boolean bl;
        JSONWriter $this$writeResolutionInformationOn_u24lambda_u2d18 = writer;
        boolean bl2 = false;
        ModuleNameResolver resolver = builder2.getRuntime().getModuleNameResolver();
        ResolvedModuleName resolved = null;
        UnresolvedModuleException resolutionException = null;
        try {
            resolved = ModuleNameResolver.resolve$default(resolver, new ModuleName(this.qualifiedName, false, 2, null), null, 2, null);
            bl = builder2.getLoadedModule(resolved) != null;
        }
        catch (UnresolvedModuleException e) {
            resolutionException = e;
            bl = false;
        }
        boolean loaded = bl;
        JSONWriter jSONWriter = $this$writeResolutionInformationOn_u24lambda_u2d18;
        String key$iv = "status";
        boolean $i$f$at = false;
        this_$iv.write(key$iv);
        void $this$writeResolutionInformationOn_u24lambda_u2d18_u24lambda_u2d12 = this_$iv;
        boolean bl3 = false;
        $this$writeResolutionInformationOn_u24lambda_u2d18_u24lambda_u2d12.write(loaded ? "loaded" : "not loaded");
        ResolvedModuleName resolvedModuleName = resolved;
        boolean bl4 = resolvedModuleName != null ? resolvedModuleName.isRename() : false;
        if (bl4) {
            this_$iv = $this$writeResolutionInformationOn_u24lambda_u2d18;
            key$iv = "resolvedName";
            $i$f$at = false;
            this_$iv.write(key$iv);
            JSONWriter $this$writeResolutionInformationOn_u24lambda_u2d18_u24lambda_u2d13 = this_$iv;
            boolean bl5 = false;
            $this$writeResolutionInformationOn_u24lambda_u2d18_u24lambda_u2d13.write(resolved.getQualifiedName());
        } else if (this.accessException == null && resolutionException != null) {
            this_$iv = $this$writeResolutionInformationOn_u24lambda_u2d18;
            key$iv = "error";
            $i$f$at = false;
            this_$iv.write(key$iv);
            JSONWriter $this$writeResolutionInformationOn_u24lambda_u2d18_u24lambda_u2d14 = this_$iv;
            boolean bl6 = false;
            $this$writeResolutionInformationOn_u24lambda_u2d18_u24lambda_u2d14.write(((Throwable)resolutionException).getLocalizedMessage());
        }
        List<String> list2 = resolver.getRenameRulesInverted().get(this.qualifiedName);
        if (list2 != null) {
            void this_$iv2;
            List<String> it = list2;
            boolean bl7 = false;
            JSONWriter bl6 = $this$writeResolutionInformationOn_u24lambda_u2d18;
            String key$iv2 = "redirectedNames";
            boolean $i$f$at2 = false;
            this_$iv2.write(key$iv2);
            void $this$writeResolutionInformationOn_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16 = this_$iv2;
            boolean bl8 = false;
            void this_$iv3 = $this$writeResolutionInformationOn_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16;
            boolean $i$f$writeArray = false;
            this_$iv3.startArray();
            try {
                void $this$writeResolutionInformationOn_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d15 = this_$iv3;
                boolean bl9 = false;
                Iterable $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p0 = (String)element$iv;
                    boolean bl10 = false;
                    $this$writeResolutionInformationOn_u24lambda_u2d18_u24lambda_u2d17_u24lambda_u2d16_u24lambda_u2d15.write(p0);
                }
                Unit unit2 = Unit.INSTANCE;
            }
            finally {
                this_$iv3.endArray();
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public final void writeOn(@NotNull JSONWriter writer, @NotNull AvailBuilder builder2) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        this.recursivelyWriteOn(writer, builder2);
    }

    public final void refresh(long lastModified, long size) {
        if (this.lastModified < lastModified) {
            this.lastModified = lastModified;
            this.size = size;
        }
    }

    public final void digest$avail(boolean refresh, @NotNull Function2<? super byte[], ? super Long, Unit> withDigest, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(withDigest, "withDigest");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        byte[] currentDigest = this.getDigest();
        if (!refresh && currentDigest != null) {
            withDigest.invoke((byte[])currentDigest, (Long)this.lastModified);
            return;
        }
        this.resolver.refreshResolverReferenceDigest(this, withDigest, failureHandler);
    }

    public static /* synthetic */ void digest$avail$default(ResolverReference resolverReference, boolean bl, Function2 function2, Function2 function22, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        resolverReference.digest$avail(bl, function2, function22);
    }

    public final void readFileBytes(boolean bypassFileManager, @NotNull Function2<? super byte[], ? super UUID, Unit> withContents, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(withContents, "withContents");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        this.resolver.readFile(bypassFileManager, this, withContents, failureHandler);
    }

    public final void readFileString(boolean bypassFileManager, @NotNull Function2<? super String, ? super UUID, Unit> withContents, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(withContents, "withContents");
        Intrinsics.checkNotNullParameter(failureHandler, "failureHandler");
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPLACE);
        decoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.readFileBytes(bypassFileManager, (Function2<? super byte[], ? super UUID, Unit>)new Function2<byte[], UUID, Unit>(withContents, decoder){
            final /* synthetic */ Function2<String, UUID, Unit> $withContents;
            final /* synthetic */ CharsetDecoder $decoder;
            {
                this.$withContents = $withContents;
                this.$decoder = $decoder;
                super(2);
            }

            public final void invoke(@NotNull byte[] bytes, @Nullable UUID uuid) {
                Intrinsics.checkNotNullParameter(bytes, "bytes");
                String string2 = this.$decoder.decode(ByteBuffer.wrap(bytes)).toString();
                Intrinsics.checkNotNullExpressionValue(string2, "decoder.decode(ByteBuffer.wrap(bytes)).toString()");
                this.$withContents.invoke(string2, uuid);
            }
        }, failureHandler);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResolverReference)) {
            return false;
        }
        return this.resolver == ((ResolverReference)other).resolver && Intrinsics.areEqual(this.qualifiedName, ((ResolverReference)other).qualifiedName);
    }

    public int hashCode() {
        int result2 = this.resolver.getUri().hashCode();
        result2 = 31 * result2 + this.qualifiedName.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return this.qualifiedName;
    }

    /*
     * WARNING - void declaration
     */
    public final void walkChildrenThen(boolean visitResources, @NotNull Function1<? super ResolverReference, Unit> withReference, @NotNull Function1<? super Integer, Unit> afterAllVisited) {
        void $this$fold$iv;
        void initial$iv;
        Intrinsics.checkNotNullParameter(withReference, "withReference");
        Intrinsics.checkNotNullParameter(afterAllVisited, "afterAllVisited");
        if (this.type != ResourceType.ROOT && !this.isPackage() && this.type != ResourceType.DIRECTORY) {
            return;
        }
        List top = CollectionsKt.plus((Collection)this.modules, (Iterable)new LinkedList(visitResources ? this.childReferences(true) : CollectionsKt.emptyList()));
        Iterable iterable = top;
        Integer n = 0;
        Function1<? super Integer, Unit> function1 = afterAllVisited;
        boolean $i$f$fold = false;
        Integer accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void module;
            ResolverReference resolverReference = (ResolverReference)element$iv;
            int count = ((Number)accumulator$iv).intValue();
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(module, "module");
            accumulator$iv = count + Companion.visitReference((ResolverReference)module, visitResources, withReference);
        }
        function1.invoke(accumulator$iv);
    }

    public static /* synthetic */ void walkChildrenThen$default(ResolverReference resolverReference, boolean bl, Function1 function1, Function1 function12, int n, Object object) {
        if ((n & 4) != 0) {
            function12 = walkChildrenThen.1.INSTANCE;
        }
        resolverReference.walkChildrenThen(bl, function1, function12);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lavail/resolver/ResolverReference$Companion;", "", "()V", "DIGEST_ALGORITHM", "", "visitReference", "", "reference", "Lavail/resolver/ResolverReference;", "visitResources", "", "withReference", "Lkotlin/Function1;", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final int visitReference(@NotNull ResolverReference reference, boolean visitResources, @NotNull Function1<? super ResolverReference, Unit> withReference) {
            Intrinsics.checkNotNullParameter(reference, "reference");
            Intrinsics.checkNotNullParameter(withReference, "withReference");
            ResolverReference ref = reference;
            int visited = 0;
            Deque stack = new LinkedList();
            while (true) {
                if (visitResources || !ref.isResource()) {
                    withReference.invoke(ref);
                    if (ref.getHasChildren()) {
                        void $this$forEach$iv;
                        Iterable iterable = ref.childReferences(visitResources);
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            ResolverReference p0 = (ResolverReference)element$iv;
                            boolean bl = false;
                            stack.addFirst(p0);
                        }
                    }
                }
                if (stack.isEmpty()) {
                    return visited;
                }
                ++visited;
                Object e = stack.removeFirst();
                Intrinsics.checkNotNullExpressionValue(e, "stack.removeFirst()");
                ref = (ResolverReference)e;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResourceType.values().length];
            nArray[ResourceType.MODULE.ordinal()] = 1;
            nArray[ResourceType.HEADERLESS_MODULE.ordinal()] = 2;
            nArray[ResourceType.REPRESENTATIVE.ordinal()] = 3;
            nArray[ResourceType.RESOURCE.ordinal()] = 4;
            nArray[ResourceType.PACKAGE.ordinal()] = 5;
            nArray[ResourceType.ROOT.ordinal()] = 6;
            nArray[ResourceType.DIRECTORY.ordinal()] = 7;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

