/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.ScaledImageIcon;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;

public class FlatInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    private JLabel titleLabel;
    private JPanel buttonPanel;

    public FlatInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this, "InternalFrameTitlePane.border");
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new FlatPropertyChangeHandler();
    }

    @Override
    protected LayoutManager createLayout() {
        return new BorderLayout(UIScale.scale(4), 0);
    }

    @Override
    protected void createButtons() {
        super.createButtons();
        this.iconButton.setContentAreaFilled(false);
        this.maxButton.setContentAreaFilled(false);
        this.closeButton.setContentAreaFilled(false);
        Border emptyBorder = BorderFactory.createEmptyBorder();
        this.iconButton.setBorder(emptyBorder);
        this.maxButton.setBorder(emptyBorder);
        this.closeButton.setBorder(emptyBorder);
        this.updateButtonsVisibility();
    }

    @Override
    protected void addSubComponents() {
        this.titleLabel = new JLabel(this.frame.getTitle());
        this.titleLabel.setFont(FlatUIUtils.nonUIResource(this.getFont()));
        this.titleLabel.setMinimumSize(new Dimension(UIScale.scale(32), 1));
        this.updateFrameIcon();
        this.updateColors();
        this.buttonPanel = new JPanel(){

            @Override
            public Dimension getPreferredSize() {
                Dimension size = super.getPreferredSize();
                int height = size.height;
                if (!FlatInternalFrameTitlePane.this.iconButton.isVisible()) {
                    height = Math.max(height, ((FlatInternalFrameTitlePane)FlatInternalFrameTitlePane.this).iconButton.getPreferredSize().height);
                }
                if (!FlatInternalFrameTitlePane.this.maxButton.isVisible()) {
                    height = Math.max(height, ((FlatInternalFrameTitlePane)FlatInternalFrameTitlePane.this).maxButton.getPreferredSize().height);
                }
                if (!FlatInternalFrameTitlePane.this.closeButton.isVisible()) {
                    height = Math.max(height, ((FlatInternalFrameTitlePane)FlatInternalFrameTitlePane.this).closeButton.getPreferredSize().height);
                }
                return new Dimension(size.width, height);
            }
        };
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 2));
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.add(this.iconButton);
        this.buttonPanel.add(this.maxButton);
        this.buttonPanel.add(this.closeButton);
        this.add((Component)this.titleLabel, "Center");
        this.add((Component)this.buttonPanel, "After");
    }

    protected void updateFrameIcon() {
        Icon frameIcon = this.frame.getFrameIcon();
        if (frameIcon != null && (frameIcon.getIconWidth() == 0 || frameIcon.getIconHeight() == 0)) {
            frameIcon = null;
        } else if (frameIcon instanceof ImageIcon) {
            frameIcon = new ScaledImageIcon((ImageIcon)frameIcon);
        }
        this.titleLabel.setIcon(frameIcon);
    }

    protected void updateColors() {
        Color background2 = FlatUIUtils.nonUIResource(this.frame.isSelected() ? this.selectedTitleColor : this.notSelectedTitleColor);
        Color foreground2 = FlatUIUtils.nonUIResource(this.frame.isSelected() ? this.selectedTextColor : this.notSelectedTextColor);
        this.titleLabel.setForeground(foreground2);
        this.iconButton.setBackground(background2);
        this.iconButton.setForeground(foreground2);
        this.maxButton.setBackground(background2);
        this.maxButton.setForeground(foreground2);
        this.closeButton.setBackground(background2);
        this.closeButton.setForeground(foreground2);
    }

    protected void updateButtonsVisibility() {
        this.iconButton.setVisible(this.frame.isIconifiable());
        this.maxButton.setVisible(this.frame.isMaximizable());
        this.closeButton.setVisible(this.frame.isClosable());
    }

    Rectangle getFrameIconBounds() {
        Icon icon = this.titleLabel.getIcon();
        if (icon == null) {
            return null;
        }
        int iconWidth = icon.getIconWidth();
        int iconHeight = icon.getIconHeight();
        boolean leftToRight = this.titleLabel.getComponentOrientation().isLeftToRight();
        int x = this.titleLabel.getX() + (leftToRight ? 0 : this.titleLabel.getWidth() - iconWidth);
        int y = this.titleLabel.getY() + (this.titleLabel.getHeight() - iconHeight) / 2;
        return new Rectangle(x, y, iconWidth, iconHeight);
    }

    @Override
    protected void assembleSystemMenu() {
    }

    @Override
    protected void showSystemMenu() {
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintTitleBackground(g);
    }

    protected class FlatPropertyChangeHandler
    extends BasicInternalFrameTitlePane.PropertyChangeHandler {
        protected FlatPropertyChangeHandler() {
            super(FlatInternalFrameTitlePane.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            switch (e.getPropertyName()) {
                case "title": {
                    FlatInternalFrameTitlePane.this.titleLabel.setText(FlatInternalFrameTitlePane.this.frame.getTitle());
                    break;
                }
                case "frameIcon": {
                    FlatInternalFrameTitlePane.this.updateFrameIcon();
                    break;
                }
                case "selected": {
                    FlatInternalFrameTitlePane.this.updateColors();
                    break;
                }
                case "iconable": 
                case "maximizable": 
                case "closable": {
                    FlatInternalFrameTitlePane.this.updateButtonsVisibility();
                    FlatInternalFrameTitlePane.this.enableActions();
                    FlatInternalFrameTitlePane.this.revalidate();
                    FlatInternalFrameTitlePane.this.repaint();
                    return;
                }
                case "componentOrientation": {
                    FlatInternalFrameTitlePane.this.applyComponentOrientation(FlatInternalFrameTitlePane.this.frame.getComponentOrientation());
                    break;
                }
                case "opaque": {
                    return;
                }
            }
            super.propertyChange(e);
        }
    }
}

