/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.roots;

import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.availlang.artifact.manifest.AvailRootManifest;
import org.availlang.artifact.roots.CreateAvailRoot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u001f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tBu\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u000b\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u0013J\u0011\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0000H\u0096\u0002J\u000e\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u000bJ\u0013\u00106\u001a\u0002072\b\u00102\u001a\u0004\u0018\u000108H\u0096\u0002J\b\u00109\u001a\u000201H\u0016J\b\u0010:\u001a\u00020\u000bH\u0016R\u0011\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R&\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016R\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0016R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0016R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0017\u0010$\u001a\u00020\u00058F\u00a2\u0006\f\u0012\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0016R\u001b\u0010*\u001a\u00020\u000b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b+\u0010\u0016R\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006;"}, d2={"Lorg/availlang/artifact/roots/AvailRoot;", "", "location", "Lorg/availlang/artifact/environment/location/AvailLocation;", "manifestRoot", "Lorg/availlang/artifact/manifest/AvailRootManifest;", "action", "Lkotlin/Function1;", "", "(Lorg/availlang/artifact/environment/location/AvailLocation;Lorg/availlang/artifact/manifest/AvailRootManifest;Lkotlin/jvm/functions/Function1;)V", "name", "", "digestAlgorithm", "availModuleExtensions", "", "entryPoints", "templates", "", "description", "(Ljava/lang/String;Lorg/availlang/artifact/environment/location/AvailLocation;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/Map;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "absolutePath", "getAbsolutePath", "()Ljava/lang/String;", "getAction", "()Lkotlin/jvm/functions/Function1;", "setAction", "(Lkotlin/jvm/functions/Function1;)V", "getAvailModuleExtensions", "()Ljava/util/List;", "configString", "getConfigString", "getDescription", "getDigestAlgorithm", "getEntryPoints", "getLocation", "()Lorg/availlang/artifact/environment/location/AvailLocation;", "manifest", "getManifest$annotations", "()V", "getManifest", "()Lorg/availlang/artifact/manifest/AvailRootManifest;", "getName", "rootString", "getRootString", "rootString$delegate", "Lkotlin/Lazy;", "getTemplates", "()Ljava/util/Map;", "compareTo", "", "other", "createProjectRoot", "Lorg/availlang/artifact/environment/project/AvailProjectRoot;", "projectDirectory", "equals", "", "", "hashCode", "toString", "avail-artifact"})
public class AvailRoot
implements Comparable<AvailRoot> {
    @NotNull
    private final String name;
    @NotNull
    private final AvailLocation location;
    @NotNull
    private final String digestAlgorithm;
    @NotNull
    private final List<String> availModuleExtensions;
    @NotNull
    private final List<String> entryPoints;
    @NotNull
    private final Map<String, String> templates;
    @NotNull
    private final String description;
    @NotNull
    private Function1<? super AvailRoot, Unit> action;
    @NotNull
    private final String absolutePath;
    @NotNull
    private final Lazy rootString$delegate;

    public AvailRoot(@NotNull String name, @NotNull AvailLocation location, @NotNull String digestAlgorithm, @NotNull List<String> availModuleExtensions, @NotNull List<String> entryPoints, @NotNull Map<String, String> templates2, @NotNull String description2, @NotNull Function1<? super AvailRoot, Unit> action2) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(digestAlgorithm, "digestAlgorithm");
        Intrinsics.checkNotNullParameter(availModuleExtensions, "availModuleExtensions");
        Intrinsics.checkNotNullParameter(entryPoints, "entryPoints");
        Intrinsics.checkNotNullParameter(templates2, "templates");
        Intrinsics.checkNotNullParameter(description2, "description");
        Intrinsics.checkNotNullParameter(action2, "action");
        this.name = name;
        this.location = location;
        this.digestAlgorithm = digestAlgorithm;
        this.availModuleExtensions = availModuleExtensions;
        this.entryPoints = entryPoints;
        this.templates = templates2;
        this.description = description2;
        this.action = action2;
        this.absolutePath = this.location.getFullPathNoPrefix();
        this.rootString$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ AvailRoot this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return this.this$0.getName() + "=" + this.this$0.getAbsolutePath();
            }
        });
    }

    public /* synthetic */ AvailRoot(String string2, AvailLocation availLocation, String string3, List list2, List list3, Map map, String string4, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string3 = "SHA-256";
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.listOf("avail");
        }
        if ((n & 0x10) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x20) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x40) != 0) {
            string4 = "";
        }
        if ((n & 0x80) != 0) {
            function1 = 1.INSTANCE;
        }
        this(string2, availLocation, string3, list2, list3, map, string4, function1);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final AvailLocation getLocation() {
        return this.location;
    }

    @NotNull
    public final String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    @NotNull
    public final List<String> getAvailModuleExtensions() {
        return this.availModuleExtensions;
    }

    @NotNull
    public final List<String> getEntryPoints() {
        return this.entryPoints;
    }

    @NotNull
    public final Map<String, String> getTemplates() {
        return this.templates;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final Function1<AvailRoot, Unit> getAction() {
        return this.action;
    }

    public final void setAction(@NotNull Function1<? super AvailRoot, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, "<set-?>");
        this.action = function1;
    }

    public AvailRoot(@NotNull AvailLocation location, @NotNull AvailRootManifest manifestRoot, @NotNull Function1<? super AvailRoot, Unit> action2) {
        Intrinsics.checkNotNullParameter(location, "location");
        Intrinsics.checkNotNullParameter(manifestRoot, "manifestRoot");
        Intrinsics.checkNotNullParameter(action2, "action");
        this(manifestRoot.getName(), location, manifestRoot.getDigestAlgorithm(), manifestRoot.getAvailModuleExtensions(), manifestRoot.getEntryPoints(), manifestRoot.getTemplates(), manifestRoot.getDescription(), action2);
    }

    @NotNull
    public final String getAbsolutePath() {
        return this.absolutePath;
    }

    @NotNull
    public final String getRootString() {
        Lazy lazy = this.rootString$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public String getConfigString() {
        return "\n\t" + this.name + " (" + this.absolutePath + ")";
    }

    @NotNull
    public final AvailRootManifest getManifest() {
        return new AvailRootManifest(this.name, this.availModuleExtensions, this.entryPoints, this.templates, this.description, this.digestAlgorithm);
    }

    public static /* synthetic */ void getManifest$annotations() {
    }

    @NotNull
    public final AvailProjectRoot createProjectRoot(@NotNull String projectDirectory) {
        Intrinsics.checkNotNullParameter(projectDirectory, "projectDirectory");
        return new AvailProjectRoot(projectDirectory, this.name, this.location, this.availModuleExtensions, this.templates, false, null, null, false, 480, null);
    }

    @Override
    public int compareTo(@NotNull AvailRoot other) {
        Intrinsics.checkNotNullParameter(other, "other");
        return this instanceof CreateAvailRoot && other instanceof CreateAvailRoot || !(this instanceof CreateAvailRoot) && !(other instanceof CreateAvailRoot) ? this.name.compareTo(other.name) : (this instanceof CreateAvailRoot ? 1 : -1);
    }

    @NotNull
    public String toString() {
        return this.getRootString();
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof AvailRoot) ? false : (!Intrinsics.areEqual(this.name, ((AvailRoot)other).name) ? false : Intrinsics.areEqual(this.absolutePath, ((AvailRoot)other).absolutePath)));
    }

    public int hashCode() {
        int result2 = this.name.hashCode();
        result2 = 31 * result2 + this.absolutePath.hashCode();
        return result2;
    }
}

