/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.problems;

import avail.builder.ModuleName;
import avail.compiler.problems.ProblemHandler;
import avail.compiler.problems.ProblemType;
import java.text.MessageFormat;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001BC\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r\"\u00020\u0001\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0018\u001a\u00020\u0019H&J\b\u0010\u001a\u001a\u00020\u0019H\u0016J)\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00190\u001fH\u0000\u00a2\u0006\u0002\b!J\b\u0010\"\u001a\u00020\u000bH\u0016R\u0018\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lavail/compiler/problems/Problem;", "", "moduleName", "Lavail/builder/ModuleName;", "lineNumber", "", "characterInFile", "", "type", "Lavail/compiler/problems/ProblemType;", "messagePattern", "", "arguments", "", "(Lavail/builder/ModuleName;IJLavail/compiler/problems/ProblemType;Ljava/lang/String;[Ljava/lang/Object;)V", "[Ljava/lang/Object;", "getCharacterInFile", "()J", "getLineNumber", "()I", "getModuleName", "()Lavail/builder/ModuleName;", "getType", "()Lavail/compiler/problems/ProblemType;", "abortCompilation", "", "continueCompilation", "report", "handler", "Lavail/compiler/problems/ProblemHandler;", "decider", "Lkotlin/Function1;", "", "report$avail", "toString", "avail"})
public abstract class Problem {
    @Nullable
    private final ModuleName moduleName;
    private final int lineNumber;
    private final long characterInFile;
    @NotNull
    private final ProblemType type;
    @NotNull
    private final String messagePattern;
    @NotNull
    private final Object[] arguments;

    public Problem(@Nullable ModuleName moduleName2, int lineNumber, long characterInFile, @NotNull ProblemType type, @NotNull String messagePattern, Object ... arguments) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)messagePattern, (String)"messagePattern");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.moduleName = moduleName2;
        this.lineNumber = lineNumber;
        this.characterInFile = characterInFile;
        this.type = type;
        this.messagePattern = messagePattern;
        this.arguments = (Object[])arguments.clone();
    }

    @Nullable
    public final ModuleName getModuleName() {
        return this.moduleName;
    }

    public final int getLineNumber() {
        return this.lineNumber;
    }

    public final long getCharacterInFile() {
        return this.characterInFile;
    }

    @NotNull
    public final ProblemType getType() {
        return this.type;
    }

    public final void report$avail(@NotNull ProblemHandler handler, @NotNull Function1<? super Boolean, Unit> decider) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter(decider, (String)"decider");
        this.type.report$avail(this, handler, decider);
    }

    public void continueCompilation() {
        this.abortCompilation();
    }

    public abstract void abortCompilation();

    @NotNull
    public String toString() {
        Object[] objectArray = this.arguments;
        String string2 = MessageFormat.format(this.messagePattern, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(messagePattern, *arguments)");
        return string2;
    }
}

