/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.ParsingConversionRule;
import avail.compiler.ParsingOperation;
import avail.compiler.splitter.Expression;
import avail.compiler.splitter.Group;
import avail.compiler.splitter.InstructionGenerator;
import avail.compiler.splitter.MessageSplitter;
import avail.compiler.splitter.SectionCheckpoint;
import avail.compiler.splitter.WrapState;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.InstanceTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.ListPhraseTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.SignatureException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u0016\u001a\u00020\u0000H\u0010\u00a2\u0006\u0002\b\u0017J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001d\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b J%\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\"H\u0010\u00a2\u0006\u0002\b'J\u001b\u0010(\u001a\u00020\u001c2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0010\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u001eH\u0010\u00a2\u0006\u0002\b.J1\u0010/\u001a\u00020\u001c2\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u0001012\n\u00102\u001a\u000603j\u0002`42\u0006\u00105\u001a\u00020\u0003H\u0010\u00a2\u0006\u0002\b6J\b\u00107\u001a\u000208H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\u00038PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\b8PX\u0090\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\n\u00a8\u00069"}, d2={"Lavail/compiler/splitter/Counter;", "Lavail/compiler/splitter/Expression;", "positionInName", "", "group", "Lavail/compiler/splitter/Group;", "(ILavail/compiler/splitter/Group;)V", "isLowerCase", "", "isLowerCase$avail", "()Z", "recursivelyContainsReorders", "getRecursivelyContainsReorders", "shouldBeSeparatedOnLeft", "getShouldBeSeparatedOnLeft$avail", "shouldBeSeparatedOnRight", "getShouldBeSeparatedOnRight$avail", "underscoreCount", "getUnderscoreCount$avail", "()I", "yieldsValue", "getYieldsValue$avail", "applyCaseInsensitive", "applyCaseInsensitive$avail", "checkListStructure", "phrase", "Lavail/descriptor/phrases/A_Phrase;", "checkType", "", "argumentType", "Lavail/descriptor/types/A_Type;", "sectionNumber", "checkType$avail", "emitOn", "Lavail/compiler/splitter/WrapState;", "phraseType", "generator", "Lavail/compiler/splitter/InstructionGenerator;", "wrapState", "emitOn$avail", "extractSectionCheckpointsInto", "sectionCheckpoints", "", "Lavail/compiler/splitter/SectionCheckpoint;", "extractSectionCheckpointsInto$avail", "mightBeEmpty", "mightBeEmpty$avail", "printWithArguments", "arguments", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "indent", "printWithArguments$avail", "toString", "", "avail"})
public final class Counter
extends Expression {
    @NotNull
    private final Group group;

    public Counter(int positionInName, @NotNull Group group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        super(positionInName);
        this.group = group;
        boolean bl = this.group.getBeforeDagger().getYielders().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        bl = this.group.getAfterDagger().getYielders().isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
    }

    @Override
    public boolean getRecursivelyContainsReorders() {
        return this.group.getRecursivelyContainsReorders();
    }

    @Override
    public boolean getYieldsValue$avail() {
        return true;
    }

    @Override
    public boolean isLowerCase$avail() {
        return this.group.isLowerCase$avail();
    }

    @Override
    @NotNull
    public Counter applyCaseInsensitive$avail() {
        return new Counter(this.getPositionInName(), this.group.applyCaseInsensitive$avail());
    }

    @Override
    public int getUnderscoreCount$avail() {
        boolean bl;
        boolean bl2 = bl = this.group.getUnderscoreCount$avail() == 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return 0;
    }

    @Override
    public void extractSectionCheckpointsInto$avail(@NotNull List<SectionCheckpoint> sectionCheckpoints) {
        Intrinsics.checkNotNullParameter(sectionCheckpoints, (String)"sectionCheckpoints");
        this.group.extractSectionCheckpointsInto$avail(sectionCheckpoints);
    }

    @Override
    public void checkType$avail(@NotNull A_Type argumentType, int sectionNumber) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
        if (!A_Type.Companion.isSubtypeOf(argumentType, IntegerRangeTypeDescriptor.Companion.getWholeNumbers())) {
            MessageSplitter.Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_TYPE_FOR_COUNTING_GROUP);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public WrapState emitOn$avail(@NotNull A_Type phraseType, @NotNull InstructionGenerator generator, @NotNull WrapState wrapState) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)phraseType, (String)"phraseType");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        Intrinsics.checkNotNullParameter((Object)((Object)wrapState), (String)"wrapState");
        generator.flushDelayed();
        A_Type phraseCountRange = A_Type.Companion.getPhraseTypeExpressionType(phraseType);
        AvailObject emptyTupleType = InstanceTypeDescriptor.Companion.instanceType(TupleDescriptor.Companion.getEmptyTuple());
        A_Type tupleOfEmptyTuplesType = TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(phraseCountRange, TupleDescriptor.Companion.getEmptyTuple(), emptyTupleType);
        A_Type tupleOfEmptyTuplePhrasesType = TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(phraseCountRange, TupleDescriptor.Companion.getEmptyTuple(), PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.create(emptyTupleType));
        A_Type listPhraseType = ListPhraseTypeDescriptor.Companion.createListPhraseType(PhraseTypeDescriptor.PhraseKind.LIST_PHRASE, tupleOfEmptyTuplesType, tupleOfEmptyTuplePhrasesType);
        WrapState newWrapState = this.group.emitOn$avail(listPhraseType, generator, wrapState);
        boolean bl2 = bl = newWrapState == WrapState.SHOULD_NOT_PUSH_LIST;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        generator.emit((Expression)this, ParsingOperation.CONVERT, ParsingConversionRule.LIST_TO_SIZE.getNumber());
        return wrapState.processAfterPushedArgument$avail(this, generator);
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.group + ")";
    }

    @Override
    public void printWithArguments$avail(@Nullable Iterator<? extends A_Phrase> arguments, @NotNull StringBuilder builder2, int indent) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Iterator<? extends A_Phrase> iterator2 = arguments;
        Intrinsics.checkNotNull(iterator2);
        A_Phrase countLiteral = iterator2.next();
        boolean bl = countLiteral.isInstanceOf(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.getMostGeneralType());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int i = 1;
        int count = A_Number.Companion.getExtractInt(A_Phrase.Companion.getToken(countLiteral).literal());
        if (i <= count) {
            while (true) {
                if (i > 1) {
                    builder2.append(' ');
                }
                Iterator<AvailObject> iterator3 = Collections.emptyIterator();
                Intrinsics.checkNotNullExpressionValue(iterator3, (String)"emptyIterator()");
                this.group.printGroupOccurrence(iterator3, builder2, indent, this.getYieldsValue$avail());
                if (i == count) break;
                ++i;
            }
        }
        builder2.append('#');
    }

    @Override
    public boolean getShouldBeSeparatedOnLeft$avail() {
        return this.group.getShouldBeSeparatedOnLeft$avail();
    }

    @Override
    public boolean getShouldBeSeparatedOnRight$avail() {
        return true;
    }

    @Override
    public boolean mightBeEmpty$avail(@NotNull A_Type phraseType) {
        Intrinsics.checkNotNullParameter((Object)phraseType, (String)"phraseType");
        A_Type integerRangeType = A_Type.Companion.getPhraseTypeExpressionType(phraseType);
        boolean bl = integerRangeType.isIntegerRangeType();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(integerRangeType), 0);
    }

    @Override
    public boolean checkListStructure(@NotNull A_Phrase phrase) {
        Intrinsics.checkNotNullParameter((Object)phrase, (String)"phrase");
        return true;
    }
}

