/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.numbers;

import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.AbstractNumberDescriptor;
import avail.descriptor.numbers.DoubleDescriptor;
import avail.descriptor.numbers.ExtendedIntegerDescriptor;
import avail.descriptor.numbers.FloatDescriptor;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectFieldHelper;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.exceptions.ArithmeticException;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MarshalingException;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.serialization.SerializerOperation;
import avail.utility.structures.EnumMap;
import java.math.BigInteger;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u0089\u00012\u00020\u0001:\u0004\u0089\u0001\u008a\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J:\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u0011H\u0002J\b\u0010\u0013\u001a\u00020\u0000H\u0016J2\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002J \u0010\u001a\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u001c\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u001e\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010!\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\nH\u0016J(\u0010$\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010'\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010(\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010)\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010(\u001a\u00020\r2\u0006\u0010*\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010+\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0012H\u0016J \u0010,\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010-\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010.\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010/\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001b\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u00104J \u00105\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u00106\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u00107\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u00108\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u00109\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010:\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010;\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010>\u001a\u00020\u0012H\u0016J\u0018\u0010?\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010@\u001a\u00020\nH\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010C\u001a\u00020D2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010E\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010F\u001a\u00020G2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010H\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010I\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010J\u001a\u00020K2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010L\u001a\u00020K2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010M\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010N\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010O\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010P\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010Q\u001a\u00020RH\u0016J\u0010\u0010S\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010T\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010U\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010V\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010W\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010X\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010Y\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010Z\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010[\u001a\u00020R2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u001e\u0010\\\u001a\u00020]2\u0006\u0010\u000b\u001a\u00020\n2\f\u0010^\u001a\b\u0012\u0002\b\u0003\u0018\u00010_H\u0016J \u0010`\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u00106\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010a\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010b\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010c\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010d\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010e\u001a\u00020f2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010g\u001a\u00020h2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0018\u0010i\u001a\u00020h2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010j\u001a\u00020BH\u0016J\u0018\u0010k\u001a\u00020h2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010l\u001a\u00020h2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0016J \u0010m\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u00106\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010n\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010o\u001a\u00020\u0012H\u0016J \u0010p\u001a\u00020q2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010o\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0012H\u0016J\u0018\u0010r\u001a\u00020G2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010o\u001a\u00020\u0012H\u0016J \u0010s\u001a\u00020q2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010o\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0012H\u0016J\u0010\u0010t\u001a\u00020u2\u0006\u0010\u000b\u001a\u00020\nH\u0016J \u0010v\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010w\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010x\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010y\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010z\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u00106\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010{\u001a\u00020q2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010|\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010}\u001a\u00020q2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010~\u001a\u00020\u007fH\u0016J@\u0010\u0080\u0001\u001a\u00020q2\u0006\u0010\u000b\u001a\u00020\n2\r\u0010\u0081\u0001\u001a\b0\u0082\u0001j\u0003`\u0083\u00012\u0015\u0010\u0084\u0001\u001a\u0010\u0012\u0004\u0012\u00020<\u0012\u0005\u0012\u00030\u0086\u00010\u0085\u00012\u0007\u0010\u0087\u0001\u001a\u00020\u0012H\u0016J\t\u0010\u0088\u0001\u001a\u00020\u0000H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u008b\u0001"}, d2={"Lavail/descriptor/numbers/IntegerDescriptor;", "Lavail/descriptor/numbers/ExtendedIntegerDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "unusedIntsOfLastLong", "", "(Lavail/descriptor/representation/Mutability;B)V", "getUnusedIntsOfLastLong", "()B", "bitwiseOperation", "Lavail/descriptor/representation/AvailObject;", "self", "anInteger", "Lavail/descriptor/numbers/A_Number;", "canDestroy", "", "operation", "Lkotlin/Function2;", "", "immutable", "largerMutableOf", "another", "selfIntCount", "anotherIntCount", "mutable", "mutableOf", "o_AddToDoubleCanDestroy", "doubleObject", "o_AddToFloatCanDestroy", "floatObject", "o_AddToInfinityCanDestroy", "sign", "Lavail/descriptor/numbers/AbstractNumberDescriptor$Sign;", "o_AddToIntegerCanDestroy", "o_AsBigInteger", "Ljava/math/BigInteger;", "o_BitSet", "bitPosition", "value", "o_BitShift", "shiftFactor", "o_BitShiftLeftTruncatingToBits", "truncationBits", "o_BitTest", "o_BitwiseAnd", "o_BitwiseOr", "o_BitwiseXor", "o_ComputeTypeTag", "Lavail/descriptor/types/TypeTag;", "o_DescribeForDebugger", "", "Lavail/descriptor/representation/AvailObjectFieldHelper;", "(Lavail/descriptor/representation/AvailObject;)[Lavail/descriptor/representation/AvailObjectFieldHelper;", "o_DivideCanDestroy", "aNumber", "o_DivideIntoDoubleCanDestroy", "o_DivideIntoFloatCanDestroy", "o_DivideIntoInfinityCanDestroy", "o_DivideIntoIntegerCanDestroy", "o_Equals", "Lavail/descriptor/representation/A_BasicObject;", "o_EqualsInt", "theInt", "o_EqualsInteger", "anAvailInteger", "o_ExtractDouble", "", "o_ExtractFloat", "", "o_ExtractInt", "o_ExtractLong", "", "o_ExtractNybble", "o_ExtractSignedByte", "o_ExtractSignedShort", "", "o_ExtractUnsignedByte", "o_ExtractUnsignedShort", "o_Hash", "o_IsFinite", "o_IsInstanceOfKind", "aType", "Lavail/descriptor/types/A_Type;", "o_IsInt", "o_IsLong", "o_IsNumericallyIntegral", "o_IsNybble", "o_IsSignedByte", "o_IsSignedShort", "o_IsUnsignedByte", "o_IsUnsignedShort", "o_Kind", "o_MarshalToJava", "", "classHint", "Ljava/lang/Class;", "o_MinusCanDestroy", "o_MultiplyByDoubleCanDestroy", "o_MultiplyByFloatCanDestroy", "o_MultiplyByInfinityCanDestroy", "o_MultiplyByIntegerCanDestroy", "o_NameForDebugger", "", "o_NumericCompare", "Lavail/descriptor/numbers/AbstractNumberDescriptor$Order;", "o_NumericCompareToDouble", "aDouble", "o_NumericCompareToInfinity", "o_NumericCompareToInteger", "o_PlusCanDestroy", "o_RawSignedIntegerAt", "index", "o_RawSignedIntegerAtPut", "", "o_RawUnsignedIntegerAt", "o_RawUnsignedIntegerAtPut", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_SubtractFromDoubleCanDestroy", "o_SubtractFromFloatCanDestroy", "o_SubtractFromInfinityCanDestroy", "o_SubtractFromIntegerCanDestroy", "o_TimesCanDestroy", "o_TrimExcessInts", "o_WhichPowerOfTwo", "o_WriteTo", "writer", "Lorg/availlang/json/JSONWriter;", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "Companion", "IntegerSlots", "avail"})
public final class IntegerDescriptor
extends ExtendedIntegerDescriptor {
    @NotNull
    public static final Companion Companion;
    private final byte unusedIntsOfLastLong;
    @NotNull
    private static final CheckedMethod fromIntMethod;
    private static final int initialHashValue = 324610180;
    private static final int postMultiplyHashToggle = -1778403937;
    private static final int finalHashAddend = 1361571430;
    @NotNull
    private static final int[] byteHashes;
    @NotNull
    private static final EnumMap<Mutability, IntegerDescriptor[]> descriptors;
    private static final int smallIntegerLimit = 16384;
    @NotNull
    private static final AvailObject[] smallIntegers;
    @NotNull
    private static final int[] hashesOfSmallIntegers;
    @NotNull
    private static final AvailObject zero;
    @NotNull
    private static final AvailObject one;
    @NotNull
    private static final AvailObject two;
    @NotNull
    private static AvailObject negativeOne;
    private static final long quintillionLong = 1000000000000000000L;
    @NotNull
    private static final A_Number quintillionInteger;
    @GuardedBy(value="squaresOfQuintillionLock")
    @NotNull
    private static final List<A_Number> squaresOfQuintillion;
    @NotNull
    private static final ReentrantReadWriteLock squaresOfQuintillionLock;

    private IntegerDescriptor(Mutability mutability, byte unusedIntsOfLastLong) {
        super(mutability, TypeTag.UNKNOWN_TAG, null, IntegerSlots.class);
        boolean bl;
        this.unusedIntsOfLastLong = unusedIntsOfLastLong;
        boolean bl2 = bl = (this.unusedIntsOfLastLong & 0xFFFFFFFE) == 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    public final byte getUnusedIntsOfLastLong() {
        return this.unusedIntsOfLastLong;
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder2, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(recursionMap, (String)"recursionMap");
        if (A_Number.Companion.isLong(self)) {
            builder2.append(A_Number.Companion.getExtractLong(self));
        } else {
            A_Number magnitude = self;
            if (A_Number.Companion.lessThan(self, zero)) {
                builder2.append('-');
                magnitude = A_Number.Companion.minusCanDestroy(zero, self, false);
            }
            IntegerDescriptor.Companion.printBigInteger(magnitude, builder2, 0);
        }
    }

    @Override
    @NotNull
    public String o_NameForDebugger(@NotNull AvailObject self) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (A_Number.Companion.isLong(self)) {
            StringBuilder stringBuilder;
            StringBuilder $this$o_NameForDebugger_u24lambda_u2d0 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$o_NameForDebugger_u24lambda_u2d0.append("(Integer");
            $this$o_NameForDebugger_u24lambda_u2d0.append(this.getMutability().getSuffix());
            $this$o_NameForDebugger_u24lambda_u2d0.append(") = ");
            long longValue = A_Number.Companion.getExtractLong(self);
            AbstractDescriptor.Companion.describeLong(longValue, Companion.intCount(self) == 1 ? 32 : 64, $this$o_NameForDebugger_u24lambda_u2d0);
            $this$o_NameForDebugger_u24lambda_u2d0.append(" = ");
            $this$o_NameForDebugger_u24lambda_u2d0.append(longValue);
            String string3 = stringBuilder.toString();
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        } else {
            string2 = super.o_NameForDebugger(self);
        }
        return string2;
    }

    @Override
    @NotNull
    public AvailObjectFieldHelper[] o_DescribeForDebugger(@NotNull AvailObject self) {
        AvailObjectFieldHelper[] availObjectFieldHelperArray;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (A_Number.Companion.isLong(self)) {
            boolean $i$f$emptyArray = false;
            availObjectFieldHelperArray = (AvailObjectFieldHelper[])((Object[])new AvailObjectFieldHelper[0]);
        } else {
            availObjectFieldHelperArray = super.o_DescribeForDebugger(self);
        }
        return availObjectFieldHelperArray;
    }

    @Override
    public int o_RawSignedIntegerAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, index2);
    }

    @Override
    public void o_RawSignedIntegerAtPut(@NotNull AvailObject self, int index2, int value) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        self.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, index2, value);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return A_Number.Companion.equalsInteger((A_Number)another, self);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean o_EqualsInteger(@NotNull AvailObject self, @NotNull AvailObject anAvailInteger) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anAvailInteger, (String)"anAvailInteger");
        int slotsCount = Companion.intCount(self);
        if (slotsCount != Companion.intCount(anAvailInteger)) return false;
        Iterable $this$all$iv = (Iterable)new IntRange(1, slotsCount);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            int element$iv;
            if (!iterator2.hasNext()) return true;
            int it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl2 = false;
            if (self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, it) != A_Number.Companion.rawSignedIntegerAt(anAvailInteger, it)) return false;
            bl = true;
        } while (bl);
        return false;
    }

    @Override
    public boolean o_EqualsInt(@NotNull AvailObject self, int theInt) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, 1) == theInt && Companion.intCount(self) == 1;
    }

    @Override
    public boolean o_IsInstanceOfKind(@NotNull AvailObject self, @NotNull A_Type aType) {
        boolean bl;
        block1: {
            block2: {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)self, (String)"self");
                    Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
                    if (!A_Type.Companion.isSupertypeOfPrimitiveTypeEnum(aType, PrimitiveTypeDescriptor.Types.NUMBER)) break block0;
                    bl = true;
                    break block1;
                }
                if (aType.isIntegerRangeType()) break block2;
                bl = false;
                break block1;
            }
            bl = (A_Type.Companion.getUpperInclusive(aType) ? !A_Number.Companion.lessOrEqual(self, A_Type.Companion.getUpperBound(aType)) : !A_Number.Companion.lessThan(self, A_Type.Companion.getUpperBound(aType))) ? false : !(A_Type.Companion.getLowerInclusive(aType) ? !A_Number.Companion.lessOrEqual(A_Type.Companion.getLowerBound(aType), self) : !A_Number.Companion.lessThan(A_Type.Companion.getLowerBound(aType), self));
        }
        return bl;
    }

    @Override
    @NotNull
    public AbstractNumberDescriptor.Order o_NumericCompare(@NotNull AvailObject self, @NotNull A_Number another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return A_Number.Companion.numericCompareToInteger(another, self).reverse();
    }

    @Override
    public int o_Hash(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.isUnsignedByte() ? Companion.hashOfUnsignedByte(A_Number.Companion.getExtractUnsignedByte(self)) : IntegerDescriptor.Companion.computeHashOfIntegerObject(self);
    }

    @Override
    public boolean o_IsFinite(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return true;
    }

    @Override
    @NotNull
    public A_Type o_Kind(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return IntegerRangeTypeDescriptor.Companion.singleInteger(self.makeImmutable());
    }

    @Override
    @NotNull
    public A_Number o_DivideCanDestroy(@NotNull AvailObject self, @NotNull A_Number aNumber, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aNumber, (String)"aNumber");
        return A_Number.Companion.divideIntoIntegerCanDestroy(aNumber, self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_MinusCanDestroy(@NotNull AvailObject self, @NotNull A_Number aNumber, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aNumber, (String)"aNumber");
        return A_Number.Companion.subtractFromIntegerCanDestroy(aNumber, self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_PlusCanDestroy(@NotNull AvailObject self, @NotNull A_Number aNumber, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aNumber, (String)"aNumber");
        return A_Number.Companion.addToIntegerCanDestroy(aNumber, self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_TimesCanDestroy(@NotNull AvailObject self, @NotNull A_Number aNumber, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aNumber, (String)"aNumber");
        return A_Number.Companion.multiplyByIntegerCanDestroy(aNumber, self, canDestroy);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean o_IsNybble(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (Companion.intCount(self) != 1) return false;
        int n = A_Number.Companion.getExtractInt(self);
        if (0 > n) return false;
        if (n >= 16) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean o_IsSignedByte(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (Companion.intCount(self) != 1) return false;
        int n = A_Number.Companion.getExtractInt(self);
        if (-128 > n) return false;
        if (n >= 128) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean o_IsUnsignedByte(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (Companion.intCount(self) != 1) return false;
        int n = A_Number.Companion.getExtractInt(self);
        if (0 > n) return false;
        if (n >= 256) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean o_IsSignedShort(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (Companion.intCount(self) != 1) return false;
        int n = A_Number.Companion.getExtractInt(self);
        if (Short.MIN_VALUE > n) return false;
        if (n >= 32768) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean o_IsUnsignedShort(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (Companion.intCount(self) != 1) return false;
        int n = A_Number.Companion.getExtractInt(self);
        if (0 > n) return false;
        if (n >= 65536) return false;
        return true;
    }

    @Override
    public boolean o_IsInt(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return Companion.intCount(self) == 1;
    }

    @Override
    public boolean o_IsLong(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return Companion.intCount(self) <= 2;
    }

    @Override
    public byte o_ExtractNybble(@NotNull AvailObject self) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl3 = bl2 = Companion.intCount(self) == 1;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int value = A_Number.Companion.rawSignedIntegerAt(self, 1);
        boolean bl4 = bl = value == (value & 0xF);
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string3 = "Value is out of range for a nybble";
            throw new AssertionError((Object)string3);
        }
        return (byte)value;
    }

    @Override
    public byte o_ExtractSignedByte(@NotNull AvailObject self) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl3 = bl2 = Companion.intCount(self) == 1;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int value = A_Number.Companion.rawSignedIntegerAt(self, 1);
        boolean bl4 = bl = value == (byte)value;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string3 = "Value is out of range for a signed byte";
            throw new AssertionError((Object)string3);
        }
        return (byte)value;
    }

    @Override
    public short o_ExtractUnsignedByte(@NotNull AvailObject self) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl3 = bl2 = Companion.intCount(self) == 1;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int value = A_Number.Companion.rawSignedIntegerAt(self, 1);
        boolean bl4 = bl = value == (value & 0xFF);
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string3 = "Value is out of range for an unsigned byte";
            throw new AssertionError((Object)string3);
        }
        return (short)value;
    }

    @Override
    public short o_ExtractSignedShort(@NotNull AvailObject self) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl3 = bl2 = Companion.intCount(self) == 1;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int value = A_Number.Companion.rawSignedIntegerAt(self, 1);
        boolean bl4 = bl = value == (short)value;
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string3 = "Value is out of range for a signed short";
            throw new AssertionError((Object)string3);
        }
        return (short)value;
    }

    @Override
    public int o_ExtractUnsignedShort(@NotNull AvailObject self) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl3 = bl2 = Companion.intCount(self) == 1;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int value = A_Number.Companion.rawSignedIntegerAt(self, 1);
        boolean bl4 = bl = value == (value & 0xFFFF);
        if (_Assertions.ENABLED && !bl) {
            boolean bl5 = false;
            String string3 = "Value is out of range for an unsigned short";
            throw new AssertionError((Object)string3);
        }
        return value;
    }

    @Override
    public int o_ExtractInt(@NotNull AvailObject self) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl2 = bl = Companion.intCount(self) == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Integer value out of bounds";
            throw new AssertionError((Object)string2);
        }
        return A_Number.Companion.rawSignedIntegerAt(self, 1);
    }

    @Override
    public long o_ExtractLong(@NotNull AvailObject self) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl2 = bl = Companion.intCount(self) <= 2;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Integer value out of bounds";
            throw new AssertionError((Object)string2);
        }
        if (Companion.intCount(self) == 1) {
            return A_Number.Companion.rawSignedIntegerAt(self, 1);
        }
        long low = (long)A_Number.Companion.rawSignedIntegerAt(self, 1) & 0xFFFFFFFFL;
        return low | (long)A_Number.Companion.rawSignedIntegerAt(self, 2) << 32;
    }

    @Override
    public float o_ExtractFloat(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return (float)Companion.extractDoubleScaled(self, 0);
    }

    @Override
    public double o_ExtractDouble(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return Companion.extractDoubleScaled(self, 0);
    }

    @Override
    public long o_RawUnsignedIntegerAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int signedInt = self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, index2);
        return (long)signedInt & 0xFFFFFFFFL;
    }

    @Override
    public void o_RawUnsignedIntegerAtPut(@NotNull AvailObject self, int index2, int value) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        self.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, index2, value);
    }

    @Override
    public void o_TrimExcessInts(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl = this.isMutable();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int originalSize = Companion.intCount(self);
        int size = originalSize;
        if (size > 1) {
            if (self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, size) >= 0) {
                while (size > 1 && self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, size) == 0 && self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, size - 1) >= 0) {
                    --size;
                }
            } else {
                while (size > 1 && self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, size) == -1 && self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, size - 1) < 0) {
                    --size;
                }
            }
            if (size < originalSize) {
                if (size + 1 >> 1 != originalSize + 1 >> 1) {
                    self.truncateWithFillerForNewIntegerSlotsCount(size + 1 >> 1);
                }
                if ((size & 1) == 1) {
                    self.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, size + 1, 0);
                }
                self.setDescriptor(IntegerDescriptor.Companion.mutableFor(size));
            }
        }
    }

    @Override
    @NotNull
    public A_Number o_AddToInfinityCanDestroy(@NotNull AvailObject self, @NotNull AbstractNumberDescriptor.Sign sign, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)((Object)sign), (String)"sign");
        return sign == AbstractNumberDescriptor.Sign.POSITIVE ? InfinityDescriptor.Companion.getPositiveInfinity() : InfinityDescriptor.Companion.getNegativeInfinity();
    }

    private final AvailObject largerMutableOf(AvailObject self, AvailObject another, int selfIntCount, int anotherIntCount, boolean canDestroy) {
        return !canDestroy ? null : (selfIntCount == anotherIntCount ? (this.isMutable() ? self : (another.descriptor().isMutable() ? another : null)) : (selfIntCount > anotherIntCount ? (this.isMutable() ? self : null) : (another.descriptor().isMutable() ? another : null)));
    }

    @Override
    @NotNull
    public A_Number o_AddToIntegerCanDestroy(@NotNull AvailObject self, @NotNull AvailObject anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anInteger, (String)"anInteger");
        int objectSize = Companion.intCount(self);
        int anIntegerSize = Companion.intCount(anInteger);
        AvailObject output = this.largerMutableOf(self, anInteger, objectSize, anIntegerSize, canDestroy);
        if (objectSize == 1 && anIntegerSize == 1) {
            long sum = A_Number.Companion.getExtractLong(self) + A_Number.Companion.getExtractLong(anInteger);
            if (sum == (long)((int)sum)) {
                boolean bl;
                AvailObject availObject = output;
                if (availObject == null) {
                    availObject = Companion.createUninitializedInteger(1);
                }
                boolean bl2 = bl = Companion.intCount(output = availObject) == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Number.Companion.rawSignedIntegerAtPut(output, 1, (int)sum);
                return output;
            }
            return Companion.fromLong(sum);
        }
        AvailObject availObject = output;
        if (availObject == null) {
            availObject = Companion.createUninitializedInteger(Math.max(objectSize, anIntegerSize));
        }
        output = availObject;
        int outputSize = Companion.intCount(output);
        long extendedObject = (long)(A_Number.Companion.rawSignedIntegerAt(self, objectSize) >> 31) & 0xFFFFFFFFL;
        long extendedAnInteger = (long)(A_Number.Companion.rawSignedIntegerAt(anInteger, anIntegerSize) >> 31) & 0xFFFFFFFFL;
        long partial = 0L;
        int lastInt = 0;
        int i = 1;
        if (i <= outputSize) {
            while (true) {
                partial += i > objectSize ? extendedObject : A_Number.Companion.rawUnsignedIntegerAt(self, i);
                lastInt = (int)(partial += i > anIntegerSize ? extendedAnInteger : A_Number.Companion.rawUnsignedIntegerAt(anInteger, i));
                A_Number.Companion.rawSignedIntegerAtPut(output, i, lastInt);
                partial >>>= 32;
                if (i == outputSize) break;
                ++i;
            }
        }
        if (lastInt >> 31 != (int)(partial += extendedObject + extendedAnInteger)) {
            AvailObject newOutput = Companion.createUninitializedInteger(outputSize + 1);
            int i2 = 1;
            if (i2 <= outputSize) {
                while (true) {
                    newOutput.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, i2, output.intSlot(IntegerSlots.RAW_LONG_SLOTS_, i2));
                    if (i2 == outputSize) break;
                    ++i2;
                }
            }
            A_Number.Companion.rawSignedIntegerAtPut(newOutput, outputSize + 1, (int)partial);
            return newOutput;
        }
        A_Number.Companion.trimExcessInts(output);
        return output;
    }

    @Override
    @NotNull
    public A_Number o_AddToDoubleCanDestroy(@NotNull AvailObject self, @NotNull A_Number doubleObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)doubleObject, (String)"doubleObject");
        double d = DoubleDescriptor.Companion.addDoubleAndIntegerCanDestroy(A_Number.Companion.getExtractDouble(doubleObject), self, canDestroy);
        return DoubleDescriptor.Companion.fromDoubleRecycling(d, doubleObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_AddToFloatCanDestroy(@NotNull AvailObject self, @NotNull A_Number floatObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)floatObject, (String)"floatObject");
        double d = DoubleDescriptor.Companion.addDoubleAndIntegerCanDestroy(A_Number.Companion.getExtractDouble(floatObject), self, canDestroy);
        return FloatDescriptor.Companion.fromFloatRecycling((float)d, floatObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_DivideIntoInfinityCanDestroy(@NotNull AvailObject self, @NotNull AbstractNumberDescriptor.Sign sign, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)((Object)sign), (String)"sign");
        if (self.equals(zero)) {
            throw new ArithmeticException(AvailErrorCode.E_CANNOT_DIVIDE_BY_ZERO);
        }
        return A_Number.Companion.greaterThan(self, zero) ^ sign == AbstractNumberDescriptor.Sign.POSITIVE ? InfinityDescriptor.Companion.getNegativeInfinity() : InfinityDescriptor.Companion.getPositiveInfinity();
    }

    private final AvailObject mutableOf(AvailObject self, AvailObject another) {
        return this.isMutable() ? self : (another.descriptor().isMutable() ? another : null);
    }

    @Override
    @NotNull
    public A_Number o_DivideIntoIntegerCanDestroy(@NotNull AvailObject self, @NotNull AvailObject anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anInteger, (String)"anInteger");
        if (A_Number.Companion.isLong(self)) {
            long numerator;
            long denominator = A_Number.Companion.getExtractLong(self);
            if (denominator == 0L) {
                throw new ArithmeticException(AvailErrorCode.E_CANNOT_DIVIDE_BY_ZERO);
            }
            if (A_Number.Companion.isLong(anInteger) && (numerator = A_Number.Companion.getExtractLong(anInteger)) != Long.MIN_VALUE && denominator != Long.MIN_VALUE) {
                if (denominator < 0L) {
                    denominator = -denominator;
                    numerator = -numerator;
                }
                return numerator < 0L ? (A_Number)Companion.fromLong((long)-1 - ((long)-1 - numerator) / denominator) : (A_Number)Companion.fromLong(numerator / denominator);
            }
        }
        A_Number numerator = anInteger;
        A_Number denominator = self;
        if (A_Number.Companion.lessThan(denominator, zero)) {
            numerator = A_Number.Companion.subtractFromIntegerCanDestroy(numerator, zero, canDestroy);
            denominator = A_Number.Companion.subtractFromIntegerCanDestroy(denominator, zero, canDestroy);
        }
        boolean invertResult = false;
        if (A_Number.Companion.lessThan(numerator, zero)) {
            numerator = A_Number.Companion.bitwiseXor(numerator, negativeOne, canDestroy);
            invertResult = true;
        }
        BigInteger numeratorBigInt = A_Number.Companion.asBigInteger(numerator);
        BigInteger denominatorBigInt = A_Number.Companion.asBigInteger(denominator);
        BigInteger quotient = numeratorBigInt.divide(denominatorBigInt);
        Intrinsics.checkNotNullExpressionValue((Object)quotient, (String)"quotient");
        A_Number result2 = Companion.fromBigInteger(quotient);
        if (invertResult) {
            result2 = A_Number.Companion.bitwiseXor(result2, negativeOne, true);
        }
        return result2;
    }

    @Override
    @NotNull
    public A_Number o_DivideIntoDoubleCanDestroy(@NotNull AvailObject self, @NotNull A_Number doubleObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)doubleObject, (String)"doubleObject");
        int scale = Math.max(Companion.intCount(self) - 4, 0) << 5;
        double scaledIntAsDouble = Companion.extractDoubleScaled(self, scale);
        boolean bl2 = bl = !Double.isInfinite(scaledIntAsDouble);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        double scaledQuotient = A_Number.Companion.getExtractDouble(doubleObject) / scaledIntAsDouble;
        double quotient = Math.scalb(scaledQuotient, scale);
        return DoubleDescriptor.Companion.fromDoubleRecycling(quotient, doubleObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_DivideIntoFloatCanDestroy(@NotNull AvailObject self, @NotNull A_Number floatObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)floatObject, (String)"floatObject");
        int scale = Math.max(Companion.intCount(self) - 4, 0) << 5;
        double scaledIntAsDouble = Companion.extractDoubleScaled(self, scale);
        boolean bl2 = bl = !Double.isInfinite(scaledIntAsDouble);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        double scaledQuotient = A_Number.Companion.getExtractDouble(floatObject) / scaledIntAsDouble;
        double quotient = Math.scalb(scaledQuotient, scale);
        return FloatDescriptor.Companion.fromFloatRecycling((float)quotient, floatObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_MultiplyByInfinityCanDestroy(@NotNull AvailObject self, @NotNull AbstractNumberDescriptor.Sign sign, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)((Object)sign), (String)"sign");
        if (self.equals(zero)) {
            throw new ArithmeticException(AvailErrorCode.E_CANNOT_MULTIPLY_ZERO_AND_INFINITY);
        }
        return A_Number.Companion.greaterThan(self, zero) ^ sign == AbstractNumberDescriptor.Sign.POSITIVE ? InfinityDescriptor.Companion.getNegativeInfinity() : InfinityDescriptor.Companion.getPositiveInfinity();
    }

    @Override
    @NotNull
    public A_Number o_MultiplyByIntegerCanDestroy(@NotNull AvailObject self, @NotNull AvailObject anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anInteger, (String)"anInteger");
        AvailObject output = null;
        if (A_Number.Companion.isInt(self) && A_Number.Companion.isInt(anInteger)) {
            long prod = (long)A_Number.Companion.getExtractInt(self) * (long)A_Number.Companion.getExtractInt(anInteger);
            if (prod == (long)((int)prod)) {
                boolean bl;
                output = canDestroy ? this.mutableOf(self, anInteger) : null;
                AvailObject availObject = output;
                if (availObject == null) {
                    availObject = Companion.createUninitializedInteger(1);
                }
                boolean bl2 = bl = Companion.intCount(output = availObject) == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Number.Companion.rawSignedIntegerAtPut(output, 1, (int)prod);
                return output;
            }
            return Companion.fromLong(prod);
        }
        if (self.equals(zero) || anInteger.equals(zero)) {
            return zero;
        }
        int shift = A_Number.Companion.getWhichPowerOfTwo(self);
        if (shift >= 0) {
            return A_Number.Companion.bitShift(anInteger, Companion.fromInt(shift), canDestroy);
        }
        shift = A_Number.Companion.getWhichPowerOfTwo(anInteger);
        if (shift >= 0) {
            return A_Number.Companion.bitShift(self, Companion.fromInt(shift), canDestroy);
        }
        int size1 = Companion.intCount(self);
        int size2 = Companion.intCount(anInteger);
        if (size1 > 40 && size2 > 40) {
            BigInteger bigInteger = A_Number.Companion.asBigInteger(self).multiply(A_Number.Companion.asBigInteger(anInteger));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"this.multiply(other)");
            return Companion.fromBigInteger(bigInteger);
        }
        int targetSize = size1 + size2;
        output = Companion.createUninitializedInteger(targetSize);
        long extension1 = (long)A_Number.Companion.rawSignedIntegerAt(self, size1) >> 31 & 0xFFFFFFFFL;
        long extension2 = (long)A_Number.Companion.rawSignedIntegerAt(anInteger, size2) >> 31 & 0xFFFFFFFFL;
        long low = 0L;
        long high = 0L;
        int i = 1;
        if (i <= targetSize) {
            do {
                int k = 1;
                int m = ++i;
                while (k <= i) {
                    long multiplicand1 = k > size1 ? extension1 : A_Number.Companion.rawUnsignedIntegerAt(self, k);
                    long multiplicand2 = m > size2 ? extension2 : A_Number.Companion.rawUnsignedIntegerAt(anInteger, m);
                    high += (low += multiplicand1 * multiplicand2) >>> 32;
                    low &= 0xFFFFFFFFL;
                    ++k;
                    --m;
                }
                A_Number.Companion.rawSignedIntegerAtPut(output, i, (int)low);
                low = high & 0xFFFFFFFFL;
                high >>>= 32;
            } while (i != targetSize);
        }
        A_Number.Companion.trimExcessInts(output);
        return output;
    }

    @Override
    @NotNull
    public A_Number o_MultiplyByDoubleCanDestroy(@NotNull AvailObject self, @NotNull A_Number doubleObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)doubleObject, (String)"doubleObject");
        int scale = Math.max(Companion.intCount(self) - 4, 0) << 5;
        double scaledIntAsDouble = Companion.extractDoubleScaled(self, scale);
        boolean bl2 = bl = !Double.isInfinite(scaledIntAsDouble);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        double scaledProduct = A_Number.Companion.getExtractDouble(doubleObject) * scaledIntAsDouble;
        double product = Math.scalb(scaledProduct, scale);
        return DoubleDescriptor.Companion.fromDoubleRecycling(product, doubleObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_MultiplyByFloatCanDestroy(@NotNull AvailObject self, @NotNull A_Number floatObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)floatObject, (String)"floatObject");
        int scale = Math.max(Companion.intCount(self) - 4, 0) << 5;
        double scaledIntAsDouble = Companion.extractDoubleScaled(self, scale);
        boolean bl2 = bl = !Double.isInfinite(scaledIntAsDouble);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        double scaledProduct = A_Number.Companion.getExtractDouble(floatObject) * scaledIntAsDouble;
        double product = Math.scalb(scaledProduct, scale);
        return FloatDescriptor.Companion.fromFloatRecycling((float)product, floatObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_SubtractFromInfinityCanDestroy(@NotNull AvailObject self, @NotNull AbstractNumberDescriptor.Sign sign, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)((Object)sign), (String)"sign");
        return sign == AbstractNumberDescriptor.Sign.POSITIVE ? InfinityDescriptor.Companion.getPositiveInfinity() : InfinityDescriptor.Companion.getNegativeInfinity();
    }

    @Override
    @NotNull
    public A_Number o_SubtractFromIntegerCanDestroy(@NotNull AvailObject self, @NotNull AvailObject anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anInteger, (String)"anInteger");
        int objectSize = Companion.intCount(self);
        int anIntegerSize = Companion.intCount(anInteger);
        AvailObject output = this.largerMutableOf(self, anInteger, objectSize, anIntegerSize, canDestroy);
        if (objectSize == 1 && anIntegerSize == 1) {
            long diff = A_Number.Companion.getExtractLong(anInteger) - A_Number.Companion.getExtractLong(self);
            if (diff == (long)((int)diff)) {
                boolean bl;
                AvailObject availObject = output;
                if (availObject == null) {
                    availObject = Companion.createUninitializedInteger(1);
                }
                boolean bl2 = bl = Companion.intCount(output = availObject) == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Number.Companion.rawSignedIntegerAtPut(output, 1, (int)diff);
                return output;
            }
            output = Companion.createUninitializedInteger(2);
            A_Number.Companion.rawSignedIntegerAtPut(output, 1, (int)diff);
            A_Number.Companion.rawSignedIntegerAtPut(output, 2, (int)(diff >> 32));
            return output;
        }
        AvailObject availObject = output;
        if (availObject == null) {
            availObject = Companion.createUninitializedInteger(Math.max(objectSize, anIntegerSize));
        }
        output = availObject;
        int outputSize = Companion.intCount(output);
        long extendedObject = (long)A_Number.Companion.rawSignedIntegerAt(self, objectSize) >> 31 & 0xFFFFFFFFL;
        long extendedAnInteger = (long)A_Number.Companion.rawSignedIntegerAt(anInteger, anIntegerSize) >> 31 & 0xFFFFFFFFL;
        long partial = 1L;
        int lastInt = 0;
        int i = 1;
        if (i <= outputSize) {
            while (true) {
                partial += i > anIntegerSize ? extendedAnInteger : A_Number.Companion.rawUnsignedIntegerAt(anInteger, i);
                lastInt = (int)(partial += 0xFFFFFFFFL ^ (i > objectSize ? extendedObject : A_Number.Companion.rawUnsignedIntegerAt(self, i)));
                A_Number.Companion.rawSignedIntegerAtPut(output, i, lastInt);
                partial >>>= 32;
                if (i == outputSize) break;
                ++i;
            }
        }
        if (lastInt >> 31 != (int)(partial += extendedAnInteger + (extendedObject ^ 0xFFFFFFFFL))) {
            AvailObject newOutput = Companion.createUninitializedInteger(outputSize + 1);
            int i2 = 1;
            if (i2 <= outputSize) {
                while (true) {
                    A_Number.Companion.rawSignedIntegerAtPut(newOutput, i2, A_Number.Companion.rawSignedIntegerAt(output, i2));
                    if (i2 == outputSize) break;
                    ++i2;
                }
            }
            A_Number.Companion.rawSignedIntegerAtPut(newOutput, outputSize + 1, (int)partial);
            return newOutput;
        }
        A_Number.Companion.trimExcessInts(output);
        return output;
    }

    @Override
    @NotNull
    public A_Number o_SubtractFromDoubleCanDestroy(@NotNull AvailObject self, @NotNull A_Number doubleObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)doubleObject, (String)"doubleObject");
        double d = DoubleDescriptor.Companion.addDoubleAndIntegerCanDestroy(-A_Number.Companion.getExtractDouble(doubleObject), self, canDestroy);
        return DoubleDescriptor.Companion.fromDoubleRecycling(-d, doubleObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_SubtractFromFloatCanDestroy(@NotNull AvailObject self, @NotNull A_Number floatObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)floatObject, (String)"floatObject");
        double d = DoubleDescriptor.Companion.addDoubleAndIntegerCanDestroy(-A_Number.Companion.getExtractDouble(floatObject), self, canDestroy);
        return FloatDescriptor.Companion.fromFloatRecycling((float)(-d), floatObject, canDestroy);
    }

    @Override
    @NotNull
    public AbstractNumberDescriptor.Order o_NumericCompareToInteger(@NotNull AvailObject self, @NotNull AvailObject anInteger) {
        boolean bl;
        int composite2;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anInteger, (String)"anInteger");
        int size1 = Companion.intCount(self);
        int size2 = Companion.intCount(anInteger);
        int high1 = self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, size1);
        int high2 = A_Number.Companion.rawSignedIntegerAt(anInteger, size2);
        int composite1 = high1 >= 0 ? size1 : -size1;
        int n = composite2 = high2 >= 0 ? size2 : -size2;
        if (composite1 != composite2) {
            return composite1 < composite2 ? AbstractNumberDescriptor.Order.LESS : AbstractNumberDescriptor.Order.MORE;
        }
        boolean bl2 = bl = size1 == size2;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = high1 >= 0 == high2 >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (high1 != high2) {
            return high1 < high2 ? AbstractNumberDescriptor.Order.LESS : AbstractNumberDescriptor.Order.MORE;
        }
        for (int i = size1 - 1; 0 < i; --i) {
            int b;
            int a = self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, i);
            if (a == (b = A_Number.Companion.rawSignedIntegerAt(anInteger, i))) continue;
            return ((long)a & 0xFFFFFFFFL) < ((long)b & 0xFFFFFFFFL) ? AbstractNumberDescriptor.Order.LESS : AbstractNumberDescriptor.Order.MORE;
        }
        return AbstractNumberDescriptor.Order.EQUAL;
    }

    @Override
    @NotNull
    public AbstractNumberDescriptor.Order o_NumericCompareToInfinity(@NotNull AvailObject self, @NotNull AbstractNumberDescriptor.Sign sign) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)((Object)sign), (String)"sign");
        return sign == AbstractNumberDescriptor.Sign.POSITIVE ? AbstractNumberDescriptor.Order.LESS : AbstractNumberDescriptor.Order.MORE;
    }

    @Override
    @NotNull
    public AbstractNumberDescriptor.Order o_NumericCompareToDouble(@NotNull AvailObject self, double aDouble) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return DoubleDescriptor.Companion.compareDoubleAndInteger(aDouble, self).reverse();
    }

    private final AvailObject bitwiseOperation(AvailObject self, A_Number anInteger, boolean canDestroy, Function2<? super Integer, ? super Integer, Integer> operation) {
        int objectSize = Companion.intCount(self);
        AvailObject anIntegerTraversed = anInteger.traversed();
        int anIntegerSize = Companion.intCount(anIntegerTraversed);
        AvailObject output = this.largerMutableOf(self, anIntegerTraversed, objectSize, anIntegerSize, canDestroy);
        if (objectSize == 1 && anIntegerSize == 1) {
            int result2 = ((Number)operation.invoke((Object)A_Number.Companion.rawSignedIntegerAt(self, 1), (Object)A_Number.Companion.rawSignedIntegerAt(anIntegerTraversed, 1))).intValue();
            AvailObject availObject = output;
            if (availObject == null) {
                availObject = Companion.createUninitializedInteger(1);
            }
            output = availObject;
            A_Number.Companion.rawSignedIntegerAtPut(output, 1, result2);
            return output;
        }
        AvailObject availObject = output;
        if (availObject == null) {
            availObject = Companion.createUninitializedInteger(Math.max(objectSize, anIntegerSize));
        }
        output = availObject;
        int outputSize = Companion.intCount(output);
        int extendedObject = A_Number.Companion.rawSignedIntegerAt(self, objectSize) >> 31;
        int extendedAnInteger = A_Number.Companion.rawSignedIntegerAt(anIntegerTraversed, anIntegerSize) >> 31;
        int i = 1;
        if (i <= outputSize) {
            while (true) {
                int objectWord = i > objectSize ? extendedObject : A_Number.Companion.rawSignedIntegerAt(self, i);
                int anIntegerWord = i > anIntegerSize ? extendedAnInteger : A_Number.Companion.rawSignedIntegerAt(anIntegerTraversed, i);
                int result3 = ((Number)operation.invoke((Object)objectWord, (Object)anIntegerWord)).intValue();
                A_Number.Companion.rawSignedIntegerAtPut(output, i, result3);
                if (i == outputSize) break;
                ++i;
            }
        }
        A_Number.Companion.trimExcessInts(output);
        return output;
    }

    @Override
    @NotNull
    public A_Number o_BitwiseAnd(@NotNull AvailObject self, @NotNull A_Number anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anInteger, (String)"anInteger");
        return this.bitwiseOperation(self, anInteger, canDestroy, (Function2<? super Integer, ? super Integer, Integer>)((Function2)o_BitwiseAnd.1.INSTANCE));
    }

    @Override
    @NotNull
    public A_Number o_BitwiseOr(@NotNull AvailObject self, @NotNull A_Number anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anInteger, (String)"anInteger");
        return this.bitwiseOperation(self, anInteger, canDestroy, (Function2<? super Integer, ? super Integer, Integer>)((Function2)o_BitwiseOr.1.INSTANCE));
    }

    @Override
    @NotNull
    public A_Number o_BitwiseXor(@NotNull AvailObject self, @NotNull A_Number anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anInteger, (String)"anInteger");
        return this.bitwiseOperation(self, anInteger, canDestroy, (Function2<? super Integer, ? super Integer, Integer>)((Function2)o_BitwiseXor.1.INSTANCE));
    }

    @Override
    public boolean o_BitTest(@NotNull AvailObject self, int bitPosition) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl2 = bl = bitPosition >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int intIndex = (bitPosition >>> 5) + 1;
        if (intIndex > Companion.intCount(self)) {
            return A_Number.Companion.lessThan(self, zero);
        }
        int intValue = A_Number.Companion.rawSignedIntegerAt(self, intIndex);
        return (intValue & 1 << (bitPosition & 0x1F)) != 0;
    }

    @Override
    @NotNull
    public A_Number o_BitSet(@NotNull AvailObject self, int bitPosition, boolean value, boolean canDestroy) {
        int i;
        int newInt;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl2 = bl = bitPosition >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int intIndex = (bitPosition >>> 5) + 1;
        int oldIntCount = Companion.intCount(self);
        int mask = 1 << (bitPosition & 0x1F);
        int oldInt = intIndex <= oldIntCount ? A_Number.Companion.rawSignedIntegerAt(self, intIndex) : (A_Number.Companion.lessThan(self, zero) ? -1 : 0);
        int n = newInt = value ? oldInt | mask : oldInt & ~mask;
        if (oldInt == newInt) {
            if (this.isMutable() && !canDestroy) {
                self.makeImmutable();
            }
            return self;
        }
        int newIntCount = Math.max(oldIntCount, (bitPosition + 1 >>> 5) + 1);
        if (oldIntCount == newIntCount && this.isMutable() && canDestroy) {
            A_Number.Companion.rawSignedIntegerAtPut(self, intIndex, newInt);
            A_Number.Companion.trimExcessInts(self);
            return self;
        }
        AvailObject result2 = AvailObjectRepresentation.Companion.newLike(IntegerDescriptor.Companion.mutableFor(newIntCount), self, 0, 0);
        if (A_Number.Companion.lessThan(self, zero) && (i = oldIntCount + 1) <= newIntCount) {
            while (true) {
                A_Number.Companion.rawSignedIntegerAtPut(result2, i, -1);
                if (i == newIntCount) break;
                ++i;
            }
        }
        A_Number.Companion.rawSignedIntegerAtPut(result2, intIndex, newInt);
        A_Number.Companion.trimExcessInts(result2);
        return result2;
    }

    @Override
    @NotNull
    public A_Number o_BitShiftLeftTruncatingToBits(@NotNull AvailObject self, @NotNull A_Number shiftFactor, @NotNull A_Number truncationBits, boolean canDestroy) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)shiftFactor, (String)"shiftFactor");
        Intrinsics.checkNotNullParameter((Object)truncationBits, (String)"truncationBits");
        if (!A_Number.Companion.isInt(truncationBits)) {
            throw new ArithmeticException(AvailErrorCode.E_TOO_LARGE_TO_REPRESENT);
        }
        int truncationInt = A_Number.Companion.getExtractInt(truncationBits);
        boolean bl3 = bl2 = truncationInt >= 0;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AbstractNumberDescriptor.Order sign = A_Number.Companion.numericCompareToInteger(self, zero);
        boolean bl4 = bl = sign != AbstractNumberDescriptor.Order.LESS;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (sign == AbstractNumberDescriptor.Order.EQUAL) {
            if (!canDestroy || this.isMutable()) {
                self.makeImmutable();
            }
            return self;
        }
        if (!A_Number.Companion.isInt(shiftFactor)) {
            return zero;
        }
        int shiftInt = A_Number.Companion.getExtractInt(shiftFactor);
        if (A_Number.Companion.isLong(self)) {
            long baseLong = A_Number.Companion.getExtractLong(self);
            long shiftedLong = AbstractDescriptor.Companion.bitShiftLong(baseLong, shiftInt);
            if (shiftInt < 0 || truncationInt < 64 || AbstractDescriptor.Companion.bitShiftLong(shiftedLong, -shiftInt) == baseLong) {
                long resultLong = shiftedLong;
                if (truncationInt < 64) {
                    resultLong &= (1L << truncationInt) - 1L;
                }
                if (canDestroy && this.isMutable()) {
                    if (resultLong == (long)((int)resultLong)) {
                        if (Companion.intCount(self) == 1) {
                            A_Number.Companion.rawSignedIntegerAtPut(self, 1, (int)resultLong);
                            return self;
                        }
                    } else if (Companion.intCount(self) == 2) {
                        A_Number.Companion.rawSignedIntegerAtPut(self, 1, (int)resultLong);
                        A_Number.Companion.rawSignedIntegerAtPut(self, 2, (int)(resultLong >> 32));
                        return self;
                    }
                }
                return Companion.fromLong(resultLong);
            }
        }
        int sourceSlots = Companion.intCount(self);
        int estimatedBits = (sourceSlots << 5) + shiftInt;
        estimatedBits = Math.min(estimatedBits, truncationInt + 1);
        estimatedBits = Math.max(estimatedBits, 1);
        int slotCount = estimatedBits + 31 >> 5;
        A_Number result2 = Companion.createUninitializedInteger(slotCount);
        int shortShift = shiftInt & 0x1F;
        int sourceIndex = slotCount - (shiftInt >> 5);
        long accumulator = 6822332205939736303L;
        for (int destIndex = slotCount + 1; 0 < destIndex; --destIndex) {
            int nextWord = (1 <= sourceIndex ? sourceIndex <= sourceSlots : false) ? A_Number.Companion.rawSignedIntegerAt(self, sourceIndex) : 0;
            accumulator <<= 32;
            accumulator |= (long)nextWord << shortShift;
            if (destIndex <= slotCount) {
                A_Number.Companion.rawSignedIntegerAtPut(result2, destIndex, (int)(accumulator >> 32));
            }
            --sourceIndex;
        }
        int mask = (1 << (truncationInt & 0x1F)) - 1;
        int destIndex = truncationInt >> 5;
        if (destIndex <= slotCount) {
            while (true) {
                A_Number.Companion.rawSignedIntegerAtPut(result2, destIndex, A_Number.Companion.rawSignedIntegerAt(result2, destIndex) & mask);
                mask = 0;
                if (destIndex == slotCount) break;
                ++destIndex;
            }
        }
        A_Number.Companion.trimExcessInts(result2);
        return result2;
    }

    @Override
    @NotNull
    public A_Number o_BitShift(@NotNull AvailObject self, @NotNull A_Number shiftFactor, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)shiftFactor, (String)"shiftFactor");
        if (self.equals(zero)) {
            if (!canDestroy || this.isMutable()) {
                self.makeImmutable();
            }
            return self;
        }
        if (!A_Number.Companion.isInt(shiftFactor)) {
            if (A_Number.Companion.numericCompareToInteger(shiftFactor, zero) == AbstractNumberDescriptor.Order.MORE) {
                throw new ArithmeticException(AvailErrorCode.E_TOO_LARGE_TO_REPRESENT);
            }
            return AbstractNumberDescriptor.Order.MORE == A_Number.Companion.numericCompareToInteger(self, zero) ? (A_Number)zero : Companion.negativeOne();
        }
        int shiftInt = A_Number.Companion.getExtractInt(shiftFactor);
        if (A_Number.Companion.isLong(self)) {
            long baseLong = A_Number.Companion.getExtractLong(self);
            long shiftedLong = AbstractDescriptor.Companion.arithmeticBitShiftLong(baseLong, shiftInt);
            if (shiftInt < 0 || AbstractDescriptor.Companion.arithmeticBitShiftLong(shiftedLong, -shiftInt) == baseLong) {
                if (canDestroy && this.isMutable()) {
                    if (shiftedLong == (long)((int)shiftedLong)) {
                        if (Companion.intCount(self) == 1) {
                            A_Number.Companion.rawSignedIntegerAtPut(self, 1, (int)shiftedLong);
                            return self;
                        }
                    } else if (Companion.intCount(self) == 2) {
                        A_Number.Companion.rawSignedIntegerAtPut(self, 1, (int)shiftedLong);
                        A_Number.Companion.rawSignedIntegerAtPut(self, 2, (int)(shiftedLong >> 32));
                        return self;
                    }
                }
                return Companion.fromLong(shiftedLong);
            }
        }
        int sourceSlots = Companion.intCount(self);
        int estimatedBits = Math.max((sourceSlots << 5) + shiftInt, 1);
        int intSlotCount = estimatedBits + 31 >> 5;
        A_Number result2 = Companion.createUninitializedInteger(intSlotCount);
        int shortShift = shiftInt & 0x1F;
        int sourceIndex = intSlotCount - (shiftInt >> 5);
        long accumulator = 6822332205939736303L;
        int signExtension = AbstractNumberDescriptor.Order.LESS == A_Number.Companion.numericCompareToInteger(self, zero) ? -1 : 0;
        for (int destIndex = intSlotCount + 1; 0 < destIndex; --destIndex) {
            int nextWord = sourceIndex < 1 ? 0 : (sourceIndex > sourceSlots ? signExtension : A_Number.Companion.rawSignedIntegerAt(self, sourceIndex));
            accumulator <<= 32;
            accumulator |= ((long)nextWord & 0xFFFFFFFFL) << shortShift;
            if (destIndex <= intSlotCount) {
                A_Number.Companion.rawSignedIntegerAtPut(result2, destIndex, (int)(accumulator >> 32));
            }
            --sourceIndex;
        }
        A_Number.Companion.trimExcessInts(result2);
        return result2;
    }

    @Override
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        block0: {
            SerializerOperation serializerOperation;
            block2: {
                int n;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block6: {
                                            block5: {
                                                block4: {
                                                    block3: {
                                                        block1: {
                                                            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
                                                            if (!A_Number.Companion.isInt(self)) break block0;
                                                            n = A_Number.Companion.getExtractInt(self);
                                                            if (n != 0) break block1;
                                                            serializerOperation = SerializerOperation.ZERO_INTEGER;
                                                            break block2;
                                                        }
                                                        if (n != 1) break block3;
                                                        serializerOperation = SerializerOperation.ONE_INTEGER;
                                                        break block2;
                                                    }
                                                    if (n != 2) break block4;
                                                    serializerOperation = SerializerOperation.TWO_INTEGER;
                                                    break block2;
                                                }
                                                if (n != 3) break block5;
                                                serializerOperation = SerializerOperation.THREE_INTEGER;
                                                break block2;
                                            }
                                            if (n != 4) break block6;
                                            serializerOperation = SerializerOperation.FOUR_INTEGER;
                                            break block2;
                                        }
                                        if (n != 5) break block7;
                                        serializerOperation = SerializerOperation.FIVE_INTEGER;
                                        break block2;
                                    }
                                    if (n != 6) break block8;
                                    serializerOperation = SerializerOperation.SIX_INTEGER;
                                    break block2;
                                }
                                if (n != 7) break block9;
                                serializerOperation = SerializerOperation.SEVEN_INTEGER;
                                break block2;
                            }
                            if (n != 8) break block10;
                            serializerOperation = SerializerOperation.EIGHT_INTEGER;
                            break block2;
                        }
                        if (n != 9) break block11;
                        serializerOperation = SerializerOperation.NINE_INTEGER;
                        break block2;
                    }
                    if (n != 10) break block12;
                    serializerOperation = SerializerOperation.TEN_INTEGER;
                    break block2;
                }
                serializerOperation = (0 <= n ? n < 256 : false) ? SerializerOperation.BYTE_INTEGER : ((0 <= n ? n < 65536 : false) ? SerializerOperation.SHORT_INTEGER : SerializerOperation.INT_INTEGER);
            }
            return serializerOperation;
        }
        return SerializerOperation.BIG_INTEGER;
    }

    @Override
    @NotNull
    public Object o_MarshalToJava(@NotNull AvailObject self, @Nullable Class<?> classHint) {
        Number number;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Class<?> clazz = classHint;
        if (Intrinsics.areEqual(clazz, BigInteger.class)) {
            number = A_Number.Companion.asBigInteger(self);
        } else if (Intrinsics.areEqual(clazz, Long.TYPE) ? true : Intrinsics.areEqual(clazz, Long.class)) {
            if (!A_Number.Companion.isLong(self)) {
                throw new MarshalingException();
            }
            number = A_Number.Companion.getExtractLong(self);
        } else if (Intrinsics.areEqual(clazz, Integer.TYPE) ? true : Intrinsics.areEqual(clazz, Integer.class)) {
            if (!A_Number.Companion.isInt(self)) {
                throw new MarshalingException();
            }
            number = A_Number.Companion.getExtractInt(self);
        } else if (Intrinsics.areEqual(clazz, Short.TYPE) ? true : Intrinsics.areEqual(clazz, Short.class)) {
            if (!A_Number.Companion.isSignedShort(self)) {
                throw new MarshalingException();
            }
            number = A_Number.Companion.getExtractSignedShort(self);
        } else if (Intrinsics.areEqual(clazz, Byte.TYPE) ? true : Intrinsics.areEqual(clazz, Byte.class)) {
            if (!A_Number.Companion.isSignedByte(self)) {
                throw new MarshalingException();
            }
            number = A_Number.Companion.getExtractSignedByte(self);
        } else {
            long longValue;
            number = !A_Number.Companion.isLong(self) ? A_Number.Companion.asBigInteger(self) : ((longValue = A_Number.Companion.getExtractLong(self)) == (long)((byte)longValue) ? (Number)((byte)longValue) : (Number)(longValue == (long)((short)longValue) ? (Number)((short)longValue) : (Number)(longValue == (long)((int)longValue) ? (Number)((int)longValue) : (Number)longValue)));
        }
        return number;
    }

    @Override
    @NotNull
    public BigInteger o_AsBigInteger(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int integerCount = Companion.intCount(self);
        if (integerCount <= 2) {
            BigInteger bigInteger = BigInteger.valueOf(A_Number.Companion.getExtractLong(self));
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(self.extractLong)");
            return bigInteger;
        }
        byte[] bytes = new byte[integerCount << 2];
        int b = 0;
        for (int i = integerCount; 0 < i; --i) {
            int integer = self.intSlot(IntegerSlots.RAW_LONG_SLOTS_, i);
            bytes[b++] = (byte)(integer >> 24);
            bytes[b++] = (byte)(integer >> 16);
            bytes[b++] = (byte)(integer >> 8);
            bytes[b++] = (byte)integer;
        }
        return new BigInteger(bytes);
    }

    @Override
    public boolean o_IsNumericallyIntegral(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return true;
    }

    @Override
    @NotNull
    public TypeTag o_ComputeTypeTag(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return A_Number.Companion.greaterThan(self, zero) ? TypeTag.NATURAL_NUMBER_TAG : (A_Number.Companion.equalsInt(self, 0) ? TypeTag.WHOLE_NUMBER_TAG : TypeTag.INTEGER_TAG);
    }

    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        if (A_Number.Companion.isLong(self)) {
            writer.write(A_Number.Companion.getExtractLong(self));
        } else {
            writer.write(A_Number.Companion.asBigInteger(self));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int o_WhichPowerOfTwo(@NotNull AvailObject self) {
        boolean bl;
        int theInt;
        int nonZeroIndex;
        block7: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            if (A_Number.Companion.lessOrEqual(self, zero)) {
                return -1;
            }
            nonZeroIndex = 1;
            theInt = 0;
            while ((theInt = A_Number.Companion.rawSignedIntegerAt(self, nonZeroIndex)) == 0) {
                ++nonZeroIndex;
            }
            if (Integer.bitCount(theInt) > 1) {
                return -1;
            }
            Iterable iterable = (Iterable)new IntRange(nonZeroIndex + 1, Companion.intCount(self));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(A_Number.Companion.rawSignedIntegerAt(self, it) != 0)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return -1;
        }
        return (nonZeroIndex - 1 << 5) + Integer.numberOfTrailingZeros(theInt);
    }

    @Override
    @NotNull
    public IntegerDescriptor mutable() {
        IntegerDescriptor[] integerDescriptorArray = descriptors.get((Object)Mutability.MUTABLE);
        Intrinsics.checkNotNull((Object)integerDescriptorArray);
        return integerDescriptorArray[this.unusedIntsOfLastLong];
    }

    @Override
    @NotNull
    public IntegerDescriptor immutable() {
        IntegerDescriptor[] integerDescriptorArray = descriptors.get((Object)Mutability.IMMUTABLE);
        Intrinsics.checkNotNull((Object)integerDescriptorArray);
        return integerDescriptorArray[this.unusedIntsOfLastLong];
    }

    @Override
    @NotNull
    public IntegerDescriptor shared() {
        IntegerDescriptor[] integerDescriptorArray = descriptors.get((Object)Mutability.SHARED);
        Intrinsics.checkNotNull((Object)integerDescriptorArray);
        return integerDescriptorArray[this.unusedIntsOfLastLong];
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject fromInt(int anInteger) {
        return Companion.fromInt(anInteger);
    }

    /*
     * WARNING - void declaration
     */
    static {
        Object[] objectArray;
        AvailObject[] availObjectArray;
        Object key$iv;
        Companion = new Companion(null);
        Class[] classArray = new Class[1];
        Intrinsics.checkNotNull(Integer.TYPE);
        fromIntMethod = CheckedMethod.Companion.staticMethod(IntegerDescriptor.class, "fromInt", AvailObject.class, classArray);
        int n = 0;
        int[] nArray = new int[256];
        while (n < 256) {
            int n2 = n++;
            nArray[n2] = Random.Default.nextBits(32);
        }
        byteHashes = nArray;
        EnumMap.Companion this_$iv = EnumMap.Companion;
        boolean $i$f$enumMap = false;
        Enum[] keys$iv = (Enum[])Mutability.class.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue((Object)keys$iv, (String)"keys");
        EnumMap map$iv = new EnumMap(keys$iv);
        Enum[] $this$forEach$iv$iv = keys$iv;
        boolean $i$f$forEach = false;
        for (Enum element$iv$iv : $this$forEach$iv$iv) {
            key$iv = element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)key$iv, (String)"key");
            Mutability mut = (Mutability)((Object)key$iv);
            boolean bl2 = false;
            int n3 = 0;
            IntegerDescriptor[] integerDescriptorArray = new IntegerDescriptor[2];
            while (n3 < 2) {
                int n4 = n3++;
                integerDescriptorArray[n4] = new IntegerDescriptor(mut, (byte)n4);
            }
            IntegerDescriptor[] value$iv = integerDescriptorArray;
            boolean bl3 = false;
            map$iv.set(key$iv, value$iv);
        }
        descriptors = map$iv;
        Object[] array = availObjectArray = new AvailObject[16384];
        boolean $i$a$-also-IntegerDescriptor$Companion$smallIntegers$22 = false;
        Iterable $this$forEach$iv = (Iterable)new IntRange(0, 255);
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            AvailObject availObject;
            void $this$smallIntegers_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11;
            int element$iv;
            int i = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            key$iv = Companion.createUninitializedInteger(1);
            int n5 = i;
            AvailObject[] availObjectArray2 = array;
            boolean bl4 = false;
            A_Number.Companion.rawSignedIntegerAtPut((A_Number)$this$smallIntegers_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11, 1, i);
            availObjectArray2[n5] = availObject = $this$smallIntegers_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d11.makeShared();
        }
        smallIntegers = availObjectArray;
        int n6 = 0;
        array = new int[16384];
        Companion $i$a$-also-IntegerDescriptor$Companion$smallIntegers$22 = Companion;
        while (n6 < 16384) {
            int n7 = n6++;
            array[n7] = (AvailObject)$i$a$-also-IntegerDescriptor$Companion$smallIntegers$22.computeHashOfInt(n7);
        }
        hashesOfSmallIntegers = (int[])array;
        AvailObject availObject = smallIntegers[0];
        Intrinsics.checkNotNull((Object)availObject);
        zero = availObject;
        AvailObject availObject2 = smallIntegers[1];
        Intrinsics.checkNotNull((Object)availObject2);
        one = availObject2;
        AvailObject availObject3 = smallIntegers[2];
        Intrinsics.checkNotNull((Object)availObject3);
        two = availObject3;
        Object[] $this$negativeOne_u24lambda_u2d14 = objectArray = Companion.createUninitializedInteger(1);
        boolean bl = false;
        A_Number.Companion.rawSignedIntegerAtPut((A_Number)$this$negativeOne_u24lambda_u2d14, 1, -1);
        $this$negativeOne_u24lambda_u2d14.makeShared();
        negativeOne = objectArray;
        quintillionInteger = Companion.fromLong(1000000000000000000L).makeShared();
        objectArray = new A_Number[]{quintillionInteger};
        squaresOfQuintillion = CollectionsKt.mutableListOf((Object[])objectArray);
        squaresOfQuintillionLock = new ReentrantReadWriteLock();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lavail/descriptor/numbers/IntegerDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "RAW_LONG_SLOTS_", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        public static final /* enum */ IntegerSlots RAW_LONG_SLOTS_ = new IntegerSlots();
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.RAW_LONG_SLOTS_};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010*\u001a\u00020\u001c2\u0006\u0010+\u001a\u00020\u000bJ\u0018\u0010,\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020\u000bH\u0002J\u000e\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u000bJ\u0010\u00101\u001a\u00020\u000b2\u0006\u00102\u001a\u00020\u0013H\u0002J\u000e\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u001eJ\u000e\u00105\u001a\u00020\u00132\u0006\u00106\u001a\u00020\u000bJ\u0016\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00132\u0006\u0010:\u001a\u00020\u000bJ\u000e\u0010;\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020=J\u0010\u0010>\u001a\u00020\u00132\u0006\u0010?\u001a\u00020\u000bH\u0007J\u000e\u0010@\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u001eJ\u000e\u0010A\u001a\u00020\u00132\u0006\u0010?\u001a\u00020BJ\u000e\u0010C\u001a\u00020\u000b2\u0006\u0010?\u001a\u00020BJ\u000e\u0010D\u001a\u00020\u000b2\u0006\u00109\u001a\u00020\u0013J\u0010\u0010E\u001a\u00020\t2\u0006\u00106\u001a\u00020\u000bH\u0002J\u0006\u0010\u0012\u001a\u00020\u001cJ$\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\u001c2\n\u0010I\u001a\u00060Jj\u0002`K2\u0006\u0010L\u001a\u00020\u000bH\u0002J\u000e\u0010M\u001a\u00020\u001c2\u0006\u0010N\u001a\u000208R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u0016\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001c0#8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010&\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0015R\u0011\u0010(\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0015\u00a8\u0006O"}, d2={"Lavail/descriptor/numbers/IntegerDescriptor$Companion;", "", "()V", "byteHashes", "", "descriptors", "Lavail/utility/structures/EnumMap;", "Lavail/descriptor/representation/Mutability;", "", "Lavail/descriptor/numbers/IntegerDescriptor;", "finalHashAddend", "", "fromIntMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getFromIntMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "hashesOfSmallIntegers", "initialHashValue", "negativeOne", "Lavail/descriptor/representation/AvailObject;", "getNegativeOne", "()Lavail/descriptor/representation/AvailObject;", "setNegativeOne", "(Lavail/descriptor/representation/AvailObject;)V", "one", "getOne", "postMultiplyHashToggle", "quintillionInteger", "Lavail/descriptor/numbers/A_Number;", "quintillionLong", "", "smallIntegerLimit", "smallIntegers", "[Lavail/descriptor/representation/AvailObject;", "squaresOfQuintillion", "", "squaresOfQuintillionLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "two", "getTwo", "zero", "getZero", "cachedSquareOfQuintillion", "n", "combineHash", "currentHash", "nextInt", "computeHashOfInt", "anInt", "computeHashOfIntegerObject", "anIntegerObject", "computeHashOfLong", "aLong", "createUninitializedInteger", "size", "extractDoubleScaled", "", "self", "exponentBias", "fromBigInteger", "bigInteger", "Ljava/math/BigInteger;", "fromInt", "anInteger", "fromLong", "fromUnsignedByte", "", "hashOfUnsignedByte", "intCount", "mutableFor", "printBigInteger", "", "magnitude", "aStream", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "minDigits", "truncatedFromDouble", "aDouble", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final int intCount(@NotNull AvailObject self) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            int n = self.integerSlotsCount() << 1;
            AbstractDescriptor abstractDescriptor = self.descriptor();
            Intrinsics.checkNotNull((Object)abstractDescriptor, (String)"null cannot be cast to non-null type avail.descriptor.numbers.IntegerDescriptor");
            return n - ((IntegerDescriptor)abstractDescriptor).getUnusedIntsOfLastLong();
        }

        private final void printBigInteger(A_Number magnitude, StringBuilder aStream, int minDigits) {
            boolean bl;
            boolean bl2;
            boolean bl3 = bl2 = minDigits >= 0;
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (A_Number.Companion.isLong(magnitude)) {
                long value = A_Number.Companion.getExtractLong(magnitude);
                if (minDigits == 0) {
                    aStream.append(value);
                    return;
                }
                String digits = String.valueOf(value);
                for (int i = digits.length(); i < minDigits; ++i) {
                    aStream.append('0');
                }
                aStream.append(digits);
                return;
            }
            int n = 0;
            A_Number nextDivisor = quintillionInteger;
            A_Number previousDivisor = null;
            do {
                previousDivisor = nextDivisor;
            } while (A_Number.Companion.lessThan(nextDivisor = this.cachedSquareOfQuintillion(++n), magnitude));
            int remainderDigits = 18 << --n;
            boolean bl4 = bl = minDigits == 0 || remainderDigits < minDigits;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            A_Number quotient = A_Number.Companion.divideCanDestroy(magnitude, previousDivisor, false);
            A_Number remainder = A_Number.Companion.minusCanDestroy(magnitude, A_Number.Companion.timesCanDestroy(quotient, previousDivisor, false), false);
            this.printBigInteger(quotient, aStream, minDigits == 0 ? 0 : minDigits - remainderDigits);
            this.printBigInteger(remainder, aStream, remainderDigits);
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject fromInt(int anInteger) {
            AvailObject availObject;
            int n = anInteger;
            boolean bl = 0 <= n ? n < 256 : false;
            if (bl) {
                AvailObject availObject2 = smallIntegers[anInteger];
                availObject = availObject2;
                Intrinsics.checkNotNull((Object)availObject2);
            } else {
                boolean bl2 = 0 <= n ? n < 16384 : false;
                if (bl2) {
                    availObject = smallIntegers[anInteger];
                    if (availObject == null) {
                        AvailObject availObject3;
                        AvailObject $this$fromInt_u24lambda_u2d0 = availObject3 = this.createUninitializedInteger(1);
                        boolean bl3 = false;
                        $this$fromInt_u24lambda_u2d0.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, 1, anInteger);
                        $this$fromInt_u24lambda_u2d0.makeShared();
                        smallIntegers[anInteger] = $this$fromInt_u24lambda_u2d0;
                        availObject = availObject3;
                    }
                } else {
                    AvailObject availObject4;
                    AvailObject $this$fromInt_u24lambda_u2d1 = availObject4 = this.createUninitializedInteger(1);
                    boolean bl4 = false;
                    $this$fromInt_u24lambda_u2d1.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, 1, anInteger);
                    availObject = availObject4;
                }
            }
            return availObject;
        }

        @NotNull
        public final AvailObject fromLong(long aLong) {
            AvailObject availObject;
            long l = aLong;
            boolean bl = 0L <= l ? l < 256L : false;
            if (bl) {
                AvailObject availObject2 = smallIntegers[(int)aLong];
                availObject = availObject2;
                Intrinsics.checkNotNull((Object)availObject2);
            } else {
                boolean bl2 = 0L <= l ? l < 16384L : false;
                if (bl2) {
                    availObject = smallIntegers[(int)aLong];
                    if (availObject == null) {
                        AvailObject availObject3;
                        AvailObject $this$fromLong_u24lambda_u2d2 = availObject3 = this.createUninitializedInteger(1);
                        boolean bl3 = false;
                        $this$fromLong_u24lambda_u2d2.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, 1, (int)aLong);
                        smallIntegers[(int)aLong] = $this$fromLong_u24lambda_u2d2.makeShared();
                        availObject = availObject3;
                    }
                } else if (l == (long)((int)aLong)) {
                    AvailObject availObject4;
                    AvailObject $this$fromLong_u24lambda_u2d3 = availObject4 = this.createUninitializedInteger(1);
                    boolean bl4 = false;
                    $this$fromLong_u24lambda_u2d3.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, 1, (int)aLong);
                    availObject = availObject4;
                } else {
                    AvailObject availObject5;
                    AvailObject $this$fromLong_u24lambda_u2d4 = availObject5 = this.createUninitializedInteger(2);
                    boolean bl5 = false;
                    $this$fromLong_u24lambda_u2d4.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, 1, (int)aLong);
                    $this$fromLong_u24lambda_u2d4.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, 2, (int)(aLong >> 32));
                    availObject = availObject5;
                }
            }
            return availObject;
        }

        @NotNull
        public final A_Number fromBigInteger(@NotNull BigInteger bigInteger) {
            boolean bl;
            int destIndex;
            Intrinsics.checkNotNullParameter((Object)bigInteger, (String)"bigInteger");
            byte[] bytes = bigInteger.toByteArray();
            if (bytes.length <= 8) {
                return this.fromLong(bigInteger.longValue());
            }
            int intCount = bytes.length + 3 >> 2;
            AvailObject result2 = this.createUninitializedInteger(intCount);
            int byteIndex = bytes.length;
            for (destIndex = 1; destIndex < intCount; ++destIndex) {
                int intValue = ((bytes[byteIndex -= 4] & 0xFF) << 24) + ((bytes[byteIndex + 1] & 0xFF) << 16) + ((bytes[byteIndex + 2] & 0xFF) << 8) + (bytes[byteIndex + 3] & 0xFF);
                result2.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, destIndex, intValue);
            }
            int highInt = ((bytes[0] & 0xFF) << 24) + ((bytes[1] & 0xFF) << 16) + ((bytes[2] & 0xFF) << 8) + (bytes[3] & 0xFF);
            boolean bl2 = 1 <= byteIndex ? byteIndex < 5 : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            result2.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, destIndex, highInt >>= 4 - byteIndex << 3);
            A_Number.Companion.trimExcessInts(result2);
            boolean bl3 = bl = this.intCount(result2) == intCount;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            return result2;
        }

        @NotNull
        public final A_Number truncatedFromDouble(double aDouble) {
            double truncated = aDouble;
            if (truncated >= -9.223372036854776E18 && truncated <= 9.223372036854776E18) {
                return this.fromLong((long)truncated);
            }
            boolean neg = truncated < 0.0;
            truncated = Math.abs(truncated);
            int exponent = Math.getExponent(truncated);
            int slots = exponent + 31 >> 5;
            AvailObject out2 = this.createUninitializedInteger(slots);
            truncated = Math.scalb(truncated, 1 - slots << 5);
            for (int i = slots; 0 < i; --i) {
                int intSlice = (int)truncated;
                out2.setIntSlot(IntegerSlots.RAW_LONG_SLOTS_, i, intSlice);
                truncated -= (double)intSlice;
                truncated = Math.scalb(truncated, 32);
            }
            A_Number.Companion.trimExcessInts(out2);
            return neg ? A_Number.Companion.noFailMinusCanDestroy(this.getZero(), out2, true) : (A_Number)out2;
        }

        @NotNull
        public final CheckedMethod getFromIntMethod() {
            return fromIntMethod;
        }

        @NotNull
        public final AvailObject fromUnsignedByte(short anInteger) {
            short s = anInteger;
            short s2 = 0 <= s ? (s < 256 ? (short)1 : 0) : (s = 0);
            if (_Assertions.ENABLED && s == 0) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            AvailObject availObject = smallIntegers[anInteger];
            Intrinsics.checkNotNull((Object)availObject);
            return availObject;
        }

        public final double extractDoubleScaled(@NotNull AvailObject self, int exponentBias) {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            int slotsCount = this.intCount(self);
            long high = A_Number.Companion.rawSignedIntegerAt(self, slotsCount);
            double d = Math.scalb((double)high, (slotsCount - 1 << 5) - exponentBias);
            if (slotsCount > 1) {
                long med = A_Number.Companion.rawUnsignedIntegerAt(self, slotsCount - 1);
                d += Math.scalb((double)med, (slotsCount - 2 << 5) - exponentBias);
                if (slotsCount > 2) {
                    long low = A_Number.Companion.rawUnsignedIntegerAt(self, slotsCount - 2);
                    d += Math.scalb((double)low, (slotsCount - 3 << 5) - exponentBias);
                }
            }
            return d;
        }

        @NotNull
        public final A_Number negativeOne() {
            return this.getNegativeOne();
        }

        public final int hashOfUnsignedByte(short anInteger) {
            return hashesOfSmallIntegers[anInteger];
        }

        private final int combineHash(int currentHash, int nextInt) {
            int hash = currentHash ^ nextInt;
            int index2 = hash ^ hash >> 16;
            index2 -= index2 >> 8;
            hash += byteHashes[index2 & 0xFF];
            return (hash -= byteHashes[index2 >> 8 & 0xFF]) ^ 0x95FFB59F;
        }

        public final int computeHashOfInt(int anInt) {
            int output = this.combineHash(324610180, anInt);
            output *= 1664525;
            return output += 1361571430;
        }

        public final int computeHashOfLong(long aLong) {
            int lowInt = (int)aLong;
            if (aLong == (long)lowInt) {
                return this.computeHashOfInt(lowInt);
            }
            int output = 324610180;
            output = this.combineHash(output, (int)(aLong >> 32));
            output = this.combineHash(output, lowInt);
            output *= 1664525;
            return output += 1361571430;
        }

        private final int computeHashOfIntegerObject(AvailObject anIntegerObject) {
            int output = 324610180;
            for (int i = this.intCount(anIntegerObject); 0 < i; --i) {
                output = this.combineHash(output, A_Number.Companion.rawSignedIntegerAt(anIntegerObject, i));
            }
            output *= 1664525;
            return output += 1361571430;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final AvailObject createUninitializedInteger(int size) {
            void $this$iv;
            AvailObject availObject;
            AbstractDescriptor abstractDescriptor = this.mutableFor(size);
            int indexedSlotCount$iv = size + 1 >> 1;
            boolean $i$f$create = false;
            AvailObject availObject2 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, (AbstractDescriptor)$this$iv);
            boolean bl = false;
            AvailObject $this$null = availObject2;
            return availObject;
        }

        private final IntegerDescriptor mutableFor(int size) {
            Object v = descriptors.get((Object)Mutability.MUTABLE);
            Intrinsics.checkNotNull(v);
            return ((IntegerDescriptor[])v)[size & 1];
        }

        @NotNull
        public final AvailObject getZero() {
            return zero;
        }

        @NotNull
        public final AvailObject getOne() {
            return one;
        }

        @NotNull
        public final AvailObject getTwo() {
            return two;
        }

        @NotNull
        public final AvailObject getNegativeOne() {
            return negativeOne;
        }

        public final void setNegativeOne(@NotNull AvailObject availObject) {
            Intrinsics.checkNotNullParameter((Object)availObject, (String)"<set-?>");
            negativeOne = availObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final A_Number cachedSquareOfQuintillion(int n) {
            Object object;
            ReentrantReadWriteLock.ReadLock readLock = squaresOfQuintillionLock.readLock();
            readLock.lock();
            try {
                boolean bl = false;
                if (n < squaresOfQuintillion.size()) {
                    A_Number a_Number = (A_Number)squaresOfQuintillion.get(n);
                    return a_Number;
                }
                object = Unit.INSTANCE;
            }
            finally {
                readLock.unlock();
            }
            ReentrantReadWriteLock $this$safeWrite$iv = squaresOfQuintillionLock;
            boolean $i$f$safeWrite = false;
            ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
            Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
            object = writeLock;
            object.lock();
            try {
                boolean bl = false;
                int size = squaresOfQuintillion.size();
                if (size <= n) {
                    while (true) {
                        A_Number last = (A_Number)squaresOfQuintillion.get(size - 1);
                        AvailObject next = A_Number.Companion.timesCanDestroy(last, last, false).makeShared();
                        squaresOfQuintillion.add(next);
                        if (size == n) break;
                        ++size;
                    }
                }
                A_Number a_Number = (A_Number)squaresOfQuintillion.get(n);
                return a_Number;
            }
            finally {
                object.unlock();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

