/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.tuples;

import avail.annotations.HideFieldInDebugger;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.IntTupleDescriptor;
import avail.descriptor.tuples.LongTupleDescriptor;
import avail.descriptor.tuples.NumericTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TreeTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 B2\u00020\u0001:\u0002BCB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\b\u0010\u0006\u001a\u00020\u0000H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J0\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J0\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J \u0010\u001a\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010H\u0016J \u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010 \u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010!\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010#\u001a\u00020\fH\u0016J\u0018\u0010$\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\bH\u0016J\u0018\u0010%\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\bH\u0016J\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010'\u001a\u00020\bH\u0016J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010)\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010-\u001a\u00020.2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00102\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u00104\u001a\u00020\u0010H\u0016J(\u00105\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u00104\u001a\u00020\u00102\u0006\u00106\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J(\u00107\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00102\u0006\u00108\u001a\u00020+H\u0016J\u0018\u00109\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u00104\u001a\u00020\u0010H\u0016J\u0018\u0010:\u001a\u00020;2\u0006\u0010\t\u001a\u00020\n2\u0006\u00104\u001a\u00020\u0010H\u0016J\u0010\u0010<\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010=\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010>\u001a\u00020.2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010?\u001a\u00020@H\u0016J\b\u0010A\u001a\u00020\u0000H\u0016\u00a8\u0006D"}, d2={"Lavail/descriptor/tuples/LongTupleDescriptor;", "Lavail/descriptor/tuples/NumericTupleDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "(Lavail/descriptor/representation/Mutability;)V", "immutable", "mutable", "o_AppendCanDestroy", "Lavail/descriptor/tuples/A_Tuple;", "self", "Lavail/descriptor/representation/AvailObject;", "newElement", "Lavail/descriptor/representation/A_BasicObject;", "canDestroy", "", "o_BitsPerEntry", "", "o_CompareFromToWithByteTupleStartingAt", "startIndex1", "endIndex1", "aByteTuple", "startIndex2", "o_CompareFromToWithIntTupleStartingAt", "anIntTuple", "o_CompareFromToWithStartingAt", "anotherObject", "o_ComputeHashFromTo", "start", "end", "o_ConcatenateWith", "otherTuple", "o_CopyAsMutableIntTuple", "o_CopyAsMutableLongTuple", "o_CopyTupleFromToCanDestroy", "o_Equals", "another", "o_EqualsByteTuple", "o_EqualsIntTuple", "o_EqualsLongTuple", "aLongTuple", "o_IsByteTuple", "o_IsInstanceOfKind", "aType", "Lavail/descriptor/types/A_Type;", "o_IsLongTuple", "o_TransferIntoByteBuffer", "", "startIndex", "endIndex", "outputByteBuffer", "Ljava/nio/ByteBuffer;", "o_TupleAt", "index", "o_TupleAtPuttingCanDestroy", "newValueObject", "o_TupleElementsInRangeAreInstancesOf", "type", "o_TupleIntAt", "o_TupleLongAt", "", "o_TupleReverse", "o_TupleSize", "o_WriteTo", "writer", "Lorg/availlang/json/JSONWriter;", "shared", "Companion", "IntegerSlots", "avail"})
public final class LongTupleDescriptor
extends NumericTupleDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int maximumCopySize = 32;
    @NotNull
    private static final CheckedMethod createUninitializedLongTupleMethod;
    @NotNull
    private static final LongTupleDescriptor mutable;
    @NotNull
    private static final LongTupleDescriptor immutable;
    @NotNull
    private static final LongTupleDescriptor shared;

    private LongTupleDescriptor(Mutability mutability) {
        super(mutability, null, IntegerSlots.class);
    }

    @Override
    @NotNull
    public A_Tuple o_AppendCanDestroy(@NotNull AvailObject self, @NotNull A_BasicObject newElement, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        AvailObject newElementStrong = (AvailObject)newElement;
        int originalSize = A_Tuple.Companion.getTupleSize(self);
        if (!A_Number.Companion.isLong(newElementStrong)) {
            A_Tuple singleton2 = ObjectTupleDescriptor.Companion.tuple(newElement);
            return A_Tuple.Companion.concatenateWith(self, singleton2, canDestroy);
        }
        long longValue = A_Number.Companion.getExtractLong(newElementStrong);
        if (originalSize >= 32) {
            A_Tuple singleton3 = Companion.generateLongTupleFrom(1, (Function1<? super Integer, Long>)((Function1)new Function1<Integer, Long>(longValue){
                final /* synthetic */ long $longValue;
                {
                    this.$longValue = $longValue;
                    super(1);
                }

                @NotNull
                public final Long invoke(int it) {
                    return this.$longValue;
                }
            }));
            return A_Tuple.Companion.concatenateWith(self, singleton3, canDestroy);
        }
        int newSize = originalSize + 1;
        AvailObject result2 = AvailObjectRepresentation.Companion.newLike(mutable, self, 0, 1);
        result2.setSlot(IntegerSlots.LONG_AT_, newSize, longValue);
        result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
        return result2;
    }

    @Override
    public int o_BitsPerEntry(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return 64;
    }

    @Override
    public boolean o_CompareFromToWithByteTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple aByteTuple, int startIndex2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)aByteTuple, (String)"aByteTuple");
            int index2 = 0;
            index2 = startIndex2;
            Iterable $this$all$iv = (Iterable)new IntRange(startIndex1, endIndex1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    int n = index2;
                    index2 = n + 1;
                    if (self.slot(IntegerSlots.LONG_AT_, it) == A_Tuple.Companion.tupleLongAt(aByteTuple, n)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean o_CompareFromToWithIntTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anIntTuple, int startIndex2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)anIntTuple, (String)"anIntTuple");
            if (self.sameAddressAs(anIntTuple) && startIndex1 == startIndex2) {
                return true;
            }
            int index2 = 0;
            index2 = startIndex2;
            Iterable $this$all$iv = (Iterable)new IntRange(startIndex1, endIndex1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    int n = index2;
                    index2 = n + 1;
                    if (self.slot(IntegerSlots.LONG_AT_, it) == A_Tuple.Companion.tupleLongAt(anIntTuple, n)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean o_CompareFromToWithStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anotherObject, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anotherObject, (String)"anotherObject");
        return A_Tuple.Companion.compareFromToWithIntTupleStartingAt(anotherObject, startIndex2, startIndex2 + endIndex1 - startIndex1, self, startIndex1);
    }

    @Override
    public int o_ComputeHashFromTo(@NotNull AvailObject self, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int hash = 0;
        int index2 = end;
        if (start <= index2) {
            while (true) {
                int itemHash = IntegerDescriptor.Companion.computeHashOfLong(self.slot(IntegerSlots.LONG_AT_, index2)) ^ 0x71E570A6;
                hash = (hash + itemHash) * 1664525;
                if (index2 == start) break;
                --index2;
            }
        }
        return hash;
    }

    @Override
    @NotNull
    public A_Tuple o_ConcatenateWith(@NotNull AvailObject self, @NotNull A_Tuple otherTuple, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)otherTuple, (String)"otherTuple");
        int size1 = A_Tuple.Companion.getTupleSize(self);
        if (size1 == 0) {
            if (!canDestroy) {
                otherTuple.makeImmutable();
            }
            return otherTuple;
        }
        int size2 = A_Tuple.Companion.getTupleSize(otherTuple);
        if (size2 == 0) {
            if (!canDestroy) {
                self.makeImmutable();
            }
            return self;
        }
        int newSize = size1 + size2;
        if (otherTuple.isLongTuple() && newSize <= 32) {
            int deltaSlots = newSize - self.variableIntegerSlotsCount();
            AvailObject result2 = AvailObjectRepresentation.Companion.newLike(mutable, self, 0, deltaSlots);
            int destination = 0;
            destination = size1 + 1;
            Iterable $this$forEach$iv = (Iterable)new IntRange(1, size2);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                int n = destination;
                destination = n + 1;
                result2.setSlot(IntegerSlots.LONG_AT_, n, A_Tuple.Companion.tupleLongAt(otherTuple, it));
            }
            result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return result2;
        }
        if (!canDestroy) {
            self.makeImmutable();
            otherTuple.makeImmutable();
        }
        return A_Tuple.Companion.getTreeTupleLevel(otherTuple) == 0 ? (A_Tuple)TreeTupleDescriptor.Companion.createTwoPartTreeTuple(self, otherTuple, 1, 0) : TreeTupleDescriptor.Companion.concatenateAtLeastOneTree(self, otherTuple, true);
    }

    @Override
    @NotNull
    public A_Tuple o_CopyAsMutableIntTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return IntTupleDescriptor.Companion.generateIntTupleFrom(A_Tuple.Companion.getTupleSize(self), (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(self){
            final /* synthetic */ AvailObject $self;
            {
                this.$self = $self;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return (int)this.$self.slot(IntegerSlots.LONG_AT_, it);
            }
        }));
    }

    @Override
    @NotNull
    public A_Tuple o_CopyAsMutableLongTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return AvailObjectRepresentation.Companion.newLike(this.mutable(), self, 0, 0);
    }

    @Override
    @NotNull
    public A_Tuple o_CopyTupleFromToCanDestroy(@NotNull AvailObject self, int start, int end, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        boolean bl2 = bl = (1 <= start ? start <= end + 1 : false) && end <= tupleSize;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int size = end - start + 1;
        boolean bl3 = 1 <= size ? size < tupleSize : false;
        if (bl3 && size < 32) {
            Ref.IntRef source = new Ref.IntRef();
            source.element = start;
            AvailObject result2 = Companion.generateLongTupleFrom(size, (Function1<? super Integer, Long>)((Function1)new Function1<Integer, Long>(self, source){
                final /* synthetic */ AvailObject $self;
                final /* synthetic */ Ref.IntRef $source;
                {
                    this.$self = $self;
                    this.$source = $source;
                    super(1);
                }

                @NotNull
                public final Long invoke(int it) {
                    int n = this.$source.element;
                    this.$source.element = n + 1;
                    return this.$self.slot(IntegerSlots.LONG_AT_, n);
                }
            }));
            if (canDestroy) {
                self.assertObjectUnreachableIfMutable();
            }
            return result2;
        }
        return super.o_CopyTupleFromToCanDestroy(self, start, end, canDestroy);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return another.equalsLongTuple(self);
    }

    @Override
    public boolean o_EqualsByteTuple(@NotNull AvailObject self, @NotNull A_Tuple aByteTuple) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aByteTuple, (String)"aByteTuple");
        if (A_Tuple.Companion.getTupleSize(self) != A_Tuple.Companion.getTupleSize(aByteTuple)) {
            return false;
        }
        if (self.hash() != aByteTuple.hash()) {
            return false;
        }
        if (!A_Tuple.Companion.compareFromToWithByteTupleStartingAt(self, 1, A_Tuple.Companion.getTupleSize(self), aByteTuple, 1)) {
            return false;
        }
        if (!this.isShared()) {
            aByteTuple.makeImmutable();
            self.becomeIndirectionTo(aByteTuple);
        } else if (!aByteTuple.descriptor().isShared()) {
            self.makeImmutable();
            aByteTuple.becomeIndirectionTo(self);
        }
        return true;
    }

    @Override
    public boolean o_EqualsIntTuple(@NotNull AvailObject self, @NotNull A_Tuple anIntTuple) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anIntTuple, (String)"anIntTuple");
        if (A_Tuple.Companion.getTupleSize(self) != A_Tuple.Companion.getTupleSize(anIntTuple)) {
            return false;
        }
        if (self.hash() != anIntTuple.hash()) {
            return false;
        }
        if (!A_Tuple.Companion.compareFromToWithIntTupleStartingAt(self, 1, A_Tuple.Companion.getTupleSize(self), anIntTuple, 1)) {
            return false;
        }
        if (!this.isShared()) {
            anIntTuple.makeImmutable();
            self.becomeIndirectionTo(anIntTuple);
        } else if (!anIntTuple.descriptor().isShared()) {
            self.makeImmutable();
            anIntTuple.becomeIndirectionTo(self);
        }
        return true;
    }

    @Override
    public boolean o_EqualsLongTuple(@NotNull AvailObject self, @NotNull A_Tuple aLongTuple) {
        boolean bl;
        block10: {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)aLongTuple, (String)"aLongTuple");
            AvailObject strongLongTuple = (AvailObject)aLongTuple;
            if (self.sameAddressAs(aLongTuple)) {
                return true;
            }
            if (A_Tuple.Companion.getTupleSize(self) != A_Tuple.Companion.getTupleSize(aLongTuple)) {
                return false;
            }
            if (self.hash() != aLongTuple.hash()) {
                return false;
            }
            Iterable $this$any$iv = (Iterable)new IntRange(1, A_Tuple.Companion.getTupleSize(self));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    if (!(self.slot(IntegerSlots.LONG_AT_, it) != strongLongTuple.slot(IntegerSlots.LONG_AT_, it))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        if (!this.isShared()) {
            aLongTuple.makeImmutable();
            self.becomeIndirectionTo(aLongTuple);
        } else if (!aLongTuple.descriptor().isShared()) {
            self.makeImmutable();
            aLongTuple.becomeIndirectionTo(self);
        }
        return true;
    }

    @Override
    public boolean o_IsByteTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        if (tupleSize <= 10) {
            int i = 1;
            if (i <= tupleSize) {
                while (true) {
                    long element;
                    if ((element = self.slot(IntegerSlots.LONG_AT_, i)) != (element & 0xFFL)) {
                        return false;
                    }
                    if (i == tupleSize) break;
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean o_IsInstanceOfKind(@NotNull AvailObject self, @NotNull A_Type aType) {
        boolean bl;
        block15: {
            boolean bl2;
            int breakIndex;
            block14: {
                Intrinsics.checkNotNullParameter((Object)self, (String)"self");
                Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
                if (A_Type.Companion.isSupertypeOfPrimitiveTypeEnum(aType, PrimitiveTypeDescriptor.Types.NONTYPE)) {
                    return true;
                }
                if (!aType.isTupleType()) {
                    return false;
                }
                if (!A_Type.Companion.rangeIncludesLong(A_Type.Companion.getSizeRange(aType), A_Tuple.Companion.getTupleSize(self))) {
                    return false;
                }
                A_Tuple typeTuple2 = A_Type.Companion.getTypeTuple(aType);
                int i = 1;
                breakIndex = Math.min(A_Tuple.Companion.getTupleSize(self), A_Tuple.Companion.getTupleSize(typeTuple2));
                if (i <= breakIndex) {
                    while (true) {
                        if (!A_Type.Companion.rangeIncludesLong(A_Tuple.Companion.tupleAt(typeTuple2, i), self.slot(IntegerSlots.LONG_AT_, i))) {
                            return false;
                        }
                        if (i == breakIndex) break;
                        ++i;
                    }
                }
                Iterable $this$all$iv = (Iterable)new IntRange(1, breakIndex);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl3 = false;
                        if (A_Tuple.Companion.tupleAt(self, it).isInstanceOf(A_Tuple.Companion.tupleAt(typeTuple2, it))) continue;
                        bl2 = false;
                        break block14;
                    }
                    bl2 = true;
                }
            }
            if (!bl2) {
                return false;
            }
            A_Type defaultTypeObject = A_Type.Companion.getDefaultType(aType);
            if (A_Type.Companion.isSubtypeOf(IntegerRangeTypeDescriptor.Companion.getInt64(), defaultTypeObject)) {
                return true;
            }
            Iterable $this$all$iv = (Iterable)new IntRange(breakIndex + 1, A_Tuple.Companion.getTupleSize(self));
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator3 = $this$all$iv.iterator();
                while (iterator3.hasNext()) {
                    int element$iv;
                    int it = element$iv = ((IntIterator)iterator3).nextInt();
                    boolean bl4 = false;
                    if (A_Tuple.Companion.tupleAt(self, it).isInstanceOf(defaultTypeObject)) continue;
                    bl = false;
                    break block15;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean o_IsLongTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return true;
    }

    @Override
    public void o_TransferIntoByteBuffer(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull ByteBuffer outputByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)outputByteBuffer, (String)"outputByteBuffer");
        int index2 = startIndex;
        if (index2 <= endIndex) {
            while (true) {
                long mustBeByte;
                boolean bl;
                boolean bl2 = bl = (mustBeByte = self.slot(IntegerSlots.LONG_AT_, index2)) == (mustBeByte & 0xFFL);
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                outputByteBuffer.put((byte)mustBeByte);
                if (index2 == endIndex) break;
                ++index2;
            }
        }
    }

    @Override
    @NotNull
    public AvailObject o_TupleAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return IntegerDescriptor.Companion.fromLong(self.slot(IntegerSlots.LONG_AT_, index2));
    }

    @Override
    @NotNull
    public A_Tuple o_TupleAtPuttingCanDestroy(@NotNull AvailObject self, int index2, @NotNull A_BasicObject newValueObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)newValueObject, (String)"newValueObject");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject newValueStrong = (AvailObject)newValueObject;
        if (!A_Number.Companion.isLong(newValueStrong)) {
            return A_Tuple.Companion.tupleAtPuttingCanDestroy(A_Tuple.Companion.copyAsMutableObjectTuple(self), index2, newValueObject, true);
        }
        AvailObject result2 = canDestroy && this.isMutable() ? self : AvailObjectRepresentation.Companion.newLike(this.mutable(), self, 0, 0);
        result2.setSlot(IntegerSlots.LONG_AT_, index2, A_Number.Companion.getExtractLong(newValueStrong));
        result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
        return result2;
    }

    @Override
    public boolean o_TupleElementsInRangeAreInstancesOf(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull A_Type type) {
        boolean bl;
        block19: {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            if (A_Type.Companion.isSubtypeOf(IntegerRangeTypeDescriptor.Companion.getInt64(), type)) {
                bl = true;
            } else if (startIndex > endIndex) {
                bl = true;
            } else if (type.isEnumeration()) {
                bl = super.o_TupleElementsInRangeAreInstancesOf(self, startIndex, endIndex, type);
            } else if (!type.isIntegerRangeType()) {
                bl = false;
            } else {
                long l;
                long l2;
                A_Number lowerObject = A_Type.Companion.getLowerBound(type);
                if (A_Number.Companion.isLong(lowerObject)) {
                    l2 = A_Number.Companion.getExtractLong(lowerObject);
                } else if (A_Number.Companion.lessThan(lowerObject, IntegerDescriptor.Companion.getZero())) {
                    l2 = Long.MIN_VALUE;
                } else {
                    return false;
                }
                long lower = l2;
                A_Number upperObject = A_Type.Companion.getUpperBound(type);
                if (A_Number.Companion.isLong(upperObject)) {
                    l = A_Number.Companion.getExtractLong(upperObject);
                } else if (A_Number.Companion.greaterThan(upperObject, IntegerDescriptor.Companion.getZero())) {
                    l = Long.MAX_VALUE;
                } else {
                    return false;
                }
                long upper = l;
                Iterable $this$all$iv = (Iterable)new IntRange(startIndex, endIndex);
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int it = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl2 = false;
                        long l3 = self.slot(IntegerSlots.LONG_AT_, it);
                        if (lower <= l3 ? l3 <= upper : false) continue;
                        bl = false;
                        break block19;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public int o_TupleIntAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        long longValue = self.slot(IntegerSlots.LONG_AT_, index2);
        int intValue = (int)longValue;
        boolean bl2 = bl = (long)intValue == longValue;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return intValue;
    }

    @Override
    public long o_TupleLongAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.slot(IntegerSlots.LONG_AT_, index2);
    }

    @Override
    @NotNull
    public A_Tuple o_TupleReverse(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        if (tupleSize <= 1) {
            return self;
        }
        if (tupleSize < 32) {
            Ref.IntRef i = new Ref.IntRef();
            i.element = tupleSize;
            return Companion.generateLongTupleFrom(tupleSize, (Function1<? super Integer, Long>)((Function1)new Function1<Integer, Long>(self, i){
                final /* synthetic */ AvailObject $self;
                final /* synthetic */ Ref.IntRef $i;
                {
                    this.$self = $self;
                    this.$i = $i;
                    super(1);
                }

                @NotNull
                public final Long invoke(int it) {
                    int n = this.$i.element;
                    this.$i.element = n + -1;
                    return this.$self.slot(IntegerSlots.LONG_AT_, n);
                }
            }));
        }
        return super.o_TupleReverse(self);
    }

    @Override
    public int o_TupleSize(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return self.variableIntegerSlotsCount();
    }

    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.startArray();
        Iterable $this$forEach$iv = self;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JSONFriendly p0 = (JSONFriendly)element$iv;
            boolean bl = false;
            writer.write(p0);
        }
        writer.endArray();
    }

    @Override
    @NotNull
    public LongTupleDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public LongTupleDescriptor immutable() {
        return immutable;
    }

    @Override
    @NotNull
    public LongTupleDescriptor shared() {
        return shared;
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject mutableObjectOfSize(int size) {
        return Companion.mutableObjectOfSize(size);
    }

    static {
        Class[] classArray = new Class[1];
        Intrinsics.checkNotNull(Integer.TYPE);
        createUninitializedLongTupleMethod = CheckedMethod.Companion.staticMethod(LongTupleDescriptor.class, "mutableObjectOfSize", AvailObject.class, classArray);
        mutable = new LongTupleDescriptor(Mutability.MUTABLE);
        immutable = new LongTupleDescriptor(Mutability.IMMUTABLE);
        shared = new LongTupleDescriptor(Mutability.SHARED);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/LongTupleDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "LONG_AT_", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        public static final /* enum */ IntegerSlots LONG_AT_;
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            boolean bl;
            HASH_AND_MORE = new IntegerSlots();
            LONG_AT_ = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE, IntegerSlots.LONG_AT_};
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, (Function1<? super Integer, String>)((Function1)Companion.HASH_OR_ZERO.1.INSTANCE));
            boolean bl2 = bl = TupleDescriptor.IntegerSlots.HASH_AND_MORE.ordinal() == HASH_AND_MORE.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl = TupleDescriptor.IntegerSlots.Companion.getHASH_OR_ZERO().isSamePlaceAs(HASH_OR_ZERO);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/LongTupleDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\n2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\u0011J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lavail/descriptor/tuples/LongTupleDescriptor$Companion;", "", "()V", "createUninitializedLongTupleMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getCreateUninitializedLongTupleMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "immutable", "Lavail/descriptor/tuples/LongTupleDescriptor;", "maximumCopySize", "", "mutable", "shared", "generateLongTupleFrom", "Lavail/descriptor/representation/AvailObject;", "size", "generator", "Lkotlin/Function1;", "", "mutableObjectOfSize", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject mutableObjectOfSize(int size) {
            AvailObject availObject;
            AbstractDescriptor $this$iv = mutable;
            boolean $i$f$create = false;
            AvailObject availObject2 = availObject = AvailObject.Companion.newIndexedDescriptor(size, $this$iv);
            boolean bl = false;
            AvailObject $this$null = availObject2;
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateUninitializedLongTupleMethod() {
            return createUninitializedLongTupleMethod;
        }

        @NotNull
        public final AvailObject generateLongTupleFrom(int size, @NotNull Function1<? super Integer, Long> generator) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter(generator, (String)"generator");
            AbstractDescriptor this_$iv = mutable;
            boolean $i$f$create = false;
            AvailObject $this$generateLongTupleFrom_u24lambda_u2d0 = availObject = AvailObject.Companion.newIndexedDescriptor(size, this_$iv);
            boolean bl = false;
            int i = 1;
            if (i <= size) {
                while (true) {
                    $this$generateLongTupleFrom_u24lambda_u2d0.setSlot(IntegerSlots.LONG_AT_, i, ((Number)generator.invoke((Object)i)).longValue());
                    if (i == size) break;
                    ++i;
                }
            }
            return availObject;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

