/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.AvailRuntime;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FiberTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.SetTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\rH\u0014\u00a8\u0006\u000f"}, d2={"Lavail/interpreter/primitive/files/P_CreateDirectory;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "permissionsFor", "", "Ljava/nio/file/attribute/PosixFilePermission;", "ordinals", "Lavail/descriptor/sets/A_Set;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_CreateDirectory
extends Primitive {
    @NotNull
    public static final P_CreateDirectory INSTANCE = new P_CreateDirectory();

    private P_CreateDirectory() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(5, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(5);
        AvailObject directoryName = interpreter.argument(0);
        AvailObject ordinals = interpreter.argument(1);
        AvailObject succeed2 = interpreter.argument(2);
        AvailObject fail2 = interpreter.argument(3);
        AvailObject priority = interpreter.argument(4);
        AvailRuntime runtime = interpreter.runtime;
        FileSystem fileSystem = IOSystem.Companion.getFileSystem();
        try {
            Path path2 = fileSystem.getPath(directoryName.asNativeString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"{\n\t\t\t\tfileSystem.getPath\u2026me.asNativeString())\n\t\t\t}");
            path = path2;
        }
        catch (InvalidPathException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INVALID_PATH);
        }
        Path path3 = path;
        int priorityInt = A_Number.Companion.getExtractInt(priority);
        A_Fiber current = interpreter.fiber();
        A_Fiber newFiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, A_Type.Companion.typeUnion(A_Type.Companion.getReturnType(succeed2.kind()), A_Type.Companion.getReturnType(fail2.kind())), interpreter.runtime, A_Fiber.Companion.getTextInterface(current), priorityInt, null, (Function0)new Function0<A_String>(path3){
            final /* synthetic */ Path $path;
            {
                this.$path = $path;
                super(0);
            }

            @NotNull
            public final A_String invoke() {
                Object[] objectArray = new Object[]{this.$path};
                return StringDescriptor.Companion.formatString("Asynchronous create directory, %s", objectArray);
            }
        }, 16, null);
        A_Fiber.Companion.setAvailLoader(newFiber2, A_Fiber.Companion.getAvailLoader(current));
        A_Fiber.Companion.setHeritableFiberGlobals(newFiber2, A_Fiber.Companion.getHeritableFiberGlobals(current).makeShared());
        newFiber2.makeShared();
        succeed2.makeShared();
        fail2.makeShared();
        Set<PosixFilePermission> permissions = this.permissionsFor(ordinals);
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(permissions);
        runtime.getIoSystem().executeFileTask(() -> P_CreateDirectory.attempt$lambda-0(path3, attr, runtime, newFiber2, fail2, succeed2));
        return interpreter.primitiveSuccess(newFiber2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_FILE_EXISTS, AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_IO_ERROR};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getStringType(), SetTypeDescriptor.Companion.setTypeForSizesContentType(IntegerRangeTypeDescriptor.Companion.inclusive(0L, 9L), IntegerRangeTypeDescriptor.Companion.inclusive(1L, 9L)), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, TupleDescriptor.Companion.getEmptyTuple(), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray))), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null), IntegerRangeTypeDescriptor.Companion.getBytes()), FiberTypeDescriptor.Companion.fiberType(PrimitiveTypeDescriptor.Types.TOP.getO()), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_PATH};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    private final Set<PosixFilePermission> permissionsFor(A_Set ordinals) {
        PosixFilePermission[] allPermissions = IOSystem.Companion.getPosixPermissions();
        EnumSet<PosixFilePermission> permissions = EnumSet.noneOf(PosixFilePermission.class);
        for (AvailObject ordinal : ordinals) {
            permissions.add(allPermissions[A_Number.Companion.getExtractInt(ordinal) - 1]);
        }
        Intrinsics.checkNotNullExpressionValue(permissions, (String)"permissions");
        return permissions;
    }

    private static final void attempt$lambda-0(Path $path, FileAttribute $attr, AvailRuntime $runtime, A_Fiber $newFiber, AvailObject $fail, AvailObject $succeed) {
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)$runtime, (String)"$runtime");
        Intrinsics.checkNotNullParameter((Object)$newFiber, (String)"$newFiber");
        Intrinsics.checkNotNullParameter((Object)$fail, (String)"$fail");
        Intrinsics.checkNotNullParameter((Object)$succeed, (String)"$succeed");
        try {
            try {
                FileAttribute[] fileAttributeArray = new FileAttribute[]{$attr};
                Files.createDirectory($path, fileAttributeArray);
            }
            catch (UnsupportedOperationException e) {
                Files.createDirectory($path, new FileAttribute[0]);
            }
        }
        catch (FileAlreadyExistsException e) {
            $runtime.runOutermostFunction($newFiber, $fail, CollectionsKt.listOf((Object)AvailErrorCode.E_FILE_EXISTS.numericCode()));
            return;
        }
        catch (SecurityException e) {
            $runtime.runOutermostFunction($newFiber, $fail, CollectionsKt.listOf((Object)AvailErrorCode.E_PERMISSION_DENIED.numericCode()));
            return;
        }
        catch (AccessDeniedException e) {
            $runtime.runOutermostFunction($newFiber, $fail, CollectionsKt.listOf((Object)AvailErrorCode.E_PERMISSION_DENIED.numericCode()));
            return;
        }
        catch (IOException e) {
            $runtime.runOutermostFunction($newFiber, $fail, CollectionsKt.listOf((Object)AvailErrorCode.E_IO_ERROR.numericCode()));
            return;
        }
        $runtime.runOutermostFunction($newFiber, $succeed, CollectionsKt.emptyList());
    }
}

