/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.integers;

import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_BIT_LOGIC_OP;
import avail.interpreter.levelTwo.operation.L2_JUMP_IF_COMPARE_INT;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2Generator;
import avail.optimizer.values.L2SemanticUnboxedInt;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/integers/P_BitTest;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_BitTest
extends Primitive {
    @NotNull
    public static final P_BitTest INSTANCE = new P_BitTest();

    private P_BitTest() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject a = interpreter.argument(0);
        AvailObject b = interpreter.argument(1);
        int bInt = A_Number.Companion.isInt(b) ? A_Number.Companion.getExtractInt(b) : Integer.MAX_VALUE;
        return interpreter.primitiveSuccess(AtomDescriptor.Companion.objectFromBoolean(A_Number.Companion.bitTest(a, bInt)));
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        A_Number shiftedHigh;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        boolean bl2 = bl = argumentTypes.size() == 2;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Type aRange = argumentTypes.get(0);
        A_Type bRange = argumentTypes.get(1);
        if (!A_Type.Companion.getLowerInclusive(aRange) || !A_Type.Companion.getUpperInclusive(aRange)) {
            return EnumerationTypeDescriptor.Companion.getBooleanType();
        }
        A_Number bLowValue = A_Type.Companion.getLowerBound(bRange);
        A_Number bLowValueNeg = A_Number.Companion.minusCanDestroy(IntegerDescriptor.Companion.getZero(), bLowValue, false);
        A_Number shiftedLow = A_Number.Companion.bitShift(A_Type.Companion.getLowerBound(aRange), bLowValueNeg, false);
        if (shiftedLow.equals(shiftedHigh = A_Number.Companion.bitShift(A_Type.Companion.getUpperBound(aRange), bLowValueNeg, false))) {
            boolean firstBit = A_Number.Companion.bitTest(shiftedLow, 0);
            if (!bLowValue.equals(A_Type.Companion.getUpperBound(bRange))) {
                int limit = IntegerDescriptor.Companion.intCount(shiftedLow.traversed()) << 5;
                int i = 1;
                A_Number maxShiftedBit = A_Number.Companion.minusCanDestroy(A_Type.Companion.getUpperBound(bRange), bLowValue, false);
                int maxShiftedBitInt = A_Number.Companion.isInt(maxShiftedBit) ? A_Number.Companion.getExtractInt(maxShiftedBit) : limit;
                int n = Math.min(maxShiftedBitInt, limit);
                if (i <= n) {
                    while (true) {
                        if (A_Number.Companion.bitTest(shiftedLow, i) != firstBit) {
                            return EnumerationTypeDescriptor.Companion.getBooleanType();
                        }
                        if (i == n) break;
                        ++i;
                    }
                }
            }
            return firstBit ? EnumerationTypeDescriptor.Companion.getTrueType() : EnumerationTypeDescriptor.Companion.getFalseType();
        }
        return EnumerationTypeDescriptor.Companion.getBooleanType();
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        L2Operand[] l2OperandArray;
        L2ReadIntOperand l2ReadIntOperand;
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand a = arguments.get(0);
        L2ReadBoxedOperand b = arguments.get(1);
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        if (A_Type.Companion.typeIntersection(aType, IntegerRangeTypeDescriptor.Companion.getInt32()).isBottom() || A_Type.Companion.typeIntersection(bType, IntegerRangeTypeDescriptor.Companion.inclusive(IntegerDescriptor.Companion.getZero(), IntegerDescriptor.Companion.fromInt(31))).isBottom()) {
            return false;
        }
        L2Generator generator = callSiteHelper.generator();
        L2BasicBlock fallback = new L2BasicBlock("fallback for bit test", false, null, 6, null);
        L2ReadIntOperand aInt = generator.readInt(new L2SemanticUnboxedInt(a.semanticValue()), fallback);
        L2ReadIntOperand bInt = generator.readInt(new L2SemanticUnboxedInt(b.semanticValue()), fallback);
        L2BasicBlock inRange = new L2BasicBlock("bit position is in 0..31", false, null, 6, null);
        L2_JUMP_IF_COMPARE_INT.Companion.getLessOrEqual().compareAndBranch(generator, bInt, generator.unboxedIntConstant(31), L2Generator.Companion.edgeTo(inRange), L2Generator.Companion.edgeTo(fallback));
        L2Generator.startBlock$default(generator, inRange, false, null, 6, null);
        if (A_Type.Companion.getUpperBound(bType).equals(IntegerDescriptor.Companion.getZero())) {
            l2ReadIntOperand = aInt;
        } else {
            L2WriteIntOperand shiftedWrite = generator.intWriteTemp(TypeRestriction.Companion.restrictionForType(IntegerRangeTypeDescriptor.Companion.getInt32(), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG));
            l2OperandArray = new L2Operand[]{aInt, bInt, shiftedWrite};
            generator.addInstruction(L2_BIT_LOGIC_OP.Companion.getBitwiseSignedShiftRight(), l2OperandArray);
            l2ReadIntOperand = new L2ReadIntOperand(shiftedWrite.pickSemanticValue(), shiftedWrite.restriction(), generator.getCurrentManifest());
        }
        L2ReadIntOperand shifted = l2ReadIntOperand;
        L2WriteIntOperand maskedWrite = generator.intWriteTemp(TypeRestriction.Companion.restrictionForType(IntegerRangeTypeDescriptor.Companion.getZeroOrOne(), TypeRestriction.RestrictionFlagEncoding.UNBOXED_INT_FLAG));
        l2OperandArray = new L2Operand[]{shifted, generator.unboxedIntConstant(1), maskedWrite};
        generator.addInstruction(L2_BIT_LOGIC_OP.Companion.getBitwiseAnd(), l2OperandArray);
        L2BasicBlock isZeroLabel = generator.createBasicBlock("bit is zero");
        L2BasicBlock isOneLabel = generator.createBasicBlock("bit is one");
        L2_JUMP_IF_COMPARE_INT.Companion.getEqual().compareAndBranch(generator, new L2ReadIntOperand(maskedWrite.pickSemanticValue(), maskedWrite.restriction(), generator.getCurrentManifest()), generator.unboxedIntConstant(0), L2Generator.Companion.edgeTo(isZeroLabel), L2Generator.Companion.edgeTo(isOneLabel));
        L2Generator.startBlock$default(generator, isZeroLabel, false, null, 6, null);
        callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(AtomDescriptor.Companion.getFalseObject()));
        L2Generator.startBlock$default(generator, isOneLabel, false, null, 6, null);
        callSiteHelper.useAnswer(translator.getGenerator().boxedConstant(AtomDescriptor.Companion.getTrueObject()));
        L2Generator.startBlock$default(generator, fallback, false, null, 6, null);
        return !generator.currentlyReachable();
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(IntegerRangeTypeDescriptor.Companion.getIntegers(), IntegerRangeTypeDescriptor.Companion.getWholeNumbers()), EnumerationTypeDescriptor.Companion.getBooleanType(), null, 4, null);
    }
}

