/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.objects;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.objects.ObjectDescriptor;
import avail.descriptor.objects.ObjectLayoutVariant;
import avail.descriptor.objects.ObjectTypeDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ArbitraryConstantOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_CREATE_OBJECT;
import avail.optimizer.L1Translator;
import avail.optimizer.L2Generator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/objects/P_TupleToObject;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_TupleToObject
extends Primitive {
    @NotNull
    public static final P_TupleToObject INSTANCE = new P_TupleToObject();

    private P_TupleToObject() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject tuple2 = interpreter.argument(0);
        return interpreter.primitiveSuccess(ObjectDescriptor.Companion.objectFromTuple(tuple2));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_Type[] a_TypeArray = new A_Type[]{PrimitiveTypeDescriptor.Types.ATOM.getO(), PrimitiveTypeDescriptor.Types.ANY.getO()};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.zeroOrMoreOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray))), ObjectTypeDescriptor.Companion.getMostGeneralObjectType(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type tupleType = argumentTypes.get(0);
        A_Type tupleSizes = A_Type.Companion.getSizeRange(tupleType);
        A_Number tupleSizeLowerBound = A_Type.Companion.getLowerBound(tupleSizes);
        if (!tupleSizeLowerBound.equals(A_Type.Companion.getUpperBound(tupleSizes)) || !A_Number.Companion.isInt(tupleSizeLowerBound)) {
            return super.returnTypeGuaranteedByVM(rawFunction, argumentTypes);
        }
        int tupleSize = A_Number.Companion.getExtractInt(tupleSizeLowerBound);
        A_Map fieldTypeMap = MapDescriptor.Companion.getEmptyMap();
        int i = 1;
        if (i <= tupleSize) {
            while (true) {
                String string2;
                A_Type pairType;
                boolean bl;
                boolean bl2 = bl = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(pairType = A_Type.Companion.typeAtIndex(tupleType, i)))) == 2;
                if (_Assertions.ENABLED && !bl) {
                    string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                boolean bl3 = bl = A_Number.Companion.getExtractInt(A_Type.Companion.getUpperBound(A_Type.Companion.getSizeRange(pairType))) == 2;
                if (_Assertions.ENABLED && !bl) {
                    string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Type keyType = A_Type.Companion.typeAtIndex(pairType, 1);
                if (!keyType.isEnumeration() || !A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(keyType), 1)) {
                    return super.returnTypeGuaranteedByVM(rawFunction, argumentTypes);
                }
                AvailObject keyValue = A_Type.Companion.getInstance(keyType);
                if (A_Map.Companion.hasKey(fieldTypeMap, keyValue)) {
                    return super.returnTypeGuaranteedByVM(rawFunction, argumentTypes);
                }
                boolean bl4 = keyValue.isAtom();
                if (_Assertions.ENABLED && !bl4) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                A_Type valueType = A_Type.Companion.typeAtIndex(pairType, 2);
                fieldTypeMap = A_Map.Companion.mapAtPuttingCanDestroy(fieldTypeMap, keyValue, valueType, true);
                if (i == tupleSize) break;
                ++i;
            }
        }
        return ObjectTypeDescriptor.Companion.objectTypeFromMap(fieldTypeMap);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Collection<void> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element$iv2;
        Object object;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        L2ReadBoxedOperand pairsReg = arguments.get(0);
        A_Type pairsType = argumentTypes.get(0);
        A_Type sizeRange = A_Type.Companion.getSizeRange(pairsType);
        L2Generator generator = translator.getGenerator();
        if (!A_Number.Companion.isInt(A_Type.Companion.getLowerBound(sizeRange))) {
            return false;
        }
        int size = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(sizeRange));
        if (!A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound(sizeRange), size)) {
            return false;
        }
        Iterable $this$map$iv2 = (Iterable)new IntRange(1, size);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            object = destination$iv$iv;
            boolean bl = false;
            A_Type keyType = A_Type.Companion.typeAtIndex(A_Type.Companion.typeAtIndex(pairsType, (int)it), 1);
            if (!keyType.isEnumeration() || !A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(keyType), 1)) {
                return false;
            }
            object.add(A_Type.Companion.getInstance(keyType));
        }
        List atoms = (List)destination$iv$iv;
        A_Set atomsSet = SetDescriptor.Companion.setFromCollection(atoms);
        if (A_Set.Companion.getSetSize(atomsSet) != size) {
            return false;
        }
        ObjectLayoutVariant variant = ObjectLayoutVariant.Companion.variantForFields(atomsSet);
        Map<A_Atom, Integer> fieldMap = variant.getFieldToSlotIndex();
        L2ReadBoxedOperand[] sourcesByFieldIndex = new L2ReadBoxedOperand[variant.getRealSlotCount()];
        List<L2ReadBoxedOperand> pairSources = generator.explodeTupleIfPossible(pairsReg, CollectionsKt.toList((Iterable)A_Type.Companion.tupleOfTypesFromTo(pairsType, 1, size)));
        if (pairSources == null) {
            return false;
        }
        List fieldTypePairs = new ArrayList();
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)atoms, (Iterable)pairSources);
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            L2ReadBoxedOperand fieldRead;
            Pair pair = (Pair)element$iv2;
            boolean bl = false;
            AvailObject atom = (AvailObject)pair.component1();
            L2ReadBoxedOperand pairSource = (L2ReadBoxedOperand)pair.component2();
            Integer n = fieldMap.get(atom);
            if (n == null) continue;
            int index2 = ((Number)n).intValue();
            boolean bl2 = false;
            if (index2 == 0) continue;
            sourcesByFieldIndex[index2 - 1] = fieldRead = generator.extractTupleElement(pairSource, 2);
            fieldTypePairs.add(ObjectTupleDescriptor.Companion.tuple(atom, fieldRead.type()));
        }
        AvailObject typeGuarantee = ObjectTypeDescriptor.Companion.objectTypeFromTuple(ObjectTupleDescriptor.Companion.tupleFromList(fieldTypePairs));
        L2WriteBoxedOperand write2 = generator.boxedWriteTemp(TypeRestriction.Companion.restrictionForType(typeGuarantee, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG).intersectionWithObjectVariant(variant));
        L2Operand[] l2OperandArray = new L2Operand[3];
        l2OperandArray[0] = new L2ArbitraryConstantOperand(variant);
        element$iv2 = sourcesByFieldIndex;
        int n = 1;
        L2Operand[] l2OperandArray2 = l2OperandArray;
        L2Operation l2Operation = L2_CREATE_OBJECT.INSTANCE;
        object = generator;
        boolean $i$f$map2 = false;
        void bl = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo2 = false;
        int n2 = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n2; ++i) {
            void it;
            void item$iv$iv;
            void var30_42 = item$iv$iv = $this$mapTo$iv$iv[i];
            collection = destination$iv$iv2;
            boolean bl3 = false;
            void v1 = it;
            Intrinsics.checkNotNull((Object)v1);
            collection.add(v1);
        }
        Collection<void> collection2 = collection = (List)destination$iv$iv2;
        l2OperandArray2[n] = new L2ReadBoxedVectorOperand((List<L2ReadBoxedOperand>)collection2);
        l2OperandArray[2] = write2;
        ((L2Generator)object).addInstruction(l2Operation, l2OperandArray);
        callSiteHelper.useAnswer(generator.readBoxed(write2));
        return true;
    }
}

