/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil;

import avail.anvil.AvailWorkbench;
import avail.io.NybbleInputStream;
import avail.io.NybbleOutputStream;
import java.awt.Color;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.environment.project.Palette;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\u0012\u0010\u0007\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\b\u001a\n\u0010\r\u001a\u00020\b*\u00020\t\u001a\u0012\u0010\u000e\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\b\"!\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"colors", "", "", "Ljava/awt/Color;", "Lorg/availlang/artifact/environment/project/Palette;", "getColors", "(Lorg/availlang/artifact/environment/project/Palette;)Ljava/util/Map;", "opcode", "", "Lavail/io/NybbleInputStream;", "", "Lavail/io/NybbleOutputStream;", "value", "unvlq", "vlq", "avail"})
public final class StylesKt {
    @NotNull
    public static final Map<String, Color> getColors(@NotNull Palette $this$colors) {
        Intrinsics.checkNotNullParameter($this$colors, "<this>");
        return AvailWorkbench.Companion.getDarkMode() ? $this$colors.getDarkColors() : $this$colors.getLightColors();
    }

    public static final void opcode(@NotNull NybbleOutputStream $this$opcode, int value) {
        int residue;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$opcode, "<this>");
        boolean bl2 = bl = value >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        for (residue = value; residue >= 15; residue -= 15) {
            $this$opcode.write(15);
        }
        $this$opcode.write(residue);
    }

    public static final int opcode(@NotNull NybbleInputStream $this$opcode) {
        int nybble;
        Intrinsics.checkNotNullParameter($this$opcode, "<this>");
        int value = 0;
        while ((nybble = $this$opcode.read()) == 15) {
            value += 15;
        }
        return value += nybble;
    }

    public static final void vlq(@NotNull NybbleOutputStream $this$vlq, int value) {
        int residue;
        boolean bl;
        Intrinsics.checkNotNullParameter($this$vlq, "<this>");
        boolean bl2 = bl = value >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        for (residue = value; residue >= 8; residue >>>= 3) {
            int nybble = residue & 7 | 8;
            $this$vlq.write(nybble);
        }
        $this$vlq.write(residue);
    }

    public static final int unvlq(@NotNull NybbleInputStream $this$unvlq) {
        int nybble;
        Intrinsics.checkNotNullParameter($this$unvlq, "<this>");
        int n = 0;
        int k = 0;
        while (true) {
            nybble = $this$unvlq.read();
            if ((nybble & 8) != 8) break;
            n |= (nybble & 7) << k;
            k += 3;
        }
        return n | nybble << k;
    }
}

