/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.manager;

import avail.anvil.components.DirectoryChooser;
import avail.anvil.components.TextFieldWithLabel;
import avail.anvil.components.TextFieldWithLabelAndButton;
import avail.anvil.environment.GlobalEnvironmentSettings;
import avail.anvil.environment.UtilitiesKt;
import avail.anvil.icons.ProjectManagerIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.availlang.artifact.environment.AvailEnvironment;
import org.availlang.artifact.environment.location.AvailLibraries;
import org.availlang.artifact.environment.location.AvailRepositories;
import org.availlang.artifact.environment.location.ProjectHome;
import org.availlang.artifact.environment.location.Scheme;
import org.availlang.artifact.environment.project.AvailProject;
import org.availlang.artifact.environment.project.AvailProjectRoot;
import org.availlang.artifact.environment.project.AvailProjectV1;
import org.availlang.artifact.environment.project.LocalSettings;
import org.availlang.artifact.environment.project.StylingGroup;
import org.availlang.artifact.environment.project.TemplateGroup;
import org.availlang.artifact.jar.AvailArtifactJar;
import org.availlang.artifact.manifest.AvailRootManifest;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010'\u001a\u00020\bR\u000e\u0010\f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00070\u00070\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010!\u001a\u0016\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00070\u0007\u0012\u0004\u0012\u00020 0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00070$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006("}, d2={"Lavail/anvil/manager/CreateProjectPanel;", "Ljavax/swing/JPanel;", "config", "Lavail/anvil/environment/GlobalEnvironmentSettings;", "onCreate", "Lkotlin/Function2;", "Lorg/availlang/artifact/environment/project/AvailProject;", "", "", "onCancel", "Lkotlin/Function0;", "(Lavail/anvil/environment/GlobalEnvironmentSettings;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function0;)V", "bottomPanel", "cancel", "Ljavax/swing/JButton;", "getCancel", "()Ljavax/swing/JButton;", "getConfig$avail", "()Lavail/anvil/environment/GlobalEnvironmentSettings;", "createButton", "libraryNameField", "Lavail/anvil/components/TextFieldWithLabel;", "libraryPicker", "Ljavax/swing/JComboBox;", "kotlin.jvm.PlatformType", "projectFileName", "Lavail/anvil/components/TextFieldWithLabelAndButton;", "projectLocation", "Lavail/anvil/components/DirectoryChooser;", "projectNameField", "rootNameField", "selectedLibrary", "Ljava/io/File;", "standardLibraries", "", "standardLibraryNames", "", "getStandardLibraryNames", "()[Ljava/lang/String;", "create", "avail"})
public final class CreateProjectPanel
extends JPanel {
    @NotNull
    private final GlobalEnvironmentSettings config;
    @NotNull
    private final Function2<AvailProject, String, Unit> onCreate;
    @NotNull
    private final Function0<Unit> onCancel;
    @NotNull
    private final Map<String, File> standardLibraries;
    @Nullable
    private File selectedLibrary;
    @NotNull
    private final TextFieldWithLabel projectNameField;
    @NotNull
    private final TextFieldWithLabelAndButton projectFileName;
    @NotNull
    private final DirectoryChooser projectLocation;
    @NotNull
    private final TextFieldWithLabel rootNameField;
    @NotNull
    private final TextFieldWithLabel libraryNameField;
    @NotNull
    private final JComboBox<String> libraryPicker;
    @NotNull
    private final JButton createButton;
    @NotNull
    private final JButton cancel;
    @NotNull
    private final JPanel bottomPanel;

    /*
     * WARNING - void declaration
     */
    public CreateProjectPanel(@NotNull GlobalEnvironmentSettings config, @NotNull Function2<? super AvailProject, ? super String, Unit> onCreate, @NotNull Function0<Unit> onCancel) {
        Object $this$bottomPanel_u24lambda_u2416;
        Object $this$cancel_u24lambda_u2415;
        Object $this$createButton_u24lambda_u2413;
        Object $this$libraryPicker_u24lambda_u2411;
        Object $this$projectFileName_u24lambda_u247;
        Object object;
        JButton $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(onCreate, "onCreate");
        Intrinsics.checkNotNullParameter(onCancel, "onCancel");
        super(new GridBagLayout());
        this.config = config;
        this.onCreate = onCreate;
        this.onCancel = onCancel;
        Object object2 = UtilitiesKt.getAvailStandardLibraries();
        CreateProjectPanel createProjectPanel = this;
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(((void)$this$associateBy$iv).length), 16);
        void var7_9 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        int n = ((void)$this$associateByTo$iv$iv).length;
        for (int j = 0; j < n; ++j) {
            void it;
            void element$iv$iv;
            void var13_17 = element$iv$iv = $this$associateByTo$iv$iv[j];
            object = destination$iv$iv;
            boolean bl = false;
            object.put(it.getName(), element$iv$iv);
        }
        createProjectPanel.standardLibraries = destination$iv$iv;
        this.projectNameField = new TextFieldWithLabel("Project Name: ", null, null, null, 14, null);
        Object $i$f$associateBy22 = object2 = new TextFieldWithLabelAndButton("Project Config File Name: ", null, null, null, 14, null);
        createProjectPanel = this;
        boolean bl = false;
        $this$projectFileName_u24lambda_u247.setToolTipText("The name applied to the JSON project file.");
        $this$projectFileName_u24lambda_u247.getTextField().setText("avail-config");
        JButton $this$projectFileName_u24lambda_u247_u24lambda_u246 = $this$associateByTo$iv$iv = $this$projectFileName_u24lambda_u247.getButton();
        boolean bl2 = false;
        $this$projectFileName_u24lambda_u247_u24lambda_u246.setContentAreaFilled(false);
        $this$projectFileName_u24lambda_u247_u24lambda_u246.setBorderPainted(false);
        $this$projectFileName_u24lambda_u247_u24lambda_u246.setText("");
        $this$projectFileName_u24lambda_u247_u24lambda_u246.setIcon(ProjectManagerIcons.INSTANCE.refresh(23));
        $this$projectFileName_u24lambda_u247_u24lambda_u246.addActionListener(arg_0 -> CreateProjectPanel.projectFileName$lambda$7$lambda$6$lambda$5((TextFieldWithLabelAndButton)$this$projectFileName_u24lambda_u247, arg_0));
        createProjectPanel.projectFileName = object2;
        this.projectLocation = new DirectoryChooser("Project Directory: ", "Select Project Directory", null, 4, null);
        this.rootNameField = new TextFieldWithLabel("Create Root Name: ", null, null, null, 14, null);
        this.libraryNameField = new TextFieldWithLabel("Standard Library Root Name: ", null, null, null, 14, null);
        $this$projectFileName_u24lambda_u247 = object2 = new JComboBox<String>(this.getStandardLibraryNames());
        createProjectPanel = this;
        boolean bl3 = false;
        $this$libraryPicker_u24lambda_u2411.addActionListener(arg_0 -> CreateProjectPanel.libraryPicker$lambda$11$lambda$10((JComboBox)$this$libraryPicker_u24lambda_u2411, this, arg_0));
        createProjectPanel.libraryPicker = object2;
        $this$libraryPicker_u24lambda_u2411 = object2 = new JButton("Create");
        createProjectPanel = this;
        boolean bl4 = false;
        $this$createButton_u24lambda_u2413.setOpaque(true);
        $this$createButton_u24lambda_u2413.setBorder(BorderFactory.createLineBorder(new Color(187, 187, 187), 1, true));
        int currentHeight = $this$createButton_u24lambda_u2413.getHeight();
        int currentWidth = $this$createButton_u24lambda_u2413.getWidth();
        $this$createButton_u24lambda_u2413.setMinimumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$createButton_u24lambda_u2413.setPreferredSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$createButton_u24lambda_u2413.setMaximumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$createButton_u24lambda_u2413.addActionListener(arg_0 -> CreateProjectPanel.createButton$lambda$13$lambda$12(this, arg_0));
        createProjectPanel.createButton = object2;
        $this$createButton_u24lambda_u2413 = object2 = new JButton("Cancel");
        createProjectPanel = this;
        boolean bl5 = false;
        $this$cancel_u24lambda_u2415.setOpaque(true);
        currentHeight = $this$cancel_u24lambda_u2415.getHeight();
        currentWidth = $this$cancel_u24lambda_u2415.getWidth();
        $this$cancel_u24lambda_u2415.setMinimumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$cancel_u24lambda_u2415.setPreferredSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$cancel_u24lambda_u2415.setMaximumSize(new Dimension(currentWidth + 100, currentHeight + 40));
        $this$cancel_u24lambda_u2415.addActionListener(arg_0 -> CreateProjectPanel.cancel$lambda$15$lambda$14(this, arg_0));
        createProjectPanel.cancel = object2;
        $this$cancel_u24lambda_u2415 = object2 = new JPanel();
        createProjectPanel = this;
        boolean bl6 = false;
        $this$bottomPanel_u24lambda_u2416.setLayout(new FlowLayout(2));
        $this$bottomPanel_u24lambda_u2416.setMinimumSize(new Dimension(600, 50));
        $this$bottomPanel_u24lambda_u2416.setPreferredSize(new Dimension(600, 50));
        $this$bottomPanel_u24lambda_u2416.setMaximumSize(new Dimension(600, 50));
        $this$bottomPanel_u24lambda_u2416.add(this.cancel);
        $this$bottomPanel_u24lambda_u2416.add(this.createButton);
        createProjectPanel.bottomPanel = object2;
        this.setMinimumSize(new Dimension(600, 50));
        this.setPreferredSize(new Dimension(600, 50));
        this.setMaximumSize(new Dimension(600, 50));
        $this$bottomPanel_u24lambda_u2416 = object2 = new GridBagConstraints();
        object = this.projectNameField;
        createProjectPanel = this;
        boolean bl7 = false;
        $this$_init__u24lambda_u2417.weightx = 1.0;
        $this$_init__u24lambda_u2417.fill = 2;
        $this$_init__u24lambda_u2417.gridx = 0;
        $this$_init__u24lambda_u2417.gridy = 0;
        $this$_init__u24lambda_u2417.gridwidth = 2;
        Unit unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2417 = object2 = new GridBagConstraints();
        object = this.projectFileName;
        createProjectPanel = this;
        boolean bl8 = false;
        $this$_init__u24lambda_u2418.weightx = 1.0;
        $this$_init__u24lambda_u2418.fill = 2;
        $this$_init__u24lambda_u2418.gridx = 0;
        $this$_init__u24lambda_u2418.gridy = 1;
        $this$_init__u24lambda_u2418.gridwidth = 2;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2418 = object2 = new GridBagConstraints();
        object = this.projectLocation;
        createProjectPanel = this;
        boolean bl9 = false;
        $this$_init__u24lambda_u2419.weightx = 1.0;
        $this$_init__u24lambda_u2419.fill = 2;
        $this$_init__u24lambda_u2419.gridx = 0;
        $this$_init__u24lambda_u2419.gridy = 2;
        $this$_init__u24lambda_u2419.gridwidth = 2;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2419 = object2 = new GridBagConstraints();
        object = this.rootNameField;
        createProjectPanel = this;
        boolean bl10 = false;
        $this$_init__u24lambda_u2420.weightx = 1.0;
        $this$_init__u24lambda_u2420.fill = 2;
        $this$_init__u24lambda_u2420.gridx = 0;
        $this$_init__u24lambda_u2420.gridy = 3;
        $this$_init__u24lambda_u2420.gridwidth = 2;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2420 = object2 = new GridBagConstraints();
        object = this.libraryNameField;
        createProjectPanel = this;
        boolean bl11 = false;
        $this$_init__u24lambda_u2421.weightx = 1.0;
        $this$_init__u24lambda_u2421.fill = 2;
        $this$_init__u24lambda_u2421.gridx = 0;
        $this$_init__u24lambda_u2421.gridy = 4;
        $this$_init__u24lambda_u2421.gridwidth = 1;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2421 = object2 = new GridBagConstraints();
        object = this.libraryPicker;
        createProjectPanel = this;
        boolean bl12 = false;
        $this$_init__u24lambda_u2422.weightx = 1.0;
        $this$_init__u24lambda_u2422.fill = 2;
        $this$_init__u24lambda_u2422.gridx = 1;
        $this$_init__u24lambda_u2422.gridy = 4;
        $this$_init__u24lambda_u2422.gridwidth = 1;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
        Object $this$_init__u24lambda_u2422 = object2 = new GridBagConstraints();
        object = this.bottomPanel;
        createProjectPanel = this;
        boolean bl13 = false;
        $this$_init__u24lambda_u2423.weightx = 1.0;
        $this$_init__u24lambda_u2423.fill = 2;
        $this$_init__u24lambda_u2423.gridx = 0;
        $this$_init__u24lambda_u2423.gridy = 5;
        $this$_init__u24lambda_u2423.gridwidth = 2;
        unit = Unit.INSTANCE;
        createProjectPanel.add((Component)object, object2);
    }

    @NotNull
    public final GlobalEnvironmentSettings getConfig$avail() {
        return this.config;
    }

    private final String[] getStandardLibraryNames() {
        String[] stringArray = new String[]{"None"};
        Collection $this$toTypedArray$iv = this.standardLibraries.keySet();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return ArraysKt.plus(stringArray, thisCollection$iv.toArray(new String[0]));
    }

    public final void create() {
        AvailProjectV1 availProjectV1;
        String fileName = this.projectFileName.getTextField().getText();
        String projLocation = this.projectLocation.getTextField().getText();
        String projectFilePath = projLocation + "/" + fileName + ".json";
        Intrinsics.checkNotNullExpressionValue(fileName, "fileName");
        Intrinsics.checkNotNullExpressionValue(projLocation, "projLocation");
        String configPath = AvailEnvironment.INSTANCE.projectConfigPath(fileName, projLocation);
        AvailProject.Companion.optionallyInitializeConfigDirectory$default(AvailProject.Companion, configPath, false, 2, null);
        LocalSettings localSettings = LocalSettings.Companion.from(new File(configPath));
        AvailProjectV1 $this$create_u24lambda_u244 = availProjectV1 = new AvailProjectV1(fileName, true, new AvailRepositories(null, null, null, 3, null), localSettings, null, null, null, null, 240, null);
        boolean bl = false;
        new File(projLocation).mkdirs();
        String rootsLocation = projLocation + "/roots";
        new File(rootsLocation).mkdirs();
        String rootName = this.rootNameField.getTextField().getText();
        Intrinsics.checkNotNullExpressionValue(rootName, "rootName");
        String rootConfigDir = AvailEnvironment.INSTANCE.projectRootConfigPath(fileName, rootName, projLocation);
        AvailProjectRoot root = new AvailProjectRoot(rootConfigDir, projLocation, rootName, new ProjectHome("roots", Scheme.FILE, projLocation, null), new LocalSettings(rootConfigDir, null, null, 6, null), new StylingGroup(), new TemplateGroup(null, 1, null), null, false, null, false, 1920, null);
        $this$create_u24lambda_u244.addRoot(root);
        $this$create_u24lambda_u244.optionallyInitializeConfigDirectory(rootConfigDir);
        File file2 = this.selectedLibrary;
        if (file2 != null) {
            CharSequence charSequence;
            File lib = file2;
            boolean bl2 = false;
            CharSequence charSequence2 = this.libraryNameField.getInput();
            if (charSequence2.length() == 0) {
                boolean bl3 = false;
                charSequence = "avail";
            } else {
                charSequence = charSequence2;
            }
            String libName = (String)charSequence;
            String libConfigDir = AvailEnvironment.INSTANCE.projectRootConfigPath(fileName, libName, projLocation);
            $this$create_u24lambda_u244.optionallyInitializeConfigDirectory(libConfigDir);
            URI uRI = lib.toURI();
            Intrinsics.checkNotNullExpressionValue(uRI, "lib.toURI()");
            AvailArtifactJar jar = new AvailArtifactJar(uRI);
            AvailRootManifest rootManifest2 = jar.getManifest().getRoots().get("avail");
            StylingGroup sg = null;
            sg = new StylingGroup();
            TemplateGroup tg = null;
            tg = new TemplateGroup(null, 1, null);
            List extensions = new ArrayList();
            String description2 = null;
            description2 = "";
            AvailRootManifest availRootManifest = rootManifest2;
            if (availRootManifest != null) {
                AvailRootManifest it = availRootManifest;
                boolean bl4 = false;
                sg = it.getStyles();
                tg = it.getTemplates();
                extensions.addAll((Collection)it.getAvailModuleExtensions());
                description2 = it.getDescription();
            }
            AvailProjectRoot stdLib = new AvailProjectRoot(libConfigDir, projLocation, libName, new AvailLibraries("org/availlang/" + lib.getName(), Scheme.JAR, "avail"), new LocalSettings(AvailEnvironment.INSTANCE.projectRootConfigPath(fileName, libName, projLocation), null, null, 6, null), sg, tg, extensions, false, null, false, 1792, null);
            stdLib.setDescription(description2);
            stdLib.saveLocalSettingsToDisk();
            stdLib.saveTemplatesToDisk();
            stdLib.saveStylesToDisk();
            $this$create_u24lambda_u244.addRoot(stdLib);
        }
        if (((CharSequence)projectFilePath).length() > 0) {
            JSONWriter writer = JSONWriter.Companion.newPrettyPrinterWriter();
            $this$create_u24lambda_u244.writeTo(writer);
            FilesKt.writeText$default(new File(projectFilePath), writer.contents(), null, 2, null);
            this.config.add($this$create_u24lambda_u244, projectFilePath);
            this.onCreate.invoke($this$create_u24lambda_u244, projectFilePath);
        }
    }

    @NotNull
    public final JButton getCancel() {
        return this.cancel;
    }

    private static final void projectFileName$lambda$7$lambda$6$lambda$5(TextFieldWithLabelAndButton $this_panel, ActionEvent it) {
        Intrinsics.checkNotNullParameter($this_panel, "$this_panel");
        $this_panel.getTextField().setText("avail-config");
    }

    private static final void libraryPicker$lambda$11$lambda$10(JComboBox $this_apply, CreateProjectPanel this$0, ActionEvent it) {
        block1: {
            Intrinsics.checkNotNullParameter($this_apply, "$this_apply");
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            Object object = $this_apply.getSelectedItem();
            if (object == null || (object = object.toString()) == null) break block1;
            Object key = object;
            boolean bl = false;
            File file2 = this$0.standardLibraries.get(key);
            if (file2 != null) {
                File lib = file2;
                boolean bl2 = false;
                this$0.selectedLibrary = lib;
            }
        }
    }

    private static final void createButton$lambda$13$lambda$12(CreateProjectPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.create();
    }

    private static final void cancel$lambda$15$lambda$14(CreateProjectPanel this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.onCancel.invoke();
    }
}

