/*
 * Decompiled with CFR 0.152.
 */
package avail.anvil.streams;

import avail.anvil.AvailWorkbench;
import avail.anvil.streams.StreamStyle;
import avail.utility.JavaConcurrencyCompatibilityKt;
import java.io.ByteArrayInputStream;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\"\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0016J\b\u0010\u0014\u001a\u00020\u0006H\u0016J\u0006\u0010\u0015\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lavail/anvil/streams/BuildInputStream;", "Ljava/io/ByteArrayInputStream;", "workbench", "Lavail/anvil/AvailWorkbench;", "(Lavail/anvil/AvailWorkbench;)V", "clear", "", "feedbackForCommand", "commandText", "", "mark", "readAheadLimit", "", "markSupported", "", "read", "readBuffer", "", "start", "requestSize", "reset", "update", "avail"})
public final class BuildInputStream
extends ByteArrayInputStream {
    @NotNull
    private final AvailWorkbench workbench;

    public BuildInputStream(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter(workbench, "workbench");
        super(new byte[1024], 0, 0);
        this.workbench = workbench;
    }

    public final synchronized void clear() {
        this.count = 0;
        this.pos = 0;
    }

    public final synchronized void update() {
        String text;
        String string2 = text = this.workbench.getInputField().getText() + "\n";
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue(byArray, "this as java.lang.String).getBytes(charset)");
        byte[] bytes2 = byArray;
        if (this.pos + bytes2.length >= this.buf.length) {
            int newSize = Math.max(this.buf.length << 1, bytes2.length + this.buf.length);
            byte[] newBuf = new byte[newSize];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
        System.arraycopy(bytes2, 0, this.buf, this.count, bytes2.length);
        this.count += bytes2.length;
        this.workbench.writeText(text, StreamStyle.IN_ECHO);
        this.workbench.getInputField().setText("");
        JavaConcurrencyCompatibilityKt.javaNotifyAll(this);
    }

    public final synchronized void feedbackForCommand(@NotNull String commandText) {
        Intrinsics.checkNotNullParameter(commandText, "commandText");
        String textToInsert = "\n" + commandText + "\n";
        this.workbench.writeText(textToInsert, StreamStyle.COMMAND);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int read() {
        try {
            while (this.pos == this.count) {
                JavaConcurrencyCompatibilityKt.javaWait(this);
            }
        }
        catch (InterruptedException e) {
            return -1;
        }
        int n = this.pos;
        this.pos = n + 1;
        return this.buf[n] & 0xFF;
    }

    @Override
    public synchronized int read(@Nullable byte[] readBuffer, int start, int requestSize) {
        boolean bl;
        boolean bl2 = bl = readBuffer != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (requestSize <= 0) {
            return 0;
        }
        try {
            while (this.pos == this.count) {
                JavaConcurrencyCompatibilityKt.javaWait(this);
            }
        }
        catch (InterruptedException e) {
            return -1;
        }
        int bytesToTransfer = Math.min(requestSize, this.count - this.pos);
        Intrinsics.checkNotNull(readBuffer);
        System.arraycopy(this.buf, this.pos, readBuffer, start, bytesToTransfer);
        this.pos += bytesToTransfer;
        return bytesToTransfer;
    }
}

