/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.functions;

import avail.AvailRuntime;
import avail.AvailRuntimeSupport;
import avail.annotations.HideFieldInDebugger;
import avail.annotations.ThreadSafe;
import avail.compiler.AvailRejectedParseException;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.CompiledCodeDescriptor;
import avail.descriptor.functions.PrimitiveCompiledCodeDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectFieldHelper;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.Descriptor;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.NybbleTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.CompiledCodeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.interpreter.Primitive;
import avail.interpreter.levelOne.L1Disassembler;
import avail.interpreter.levelOne.L1Operation;
import avail.interpreter.levelTwo.L2Chunk;
import avail.interpreter.levelTwo.L2JVMChunk;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerStringBody;
import avail.optimizer.OptimizationLevel;
import avail.optimizer.jvm.CheckedMethod;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import avail.serialization.SerializerOperation;
import avail.utility.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import kotlin.Deprecated;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 p2\u00020\u0001:\u0006opqrstB?\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0019\u001a\u00020\u001aH\u0017J\b\u0010\u001b\u001a\u00020\u001aH\u0017J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010&\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020$H\u0016J$\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\"0+H\u0016J\u001b\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00101\u001a\u000202H\u0016J\u0018\u00103\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u00107\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u00108\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u00109\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010:\u001a\u00020\u001f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0018\u0010;\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010<\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010=\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010>\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010?\u001a\u00020@2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010A\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010B\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010C\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010D\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010E\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010F\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010G\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010H\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010I\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010J\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010K\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0016J\u0010\u0010L\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010O\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010P\u001a\u00020Q2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010R\u001a\u00020Q2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010S\u001a\u00020T2\u0006\u0010\u001e\u001a\u00020\u001fH\u0017J\u0018\u0010U\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0018\u0010V\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0007H\u0016J \u0010W\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010X\u001a\u00020\u00182\u0006\u0010Y\u001a\u00020$H\u0016J\u0010\u0010Z\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010[\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\\\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010]\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010^\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010_\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010`\u001a\u00020aH\u0016J\u0018\u0010b\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010`\u001a\u00020aH\u0016J8\u0010c\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010d\u001a\u00060ej\u0002`f2\u0012\u0010g\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u00020i0h2\u0006\u0010j\u001a\u00020\u0007H\u0016J\b\u0010k\u001a\u00020\u001aH\u0017J1\u0010l\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010`\u001a\u00020a2\u0017\u0010m\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\"0+\u00a2\u0006\u0002\bnH\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006u"}, d2={"Lavail/descriptor/functions/CompiledCodeDescriptor;", "Lavail/descriptor/representation/Descriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "module", "Lavail/descriptor/module/A_Module;", "originatingPhraseIndex", "", "originatingPhrase", "Lavail/descriptor/phrases/A_Phrase;", "packedDeclarationNames", "Lavail/descriptor/tuples/A_String;", "lineNumber", "lineNumberEncodedDeltas", "Lavail/descriptor/tuples/A_Tuple;", "(Lavail/descriptor/representation/Mutability;Lavail/descriptor/module/A_Module;ILavail/descriptor/phrases/A_Phrase;Lavail/descriptor/tuples/A_String;ILavail/descriptor/tuples/A_Tuple;)V", "invocationStatistic", "Lavail/descriptor/functions/CompiledCodeDescriptor$InvocationStatistic;", "methodName", "getMethodName", "()Lavail/descriptor/tuples/A_String;", "setMethodName", "(Lavail/descriptor/tuples/A_String;)V", "startingChunk", "Lavail/interpreter/levelTwo/L2Chunk;", "immutable", "", "mutable", "o_ConstantTypeAt", "Lavail/descriptor/types/A_Type;", "self", "Lavail/descriptor/representation/AvailObject;", "index", "o_CountdownToReoptimize", "", "value", "", "o_DeclarationNames", "o_DecreaseCountdownToReoptimizeFromPoll", "delta", "o_DecrementCountdownToReoptimize", "", "continuation", "Lkotlin/Function1;", "o_DescribeForDebugger", "", "Lavail/descriptor/representation/AvailObjectFieldHelper;", "(Lavail/descriptor/representation/AvailObject;)[Lavail/descriptor/representation/AvailObjectFieldHelper;", "o_Equals", "another", "Lavail/descriptor/representation/A_BasicObject;", "o_EqualsCompiledCode", "aCompiledCode", "Lavail/descriptor/functions/A_RawFunction;", "o_FunctionType", "o_Hash", "o_Kind", "o_LineNumberEncodedDeltas", "o_LiteralAt", "o_LocalTypeAt", "o_MaxStackDepth", "o_MethodName", "o_Module", "o_NameForDebugger", "", "o_NumArgs", "o_NumConstants", "o_NumLiterals", "o_NumLocals", "o_NumNybbles", "o_NumOuters", "o_NumSlots", "o_Nybbles", "o_OriginatingPhrase", "o_OriginatingPhraseIndex", "o_OuterTypeAt", "o_PackedDeclarationNames", "o_Primitive", "Lavail/interpreter/Primitive;", "o_ReturnTypeIfPrimitiveFails", "o_ReturneeCheckStat", "Lavail/performance/Statistic;", "o_ReturnerCheckStat", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_SetMethodName", "o_SetOriginatingPhraseIndex", "o_SetStartingChunkAndReoptimizationCountdown", "chunk", "countdown", "o_ShowValueInNameForDebugger", "o_StartingChunk", "o_StartingLineNumber", "o_TallyInvocation", "o_TotalInvocations", "o_WriteSummaryTo", "writer", "Lorg/availlang/json/JSONWriter;", "o_WriteTo", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "writeTo", "writeFunctionType", "Lkotlin/ExtensionFunctionType;", "CodeCoverageReport", "Companion", "IntegerSlots", "InvocationStatistic", "L1InstructionDecoder", "ObjectSlots", "avail"})
public class CompiledCodeDescriptor
extends Descriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final A_Module module;
    private int originatingPhraseIndex;
    @NotNull
    private volatile A_Phrase originatingPhrase;
    @NotNull
    private final A_String packedDeclarationNames;
    private final int lineNumber;
    @NotNull
    private final A_Tuple lineNumberEncodedDeltas;
    @NotNull
    private A_String methodName;
    @NotNull
    private volatile L2Chunk startingChunk;
    @NotNull
    private final InvocationStatistic invocationStatistic;
    @NotNull
    private static final Set<A_RawFunction> activeRawFunctions;
    @NotNull
    private static final CheckedMethod codePrimitiveMethod;
    @NotNull
    private static final A_String unknownFunctionName;
    @NotNull
    private static final CompiledCodeDescriptor initialMutableDescriptor;
    @NotNull
    private static final ConcurrentMap<A_String, Statistic> returnerCheckStatisticsByName;
    @NotNull
    private static final ConcurrentMap<A_String, Statistic> returneeCheckStatisticsByName;

    protected CompiledCodeDescriptor(@NotNull Mutability mutability, @NotNull A_Module module, int originatingPhraseIndex, @NotNull A_Phrase originatingPhrase, @NotNull A_String packedDeclarationNames2, int lineNumber, @NotNull A_Tuple lineNumberEncodedDeltas) {
        Intrinsics.checkNotNullParameter((Object)mutability, "mutability");
        Intrinsics.checkNotNullParameter(module, "module");
        Intrinsics.checkNotNullParameter(originatingPhrase, "originatingPhrase");
        Intrinsics.checkNotNullParameter(packedDeclarationNames2, "packedDeclarationNames");
        Intrinsics.checkNotNullParameter(lineNumberEncodedDeltas, "lineNumberEncodedDeltas");
        super(mutability, TypeTag.RAW_FUNCTION_TAG, ObjectSlots.class, IntegerSlots.class);
        this.module = module;
        this.originatingPhraseIndex = originatingPhraseIndex;
        this.originatingPhrase = originatingPhrase;
        this.packedDeclarationNames = packedDeclarationNames2;
        this.lineNumber = lineNumber;
        this.lineNumberEncodedDeltas = lineNumberEncodedDeltas;
        this.methodName = unknownFunctionName;
        this.startingChunk = L2JVMChunk.Companion.getUnoptimizedChunk();
        this.invocationStatistic = new InvocationStatistic();
    }

    @NotNull
    protected final A_String getMethodName() {
        return this.methodName;
    }

    protected final void setMethodName(@NotNull A_String a_String) {
        Intrinsics.checkNotNullParameter(a_String, "<set-?>");
        this.methodName = a_String;
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(recursionMap, "recursionMap");
        super.printObjectOnAvoidingIndent(self, builder, recursionMap, indent);
        int longCount = self.variableIntegerSlotsCount();
        if (longCount > 0) {
            Strings.INSTANCE.newlineTab(builder, indent);
            builder.append("Nybblecodes:\n");
            L1Disassembler.print$default(new L1Disassembler(self), builder, recursionMap, indent + 1, 0, 8, null);
        }
    }

    @Override
    @NotNull
    public A_Type o_ConstantTypeAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        boolean bl2 = bl = 1 <= index2 && index2 <= A_RawFunction.Companion.getNumConstants(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return A_RawFunction.Companion.literalAt(self, A_RawFunction.Companion.getNumLiterals(self) - A_RawFunction.Companion.getNumConstants(self) + index2);
    }

    @Override
    public void o_CountdownToReoptimize(@NotNull AvailObject self, long value) {
        Intrinsics.checkNotNullParameter(self, "self");
        this.invocationStatistic.getCountdownToReoptimize().set(value);
    }

    @Override
    @NotNull
    public A_Tuple o_DeclarationNames(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        List names = new ArrayList();
        int limit = A_Tuple.Companion.getTupleSize(this.packedDeclarationNames);
        if (limit == 0) {
            return TupleDescriptor.Companion.getEmptyTuple();
        }
        int position = 1;
        while (true) {
            if (A_Tuple.Companion.tupleCodePointAt(this.packedDeclarationNames, position) == 34) {
                A_Token a_Token;
                try {
                    a_Token = P_BootstrapLexerStringBody.INSTANCE.parseString(this.packedDeclarationNames, position, 1, NilDescriptor.Companion.getNil());
                }
                catch (AvailRejectedParseException e) {
                    throw new RuntimeException("Invalid encoded declaration names");
                }
                A_Token token = a_Token;
                names.add(token.literal());
                position += A_Tuple.Companion.getTupleSize(token.string());
            } else {
                int start = position;
                while (position <= limit && A_Tuple.Companion.tupleCodePointAt(this.packedDeclarationNames, position) != 44) {
                    ++position;
                }
                names.add(A_String.Companion.copyStringFromToCanDestroy(this.packedDeclarationNames, start, position - 1, false));
            }
            if (position == limit + 1) {
                return ObjectTupleDescriptor.Companion.tupleFromList(names).makeShared();
            }
            if (A_Tuple.Companion.tupleCodePointAt(this.packedDeclarationNames, position) != 44) {
                throw new RuntimeException("Invalid encoded declaration names");
            }
            ++position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean o_DecrementCountdownToReoptimize(@NotNull AvailObject self, @NotNull Function1<? super Boolean, Unit> continuation) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(continuation, "continuation");
        long newCount = this.invocationStatistic.getCountdownToReoptimize().decrementAndGet();
        if (newCount <= 0L) {
            AvailObject availObject = self;
            synchronized (availObject) {
                boolean bl = false;
                continuation.invoke((Boolean)(this.invocationStatistic.getCountdownToReoptimize().get() <= 0L ? 1 : 0));
                Unit unit = Unit.INSTANCE;
            }
            return true;
        }
        return false;
    }

    @Override
    public void o_DecreaseCountdownToReoptimizeFromPoll(@NotNull AvailObject self, long delta) {
        long current;
        Intrinsics.checkNotNullParameter(self, "self");
        AtomicLong counter = this.invocationStatistic.getCountdownToReoptimize();
        while ((current = counter.get()) > 0L && !counter.compareAndSet(current, Math.max(1L, current - delta))) {
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public AvailObjectFieldHelper[] o_DescribeForDebugger(@NotNull AvailObject self) {
        void $this$mapTo$iv$iv;
        int it;
        Collection collection2;
        int item$iv;
        Intrinsics.checkNotNullParameter(self, "self");
        AvailObject $this$o_DescribeForDebugger_u24lambda_u247 = self;
        boolean bl = false;
        AvailObjectFieldHelper[] availObjectFieldHelperArray = super.o_DescribeForDebugger(self);
        List<AvailObjectFieldHelper> fields2 = CollectionsKt.mutableListOf(Arrays.copyOf(availObjectFieldHelperArray, availObjectFieldHelperArray.length));
        fields2.add(new AvailObjectFieldHelper(self, AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, this, "Descriptor", null, null, 96, null));
        List disassembled = L1Disassembler.disassembledAsSlots$default(new L1Disassembler(self), 0, 1, null);
        if ($this$o_DescribeForDebugger_u24lambda_u247.variableIntegerSlotsCount() > 0) {
            A_Module $this$o_DescribeForDebugger_u24lambda_u247_u24lambda_u241 = A_RawFunction.Companion.getModule($this$o_DescribeForDebugger_u24lambda_u247);
            boolean bl2 = false;
            String moduleName2 = $this$o_DescribeForDebugger_u24lambda_u247_u24lambda_u241.isNil() ? "No module" : A_Module.Companion.getShortModuleNameNative($this$o_DescribeForDebugger_u24lambda_u247_u24lambda_u241);
            Collection $this$toTypedArray$iv = disassembled;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            fields2.add(new AvailObjectFieldHelper(self, AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, null, "Disassembly", "L1 Disassembly (" + moduleName2 + ")", thisCollection$iv.toArray(new AvailObjectFieldHelper[0])));
        }
        List literalFields = new ArrayList();
        int baseLiterals = A_RawFunction.Companion.getNumLiterals($this$o_DescribeForDebugger_u24lambda_u247) - A_RawFunction.Companion.getNumConstants($this$o_DescribeForDebugger_u24lambda_u247) - A_RawFunction.Companion.getNumLocals($this$o_DescribeForDebugger_u24lambda_u247) - A_RawFunction.Companion.getNumOuters($this$o_DescribeForDebugger_u24lambda_u247);
        Iterable $this$mapTo$iv = new IntRange(1, baseLiterals);
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            int n = item$iv = ((IntIterator)iterator2).nextInt();
            collection2 = literalFields;
            boolean bl3 = false;
            collection2.add(new AvailObjectFieldHelper(self, AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, it, A_RawFunction.Companion.literalAt($this$o_DescribeForDebugger_u24lambda_u247, it), "Base literal", null, null, 96, null));
        }
        $this$mapTo$iv = new IntRange(1, A_RawFunction.Companion.getNumOuters($this$o_DescribeForDebugger_u24lambda_u247));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            it = item$iv = ((IntIterator)iterator2).nextInt();
            collection2 = literalFields;
            boolean bl4 = false;
            collection2.add(new AvailObjectFieldHelper(self, AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, it, A_RawFunction.Companion.outerTypeAt($this$o_DescribeForDebugger_u24lambda_u247, it), "Outer type", null, null, 96, null));
        }
        $this$mapTo$iv = new IntRange(1, A_RawFunction.Companion.getNumLocals($this$o_DescribeForDebugger_u24lambda_u247));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            it = item$iv = ((IntIterator)iterator2).nextInt();
            collection2 = literalFields;
            boolean bl5 = false;
            collection2.add(new AvailObjectFieldHelper(self, AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, it, A_RawFunction.Companion.localTypeAt($this$o_DescribeForDebugger_u24lambda_u247, it), "Local type", null, null, 96, null));
        }
        $this$mapTo$iv = new IntRange(1, A_RawFunction.Companion.getNumConstants($this$o_DescribeForDebugger_u24lambda_u247));
        $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv.iterator();
        while (iterator2.hasNext()) {
            it = item$iv = ((IntIterator)iterator2).nextInt();
            collection2 = literalFields;
            boolean bl6 = false;
            collection2.add(new AvailObjectFieldHelper(self, AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, it, A_RawFunction.Companion.constantTypeAt($this$o_DescribeForDebugger_u24lambda_u247, it), "Constant type", null, null, 96, null));
        }
        Iterable $this$map$iv = new IntRange(1, A_RawFunction.Companion.getNumLiterals($this$o_DescribeForDebugger_u24lambda_u247));
        boolean $i$f$map = false;
        Iterable item$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo2 = false;
        Iterator iterator3 = $this$mapTo$iv$iv.iterator();
        while (iterator3.hasNext()) {
            void it2;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator3).nextInt();
            collection2 = destination$iv$iv;
            boolean bl7 = false;
            collection2.add(A_RawFunction.Companion.literalAt($this$o_DescribeForDebugger_u24lambda_u247, (int)it2));
        }
        List allLiterals = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = literalFields;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        fields2.add(new AvailObjectFieldHelper(self, AbstractDescriptor.DebuggerObjectSlots.DUMMY_DEBUGGER_SLOT, -1, ObjectTupleDescriptor.Companion.tupleFromList(allLiterals), "All literals", "Literals", thisCollection$iv.toArray(new AvailObjectFieldHelper[0])));
        $this$toTypedArray$iv = fields2;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new AvailObjectFieldHelper[0]);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return another.equalsCompiledCode(self);
    }

    @Override
    public boolean o_EqualsCompiledCode(@NotNull AvailObject self, @NotNull A_RawFunction aCompiledCode) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aCompiledCode, "aCompiledCode");
        return self.sameAddressAs(aCompiledCode);
    }

    @Override
    @NotNull
    public AvailObject o_FunctionType(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(ObjectSlots.FUNCTION_TYPE);
    }

    @Override
    public int o_Hash(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(IntegerSlots.Companion.getHASH());
    }

    @Override
    @NotNull
    public AvailObject o_Kind(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return CompiledCodeTypeDescriptor.Companion.compiledCodeTypeForFunctionType(self.functionType());
    }

    @Override
    @NotNull
    public A_Tuple o_LineNumberEncodedDeltas(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return this.lineNumberEncodedDeltas;
    }

    @Override
    @NotNull
    public AvailObject o_LiteralAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(ObjectSlots.LITERAL_AT_, index2);
    }

    @Override
    @NotNull
    public A_Type o_LocalTypeAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        boolean bl2 = bl = 1 <= index2 && index2 <= A_RawFunction.Companion.getNumLocals(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return A_RawFunction.Companion.literalAt(self, A_RawFunction.Companion.getNumLiterals(self) - A_RawFunction.Companion.getNumConstants(self) - A_RawFunction.Companion.getNumLocals(self) + index2);
    }

    @Override
    public int o_MaxStackDepth(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return A_RawFunction.Companion.getNumSlots(self) - A_RawFunction.Companion.numArgs(self) - A_RawFunction.Companion.getNumLocals(self);
    }

    @Override
    @NotNull
    public A_String o_MethodName(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return this.methodName;
    }

    @Override
    @NotNull
    public A_Module o_Module(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return this.module;
    }

    @Override
    @NotNull
    public String o_NameForDebugger(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return super.o_NameForDebugger(self) + ": " + this.methodName;
    }

    @Override
    public int o_NumArgs(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(IntegerSlots.Companion.getNUM_ARGS());
    }

    @Override
    public int o_NumConstants(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(IntegerSlots.Companion.getNUM_CONSTANTS());
    }

    @Override
    public int o_NumLiterals(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.variableObjectSlotsCount();
    }

    @Override
    public int o_NumLocals(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(IntegerSlots.Companion.getNUM_LOCALS());
    }

    @Override
    public int o_NumNybbles(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        int longCount = self.variableIntegerSlotsCount();
        if (longCount == 0) {
            return 0;
        }
        long firstLong = self.slot(IntegerSlots.NYBBLECODES_, 1);
        int unusedNybbles = (int)firstLong & 0xF;
        return (longCount << 4) - unusedNybbles - 1;
    }

    @Override
    public int o_NumOuters(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(IntegerSlots.Companion.getNUM_OUTERS());
    }

    @Override
    public int o_NumSlots(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(IntegerSlots.Companion.getFRAME_SLOTS());
    }

    @Override
    @NotNull
    public A_Tuple o_Nybbles(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        int longCount = self.variableIntegerSlotsCount();
        if (longCount == 0) {
            return TupleDescriptor.Companion.getEmptyTuple();
        }
        L1InstructionDecoder decoder = new L1InstructionDecoder();
        self.setUpInstructionDecoder(decoder);
        decoder.pc(1);
        return NybbleTupleDescriptor.Companion.generateNybbleTupleFrom(this.o_NumNybbles(self), (Function1<? super Integer, Integer>)new Function1<Integer, Integer>(decoder){
            final /* synthetic */ L1InstructionDecoder $decoder;
            {
                this.$decoder = $decoder;
                super(1);
            }

            @NotNull
            public final Integer invoke(int it) {
                return this.$decoder.getNybble();
            }
        });
    }

    @Override
    @NotNull
    public A_Phrase o_OriginatingPhrase(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        A_Phrase phrase = this.originatingPhrase;
        if (phrase.isNil() && this.originatingPhraseIndex != -1) {
            this.originatingPhrase = phrase = A_Module.Companion.originatingPhraseAtIndex(this.module, this.originatingPhraseIndex);
        }
        return phrase;
    }

    @Override
    public int o_OriginatingPhraseIndex(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return this.originatingPhraseIndex;
    }

    @Override
    @NotNull
    public A_Type o_OuterTypeAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        boolean bl2 = bl = 1 <= index2 && index2 <= A_RawFunction.Companion.getNumOuters(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return A_RawFunction.Companion.literalAt(self, A_RawFunction.Companion.getNumLiterals(self) - A_RawFunction.Companion.getNumConstants(self) - A_RawFunction.Companion.getNumLocals(self) - A_RawFunction.Companion.getNumOuters(self) + index2);
    }

    @Override
    @NotNull
    public A_String o_PackedDeclarationNames(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return this.packedDeclarationNames;
    }

    @Override
    @Nullable
    public Primitive o_Primitive(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Statistic o_ReturnerCheckStat(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        Statistic statistic = this.invocationStatistic.getReturnerCheckStat();
        if (statistic != null) {
            Statistic it = statistic;
            boolean bl = false;
            return it;
        }
        InvocationStatistic invocationStatistic = this.invocationStatistic;
        synchronized (invocationStatistic) {
            block5: {
                boolean bl = false;
                Statistic statistic2 = this.invocationStatistic.getReturnerCheckStat();
                if (statistic2 == null) break block5;
                Statistic it = statistic2;
                boolean bl2 = false;
                Statistic statistic3 = it;
                return statistic3;
            }
            A_String name = A_RawFunction.Companion.getMethodName(self);
            Statistic returnerStat2 = returnerCheckStatisticsByName.computeIfAbsent(name, arg_0 -> CompiledCodeDescriptor.o_ReturnerCheckStat$lambda$11$lambda$10(new Function1<A_String, Statistic>(name){
                final /* synthetic */ A_String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                public final Statistic invoke(A_String it) {
                    return new Statistic(StatisticReport.NON_PRIMITIVE_RETURNER_TYPE_CHECKS, "Checked return from " + A_String.Companion.asNativeString(this.$name));
                }
            }, arg_0));
            this.invocationStatistic.setReturnerCheckStat(returnerStat2);
            Intrinsics.checkNotNullExpressionValue(returnerStat2, "returnerStat");
            Statistic statistic4 = returnerStat2;
            return statistic4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Statistic o_ReturneeCheckStat(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        Statistic statistic = this.invocationStatistic.getReturneeCheckStat();
        if (statistic != null) {
            Statistic it = statistic;
            boolean bl = false;
            return it;
        }
        InvocationStatistic invocationStatistic = this.invocationStatistic;
        synchronized (invocationStatistic) {
            block5: {
                boolean bl = false;
                Statistic statistic2 = this.invocationStatistic.getReturneeCheckStat();
                if (statistic2 == null) break block5;
                Statistic it = statistic2;
                boolean bl2 = false;
                Statistic statistic3 = it;
                return statistic3;
            }
            A_String name = A_RawFunction.Companion.getMethodName(self);
            Statistic returneeStat2 = returneeCheckStatisticsByName.computeIfAbsent(name, arg_0 -> CompiledCodeDescriptor.o_ReturneeCheckStat$lambda$15$lambda$14(new Function1<A_String, Statistic>(name){
                final /* synthetic */ A_String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                public final Statistic invoke(A_String it) {
                    return new Statistic(StatisticReport.NON_PRIMITIVE_RETURNEE_TYPE_CHECKS, "Checked return into " + A_String.Companion.asNativeString(this.$name));
                }
            }, arg_0));
            this.invocationStatistic.setReturneeCheckStat(returneeStat2);
            Intrinsics.checkNotNullExpressionValue(returneeStat2, "returneeStat");
            Statistic statistic4 = returneeStat2;
            return statistic4;
        }
    }

    @Override
    @NotNull
    public A_Type o_ReturnTypeIfPrimitiveFails(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return A_Type.Companion.getReturnType(self.functionType());
    }

    @Override
    @ThreadSafe
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return SerializerOperation.COMPILED_CODE;
    }

    @Override
    public void o_SetMethodName(@NotNull AvailObject self, @NotNull A_String methodName) {
        block6: {
            boolean bl;
            Intrinsics.checkNotNullParameter(self, "self");
            Intrinsics.checkNotNullParameter(methodName, "methodName");
            boolean bl2 = bl = this.getMutability() == Mutability.SHARED;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl = methodName.isString();
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            methodName.makeShared();
            this.methodName = methodName;
            int counter = 1;
            int i2 = 1;
            int n = A_RawFunction.Companion.getNumLiterals(self);
            if (i2 > n) break block6;
            while (true) {
                block9: {
                    A_RawFunction a_RawFunction;
                    block8: {
                        AvailObject literal;
                        block7: {
                            literal = A_RawFunction.Companion.literalAt(self, i2);
                            if (!literal.isFunction()) break block7;
                            a_RawFunction = literal.code();
                            break block8;
                        }
                        if (!literal.isInstanceOf(CompiledCodeTypeDescriptor.Companion.mostGeneralCompiledCodeType())) break block9;
                        a_RawFunction = literal;
                    }
                    A_RawFunction subCode = a_RawFunction;
                    A_RawFunction.Companion.setMethodName(subCode, ((A_String)A_Tuple.Companion.concatenate((A_Tuple)methodName, (A_Tuple)StringDescriptor.Companion.stringFrom("#" + counter++), true)).makeShared());
                }
                if (i2 == n) break;
                ++i2;
            }
        }
    }

    @Override
    public void o_SetOriginatingPhraseIndex(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter(self, "self");
        this.originatingPhraseIndex = index2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void o_SetStartingChunkAndReoptimizationCountdown(@NotNull AvailObject self, @NotNull L2Chunk chunk, long countdown) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(chunk, "chunk");
        AvailObject availObject = self;
        synchronized (availObject) {
            boolean bl = false;
            this.startingChunk = chunk;
            Unit unit = Unit.INSTANCE;
        }
        this.invocationStatistic.getCountdownToReoptimize().set(countdown);
    }

    @Override
    public boolean o_ShowValueInNameForDebugger(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return false;
    }

    @Override
    @NotNull
    public L2Chunk o_StartingChunk(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        L2Chunk chunk = this.startingChunk;
        boolean bl = chunk.isValid();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (!Intrinsics.areEqual(chunk, L2JVMChunk.Companion.getUnoptimizedChunk())) {
            L2Chunk.Generation.Companion.usedChunk(chunk);
        }
        bl = chunk.isValid();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        return chunk;
    }

    @Override
    public int o_StartingLineNumber(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return this.lineNumber;
    }

    @Override
    public void o_TallyInvocation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        this.invocationStatistic.getTotalInvocations().incrementAndGet();
        this.invocationStatistic.setHasRun(true);
    }

    @Override
    public long o_TotalInvocations(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return this.invocationStatistic.getTotalInvocations().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeTo(AvailObject self, JSONWriter writer, Function1<? super A_Type, Unit> writeFunctionType) {
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter this_$iv2;
            JSONWriter $this$writeTo_u24lambda_u2430 = this_$iv;
            boolean bl = false;
            JSONWriter jSONWriter = $this$writeTo_u24lambda_u2430;
            String key$iv = "kind";
            boolean $i$f$at = false;
            this_$iv2.write(key$iv);
            void $this$writeTo_u24lambda_u2430_u24lambda_u2417 = this_$iv2;
            boolean bl2 = false;
            $this$writeTo_u24lambda_u2430_u24lambda_u2417.write("function implementation");
            this_$iv2 = $this$writeTo_u24lambda_u2430;
            key$iv = "outers";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2418 = this_$iv2;
            boolean bl3 = false;
            $this$writeTo_u24lambda_u2430_u24lambda_u2418.write(self.slot(IntegerSlots.Companion.getNUM_OUTERS()));
            this_$iv2 = $this$writeTo_u24lambda_u2430;
            key$iv = "arguments";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2419 = this_$iv2;
            boolean bl4 = false;
            $this$writeTo_u24lambda_u2430_u24lambda_u2419.write(self.slot(IntegerSlots.Companion.getNUM_ARGS()));
            this_$iv2 = $this$writeTo_u24lambda_u2430;
            key$iv = "locals";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2420 = this_$iv2;
            boolean bl5 = false;
            $this$writeTo_u24lambda_u2430_u24lambda_u2420.write(self.slot(IntegerSlots.Companion.getNUM_LOCALS()));
            this_$iv2 = $this$writeTo_u24lambda_u2430;
            key$iv = "constants";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2421 = this_$iv2;
            boolean bl6 = false;
            $this$writeTo_u24lambda_u2430_u24lambda_u2421.write(self.slot(IntegerSlots.Companion.getNUM_CONSTANTS()));
            this_$iv2 = $this$writeTo_u24lambda_u2430;
            key$iv = "maximum stack depth";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2422 = this_$iv2;
            boolean bl7 = false;
            $this$writeTo_u24lambda_u2430_u24lambda_u2422.write(self.slot(IntegerSlots.Companion.getFRAME_SLOTS()));
            this_$iv2 = $this$writeTo_u24lambda_u2430;
            key$iv = "nybbles";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2423 = this_$iv2;
            boolean bl8 = false;
            A_RawFunction.Companion.getNybbles(self).writeTo(writer);
            this_$iv2 = $this$writeTo_u24lambda_u2430;
            key$iv = "function type";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2424 = this_$iv2;
            boolean bl9 = false;
            writeFunctionType.invoke(self.slot(ObjectSlots.FUNCTION_TYPE));
            this_$iv2 = $this$writeTo_u24lambda_u2430;
            key$iv = "method";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2425 = this_$iv2;
            boolean bl10 = false;
            A_RawFunction.Companion.getMethodName(self).writeTo(writer);
            if (this.module.getNotNil()) {
                this_$iv2 = $this$writeTo_u24lambda_u2430;
                key$iv = "module";
                $i$f$at = false;
                this_$iv2.write(key$iv);
                JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2426 = this_$iv2;
                boolean bl11 = false;
                A_Module.Companion.getModuleName(A_RawFunction.Companion.getModule(self)).writeTo(writer);
            }
            this_$iv2 = $this$writeTo_u24lambda_u2430;
            key$iv = "starting line number";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2427 = this_$iv2;
            boolean bl12 = false;
            $this$writeTo_u24lambda_u2430_u24lambda_u2427.write(A_RawFunction.Companion.getCodeStartingLineNumber(self));
            this_$iv2 = $this$writeTo_u24lambda_u2430;
            key$iv = "literals";
            $i$f$at = false;
            this_$iv2.write(key$iv);
            JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2429 = this_$iv2;
            boolean bl13 = false;
            JSONWriter this_$iv3 = $this$writeTo_u24lambda_u2430_u24lambda_u2429;
            boolean $i$f$writeArray = false;
            this_$iv3.startArray();
            try {
                JSONWriter $this$writeTo_u24lambda_u2430_u24lambda_u2429_u24lambda_u2428 = this_$iv3;
                boolean bl14 = false;
                int limit = self.variableObjectSlotsCount();
                int i2 = 1;
                if (i2 <= limit) {
                    while (true) {
                        A_BasicObject literal;
                        if ((literal = (A_BasicObject)self.slot(ObjectSlots.LITERAL_AT_, i2)).isNil()) {
                            literal = IntegerDescriptor.Companion.getZero();
                        }
                        literal.writeSummaryTo(writer);
                        if (i2 == limit) break;
                        ++i2;
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                this_$iv3.endArray();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    @Override
    public void o_WriteSummaryTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(writer, "writer");
        this.writeTo(self, writer, (Function1<? super A_Type, Unit>)new Function1<A_Type, Unit>(writer){
            final /* synthetic */ JSONWriter $writer;
            {
                this.$writer = $writer;
                super(1);
            }

            public final void invoke(@NotNull A_Type $this$writeTo) {
                Intrinsics.checkNotNullParameter($this$writeTo, "$this$writeTo");
                $this$writeTo.writeSummaryTo(this.$writer);
            }
        });
    }

    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(writer, "writer");
        this.writeTo(self, writer, (Function1<? super A_Type, Unit>)new Function1<A_Type, Unit>(writer){
            final /* synthetic */ JSONWriter $writer;
            {
                this.$writer = $writer;
                super(1);
            }

            public final void invoke(@NotNull A_Type $this$writeTo) {
                Intrinsics.checkNotNullParameter($this$writeTo, "$this$writeTo");
                $this$writeTo.writeTo(this.$writer);
            }
        });
    }

    @Deprecated(message="Not supported", replaceWith=@ReplaceWith(expression="newCompiledCode(\n\t\t\tA_Tuple,\n\t\t\tInt,\n\t\t\tA_Type,\n\t\t\tPrimitive?,\n\t\t\tA_Tuple,\n\t\t\tA_Tuple,\n\t\t\tA_Tuple,\n\t\t\tA_Tuple,\n\t\t\tA_Module,\n\t\t\tInt,\n\t\t\tA_Tuple,\n\t\t\tA_Phrase", imports={}))
    @NotNull
    public Void mutable() {
        this.getUnsupported();
        throw new KotlinNothingValueException();
    }

    @Deprecated(message="Not supported", replaceWith=@ReplaceWith(expression="newCompiledCode(\n\t\t\tA_Tuple,\n\t\t\tInt,\n\t\t\tA_Type,\n\t\t\tPrimitive?,\n\t\t\tA_Tuple,\n\t\t\tA_Tuple,\n\t\t\tA_Tuple,\n\t\t\tA_Tuple,\n\t\t\tA_Module,\n\t\t\tInt,\n\t\t\tA_Tuple,\n\t\t\tA_Phrase", imports={}))
    @NotNull
    public Void immutable() {
        this.getUnsupported();
        throw new KotlinNothingValueException();
    }

    @Deprecated(message="Not supported", replaceWith=@ReplaceWith(expression="newCompiledCode(\n\t\t\tA_Tuple,\n\t\t\tInt,\n\t\t\tA_Type,\n\t\t\tPrimitive?,\n\t\t\tA_Tuple,\n\t\t\tA_Tuple,\n\t\t\tA_Tuple,\n\t\t\tA_Tuple,\n\t\t\tA_Module,\n\t\t\tInt,\n\t\t\tA_Tuple,\n\t\t\tA_Phrase", imports={}))
    @NotNull
    public Void shared() {
        this.getUnsupported();
        throw new KotlinNothingValueException();
    }

    private static final Statistic o_ReturnerCheckStat$lambda$11$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Statistic)$tmp0.invoke(p0);
    }

    private static final Statistic o_ReturneeCheckStat$lambda$15$lambda$14(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter($tmp0, "$tmp0");
        return (Statistic)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ InvocationStatistic access$getInvocationStatistic$p(CompiledCodeDescriptor $this) {
        return $this.invocationStatistic;
    }

    public static final /* synthetic */ A_Module access$getModule$p(CompiledCodeDescriptor $this) {
        return $this.module;
    }

    public static final /* synthetic */ L2Chunk access$getStartingChunk$p(CompiledCodeDescriptor $this) {
        return $this.startingChunk;
    }

    public static final /* synthetic */ int access$getLineNumber$p(CompiledCodeDescriptor $this) {
        return $this.lineNumber;
    }

    static {
        Set set2 = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
        Intrinsics.checkNotNullExpressionValue(set2, "synchronizedSet(newSetFromMap(WeakHashMap()))");
        activeRawFunctions = set2;
        codePrimitiveMethod = CheckedMethod.Companion.instanceMethod(A_RawFunction.class, "codePrimitive", Primitive.class, new Class[0]);
        unknownFunctionName = StringDescriptor.Companion.stringFrom("Unknown function").makeShared();
        initialMutableDescriptor = new CompiledCodeDescriptor(Mutability.MUTABLE, NilDescriptor.Companion.getNil(), -1, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), -1, NilDescriptor.Companion.getNil());
        returnerCheckStatisticsByName = new ConcurrentHashMap();
        returneeCheckStatisticsByName = new ConcurrentHashMap();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0001\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0007B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\b"}, d2={"Lavail/descriptor/functions/CompiledCodeDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_OUTERS", "NUM_SLOTS_ARGS_LOCALS_AND_CONSTANTS", "NYBBLECODES_", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH;
        @NotNull
        private static final BitField NUM_OUTERS;
        @NotNull
        private static final BitField FRAME_SLOTS;
        @NotNull
        private static final BitField NUM_ARGS;
        @NotNull
        private static final BitField NUM_LOCALS;
        @NotNull
        private static final BitField NUM_CONSTANTS;
        public static final /* enum */ IntegerSlots HASH_AND_OUTERS;
        public static final /* enum */ IntegerSlots NUM_SLOTS_ARGS_LOCALS_AND_CONSTANTS;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots NYBBLECODES_;
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            HASH_AND_OUTERS = new IntegerSlots();
            NUM_SLOTS_ARGS_LOCALS_AND_CONSTANTS = new IntegerSlots();
            NYBBLECODES_ = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_OUTERS, IntegerSlots.NUM_SLOTS_ARGS_LOCALS_AND_CONSTANTS, IntegerSlots.NYBBLECODES_};
            Companion = new Companion(null);
            HASH = new BitField(HASH_AND_OUTERS, 32, 32, Companion.HASH.1.INSTANCE);
            NUM_OUTERS = new BitField(HASH_AND_OUTERS, 0, 16, Companion.NUM_OUTERS.1.INSTANCE);
            FRAME_SLOTS = new BitField(NUM_SLOTS_ARGS_LOCALS_AND_CONSTANTS, 48, 16, Companion.FRAME_SLOTS.1.INSTANCE);
            NUM_ARGS = new BitField(NUM_SLOTS_ARGS_LOCALS_AND_CONSTANTS, 32, 16, Companion.NUM_ARGS.1.INSTANCE);
            NUM_LOCALS = new BitField(NUM_SLOTS_ARGS_LOCALS_AND_CONSTANTS, 16, 16, Companion.NUM_LOCALS.1.INSTANCE);
            NUM_CONSTANTS = new BitField(NUM_SLOTS_ARGS_LOCALS_AND_CONSTANTS, 0, 16, Companion.NUM_CONSTANTS.1.INSTANCE);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lavail/descriptor/functions/CompiledCodeDescriptor$IntegerSlots$Companion;", "", "()V", "FRAME_SLOTS", "Lavail/descriptor/representation/BitField;", "getFRAME_SLOTS", "()Lavail/descriptor/representation/BitField;", "HASH", "getHASH", "NUM_ARGS", "getNUM_ARGS", "NUM_CONSTANTS", "getNUM_CONSTANTS", "NUM_LOCALS", "getNUM_LOCALS", "NUM_OUTERS", "getNUM_OUTERS", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH() {
                return HASH;
            }

            @NotNull
            public final BitField getNUM_OUTERS() {
                return NUM_OUTERS;
            }

            @NotNull
            public final BitField getFRAME_SLOTS() {
                return FRAME_SLOTS;
            }

            @NotNull
            public final BitField getNUM_ARGS() {
                return NUM_ARGS;
            }

            @NotNull
            public final BitField getNUM_LOCALS() {
                return NUM_LOCALS;
            }

            @NotNull
            public final BitField getNUM_CONSTANTS() {
                return NUM_CONSTANTS;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/functions/CompiledCodeDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "FUNCTION_TYPE", "LITERAL_AT_", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots FUNCTION_TYPE = new ObjectSlots();
        @HideFieldInDebugger
        public static final /* enum */ ObjectSlots LITERAL_AT_ = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.FUNCTION_TYPE, ObjectSlots.LITERAL_AT_};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0010\"\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0016\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lavail/descriptor/functions/CompiledCodeDescriptor$InvocationStatistic;", "", "()V", "countdownToReoptimize", "Ljava/util/concurrent/atomic/AtomicLong;", "getCountdownToReoptimize", "()Ljava/util/concurrent/atomic/AtomicLong;", "hasRun", "", "getHasRun", "()Z", "setHasRun", "(Z)V", "returneeCheckStat", "Lavail/performance/Statistic;", "getReturneeCheckStat", "()Lavail/performance/Statistic;", "setReturneeCheckStat", "(Lavail/performance/Statistic;)V", "returnerCheckStat", "getReturnerCheckStat", "setReturnerCheckStat", "totalInvocations", "getTotalInvocations", "avail"})
    public static final class InvocationStatistic {
        @NotNull
        private final AtomicLong totalInvocations = new AtomicLong(0L);
        @NotNull
        private final AtomicLong countdownToReoptimize = new AtomicLong(OptimizationLevel.UNOPTIMIZED.getCountdown());
        @Nullable
        private volatile Statistic returnerCheckStat;
        @Nullable
        private volatile Statistic returneeCheckStat;
        private volatile boolean hasRun;

        @NotNull
        public final AtomicLong getTotalInvocations() {
            return this.totalInvocations;
        }

        @NotNull
        public final AtomicLong getCountdownToReoptimize() {
            return this.countdownToReoptimize;
        }

        @Nullable
        public final Statistic getReturnerCheckStat() {
            return this.returnerCheckStat;
        }

        public final void setReturnerCheckStat(@Nullable Statistic statistic) {
            this.returnerCheckStat = statistic;
        }

        @Nullable
        public final Statistic getReturneeCheckStat() {
            return this.returneeCheckStat;
        }

        public final void setReturneeCheckStat(@Nullable Statistic statistic) {
            this.returneeCheckStat = statistic;
        }

        public final boolean getHasRun() {
            return this.hasRun;
        }

        public final void setHasRun(boolean bl) {
            this.hasRun = bl;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\nJ\u0006\u0010\u0019\u001a\u00020\nJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\nJ\u0006\u0010\u001d\u001a\u00020\nJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\nJ\b\u0010\u001f\u001a\u00020 H\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u000e\u00a8\u0006\""}, d2={"Lavail/descriptor/functions/CompiledCodeDescriptor$L1InstructionDecoder;", "", "()V", "encodedInstructionsArray", "", "getEncodedInstructionsArray", "()[J", "setEncodedInstructionsArray", "([J)V", "finalLongIndex", "", "getFinalLongIndex", "()I", "setFinalLongIndex", "(I)V", "finalShift", "getFinalShift", "setFinalShift", "longIndex", "shift", "getShift", "setShift", "atEnd", "", "getNybble", "getOperand", "getOperation", "Lavail/interpreter/levelOne/L1Operation;", "getOperationOrdinal", "pc", "", "toString", "", "Companion", "avail"})
    public static final class L1InstructionDecoder {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private long[] encodedInstructionsArray = emptyArray;
        private int finalLongIndex = -1;
        private int finalShift = -1;
        private int longIndex = -1;
        private int shift = -1;
        public static final int baseIndexInArray = 2;
        @NotNull
        private static final long[] emptyArray;

        @NotNull
        public final long[] getEncodedInstructionsArray() {
            return this.encodedInstructionsArray;
        }

        public final void setEncodedInstructionsArray(@NotNull long[] lArray) {
            Intrinsics.checkNotNullParameter(lArray, "<set-?>");
            this.encodedInstructionsArray = lArray;
        }

        public final int getFinalLongIndex() {
            return this.finalLongIndex;
        }

        public final void setFinalLongIndex(int n) {
            this.finalLongIndex = n;
        }

        public final int getFinalShift() {
            return this.finalShift;
        }

        public final void setFinalShift(int n) {
            this.finalShift = n;
        }

        public final int getShift() {
            return this.shift;
        }

        public final void setShift(int n) {
            this.shift = n;
        }

        public final void pc(int pc) {
            this.longIndex = 2 + (pc >> 4);
            this.shift = (pc & 0xF) << 2;
        }

        public final int pc() {
            return (this.longIndex - 2 << 4) + (this.shift >> 2);
        }

        public final int getNybble() {
            int result2 = (int)(this.encodedInstructionsArray[this.longIndex] >> this.shift & 0xFL);
            int newShift = this.shift + 4;
            this.longIndex += newShift >> 6;
            this.shift = newShift & 0x3F;
            return result2;
        }

        @NotNull
        public final L1Operation getOperation() {
            int index2 = this.getNybble();
            if (index2 == 15) {
                index2 = 16 + this.getNybble();
            }
            return L1Operation.Companion.lookup(index2);
        }

        public final int getOperationOrdinal() {
            int index2 = this.getNybble();
            if (index2 == 15) {
                index2 = 16 + this.getNybble();
            }
            return index2;
        }

        public final int getOperand() {
            int firstNybble = this.getNybble();
            int encodeShift = firstNybble << 2;
            int count = 0xF & (int)(-8925834294773940224L >>> encodeShift);
            int value = 0;
            while (count-- > 0) {
                value = (value << 4) + this.getNybble();
            }
            int lowOff = 0xF & (int)(48038317837791760L >>> encodeShift);
            int highOff = 0xF & (int)(14091341021577216L >>> encodeShift);
            return value + lowOff + (highOff << 4);
        }

        public final boolean atEnd() {
            return this.longIndex == this.finalLongIndex && this.shift == this.finalShift;
        }

        @NotNull
        public String toString() {
            return super.toString() + "(pc=" + this.pc() + ")";
        }

        static {
            boolean bl;
            Companion = new Companion(null);
            boolean bl2 = bl = 2 == IntegerSlots.NYBBLECODES_.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            emptyArray = new long[0];
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0016\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/functions/CompiledCodeDescriptor$L1InstructionDecoder$Companion;", "", "()V", "baseIndexInArray", "", "emptyArray", "", "avail"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0012\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lavail/descriptor/functions/CompiledCodeDescriptor$CodeCoverageReport;", "", "hasRun", "", "isTranslated", "startingLineNumber", "", "moduleName", "", "methodName", "(ZZILjava/lang/String;Ljava/lang/String;)V", "getMethodName", "()Ljava/lang/String;", "getModuleName", "getStartingLineNumber", "()I", "compareTo", "other", "toString", "avail"})
    public static final class CodeCoverageReport
    implements Comparable<CodeCoverageReport> {
        private final boolean hasRun;
        private final boolean isTranslated;
        private final int startingLineNumber;
        @NotNull
        private final String moduleName;
        @NotNull
        private final String methodName;

        public CodeCoverageReport(boolean hasRun, boolean isTranslated, int startingLineNumber, @NotNull String moduleName2, @NotNull String methodName) {
            Intrinsics.checkNotNullParameter(moduleName2, "moduleName");
            Intrinsics.checkNotNullParameter(methodName, "methodName");
            this.hasRun = hasRun;
            this.isTranslated = isTranslated;
            this.startingLineNumber = startingLineNumber;
            this.moduleName = moduleName2;
            this.methodName = methodName;
        }

        public final int getStartingLineNumber() {
            return this.startingLineNumber;
        }

        @NotNull
        public final String getModuleName() {
            return this.moduleName;
        }

        @NotNull
        public final String getMethodName() {
            return this.methodName;
        }

        @Override
        public int compareTo(@NotNull CodeCoverageReport other) {
            Intrinsics.checkNotNullParameter(other, "other");
            int moduleComp = this.moduleName.compareTo(other.moduleName);
            if (moduleComp != 0) {
                return moduleComp;
            }
            int lineComp = Intrinsics.compare(this.startingLineNumber, other.startingLineNumber);
            return lineComp != 0 ? lineComp : this.methodName.compareTo(other.methodName);
        }

        @NotNull
        public String toString() {
            String string2 = "%c %c  m: %s,  l: %d,  f: %s";
            Object[] objectArray = new Object[]{Character.valueOf(this.hasRun ? (char)'r' : ' '), Character.valueOf(this.isTranslated ? (char)'t' : ' '), this.moduleName, this.startingLineNumber, this.methodName};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "format(format, *args)");
            return string3;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0019\u001a\u00020\u001a2\u0018\u0010\u001b\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001e0\u001d\u0012\u0004\u0012\u00020\u001a0\u001cJ\u0080\u0001\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\"2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020$2\u0006\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020$2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u0010J\u0014\u00106\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a07R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u00068"}, d2={"Lavail/descriptor/functions/CompiledCodeDescriptor$Companion;", "", "()V", "activeRawFunctions", "", "Lavail/descriptor/functions/A_RawFunction;", "codePrimitiveMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getCodePrimitiveMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "initialMutableDescriptor", "Lavail/descriptor/functions/CompiledCodeDescriptor;", "getInitialMutableDescriptor", "()Lavail/descriptor/functions/CompiledCodeDescriptor;", "returneeCheckStatisticsByName", "Ljava/util/concurrent/ConcurrentMap;", "Lavail/descriptor/tuples/A_String;", "Lavail/performance/Statistic;", "getReturneeCheckStatisticsByName", "()Ljava/util/concurrent/ConcurrentMap;", "returnerCheckStatisticsByName", "getReturnerCheckStatisticsByName", "unknownFunctionName", "getUnknownFunctionName", "()Lavail/descriptor/tuples/A_String;", "codeCoverageReportsThen", "", "resume", "Lkotlin/Function1;", "", "Lavail/descriptor/functions/CompiledCodeDescriptor$CodeCoverageReport;", "newCompiledCode", "Lavail/descriptor/representation/AvailObject;", "nybbles", "Lavail/descriptor/tuples/A_Tuple;", "stackDepth", "", "functionType", "Lavail/descriptor/types/A_Type;", "primitive", "Lavail/interpreter/Primitive;", "returnTypeIfPrimitiveFails", "literals", "localVariableTypes", "localConstantTypes", "outerTypes", "module", "Lavail/descriptor/module/A_Module;", "lineNumber", "lineNumberEncodedDeltas", "originatingPhraseIndex", "originatingPhrase", "Lavail/descriptor/phrases/A_Phrase;", "packedDeclarationNames", "resetCodeCoverageDetailsThen", "Lkotlin/Function0;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final void resetCodeCoverageDetailsThen(@NotNull Function0<Unit> resume) {
            Intrinsics.checkNotNullParameter(resume, "resume");
            AvailRuntime.Companion.currentRuntime().whenSafePointDo(50, new Function0<Unit>(resume){
                final /* synthetic */ Function0<Unit> $resume;
                {
                    this.$resume = $resume;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke() {
                    Lock lock = L2Chunk.Companion.getInvalidationLock();
                    Function0<Unit> function0 = this.$resume;
                    lock.lock();
                    try {
                        boolean bl = false;
                        Iterator<E> iterator2 = CompiledCodeDescriptor.access$getActiveRawFunctions$cp().iterator();
                        while (iterator2.hasNext()) {
                            L2Chunk chunk;
                            A_RawFunction rawFunction2;
                            A_RawFunction $this$cast$iv = rawFunction2 = (A_RawFunction)iterator2.next();
                            boolean $i$f$cast = false;
                            AvailObject self = (AvailObject)$this$cast$iv;
                            AbstractDescriptor $this$cast$iv2 = self.descriptor();
                            boolean $i$f$cast2 = false;
                            CompiledCodeDescriptor descriptor2 = (CompiledCodeDescriptor)$this$cast$iv2;
                            CompiledCodeDescriptor.access$getInvocationStatistic$p(descriptor2).setHasRun(false);
                            if (!CompiledCodeDescriptor.access$getModule$p(descriptor2).getNotNil() || Intrinsics.areEqual(chunk = CompiledCodeDescriptor.access$getStartingChunk$p(descriptor2), L2JVMChunk.Companion.getUnoptimizedChunk())) continue;
                            chunk.invalidate(L2Chunk.InvalidationReason.CODE_COVERAGE);
                        }
                        AvailRuntime.Companion.currentRuntime().whenRunningInterpretersDo(50, function0);
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            });
        }

        public final void codeCoverageReportsThen(@NotNull Function1<? super List<CodeCoverageReport>, Unit> resume) {
            Intrinsics.checkNotNullParameter(resume, "resume");
            AvailRuntime.Companion.currentRuntime().whenSafePointDo(50, new Function0<Unit>(resume){
                final /* synthetic */ Function1<List<CodeCoverageReport>, Unit> $resume;
                {
                    this.$resume = $resume;
                    super(0);
                }

                public final void invoke() {
                    List reports = new ArrayList<E>();
                    Iterator<E> iterator2 = CompiledCodeDescriptor.access$getActiveRawFunctions$cp().iterator();
                    while (iterator2.hasNext()) {
                        CodeCoverageReport report2;
                        A_RawFunction rawFunction2;
                        A_RawFunction $this$cast$iv = rawFunction2 = (A_RawFunction)iterator2.next();
                        boolean $i$f$cast = false;
                        AvailObject self = (AvailObject)$this$cast$iv;
                        AbstractDescriptor $this$cast$iv2 = self.descriptor();
                        boolean $i$f$cast2 = false;
                        CompiledCodeDescriptor descriptor2 = (CompiledCodeDescriptor)$this$cast$iv2;
                        A_Module module = CompiledCodeDescriptor.access$getModule$p(descriptor2);
                        if (!module.getNotNil() || reports.contains(report2 = new CodeCoverageReport(CompiledCodeDescriptor.access$getInvocationStatistic$p(descriptor2).getHasRun(), !Intrinsics.areEqual(CompiledCodeDescriptor.access$getStartingChunk$p(descriptor2), L2JVMChunk.Companion.getUnoptimizedChunk()), CompiledCodeDescriptor.access$getLineNumber$p(descriptor2), A_Module.Companion.getModuleNameNative(module), A_String.Companion.asNativeString(descriptor2.getMethodName())))) continue;
                        reports.add(report2);
                    }
                    AvailRuntime.Companion.currentRuntime().whenRunningInterpretersDo(50, new Function0<Unit>(this.$resume, (List<CodeCoverageReport>)reports){
                        final /* synthetic */ Function1<List<CodeCoverageReport>, Unit> $resume;
                        final /* synthetic */ List<CodeCoverageReport> $reports;
                        {
                            this.$resume = $resume;
                            this.$reports = $reports;
                            super(0);
                        }

                        public final void invoke() {
                            this.$resume.invoke(this.$reports);
                        }
                    });
                }
            });
        }

        @NotNull
        public final CheckedMethod getCodePrimitiveMethod() {
            return codePrimitiveMethod;
        }

        @NotNull
        public final A_String getUnknownFunctionName() {
            return unknownFunctionName;
        }

        @NotNull
        public final AvailObject newCompiledCode(@NotNull A_Tuple nybbles2, int stackDepth, @NotNull A_Type functionType, @Nullable Primitive primitive2, @NotNull A_Type returnTypeIfPrimitiveFails, @NotNull A_Tuple literals, @NotNull A_Tuple localVariableTypes, @NotNull A_Tuple localConstantTypes, @NotNull A_Tuple outerTypes2, @NotNull A_Module module, int lineNumber, @NotNull A_Tuple lineNumberEncodedDeltas, int originatingPhraseIndex, @NotNull A_Phrase originatingPhrase, @NotNull A_String packedDeclarationNames2) {
            boolean bl;
            boolean bl2;
            Intrinsics.checkNotNullParameter(nybbles2, "nybbles");
            Intrinsics.checkNotNullParameter(functionType, "functionType");
            Intrinsics.checkNotNullParameter(returnTypeIfPrimitiveFails, "returnTypeIfPrimitiveFails");
            Intrinsics.checkNotNullParameter(literals, "literals");
            Intrinsics.checkNotNullParameter(localVariableTypes, "localVariableTypes");
            Intrinsics.checkNotNullParameter(localConstantTypes, "localConstantTypes");
            Intrinsics.checkNotNullParameter(outerTypes2, "outerTypes");
            Intrinsics.checkNotNullParameter(module, "module");
            Intrinsics.checkNotNullParameter(lineNumberEncodedDeltas, "lineNumberEncodedDeltas");
            Intrinsics.checkNotNullParameter(originatingPhrase, "originatingPhrase");
            Intrinsics.checkNotNullParameter(packedDeclarationNames2, "packedDeclarationNames");
            if (primitive2 != null) {
                boolean bl3;
                canHaveCode = primitive2.canHaveNybblecodes();
                boolean bl4 = bl3 = canHaveCode == A_Tuple.Companion.getTupleSize(nybbles2) > 0;
                if (_Assertions.ENABLED && !bl3) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Type restrictionSignature = primitive2.blockTypeRestriction();
                bl2 = A_Type.Companion.isSubtypeOf(restrictionSignature, functionType);
                if (_Assertions.ENABLED && !bl2) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
            } else {
                boolean bl5 = canHaveCode = A_Tuple.Companion.getTupleSize(nybbles2) > 0;
                if (_Assertions.ENABLED && !canHaveCode) {
                    String restrictionSignature = "Assertion failed";
                    throw new AssertionError((Object)restrictionSignature);
                }
            }
            A_Type argCounts = A_Type.Companion.getSizeRange(A_Type.Companion.getArgsTupleType(functionType));
            int numArgs = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(argCounts));
            boolean bl6 = bl2 = A_Number.Companion.getExtractInt(A_Type.Companion.getUpperBound(argCounts)) == numArgs;
            if (_Assertions.ENABLED && !bl2) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            int numLocals = A_Tuple.Companion.getTupleSize(localVariableTypes);
            int numConstants = A_Tuple.Companion.getTupleSize(localConstantTypes);
            int numLiterals = A_Tuple.Companion.getTupleSize(literals);
            int numOuters = A_Tuple.Companion.getTupleSize(outerTypes2);
            int numSlots = numArgs + numLocals + numConstants + stackDepth;
            boolean bl7 = 0 <= numSlots ? numSlots < 65536 : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string5 = "Assertion failed";
                throw new AssertionError((Object)string5);
            }
            boolean bl8 = 0 <= numArgs ? numArgs < 65536 : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string6 = "Assertion failed";
                throw new AssertionError((Object)string6);
            }
            boolean bl9 = 0 <= numLocals ? numLocals < 65536 : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string7 = "Assertion failed";
                throw new AssertionError((Object)string7);
            }
            boolean bl10 = 0 <= numConstants ? numConstants < 65536 : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string8 = "Assertion failed";
                throw new AssertionError((Object)string8);
            }
            boolean bl11 = 0 <= numLiterals ? numLiterals < 65536 : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string9 = "Assertion failed";
                throw new AssertionError((Object)string9);
            }
            boolean bl12 = 0 <= numOuters ? numOuters < 65536 : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string10 = "Assertion failed";
                throw new AssertionError((Object)string10);
            }
            boolean bl13 = bl = module.isNil() || module.isInstanceOf(PrimitiveTypeDescriptor.Types.MODULE.getO());
            if (_Assertions.ENABLED && !bl) {
                String string11 = "Assertion failed";
                throw new AssertionError((Object)string11);
            }
            boolean bl14 = bl = lineNumber >= 0;
            if (_Assertions.ENABLED && !bl) {
                String string12 = "Assertion failed";
                throw new AssertionError((Object)string12);
            }
            int nybbleCount = A_Tuple.Companion.getTupleSize(nybbles2);
            AvailObject code = AvailObject.Companion.newObjectIndexedIntegerIndexedDescriptor(numLiterals + numOuters + numLocals + numConstants, nybbleCount == 0 ? 0 : nybbleCount + 16 >> 4, this.getInitialMutableDescriptor());
            code.setSlot(IntegerSlots.Companion.getFRAME_SLOTS(), numSlots);
            code.setSlot(IntegerSlots.Companion.getNUM_ARGS(), numArgs);
            code.setSlot(IntegerSlots.Companion.getNUM_LOCALS(), numLocals);
            code.setSlot(IntegerSlots.Companion.getNUM_CONSTANTS(), numConstants);
            code.setSlot(IntegerSlots.Companion.getNUM_OUTERS(), numOuters);
            code.setSlot(ObjectSlots.FUNCTION_TYPE, functionType.makeShared());
            if (nybbleCount > 0) {
                int longIndex = 1;
                long currentLong = 15 - nybbleCount & 0xF;
                int i2 = 1;
                if (i2 <= nybbleCount) {
                    while (true) {
                        int subIndex;
                        if ((subIndex = i2 & 0xF) == 0) {
                            code.setSlot(IntegerSlots.NYBBLECODES_, longIndex++, currentLong);
                            currentLong = 0L;
                        }
                        long nybble = A_Tuple.Companion.tupleIntAt(nybbles2, i2);
                        currentLong |= nybble << (subIndex << 2);
                        if (i2 == nybbleCount) break;
                        ++i2;
                    }
                }
                code.setSlot(IntegerSlots.NYBBLECODES_, longIndex, currentLong);
            }
            int literalIndex2 = 1;
            A_Tuple[] a_TupleArray = new A_Tuple[]{literals, outerTypes2, localVariableTypes, localConstantTypes};
            for (A_Tuple tuple2 : CollectionsKt.listOf(a_TupleArray)) {
                code.setSlotsFromTuple(ObjectSlots.LITERAL_AT_, literalIndex2, tuple2.makeShared(), 1, A_Tuple.Companion.getTupleSize(tuple2));
                literalIndex2 += A_Tuple.Companion.getTupleSize(tuple2);
            }
            code.setSlot(IntegerSlots.Companion.getHASH(), AvailRuntimeSupport.INSTANCE.nextNonzeroHash());
            if (primitive2 != null) {
                code.setDescriptor(new PrimitiveCompiledCodeDescriptor(Mutability.SHARED, primitive2, returnTypeIfPrimitiveFails.makeShared(), module.makeShared(), originatingPhraseIndex, originatingPhrase.makeShared(), packedDeclarationNames2.makeShared(), lineNumber, lineNumberEncodedDeltas.makeShared()));
            } else {
                code.setDescriptor(new CompiledCodeDescriptor(Mutability.SHARED, module.makeShared(), originatingPhraseIndex, originatingPhrase.makeShared(), packedDeclarationNames2.makeShared(), lineNumber, lineNumberEncodedDeltas.makeShared()));
            }
            activeRawFunctions.add(code);
            return code;
        }

        @NotNull
        public final CompiledCodeDescriptor getInitialMutableDescriptor() {
            return initialMutableDescriptor;
        }

        @NotNull
        public final ConcurrentMap<A_String, Statistic> getReturnerCheckStatisticsByName() {
            return returnerCheckStatisticsByName;
        }

        @NotNull
        public final ConcurrentMap<A_String, Statistic> getReturneeCheckStatisticsByName() {
            return returneeCheckStatisticsByName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

