/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.numbers;

import avail.annotations.ThreadSafe;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.AbstractNumberDescriptor;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TypeTag;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.serialization.SerializerOperation;
import java.util.IdentityHashMap;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 O2\u00020\u0001:\u0002OPB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\b\u0010\u0006\u001a\u00020\u0000H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0010\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0015\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0017\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020 2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010&\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010'\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010+\u001a\u00020)2\u0006\u0010\t\u001a\u00020\nH\u0016J#\u0010,\u001a\u00020 2\u0006\u0010\t\u001a\u00020\n2\f\u0010-\u001a\b\u0012\u0002\b\u0003\u0018\u00010.H\u0016\u00a2\u0006\u0002\u0010/J \u00100\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u00101\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u00102\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u00103\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J \u00104\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u00105\u001a\u0002062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\bH\u0016J\u0018\u00107\u001a\u0002062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u00108\u001a\u0002062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u00109\u001a\u0002062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nH\u0016J \u0010:\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010;\u001a\u00020<2\u0006\u0010\t\u001a\u00020\nH\u0017J \u0010=\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010>\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010?\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010@\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0016J \u0010A\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010B\u001a\u00020C2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010D\u001a\u00020EH\u0016J8\u0010F\u001a\u00020C2\u0006\u0010\t\u001a\u00020\n2\n\u0010G\u001a\u00060Hj\u0002`I2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020L0K2\u0006\u0010M\u001a\u00020%H\u0016J\b\u0010N\u001a\u00020\u0000H\u0016\u00a8\u0006Q"}, d2={"Lavail/descriptor/numbers/DoubleDescriptor;", "Lavail/descriptor/numbers/AbstractNumberDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "(Lavail/descriptor/representation/Mutability;)V", "immutable", "mutable", "o_AddToDoubleCanDestroy", "Lavail/descriptor/numbers/A_Number;", "self", "Lavail/descriptor/representation/AvailObject;", "doubleObject", "canDestroy", "", "o_AddToFloatCanDestroy", "floatObject", "o_AddToInfinityCanDestroy", "sign", "Lavail/descriptor/numbers/AbstractNumberDescriptor$Sign;", "o_AddToIntegerCanDestroy", "anInteger", "o_DivideCanDestroy", "aNumber", "o_DivideIntoDoubleCanDestroy", "o_DivideIntoFloatCanDestroy", "o_DivideIntoInfinityCanDestroy", "o_DivideIntoIntegerCanDestroy", "o_Equals", "another", "Lavail/descriptor/representation/A_BasicObject;", "o_EqualsDouble", "aDouble", "", "o_ExtractDouble", "o_ExtractFloat", "", "o_Hash", "", "o_IsDouble", "o_IsInstanceOfKind", "aType", "Lavail/descriptor/types/A_Type;", "o_IsNumericallyIntegral", "o_Kind", "o_MarshalToJava", "classHint", "Ljava/lang/Class;", "(Lavail/descriptor/representation/AvailObject;Ljava/lang/Class;)Ljava/lang/Double;", "o_MinusCanDestroy", "o_MultiplyByDoubleCanDestroy", "o_MultiplyByFloatCanDestroy", "o_MultiplyByInfinityCanDestroy", "o_MultiplyByIntegerCanDestroy", "o_NumericCompare", "Lavail/descriptor/numbers/AbstractNumberDescriptor$Order;", "o_NumericCompareToDouble", "o_NumericCompareToInfinity", "o_NumericCompareToInteger", "o_PlusCanDestroy", "o_SerializerOperation", "Lavail/serialization/SerializerOperation;", "o_SubtractFromDoubleCanDestroy", "o_SubtractFromFloatCanDestroy", "o_SubtractFromInfinityCanDestroy", "o_SubtractFromIntegerCanDestroy", "o_TimesCanDestroy", "o_WriteTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "printObjectOnAvoidingIndent", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "recursionMap", "Ljava/util/IdentityHashMap;", "Ljava/lang/Void;", "indent", "shared", "Companion", "IntegerSlots", "avail"})
public final class DoubleDescriptor
extends AbstractNumberDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CheckedMethod fromDoubleMethod;
    @NotNull
    private static final DoubleDescriptor mutable;
    @NotNull
    private static final DoubleDescriptor immutable;
    @NotNull
    private static final DoubleDescriptor shared;

    private DoubleDescriptor(Mutability mutability) {
        super(mutability, TypeTag.DOUBLE_TAG, null, IntegerSlots.class);
    }

    @Override
    public void printObjectOnAvoidingIndent(@NotNull AvailObject self, @NotNull StringBuilder builder, @NotNull IdentityHashMap<A_BasicObject, Void> recursionMap, int indent) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(recursionMap, "recursionMap");
        builder.append(DoubleDescriptor.Companion.getDouble(self));
    }

    @Override
    @NotNull
    public A_Number o_AddToInfinityCanDestroy(@NotNull AvailObject self, @NotNull AbstractNumberDescriptor.Sign sign, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter((Object)sign, "sign");
        return Companion.fromDoubleRecycling(sign.limitDouble() + DoubleDescriptor.Companion.getDouble(self), self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_AddToIntegerCanDestroy(@NotNull AvailObject self, @NotNull AvailObject anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anInteger, "anInteger");
        double sum = Companion.addDoubleAndIntegerCanDestroy(DoubleDescriptor.Companion.getDouble(self), anInteger, canDestroy);
        return Companion.fromDoubleRecycling(sum, self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_AddToDoubleCanDestroy(@NotNull AvailObject self, @NotNull A_Number doubleObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(doubleObject, "doubleObject");
        return Companion.objectFromDoubleRecycling(DoubleDescriptor.Companion.getDouble(self) + A_Number.Companion.getExtractDouble(doubleObject), self, doubleObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_AddToFloatCanDestroy(@NotNull AvailObject self, @NotNull A_Number floatObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(floatObject, "floatObject");
        return Companion.fromDoubleRecycling(DoubleDescriptor.Companion.getDouble(self) + A_Number.Companion.getExtractDouble(floatObject), self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_DivideCanDestroy(@NotNull AvailObject self, @NotNull A_Number aNumber, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aNumber, "aNumber");
        return A_Number.Companion.divideIntoDoubleCanDestroy(aNumber, self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_DivideIntoInfinityCanDestroy(@NotNull AvailObject self, @NotNull AbstractNumberDescriptor.Sign sign, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter((Object)sign, "sign");
        return Companion.fromDoubleRecycling(sign.limitDouble() / DoubleDescriptor.Companion.getDouble(self), self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_DivideIntoIntegerCanDestroy(@NotNull AvailObject self, @NotNull AvailObject anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anInteger, "anInteger");
        return Companion.fromDoubleRecycling(A_Number.Companion.getExtractDouble(anInteger) / DoubleDescriptor.Companion.getDouble(self), self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_DivideIntoDoubleCanDestroy(@NotNull AvailObject self, @NotNull A_Number doubleObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(doubleObject, "doubleObject");
        return Companion.objectFromDoubleRecycling(A_Number.Companion.getExtractDouble(doubleObject) / DoubleDescriptor.Companion.getDouble(self), self, doubleObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_DivideIntoFloatCanDestroy(@NotNull AvailObject self, @NotNull A_Number floatObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(floatObject, "floatObject");
        return Companion.fromDoubleRecycling(A_Number.Companion.getExtractDouble(floatObject) / DoubleDescriptor.Companion.getDouble(self), self, canDestroy);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        if (!A_Number.Companion.equalsDouble((A_Number)another, DoubleDescriptor.Companion.getDouble(self))) {
            return false;
        }
        if (!this.isShared()) {
            self.becomeIndirectionTo(another.makeImmutable());
        } else if (!another.descriptor().isShared()) {
            another.becomeIndirectionTo(self.makeImmutable());
        }
        return true;
    }

    @Override
    public boolean o_EqualsDouble(@NotNull AvailObject self, double aDouble) {
        Intrinsics.checkNotNullParameter(self, "self");
        return Double.doubleToRawLongBits(DoubleDescriptor.Companion.getDouble(self)) == Double.doubleToRawLongBits(aDouble);
    }

    @Override
    public double o_ExtractDouble(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return DoubleDescriptor.Companion.getDouble(self);
    }

    @Override
    public float o_ExtractFloat(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return (float)DoubleDescriptor.Companion.getDouble(self);
    }

    @Override
    public int o_Hash(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        long bits = self.slot(IntegerSlots.LONG_BITS);
        boolean bl = false;
        return AvailObject.Companion.combine3((int)(bits >> 32), (int)bits, 1204048893);
    }

    @Override
    public boolean o_IsDouble(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return true;
    }

    @Override
    public boolean o_IsInstanceOfKind(@NotNull AvailObject self, @NotNull A_Type aType) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aType, "aType");
        return A_Type.Companion.isSupertypeOfPrimitiveTypeEnum(aType, PrimitiveTypeDescriptor.Types.DOUBLE);
    }

    @Override
    public boolean o_IsNumericallyIntegral(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        double it = DoubleDescriptor.Companion.getDouble(self);
        boolean bl = false;
        return !Double.isInfinite(it) && !Double.isNaN(it) && Math.floor(it) == it;
    }

    @Override
    @NotNull
    public A_Type o_Kind(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return PrimitiveTypeDescriptor.Types.DOUBLE.getO();
    }

    @Override
    @NotNull
    public Double o_MarshalToJava(@NotNull AvailObject self, @Nullable Class<?> classHint) {
        Intrinsics.checkNotNullParameter(self, "self");
        return DoubleDescriptor.Companion.getDouble(self);
    }

    @Override
    @NotNull
    public A_Number o_MinusCanDestroy(@NotNull AvailObject self, @NotNull A_Number aNumber, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aNumber, "aNumber");
        return A_Number.Companion.subtractFromDoubleCanDestroy(aNumber, self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_MultiplyByInfinityCanDestroy(@NotNull AvailObject self, @NotNull AbstractNumberDescriptor.Sign sign, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter((Object)sign, "sign");
        return Companion.fromDoubleRecycling(sign.limitDouble() * DoubleDescriptor.Companion.getDouble(self), self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_MultiplyByIntegerCanDestroy(@NotNull AvailObject self, @NotNull AvailObject anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anInteger, "anInteger");
        return Companion.fromDoubleRecycling(A_Number.Companion.getExtractDouble(anInteger) * DoubleDescriptor.Companion.getDouble(self), self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_MultiplyByDoubleCanDestroy(@NotNull AvailObject self, @NotNull A_Number doubleObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(doubleObject, "doubleObject");
        return Companion.objectFromDoubleRecycling(A_Number.Companion.getExtractDouble(doubleObject) * DoubleDescriptor.Companion.getDouble(self), self, doubleObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_MultiplyByFloatCanDestroy(@NotNull AvailObject self, @NotNull A_Number floatObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(floatObject, "floatObject");
        return Companion.fromDoubleRecycling(A_Number.Companion.getExtractDouble(floatObject) * DoubleDescriptor.Companion.getDouble(self), self, canDestroy);
    }

    @Override
    @NotNull
    public AbstractNumberDescriptor.Order o_NumericCompare(@NotNull AvailObject self, @NotNull A_Number another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return A_Number.Companion.numericCompareToDouble(another, DoubleDescriptor.Companion.getDouble(self)).reverse();
    }

    @Override
    @NotNull
    public AbstractNumberDescriptor.Order o_NumericCompareToInfinity(@NotNull AvailObject self, @NotNull AbstractNumberDescriptor.Sign sign) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter((Object)sign, "sign");
        double thisDouble = DoubleDescriptor.Companion.getDouble(self);
        if (Double.isNaN(thisDouble)) {
            return AbstractNumberDescriptor.Order.INCOMPARABLE;
        }
        int comparison = Double.compare(thisDouble, sign.limitDouble());
        return comparison < 0 ? AbstractNumberDescriptor.Order.LESS : (comparison > 0 ? AbstractNumberDescriptor.Order.MORE : AbstractNumberDescriptor.Order.EQUAL);
    }

    @Override
    @NotNull
    public AbstractNumberDescriptor.Order o_NumericCompareToInteger(@NotNull AvailObject self, @NotNull AvailObject anInteger) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anInteger, "anInteger");
        return Companion.compareDoubleAndInteger(DoubleDescriptor.Companion.getDouble(self), anInteger);
    }

    @Override
    @NotNull
    public AbstractNumberDescriptor.Order o_NumericCompareToDouble(@NotNull AvailObject self, double aDouble) {
        Intrinsics.checkNotNullParameter(self, "self");
        return Companion.compareDoubles(DoubleDescriptor.Companion.getDouble(self), aDouble);
    }

    @Override
    @NotNull
    public A_Number o_PlusCanDestroy(@NotNull AvailObject self, @NotNull A_Number aNumber, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aNumber, "aNumber");
        return A_Number.Companion.addToDoubleCanDestroy(aNumber, self, canDestroy);
    }

    @Override
    @ThreadSafe
    @NotNull
    public SerializerOperation o_SerializerOperation(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return SerializerOperation.DOUBLE;
    }

    @Override
    @NotNull
    public A_Number o_SubtractFromInfinityCanDestroy(@NotNull AvailObject self, @NotNull AbstractNumberDescriptor.Sign sign, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter((Object)sign, "sign");
        return Companion.fromDoubleRecycling(sign.limitDouble() - DoubleDescriptor.Companion.getDouble(self), self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_SubtractFromIntegerCanDestroy(@NotNull AvailObject self, @NotNull AvailObject anInteger, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anInteger, "anInteger");
        return Companion.fromDoubleRecycling(Companion.addDoubleAndIntegerCanDestroy(-DoubleDescriptor.Companion.getDouble(self), anInteger, canDestroy), self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_SubtractFromDoubleCanDestroy(@NotNull AvailObject self, @NotNull A_Number doubleObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(doubleObject, "doubleObject");
        return Companion.objectFromDoubleRecycling(A_Number.Companion.getExtractDouble(doubleObject) - DoubleDescriptor.Companion.getDouble(self), self, doubleObject, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_SubtractFromFloatCanDestroy(@NotNull AvailObject self, @NotNull A_Number floatObject, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(floatObject, "floatObject");
        return Companion.fromDoubleRecycling(A_Number.Companion.getExtractDouble(floatObject) - DoubleDescriptor.Companion.getDouble(self), self, canDestroy);
    }

    @Override
    @NotNull
    public A_Number o_TimesCanDestroy(@NotNull AvailObject self, @NotNull A_Number aNumber, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aNumber, "aNumber");
        return A_Number.Companion.multiplyByDoubleCanDestroy(aNumber, self, canDestroy);
    }

    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(writer, "writer");
        writer.write(DoubleDescriptor.Companion.getDouble(self));
    }

    @Override
    @NotNull
    public DoubleDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public DoubleDescriptor immutable() {
        return immutable;
    }

    @Override
    @NotNull
    public DoubleDescriptor shared() {
        return shared;
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final A_Number fromDouble(double aDouble) {
        return Companion.fromDouble(aDouble);
    }

    static {
        Class[] classArray = new Class[1];
        Intrinsics.checkNotNull(Double.TYPE);
        fromDoubleMethod = CheckedMethod.Companion.staticMethod(DoubleDescriptor.class, "fromDouble", A_Number.class, classArray);
        mutable = new DoubleDescriptor(Mutability.MUTABLE);
        immutable = new DoubleDescriptor(Mutability.IMMUTABLE);
        shared = new DoubleDescriptor(Mutability.SHARED);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lavail/descriptor/numbers/DoubleDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "LONG_BITS", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        public static final /* enum */ IntegerSlots LONG_BITS = new IntegerSlots();
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.LONG_BITS};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fJ\u0006\u0010\u0017\u001a\u00020\u000fJ\u0006\u0010\u0018\u001a\u00020\u000fJ\u0006\u0010\u0019\u001a\u00020\u000fJ\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\fJ\u0006\u0010\u001c\u001a\u00020\u000fJ\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u001e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0002J&\u0010#\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lavail/descriptor/numbers/DoubleDescriptor$Companion;", "", "()V", "fromDoubleMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getFromDoubleMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "immutable", "Lavail/descriptor/numbers/DoubleDescriptor;", "mutable", "shared", "addDoubleAndIntegerCanDestroy", "", "aDouble", "anInteger", "Lavail/descriptor/numbers/A_Number;", "canDestroy", "", "compareDoubleAndInteger", "Lavail/descriptor/numbers/AbstractNumberDescriptor$Order;", "compareDoubles", "double1", "double2", "doubleNegativeInfinity", "doubleNotANumber", "doublePositiveInfinity", "doubleTruncatedToExtendedInteger", "inputD", "doubleZero", "fromDouble", "fromDoubleRecycling", "recyclable1", "getDouble", "self", "Lavail/descriptor/representation/AvailObject;", "objectFromDoubleRecycling", "recyclable2", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final double getDouble(AvailObject self) {
            return Double.longBitsToDouble(self.slot(IntegerSlots.LONG_BITS));
        }

        @NotNull
        public final AbstractNumberDescriptor.Order compareDoubles(double double1, double double2) {
            return double1 == double2 ? AbstractNumberDescriptor.Order.EQUAL : (double1 < double2 ? AbstractNumberDescriptor.Order.LESS : (double1 > double2 ? AbstractNumberDescriptor.Order.MORE : AbstractNumberDescriptor.Order.INCOMPARABLE));
        }

        @NotNull
        public final AbstractNumberDescriptor.Order compareDoubleAndInteger(double aDouble, @NotNull A_Number anInteger) {
            boolean isIntegral;
            boolean bl;
            int exponent;
            int exponentAdjustment;
            Intrinsics.checkNotNullParameter(anInteger, "anInteger");
            if (Double.isNaN(aDouble)) {
                return AbstractNumberDescriptor.Order.INCOMPARABLE;
            }
            if (Double.isInfinite(aDouble)) {
                return this.compareDoubles(aDouble, 0.0);
            }
            if (A_Number.Companion.isInt(anInteger)) {
                return this.compareDoubles(aDouble, A_Number.Companion.getExtractInt(anInteger));
            }
            if (aDouble == 0.0) {
                return A_Number.Companion.numericCompare(IntegerDescriptor.Companion.getZero(), anInteger);
            }
            double floorD = Math.floor(aDouble);
            double normalD = Math.scalb(floorD, -(exponentAdjustment = Math.max((exponent = Math.getExponent(aDouble)) - 60, 0)));
            boolean bl2 = bl = -9.223372036854776E18 < normalD && normalD < 9.223372036854776E18;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Number integer = IntegerDescriptor.Companion.fromLong((long)normalD);
            if (exponentAdjustment > 0) {
                integer = A_Number.Companion.bitShift(integer, IntegerDescriptor.Companion.fromInt(exponentAdjustment), true);
            }
            AbstractNumberDescriptor.Order integerOrder = A_Number.Companion.numericCompare(integer, anInteger);
            boolean bl3 = isIntegral = aDouble == floorD;
            if (!isIntegral && integerOrder == AbstractNumberDescriptor.Order.EQUAL) {
                return AbstractNumberDescriptor.Order.MORE;
            }
            return integerOrder;
        }

        public final double addDoubleAndIntegerCanDestroy(double aDouble, @NotNull A_Number anInteger, boolean canDestroy) {
            Intrinsics.checkNotNullParameter(anInteger, "anInteger");
            if (Double.isInfinite(aDouble)) {
                return aDouble;
            }
            double anIntegerAsDouble = A_Number.Companion.getExtractDouble(anInteger);
            if (!Double.isInfinite(anIntegerAsDouble)) {
                return anIntegerAsDouble + aDouble;
            }
            double adjustment = Math.floor(aDouble);
            A_Number adjustmentAsInteger = IntegerDescriptor.Companion.truncatedFromDouble(adjustment);
            A_Number adjustedInteger = A_Number.Companion.minusCanDestroy(anInteger, adjustmentAsInteger, canDestroy);
            double adjustedIntegerAsDouble = A_Number.Companion.getExtractDouble(adjustedInteger);
            return aDouble - adjustment + adjustedIntegerAsDouble;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final A_Number fromDouble(double aDouble) {
            AvailObject availObject;
            AbstractDescriptor $this$iv = mutable;
            int indexedSlotCount$iv = 0;
            boolean $i$f$create = false;
            AvailObject $this$fromDouble_u24lambda_u240 = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
            boolean bl = false;
            $this$fromDouble_u24lambda_u240.setSlot(IntegerSlots.LONG_BITS, Double.doubleToRawLongBits(aDouble));
            return availObject;
        }

        @NotNull
        public final CheckedMethod getFromDoubleMethod() {
            return fromDoubleMethod;
        }

        @NotNull
        public final A_Number fromDoubleRecycling(double aDouble, @NotNull A_Number recyclable1, boolean canDestroy) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter(recyclable1, "recyclable1");
            if (canDestroy && recyclable1.descriptor().isMutable()) {
                availObject = (AvailObject)recyclable1;
            } else {
                AvailObject availObject2;
                AbstractDescriptor $this$iv = mutable;
                int indexedSlotCount$iv = 0;
                boolean $i$f$create = false;
                AvailObject availObject3 = availObject2 = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
                boolean bl = false;
                AvailObject $this$null = availObject3;
                availObject = availObject2;
            }
            AvailObject result2 = availObject;
            result2.setSlot(IntegerSlots.LONG_BITS, Double.doubleToRawLongBits(aDouble));
            return result2;
        }

        @NotNull
        public final A_Number objectFromDoubleRecycling(double aDouble, @NotNull A_Number recyclable1, @NotNull A_Number recyclable2, boolean canDestroy) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter(recyclable1, "recyclable1");
            Intrinsics.checkNotNullParameter(recyclable2, "recyclable2");
            if (canDestroy && recyclable1.descriptor().isMutable()) {
                availObject = (AvailObject)recyclable1;
            } else if (canDestroy && recyclable2.descriptor().isMutable()) {
                availObject = (AvailObject)recyclable2;
            } else {
                AvailObject availObject2;
                AbstractDescriptor $this$iv = mutable;
                int indexedSlotCount$iv = 0;
                boolean $i$f$create = false;
                AvailObject availObject3 = availObject2 = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, $this$iv);
                boolean bl = false;
                AvailObject $this$null = availObject3;
                availObject = availObject2;
            }
            AvailObject result2 = availObject;
            long castAsLong = Double.doubleToRawLongBits(aDouble);
            result2.setSlot(IntegerSlots.LONG_BITS, castAsLong);
            return result2;
        }

        @NotNull
        public final A_Number doubleTruncatedToExtendedInteger(double inputD) {
            boolean neg;
            boolean bl;
            boolean bl2 = bl = !Double.isNaN(inputD);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (inputD >= -9.223372036854776E18 && inputD <= 9.223372036854776E18) {
                return IntegerDescriptor.Companion.fromLong((long)inputD);
            }
            boolean bl3 = neg = inputD < 0.0;
            if (Double.isInfinite(inputD)) {
                return neg ? InfinityDescriptor.Companion.getNegativeInfinity() : InfinityDescriptor.Companion.getPositiveInfinity();
            }
            double d = Math.abs(inputD);
            int exponent = Math.getExponent(d);
            int slots = exponent + 33 >> 5;
            A_Number out2 = IntegerDescriptor.Companion.createUninitializedInteger(slots);
            d = Math.scalb(d, 1 - slots << 5);
            for (int i2 = slots; 0 < i2; --i2) {
                long unsignedIntSlice = (long)d;
                A_Number.Companion.rawUnsignedIntegerAtPut(out2, i2, (int)unsignedIntSlice);
                d -= (double)unsignedIntSlice;
                d = Math.scalb(d, 32);
            }
            A_Number.Companion.trimExcessInts(out2);
            if (neg) {
                out2 = A_Number.Companion.noFailMinusCanDestroy(IntegerDescriptor.Companion.getZero(), out2, true);
            }
            return out2;
        }

        @NotNull
        public final A_Number doublePositiveInfinity() {
            return AbstractNumberDescriptor.Sign.POSITIVE.limitDoubleObject();
        }

        @NotNull
        public final A_Number doubleNegativeInfinity() {
            return AbstractNumberDescriptor.Sign.NEGATIVE.limitDoubleObject();
        }

        @NotNull
        public final A_Number doubleNotANumber() {
            return AbstractNumberDescriptor.Sign.INDETERMINATE.limitDoubleObject();
        }

        @NotNull
        public final A_Number doubleZero() {
            return AbstractNumberDescriptor.Sign.ZERO.limitDoubleObject();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

