/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.tuples;

import avail.annotations.HideFieldInDebugger;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TreeTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0016\n\u0002\u0010(\n\u0002\b\f\u0018\u0000 /2\u00020\u0001:\u0004/012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0000H\u0016J\b\u0010\u0006\u001a\u00020\u0000H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J0\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J0\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0010H\u0016J \u0010\u0018\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u0010H\u0016J \u0010\u001b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u001e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010 \u001a\u00020\fH\u0016J\u0018\u0010!\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\bH\u0016J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\n0'2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010(\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0010H\u0016J(\u0010*\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010,\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010-\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010.\u001a\u00020\u0000H\u0016\u00a8\u00063"}, d2={"Lavail/descriptor/tuples/ObjectTupleDescriptor;", "Lavail/descriptor/tuples/TupleDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "(Lavail/descriptor/representation/Mutability;)V", "immutable", "mutable", "o_AppendCanDestroy", "Lavail/descriptor/tuples/A_Tuple;", "self", "Lavail/descriptor/representation/AvailObject;", "newElement", "Lavail/descriptor/representation/A_BasicObject;", "canDestroy", "", "o_BitsPerEntry", "", "o_CompareFromToWithObjectTupleStartingAt", "startIndex1", "endIndex1", "anObjectTuple", "startIndex2", "o_CompareFromToWithStartingAt", "anotherObject", "o_ComputeHashFromTo", "start", "end", "o_ConcatenateWith", "otherTuple", "o_CopyAsMutableObjectTuple", "o_CopyTupleFromToCanDestroy", "o_Equals", "another", "o_EqualsObjectTuple", "aTuple", "o_IsByteTuple", "o_IsIntTuple", "o_IsLongTuple", "o_Iterator", "", "o_TupleAt", "index", "o_TupleAtPuttingCanDestroy", "newValueObject", "o_TupleReverse", "o_TupleSize", "shared", "Companion", "IntegerSlots", "ObjectSlots", "ObjectTupleIterator", "avail"})
public final class ObjectTupleDescriptor
extends TupleDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int maximumCopySize = 32;
    @NotNull
    private static final CheckedMethod tupleFromArrayMethod;
    @NotNull
    private static final CheckedMethod tuple1Method;
    @NotNull
    private static final CheckedMethod tuple2Method;
    @NotNull
    private static final CheckedMethod tuple3Method;
    @NotNull
    private static final CheckedMethod tuple4Method;
    @NotNull
    private static final CheckedMethod tuple5Method;
    @NotNull
    private static final ObjectTupleDescriptor mutable;
    @NotNull
    private static final ObjectTupleDescriptor immutable;
    @NotNull
    private static final ObjectTupleDescriptor shared;

    private ObjectTupleDescriptor(Mutability mutability) {
        super(mutability, ObjectSlots.class, IntegerSlots.class);
    }

    @Override
    @NotNull
    public A_Tuple o_AppendCanDestroy(@NotNull AvailObject self, @NotNull A_BasicObject newElement, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(newElement, "newElement");
        int originalSize = A_Tuple.Companion.getTupleSize(self);
        if (originalSize >= 32) {
            A_Tuple singleton2 = Companion.tuple(newElement);
            return A_Tuple.Companion.concatenateWith(self, singleton2, canDestroy);
        }
        if (!canDestroy) {
            newElement.makeImmutable();
            if (this.isMutable()) {
                self.makeImmutable();
            }
        }
        AvailObject newTuple2 = AvailObjectRepresentation.Companion.newLike(mutable, self, 1, 0);
        newTuple2.setSlot(ObjectSlots.TUPLE_AT_, originalSize + 1, newElement);
        newTuple2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
        return newTuple2;
    }

    @Override
    public int o_BitsPerEntry(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return 64;
    }

    @Override
    public boolean o_CompareFromToWithObjectTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anObjectTuple, int startIndex2) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(self, "self");
            Intrinsics.checkNotNullParameter(anObjectTuple, "anObjectTuple");
            if (self.sameAddressAs(anObjectTuple) && startIndex1 == startIndex2) {
                return true;
            }
            int index2 = 0;
            index2 = startIndex2;
            Iterable $this$all$iv = new IntRange(startIndex1, endIndex1);
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int index1 = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl2 = false;
                    int n = index2;
                    index2 = n + 1;
                    if (A_Tuple.Companion.tupleAt(self, index1).equals(A_Tuple.Companion.tupleAt(anObjectTuple, n))) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean o_CompareFromToWithStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anotherObject, int startIndex2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anotherObject, "anotherObject");
        return A_Tuple.Companion.compareFromToWithObjectTupleStartingAt(anotherObject, startIndex2, startIndex2 + endIndex1 - startIndex1, self, startIndex1);
    }

    @Override
    public int o_ComputeHashFromTo(@NotNull AvailObject self, int start, int end) {
        Intrinsics.checkNotNullParameter(self, "self");
        int hash = 0;
        int index2 = end;
        if (start <= index2) {
            while (true) {
                int itemHash = A_Tuple.Companion.tupleAt(self, index2).hash() ^ 0x71E570A6;
                hash = (hash + itemHash) * 1664525;
                if (index2 == start) break;
                --index2;
            }
        }
        return hash;
    }

    @Override
    @NotNull
    public A_Tuple o_ConcatenateWith(@NotNull AvailObject self, @NotNull A_Tuple otherTuple, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(otherTuple, "otherTuple");
        int size1 = A_Tuple.Companion.getTupleSize(self);
        if (size1 == 0) {
            if (!canDestroy) {
                otherTuple.makeImmutable();
            }
            return otherTuple;
        }
        int size2 = A_Tuple.Companion.getTupleSize(otherTuple);
        if (size2 == 0) {
            if (!canDestroy) {
                self.makeImmutable();
            }
            return self;
        }
        int newSize = size1 + size2;
        if (newSize <= 32) {
            int deltaSlots = newSize - self.variableObjectSlotsCount();
            AvailObject result2 = AvailObjectRepresentation.Companion.newLike(this.mutable(), self, deltaSlots, 0);
            result2.setSlotsFromTuple(ObjectSlots.TUPLE_AT_, size1 + 1, otherTuple, 1, size2);
            result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return result2;
        }
        if (!canDestroy) {
            self.makeImmutable();
            otherTuple.makeImmutable();
        }
        return A_Tuple.Companion.getTreeTupleLevel(otherTuple) == 0 ? (A_Tuple)TreeTupleDescriptor.Companion.createTwoPartTreeTuple(self, otherTuple, 1, 0) : TreeTupleDescriptor.Companion.concatenateAtLeastOneTree(self, otherTuple, true);
    }

    @Override
    @NotNull
    public A_Tuple o_CopyAsMutableObjectTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return AvailObjectRepresentation.Companion.newLike(mutable, self, 0, 0);
    }

    @Override
    @NotNull
    public A_Tuple o_CopyTupleFromToCanDestroy(@NotNull AvailObject self, int start, int end, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        boolean bl2 = bl = (1 <= start ? start <= end + 1 : false) && end <= tupleSize;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int size = end - start + 1;
        boolean bl3 = 1 <= size ? size < tupleSize : false;
        if (bl3 && size < 32) {
            AvailObject result2 = ObjectTupleDescriptor.Companion.createUninitialized(size);
            result2.setSlotsFromObjectSlots(ObjectSlots.TUPLE_AT_, 1, self, ObjectSlots.TUPLE_AT_, start, size);
            if (canDestroy) {
                self.assertObjectUnreachableIfMutable();
            } else {
                result2.makeSubobjectsImmutable();
            }
            result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return result2;
        }
        return super.o_CopyTupleFromToCanDestroy(self, start, end, canDestroy);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return another.equalsObjectTuple(self);
    }

    @Override
    public boolean o_EqualsObjectTuple(@NotNull AvailObject self, @NotNull A_Tuple aTuple) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aTuple, "aTuple");
        if (self.sameAddressAs(aTuple)) {
            return true;
        }
        if (this.o_TupleSize(self) != A_Tuple.Companion.getTupleSize(aTuple)) {
            return false;
        }
        if (this.o_Hash(self) != aTuple.hash()) {
            return false;
        }
        if (!A_Tuple.Companion.compareFromToWithObjectTupleStartingAt(self, 1, A_Tuple.Companion.getTupleSize(self), aTuple, 1)) {
            return false;
        }
        if (A_Tuple.Companion.isBetterRepresentationThan(aTuple, self)) {
            if (!this.isShared()) {
                aTuple.makeImmutable();
                self.becomeIndirectionTo(aTuple);
            }
        } else if (!aTuple.descriptor().isShared()) {
            self.makeImmutable();
            aTuple.becomeIndirectionTo(self);
        }
        return true;
    }

    @Override
    public boolean o_IsByteTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        if (tupleSize <= 5) {
            int i2 = 1;
            if (i2 <= tupleSize) {
                while (true) {
                    if (!self.slot(ObjectSlots.TUPLE_AT_, i2).isUnsignedByte()) {
                        return false;
                    }
                    if (i2 == tupleSize) break;
                    ++i2;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean o_IsIntTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        if (tupleSize <= 5) {
            int i2 = 1;
            if (i2 <= tupleSize) {
                while (true) {
                    if (!A_Number.Companion.isInt(self.slot(ObjectSlots.TUPLE_AT_, i2))) {
                        return false;
                    }
                    if (i2 == tupleSize) break;
                    ++i2;
                }
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean o_IsLongTuple(@NotNull AvailObject self) {
        int it;
        Intrinsics.checkNotNullParameter(self, "self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        if (tupleSize > 5) return false;
        Iterable $this$all$iv = new IntRange(1, tupleSize);
        boolean $i$f$all = false;
        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
            return true;
        }
        Iterator iterator2 = $this$all$iv.iterator();
        do {
            int element$iv;
            if (!iterator2.hasNext()) return true;
            it = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
        } while (A_Number.Companion.isLong(self.slot(ObjectSlots.TUPLE_AT_, it)));
        return false;
    }

    @Override
    @NotNull
    public Iterator<AvailObject> o_Iterator(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        self.makeImmutable();
        return new ObjectTupleIterator(self);
    }

    @Override
    @NotNull
    public AvailObject o_TupleAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(ObjectSlots.TUPLE_AT_, index2);
    }

    @Override
    @NotNull
    public A_Tuple o_TupleAtPuttingCanDestroy(@NotNull AvailObject self, int index2, @NotNull A_BasicObject newValueObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(newValueObject, "newValueObject");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject result2 = null;
        if (canDestroy && this.isMutable()) {
            result2 = self;
        } else {
            result2 = AvailObjectRepresentation.Companion.newLike(mutable, self, 0, 0);
            if (this.isMutable()) {
                result2.setSlot(ObjectSlots.TUPLE_AT_, index2, NilDescriptor.Companion.getNil());
                result2.makeSubobjectsImmutable();
            }
        }
        result2.setSlot(ObjectSlots.TUPLE_AT_, index2, newValueObject);
        result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public A_Tuple o_TupleReverse(@NotNull AvailObject self) {
        A_Tuple a_Tuple;
        Intrinsics.checkNotNullParameter(self, "self");
        int size = A_Tuple.Companion.getTupleSize(self);
        if (size >= 32) {
            a_Tuple = super.o_TupleReverse(self);
        } else {
            AvailObject availObject;
            Companion this_$iv = Companion;
            boolean $i$f$generateReversedFrom = false;
            AbstractDescriptor this_$iv$iv = this_$iv.getMutable();
            boolean $i$f$create = false;
            AvailObject $this$generateReversedFrom_u24lambda_u240$iv = availObject = AvailObject.Companion.newIndexedDescriptor(size, this_$iv$iv);
            boolean bl = false;
            int i$iv = size;
            while (0 < i$iv) {
                void it;
                int n = i$iv;
                int n2 = i$iv--;
                ObjectSlotsEnum objectSlotsEnum = ObjectSlots.TUPLE_AT_;
                AvailObject availObject2 = $this$generateReversedFrom_u24lambda_u240$iv;
                boolean bl2 = false;
                A_BasicObject a_BasicObject = self.slot(ObjectSlots.TUPLE_AT_, size + 1 - it);
                availObject2.setSlot(objectSlotsEnum, n2, a_BasicObject);
            }
            a_Tuple = availObject;
        }
        return a_Tuple;
    }

    @Override
    public int o_TupleSize(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.variableObjectSlotsCount();
    }

    @Override
    @NotNull
    public ObjectTupleDescriptor mutable() {
        return mutable;
    }

    @Override
    @NotNull
    public ObjectTupleDescriptor immutable() {
        return immutable;
    }

    @Override
    @NotNull
    public ObjectTupleDescriptor shared() {
        return shared;
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final A_Tuple tupleFromArray(A_BasicObject ... elements) {
        return Companion.tupleFromArray(elements);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final A_Tuple tuple(@NotNull A_BasicObject element1) {
        return Companion.tuple(element1);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final A_Tuple tuple(@NotNull A_BasicObject element1, @NotNull A_BasicObject element2) {
        return Companion.tuple(element1, element2);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final A_Tuple tuple(@NotNull A_BasicObject element1, @NotNull A_BasicObject element2, @NotNull A_BasicObject element3) {
        return Companion.tuple(element1, element2, element3);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final A_Tuple tuple(@NotNull A_BasicObject element1, @NotNull A_BasicObject element2, @NotNull A_BasicObject element3, @NotNull A_BasicObject element4) {
        return Companion.tuple(element1, element2, element3, element4);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final A_Tuple tuple(@NotNull A_BasicObject element1, @NotNull A_BasicObject element2, @NotNull A_BasicObject element3, @NotNull A_BasicObject element4, @NotNull A_BasicObject element5) {
        return Companion.tuple(element1, element2, element3, element4, element5);
    }

    static {
        Class[] classArray = new Class[]{A_BasicObject[].class};
        tupleFromArrayMethod = CheckedMethod.Companion.staticMethod(ObjectTupleDescriptor.class, "tupleFromArray", A_Tuple.class, classArray);
        classArray = new Class[]{A_BasicObject.class};
        tuple1Method = CheckedMethod.Companion.staticMethod(ObjectTupleDescriptor.class, "tuple", A_Tuple.class, classArray);
        classArray = new Class[]{A_BasicObject.class, A_BasicObject.class};
        tuple2Method = CheckedMethod.Companion.staticMethod(ObjectTupleDescriptor.class, "tuple", A_Tuple.class, classArray);
        classArray = new Class[]{A_BasicObject.class, A_BasicObject.class, A_BasicObject.class};
        tuple3Method = CheckedMethod.Companion.staticMethod(ObjectTupleDescriptor.class, "tuple", A_Tuple.class, classArray);
        classArray = new Class[]{A_BasicObject.class, A_BasicObject.class, A_BasicObject.class, A_BasicObject.class};
        tuple4Method = CheckedMethod.Companion.staticMethod(ObjectTupleDescriptor.class, "tuple", A_Tuple.class, classArray);
        classArray = new Class[]{A_BasicObject.class, A_BasicObject.class, A_BasicObject.class, A_BasicObject.class, A_BasicObject.class};
        tuple5Method = CheckedMethod.Companion.staticMethod(ObjectTupleDescriptor.class, "tuple", A_Tuple.class, classArray);
        mutable = new ObjectTupleDescriptor(Mutability.MUTABLE);
        immutable = new ObjectTupleDescriptor(Mutability.IMMUTABLE);
        shared = new ObjectTupleDescriptor(Mutability.SHARED);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0001\u0018\u0000 \u00052\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0006"}, d2={"Lavail/descriptor/tuples/ObjectTupleDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            boolean bl;
            HASH_AND_MORE = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE};
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, Companion.HASH_OR_ZERO.1.INSTANCE);
            boolean bl2 = bl = TupleDescriptor.IntegerSlots.HASH_AND_MORE.ordinal() == HASH_AND_MORE.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl = TupleDescriptor.IntegerSlots.Companion.getHASH_OR_ZERO().isSamePlaceAs(HASH_OR_ZERO);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/ObjectTupleDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lavail/descriptor/tuples/ObjectTupleDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "TUPLE_AT_", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots TUPLE_AT_ = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.TUPLE_AT_};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010*\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\t\u0010\f\u001a\u00020\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\rH\u0016J\t\u0010\u000f\u001a\u00020\u0002H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0006H\u0016J\b\u0010\u0011\u001a\u00020\u0002H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lavail/descriptor/tuples/ObjectTupleDescriptor$ObjectTupleIterator;", "", "Lavail/descriptor/representation/AvailObject;", "tuple", "(Lavail/descriptor/representation/AvailObject;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "size", "hasNext", "", "hasPrevious", "next", "nextIndex", "previous", "previousIndex", "avail"})
    private static final class ObjectTupleIterator
    implements ListIterator<AvailObject>,
    KMappedMarker {
        @NotNull
        private final AvailObject tuple;
        private final int size;
        private int index;

        public ObjectTupleIterator(@NotNull AvailObject tuple2) {
            Intrinsics.checkNotNullParameter(tuple2, "tuple");
            this.tuple = tuple2;
            this.size = A_Tuple.Companion.getTupleSize(this.tuple);
            this.index = 1;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        @Override
        public boolean hasNext() {
            return this.index <= this.size;
        }

        @Override
        public int nextIndex() {
            return this.index - 1;
        }

        @Override
        @NotNull
        public AvailObject next() {
            if (this.index > this.size) {
                throw new NoSuchElementException();
            }
            int n = this.index;
            this.index = n + 1;
            return this.tuple.slot(ObjectSlots.TUPLE_AT_, n);
        }

        @Override
        public boolean hasPrevious() {
            return this.size > 0 && this.index >= 1;
        }

        @Override
        public int previousIndex() {
            return this.index - 2;
        }

        @Override
        @NotNull
        public AvailObject previous() {
            if (this.size == 0 || this.index < 1) {
                throw new NoSuchElementException();
            }
            this.index += -1;
            return this.tuple.slot(ObjectSlots.TUPLE_AT_, this.index);
        }

        @Override
        public void add(AvailObject element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void set(AvailObject element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002J\"\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020$0#J(\u0010%\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020$0#H\u0086\b\u00f8\u0001\u0000J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$H\u0007J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$H\u0007J \u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$H\u0007J(\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020$H\u0007J0\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020$2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020$H\u0007J!\u0010-\u001a\u00020'2\u0012\u0010.\u001a\n\u0012\u0006\b\u0001\u0012\u00020$0/\"\u00020$H\u0007\u00a2\u0006\u0002\u00100J\u001e\u00101\u001a\u00020'\"\b\b\u0000\u00102*\u00020$2\f\u00103\u001a\b\u0012\u0004\u0012\u0002H204R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\u00020\f\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\r\u0010\u0002\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\u00020\f\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0002\u001a\u0004\b\u0012\u0010\u000fR\u0017\u0010\u0013\u001a\u00020\f\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0002\u001a\u0004\b\u0015\u0010\u000fR\u0017\u0010\u0016\u001a\u00020\f\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u000fR\u0017\u0010\u0019\u001a\u00020\f\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u0002\u001a\u0004\b\u001b\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u000f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u00065"}, d2={"Lavail/descriptor/tuples/ObjectTupleDescriptor$Companion;", "", "()V", "immutable", "Lavail/descriptor/tuples/ObjectTupleDescriptor;", "maximumCopySize", "", "mutable", "getMutable", "()Lavail/descriptor/tuples/ObjectTupleDescriptor;", "shared", "tuple1Method", "Lavail/optimizer/jvm/CheckedMethod;", "getTuple1Method$annotations", "getTuple1Method", "()Lavail/optimizer/jvm/CheckedMethod;", "tuple2Method", "getTuple2Method$annotations", "getTuple2Method", "tuple3Method", "getTuple3Method$annotations", "getTuple3Method", "tuple4Method", "getTuple4Method$annotations", "getTuple4Method", "tuple5Method", "getTuple5Method$annotations", "getTuple5Method", "tupleFromArrayMethod", "getTupleFromArrayMethod", "createUninitialized", "Lavail/descriptor/representation/AvailObject;", "size", "generateObjectTupleFrom", "generator", "Lkotlin/Function1;", "Lavail/descriptor/representation/A_BasicObject;", "generateReversedFrom", "tuple", "Lavail/descriptor/tuples/A_Tuple;", "element1", "element2", "element3", "element4", "element5", "tupleFromArray", "elements", "", "([Lavail/descriptor/representation/A_BasicObject;)Lavail/descriptor/tuples/A_Tuple;", "tupleFromList", "E", "list", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final AvailObject createUninitialized(int size) {
            AvailObject availObject;
            AbstractDescriptor $this$iv = this.getMutable();
            boolean $i$f$create = false;
            AvailObject availObject2 = availObject = AvailObject.Companion.newIndexedDescriptor(size, $this$iv);
            boolean bl = false;
            AvailObject $this$null = availObject2;
            return availObject;
        }

        @NotNull
        public final AvailObject generateObjectTupleFrom(int size, @NotNull Function1<? super Integer, ? extends A_BasicObject> generator) {
            Intrinsics.checkNotNullParameter(generator, "generator");
            if (size == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            AvailObject result2 = this.createUninitialized(size);
            int i2 = 1;
            if (i2 <= size) {
                while (true) {
                    result2.setSlot(ObjectSlots.TUPLE_AT_, i2, generator.invoke((Integer)i2));
                    if (i2 == size) break;
                    ++i2;
                }
            }
            return result2;
        }

        @NotNull
        public final AvailObject generateReversedFrom(int size, @NotNull Function1<? super Integer, ? extends A_BasicObject> generator) {
            AvailObject availObject;
            Intrinsics.checkNotNullParameter(generator, "generator");
            boolean $i$f$generateReversedFrom = false;
            AbstractDescriptor this_$iv = this.getMutable();
            boolean $i$f$create = false;
            AvailObject $this$generateReversedFrom_u24lambda_u240 = availObject = AvailObject.Companion.newIndexedDescriptor(size, this_$iv);
            boolean bl = false;
            for (int i2 = size; 0 < i2; --i2) {
                $this$generateReversedFrom_u24lambda_u240.setSlot(ObjectSlots.TUPLE_AT_, i2, generator.invoke((Integer)i2));
            }
            return availObject;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final A_Tuple tupleFromArray(A_BasicObject ... elements) {
            Intrinsics.checkNotNullParameter(elements, "elements");
            int size = elements.length;
            if (size == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            AvailObject result2 = this.createUninitialized(size);
            result2.setSlotsFromArray(ObjectSlots.TUPLE_AT_, 1, Arrays.copyOf(elements, elements.length), 0, size);
            return result2;
        }

        @NotNull
        public final CheckedMethod getTupleFromArrayMethod() {
            return tupleFromArrayMethod;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final A_Tuple tuple(@NotNull A_BasicObject element1) {
            Intrinsics.checkNotNullParameter(element1, "element1");
            AvailObject result2 = this.createUninitialized(1);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 1, element1);
            return result2;
        }

        @NotNull
        public final CheckedMethod getTuple1Method() {
            return tuple1Method;
        }

        public static /* synthetic */ void getTuple1Method$annotations() {
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final A_Tuple tuple(@NotNull A_BasicObject element1, @NotNull A_BasicObject element2) {
            Intrinsics.checkNotNullParameter(element1, "element1");
            Intrinsics.checkNotNullParameter(element2, "element2");
            AvailObject result2 = this.createUninitialized(2);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 1, element1);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 2, element2);
            return result2;
        }

        @NotNull
        public final CheckedMethod getTuple2Method() {
            return tuple2Method;
        }

        public static /* synthetic */ void getTuple2Method$annotations() {
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final A_Tuple tuple(@NotNull A_BasicObject element1, @NotNull A_BasicObject element2, @NotNull A_BasicObject element3) {
            Intrinsics.checkNotNullParameter(element1, "element1");
            Intrinsics.checkNotNullParameter(element2, "element2");
            Intrinsics.checkNotNullParameter(element3, "element3");
            AvailObject result2 = this.createUninitialized(3);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 1, element1);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 2, element2);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 3, element3);
            return result2;
        }

        @NotNull
        public final CheckedMethod getTuple3Method() {
            return tuple3Method;
        }

        public static /* synthetic */ void getTuple3Method$annotations() {
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final A_Tuple tuple(@NotNull A_BasicObject element1, @NotNull A_BasicObject element2, @NotNull A_BasicObject element3, @NotNull A_BasicObject element4) {
            Intrinsics.checkNotNullParameter(element1, "element1");
            Intrinsics.checkNotNullParameter(element2, "element2");
            Intrinsics.checkNotNullParameter(element3, "element3");
            Intrinsics.checkNotNullParameter(element4, "element4");
            AvailObject result2 = this.createUninitialized(4);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 1, element1);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 2, element2);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 3, element3);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 4, element4);
            return result2;
        }

        @NotNull
        public final CheckedMethod getTuple4Method() {
            return tuple4Method;
        }

        public static /* synthetic */ void getTuple4Method$annotations() {
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final A_Tuple tuple(@NotNull A_BasicObject element1, @NotNull A_BasicObject element2, @NotNull A_BasicObject element3, @NotNull A_BasicObject element4, @NotNull A_BasicObject element5) {
            Intrinsics.checkNotNullParameter(element1, "element1");
            Intrinsics.checkNotNullParameter(element2, "element2");
            Intrinsics.checkNotNullParameter(element3, "element3");
            Intrinsics.checkNotNullParameter(element4, "element4");
            Intrinsics.checkNotNullParameter(element5, "element5");
            AvailObject result2 = this.createUninitialized(5);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 1, element1);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 2, element2);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 3, element3);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 4, element4);
            result2.setSlot(ObjectSlots.TUPLE_AT_, 5, element5);
            return result2;
        }

        @NotNull
        public final CheckedMethod getTuple5Method() {
            return tuple5Method;
        }

        public static /* synthetic */ void getTuple5Method$annotations() {
        }

        @NotNull
        public final <E extends A_BasicObject> A_Tuple tupleFromList(@NotNull List<? extends E> list2) {
            Intrinsics.checkNotNullParameter(list2, "list");
            int size = list2.size();
            if (size == 0) {
                return TupleDescriptor.Companion.getEmptyTuple();
            }
            AvailObject result2 = this.createUninitialized(size);
            result2.setSlotsFromList(ObjectSlots.TUPLE_AT_, 1, list2, 0, size);
            return result2;
        }

        @NotNull
        public final ObjectTupleDescriptor getMutable() {
            return mutable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

