/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.tuples;

import avail.annotations.HideFieldInDebugger;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TreeTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.utility.structures.EnumMap;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\u0018\u0000 B2\u00020\u0001:\u0003BCDB\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0000H\u0016J\b\u0010\b\u001a\u00020\u0000H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J0\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J0\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J0\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J0\u0010!\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J \u0010#\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005H\u0016J \u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010'\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010(\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010)\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u000eH\u0016J\u0018\u0010+\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010,\u001a\u00020\nH\u0016J\u0018\u0010-\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010.\u001a\u00020\nH\u0016J(\u0010/\u001a\u0002002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u000204H\u0016J\u0010\u00105\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u00106\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0005H\u0016J(\u00108\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010:\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u00052\u0006\u0010;\u001a\u00020<H\u0016J\u0018\u0010=\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0005H\u0016J\u0018\u0010>\u001a\u00020?2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0005H\u0016J\u0010\u0010@\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010A\u001a\u00020\u0000H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lavail/descriptor/tuples/TreeTupleDescriptor;", "Lavail/descriptor/tuples/TupleDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "level", "", "(Lavail/descriptor/representation/Mutability;I)V", "immutable", "mutable", "o_AppendCanDestroy", "Lavail/descriptor/tuples/A_Tuple;", "self", "Lavail/descriptor/representation/AvailObject;", "newElement", "Lavail/descriptor/representation/A_BasicObject;", "canDestroy", "", "o_BitsPerEntry", "o_ChildAt", "childIndex", "o_ChildCount", "o_CompareFromToWithByteStringStartingAt", "startIndex1", "endIndex1", "aByteString", "Lavail/descriptor/tuples/A_String;", "startIndex2", "o_CompareFromToWithByteTupleStartingAt", "aByteTuple", "o_CompareFromToWithNybbleTupleStartingAt", "aNybbleTuple", "o_CompareFromToWithObjectTupleStartingAt", "anObjectTuple", "o_CompareFromToWithStartingAt", "anotherObject", "o_ComputeHashFromTo", "start", "end", "o_ConcatenateWith", "otherTuple", "o_CopyTupleFromToCanDestroy", "o_Equals", "another", "o_EqualsAnyTuple", "aTuple", "o_ReplaceFirstChild", "newFirst", "o_TransferIntoByteBuffer", "", "startIndex", "endIndex", "outputByteBuffer", "Ljava/nio/ByteBuffer;", "o_TreeTupleLevel", "o_TupleAt", "index", "o_TupleAtPuttingCanDestroy", "newValueObject", "o_TupleElementsInRangeAreInstancesOf", "type", "Lavail/descriptor/types/A_Type;", "o_TupleIntAt", "o_TupleLongAt", "", "o_TupleSize", "shared", "Companion", "IntegerSlots", "ObjectSlots", "avail"})
public final class TreeTupleDescriptor
extends TupleDescriptor {
    @NotNull
    public static final Companion Companion;
    private final int level;
    private static final boolean shouldCheckTreeTuple = false;
    private static final int minWidthOfNonRoot = 16;
    private static final int maxWidth = 64;
    private static final int numberOfLevels = 10;
    @NotNull
    private static final EnumMap<Mutability, TreeTupleDescriptor[]> descriptors;

    public TreeTupleDescriptor(@NotNull Mutability mutability, int level) {
        Intrinsics.checkNotNullParameter((Object)mutability, "mutability");
        super(mutability, ObjectSlots.class, IntegerSlots.class);
        this.level = level;
    }

    @Override
    @NotNull
    public A_Tuple o_AppendCanDestroy(@NotNull AvailObject self, @NotNull A_BasicObject newElement, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(newElement, "newElement");
        return Companion.concatenateAtLeastOneTree(self, ObjectTupleDescriptor.Companion.tuple(newElement), canDestroy);
    }

    @Override
    public int o_BitsPerEntry(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return 65;
    }

    @Override
    @NotNull
    public A_Tuple o_ChildAt(@NotNull AvailObject self, int childIndex) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.slot(ObjectSlots.SUBTUPLE_AT_, childIndex);
    }

    @Override
    public int o_ChildCount(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.variableObjectSlotsCount();
    }

    @Override
    public boolean o_CompareFromToWithStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anotherObject, int startIndex2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anotherObject, "anotherObject");
        if (self.sameAddressAs(anotherObject) && startIndex1 == startIndex2) {
            return true;
        }
        if (this.level < A_Tuple.Companion.getTreeTupleLevel(anotherObject)) {
            return A_Tuple.Companion.compareFromToWithStartingAt(anotherObject, startIndex2, endIndex1 + startIndex2 - startIndex1, self, startIndex1);
        }
        int startChildIndex = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, startIndex1);
        int endChildIndex = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, endIndex1);
        for (int childIndex = startChildIndex; childIndex < endChildIndex; ++childIndex) {
            int endIndexInChild;
            A_Tuple child = self.slot(ObjectSlots.SUBTUPLE_AT_, childIndex);
            int childOffset = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, childIndex);
            int childSize = self.intSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, childIndex) - childOffset;
            int startIndexInChild = RangesKt.coerceAtLeast(startIndex1 - childOffset, 1);
            if (A_Tuple.Companion.compareFromToWithStartingAt(child, startIndexInChild, endIndexInChild = RangesKt.coerceAtMost(endIndex1 - childOffset, childSize), anotherObject, startIndexInChild + childOffset - startIndex1 + startIndex2)) continue;
            return false;
        }
        if (startIndex1 == 1 && startIndex2 == 1 && endIndex1 == A_Tuple.Companion.getTupleSize(self) && endIndex1 == A_Tuple.Companion.getTupleSize(anotherObject)) {
            if (!this.isShared()) {
                anotherObject.makeImmutable();
                self.becomeIndirectionTo(anotherObject);
            } else if (!anotherObject.descriptor().isShared()) {
                self.makeImmutable();
                anotherObject.becomeIndirectionTo(self);
            }
        }
        return true;
    }

    @Override
    public boolean o_CompareFromToWithByteStringStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_String aByteString, int startIndex2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aByteString, "aByteString");
        return this.o_CompareFromToWithStartingAt(self, startIndex1, endIndex1, aByteString, startIndex2);
    }

    @Override
    public boolean o_CompareFromToWithByteTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple aByteTuple, int startIndex2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aByteTuple, "aByteTuple");
        return this.o_CompareFromToWithStartingAt(self, startIndex1, endIndex1, aByteTuple, startIndex2);
    }

    @Override
    public boolean o_CompareFromToWithNybbleTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple aNybbleTuple, int startIndex2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aNybbleTuple, "aNybbleTuple");
        return this.o_CompareFromToWithStartingAt(self, startIndex1, endIndex1, aNybbleTuple, startIndex2);
    }

    @Override
    public boolean o_CompareFromToWithObjectTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anObjectTuple, int startIndex2) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(anObjectTuple, "anObjectTuple");
        return this.o_CompareFromToWithStartingAt(self, startIndex1, endIndex1, anObjectTuple, startIndex2);
    }

    @Override
    public int o_ComputeHashFromTo(@NotNull AvailObject self, int start, int end) {
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        boolean bl2 = 1 <= start ? start <= tupleSize : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = start - 1 <= end ? end <= tupleSize : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (end == 0) {
            boolean bl4 = bl = start == 1;
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            return 0;
        }
        int startChildSubscript = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, start);
        int endChildSubscript = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, end);
        int hash = 0;
        int i2 = startChildSubscript;
        if (i2 <= endChildSubscript) {
            while (true) {
                int startOfChild = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, i2) + 1;
                int endOfChild = self.intSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, i2);
                int startIndexInChild = Math.max(0, start - startOfChild) + 1;
                int endIndexInChild = Math.min(endOfChild, end) - startOfChild + 1;
                A_Tuple child = self.slot(ObjectSlots.SUBTUPLE_AT_, i2);
                int sectionHash = A_Tuple.Companion.hashFromTo(child, startIndexInChild, endIndexInChild);
                int indexAdjustment = startOfChild + startIndexInChild - 2;
                hash += (sectionHash *= TupleDescriptor.Companion.multiplierRaisedTo(indexAdjustment));
                if (i2 == endChildSubscript) break;
                ++i2;
            }
        }
        return hash;
    }

    @Override
    @NotNull
    public A_Tuple o_ConcatenateWith(@NotNull AvailObject self, @NotNull A_Tuple otherTuple, boolean canDestroy) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(otherTuple, "otherTuple");
        return Companion.concatenateAtLeastOneTree(self, otherTuple, canDestroy);
    }

    @Override
    @NotNull
    public A_Tuple o_CopyTupleFromToCanDestroy(@NotNull AvailObject self, int start, int end, boolean canDestroy) {
        boolean offset2;
        int highChildIndex;
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        boolean bl2 = bl = (1 <= start ? start <= end + 1 : false) && end <= tupleSize;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        if (start - 1 == end) {
            return TupleDescriptor.Companion.getEmptyTuple();
        }
        if (!canDestroy) {
            self.makeImmutable();
        }
        if (start == 1 && end == A_Tuple.Companion.getTupleSize(self)) {
            return self;
        }
        int lowChildIndex = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, start);
        if (lowChildIndex == (highChildIndex = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, end))) {
            int offset2 = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, lowChildIndex);
            return A_Tuple.Companion.copyTupleFromToCanDestroy(A_Tuple.Companion.childAt(self, lowChildIndex), start - offset2, end - offset2, canDestroy);
        }
        boolean bl3 = offset2 = lowChildIndex < highChildIndex;
        if (_Assertions.ENABLED && !offset2) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        int leftOffset = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, lowChildIndex);
        int rightOffset = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, highChildIndex);
        A_Tuple leftPart = A_Tuple.Companion.copyTupleFromToCanDestroy(A_Tuple.Companion.childAt(self, lowChildIndex), start - leftOffset, TreeTupleDescriptor.Companion.offsetForChildSubscript(self, lowChildIndex + 1) - leftOffset, canDestroy);
        A_Tuple rightPart = A_Tuple.Companion.copyTupleFromToCanDestroy(A_Tuple.Companion.childAt(self, highChildIndex), 1, end - rightOffset, canDestroy);
        A_Tuple accumulator = leftPart;
        if (lowChildIndex + 5 < highChildIndex) {
            boolean bl4;
            AvailObject innerSection = TreeTupleDescriptor.Companion.createUninitializedTree(this.level, highChildIndex - lowChildIndex - 1);
            int delta = self.intSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, lowChildIndex);
            int dest = 1;
            int src = lowChildIndex + 1;
            while (src < highChildIndex) {
                A_Tuple completeChild = self.slot(ObjectSlots.SUBTUPLE_AT_, src);
                innerSection.setSlot(ObjectSlots.SUBTUPLE_AT_, dest, completeChild);
                innerSection.setIntSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, dest, self.intSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, src) - delta);
                ++src;
                ++dest;
            }
            boolean bl5 = bl4 = dest == A_Tuple.Companion.getChildCount(innerSection) + 1;
            if (_Assertions.ENABLED && !bl4) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            innerSection.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            TreeTupleDescriptor.Companion.check(innerSection);
            accumulator = A_Tuple.Companion.concatenateWith(accumulator, innerSection, true);
        } else {
            for (int childIndex = lowChildIndex + 1; childIndex < highChildIndex; ++childIndex) {
                accumulator = A_Tuple.Companion.concatenateWith(accumulator, self.slot(ObjectSlots.SUBTUPLE_AT_, childIndex), true);
            }
        }
        accumulator = A_Tuple.Companion.concatenateWith(accumulator, rightPart, true);
        return accumulator;
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(another, "another");
        return another.equalsAnyTuple(self);
    }

    @Override
    public boolean o_EqualsAnyTuple(@NotNull AvailObject self, @NotNull A_Tuple aTuple) {
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(aTuple, "aTuple");
        return self.sameAddressAs(aTuple) ? true : (A_Tuple.Companion.getTupleSize(self) != A_Tuple.Companion.getTupleSize(aTuple) ? false : (self.hash() != aTuple.hash() ? false : (this.level < A_Tuple.Companion.getTreeTupleLevel(aTuple) ? aTuple.equalsAnyTuple(self) : A_Tuple.Companion.compareFromToWithStartingAt(self, 1, A_Tuple.Companion.getTupleSize(self), aTuple, 1))));
    }

    @Override
    @NotNull
    public A_Tuple o_ReplaceFirstChild(@NotNull AvailObject self, @NotNull A_Tuple newFirst) {
        int childIndex;
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(newFirst, "newFirst");
        boolean bl2 = bl = A_Tuple.Companion.getTreeTupleLevel(newFirst) == this.level - 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Tuple oldChild = self.slot(ObjectSlots.SUBTUPLE_AT_, 1);
        int replacementSize = A_Tuple.Companion.getTupleSize(newFirst);
        int delta = replacementSize - A_Tuple.Companion.getTupleSize(oldChild);
        AvailObject result2 = this.isMutable() ? self : AvailObjectRepresentation.Companion.newLike(this.mutable(), self, 0, 0);
        int oldHash = self.slot(IntegerSlots.Companion.getHASH_OR_ZERO());
        if (oldHash != 0) {
            int hashMinusFirstChild = oldHash - oldChild.hash();
            int rescaledHashWithoutFirstChild = hashMinusFirstChild * TupleDescriptor.Companion.multiplierRaisedTo(delta);
            int newHash = rescaledHashWithoutFirstChild + newFirst.hash();
            result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), newHash);
        }
        result2.setSlot(ObjectSlots.SUBTUPLE_AT_, 1, newFirst);
        int childCount = A_Tuple.Companion.getChildCount(self);
        if (delta != 0 && (childIndex = 1) <= childCount) {
            while (true) {
                result2.setIntSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, childIndex, result2.intSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, childIndex) + delta);
                if (childIndex == childCount) break;
                ++childIndex;
            }
        }
        TreeTupleDescriptor.Companion.check(result2);
        return result2;
    }

    @Override
    public void o_TransferIntoByteBuffer(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull ByteBuffer outputByteBuffer) {
        boolean offset2;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(outputByteBuffer, "outputByteBuffer");
        int lowChildIndex = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, startIndex);
        int highChildIndex = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, endIndex);
        if (lowChildIndex == highChildIndex) {
            int offset2 = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, lowChildIndex);
            A_Tuple.Companion.transferIntoByteBuffer(A_Tuple.Companion.childAt(self, lowChildIndex), startIndex - offset2, endIndex - offset2, outputByteBuffer);
            return;
        }
        boolean bl = offset2 = lowChildIndex < highChildIndex;
        if (_Assertions.ENABLED && !offset2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int leftOffset = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, lowChildIndex);
        A_Tuple child = A_Tuple.Companion.childAt(self, lowChildIndex);
        A_Tuple.Companion.transferIntoByteBuffer(child, startIndex - leftOffset, A_Tuple.Companion.getTupleSize(child), outputByteBuffer);
        for (int childIndex = lowChildIndex + 1; childIndex < highChildIndex; ++childIndex) {
            child = A_Tuple.Companion.childAt(self, childIndex);
            A_Tuple.Companion.transferIntoByteBuffer(child, 1, A_Tuple.Companion.getTupleSize(child), outputByteBuffer);
        }
        child = A_Tuple.Companion.childAt(self, highChildIndex);
        int rightOffset = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, highChildIndex);
        A_Tuple.Companion.transferIntoByteBuffer(child, 1, endIndex - rightOffset, outputByteBuffer);
    }

    @Override
    public int o_TreeTupleLevel(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return this.level;
    }

    @Override
    @NotNull
    public AvailObject o_TupleAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter(self, "self");
        int childSubscript = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, index2);
        int offset = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, childSubscript);
        A_Tuple child = self.slot(ObjectSlots.SUBTUPLE_AT_, childSubscript);
        return A_Tuple.Companion.tupleAt(child, index2 - offset);
    }

    @Override
    @NotNull
    public A_Tuple o_TupleAtPuttingCanDestroy(@NotNull AvailObject self, int index2, @NotNull A_BasicObject newValueObject, boolean canDestroy) {
        A_Tuple newSubtuple;
        int newLevel;
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(newValueObject, "newValueObject");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject result2 = self;
        if (!canDestroy || !this.isMutable()) {
            result2 = AvailObjectRepresentation.Companion.newLike(this.mutable(), self, 0, 0);
        }
        int subtupleSubscript = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, index2);
        A_Tuple oldSubtuple = self.slot(ObjectSlots.SUBTUPLE_AT_, subtupleSubscript);
        int delta = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, subtupleSubscript);
        int oldHash = self.slot(IntegerSlots.Companion.getHASH_OR_ZERO());
        if (oldHash != 0) {
            A_BasicObject oldValue = A_Tuple.Companion.tupleAt(oldSubtuple, index2 - delta);
            int adjustment = newValueObject.hash() - oldValue.hash();
            int scaledAdjustment = adjustment * TupleDescriptor.Companion.multiplierRaisedTo(index2);
            result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), oldHash + scaledAdjustment);
        }
        if ((newLevel = A_Tuple.Companion.getTreeTupleLevel(newSubtuple = A_Tuple.Companion.tupleAtPuttingCanDestroy(oldSubtuple, index2 - delta, newValueObject, canDestroy))) == this.level - 1) {
            result2.setSlot(ObjectSlots.SUBTUPLE_AT_, subtupleSubscript, newSubtuple);
            TreeTupleDescriptor.Companion.check(result2);
            return result2;
        }
        A_Tuple leftPart = A_Tuple.Companion.copyTupleFromToCanDestroy(self, 1, delta, false);
        A_Tuple rightPart = A_Tuple.Companion.copyTupleFromToCanDestroy(self, TreeTupleDescriptor.Companion.offsetForChildSubscript(self, subtupleSubscript + 1) + 1, A_Tuple.Companion.getTupleSize(self), false);
        A_Tuple leftAndMiddle = A_Tuple.Companion.concatenateWith(leftPart, newSubtuple, true);
        return A_Tuple.Companion.concatenateWith(leftAndMiddle, rightPart, true);
    }

    @Override
    public boolean o_TupleElementsInRangeAreInstancesOf(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull A_Type type2) {
        int endChildSubscript;
        boolean bl;
        Intrinsics.checkNotNullParameter(self, "self");
        Intrinsics.checkNotNullParameter(type2, "type");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        boolean bl2 = 1 <= startIndex ? startIndex <= tupleSize : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = startIndex - 1 <= endIndex ? endIndex <= tupleSize : (bl = false);
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (endIndex == startIndex - 1) {
            return true;
        }
        int startChildSubscript = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, startIndex);
        int i2 = startChildSubscript;
        if (i2 <= (endChildSubscript = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, endIndex))) {
            while (true) {
                int startOfChild = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, i2) + 1;
                int endOfChild = self.intSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, i2);
                int startIndexInChild = Math.max(0, startIndex - startOfChild) + 1;
                int endIndexInChild = Math.min(endOfChild, endIndex) - startOfChild + 1;
                A_Tuple child = self.slot(ObjectSlots.SUBTUPLE_AT_, i2);
                if (!A_Tuple.Companion.tupleElementsInRangeAreInstancesOf(child, startIndexInChild, endIndexInChild, type2)) {
                    return false;
                }
                if (i2 == endChildSubscript) break;
                ++i2;
            }
        }
        return true;
    }

    @Override
    public int o_TupleIntAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter(self, "self");
        int childSubscript = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, index2);
        int offset = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, childSubscript);
        A_Tuple child = self.slot(ObjectSlots.SUBTUPLE_AT_, childSubscript);
        return A_Tuple.Companion.tupleIntAt(child, index2 - offset);
    }

    @Override
    public long o_TupleLongAt(@NotNull AvailObject self, int index2) {
        Intrinsics.checkNotNullParameter(self, "self");
        int childSubscript = TreeTupleDescriptor.Companion.childSubscriptForIndex(self, index2);
        int offset = TreeTupleDescriptor.Companion.offsetForChildSubscript(self, childSubscript);
        A_Tuple child = self.slot(ObjectSlots.SUBTUPLE_AT_, childSubscript);
        return A_Tuple.Companion.tupleLongAt(child, index2 - offset);
    }

    @Override
    public int o_TupleSize(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter(self, "self");
        return self.intSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, self.variableObjectSlotsCount());
    }

    @Override
    @NotNull
    public TreeTupleDescriptor mutable() {
        TreeTupleDescriptor[] treeTupleDescriptorArray = descriptors.get((Object)Mutability.MUTABLE);
        Intrinsics.checkNotNull(treeTupleDescriptorArray);
        return treeTupleDescriptorArray[this.level];
    }

    @Override
    @NotNull
    public TreeTupleDescriptor immutable() {
        TreeTupleDescriptor[] treeTupleDescriptorArray = descriptors.get((Object)Mutability.IMMUTABLE);
        Intrinsics.checkNotNull(treeTupleDescriptorArray);
        return treeTupleDescriptorArray[this.level];
    }

    @Override
    @NotNull
    public TreeTupleDescriptor shared() {
        TreeTupleDescriptor[] treeTupleDescriptorArray = descriptors.get((Object)Mutability.SHARED);
        Intrinsics.checkNotNull(treeTupleDescriptorArray);
        return treeTupleDescriptorArray[this.level];
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        Companion = new Companion(null);
        EnumMap.Companion this_$iv = EnumMap.Companion;
        boolean $i$f$enumMap = false;
        Enum[] keys$iv = (Enum[])Mutability.class.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue(keys$iv, "keys");
        EnumMap map$iv = new EnumMap(keys$iv);
        Enum[] $this$forEach$iv$iv = keys$iv;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv$iv.length;
        for (int j = 0; j < n; ++j) {
            Enum element$iv$iv;
            Enum key$iv = element$iv$iv = $this$forEach$iv$iv[j];
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue(key$iv, "key");
            Mutability mut = (Mutability)key$iv;
            boolean bl2 = false;
            int n2 = 0;
            TreeTupleDescriptor[] treeTupleDescriptorArray = new TreeTupleDescriptor[10];
            while (n2 < 10) {
                int n3 = n2++;
                treeTupleDescriptorArray[n3] = new TreeTupleDescriptor(mut, n3);
            }
            TreeTupleDescriptor[] value$iv = treeTupleDescriptorArray;
            boolean bl3 = false;
            map$iv.set(key$iv, value$iv);
        }
        descriptors = var3_3;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/TreeTupleDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "CUMULATIVE_SIZES_AREA_", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        public static final /* enum */ IntegerSlots CUMULATIVE_SIZES_AREA_;
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            boolean bl;
            HASH_AND_MORE = new IntegerSlots();
            CUMULATIVE_SIZES_AREA_ = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE, IntegerSlots.CUMULATIVE_SIZES_AREA_};
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, Companion.HASH_OR_ZERO.1.INSTANCE);
            boolean bl2 = bl = TupleDescriptor.IntegerSlots.HASH_AND_MORE.ordinal() == HASH_AND_MORE.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl = TupleDescriptor.IntegerSlots.Companion.getHASH_OR_ZERO().isSamePlaceAs(HASH_OR_ZERO);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/TreeTupleDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lavail/descriptor/tuples/TreeTupleDescriptor$ObjectSlots;", "", "Lavail/descriptor/representation/ObjectSlotsEnum;", "(Ljava/lang/String;I)V", "SUBTUPLE_AT_", "avail"})
    public static final class ObjectSlots
    extends Enum<ObjectSlots>
    implements ObjectSlotsEnum {
        public static final /* enum */ ObjectSlots SUBTUPLE_AT_ = new ObjectSlots();
        private static final /* synthetic */ ObjectSlots[] $VALUES;

        public static ObjectSlots[] values() {
            return (ObjectSlots[])$VALUES.clone();
        }

        public static ObjectSlots valueOf(String value) {
            return Enum.valueOf(ObjectSlots.class, value);
        }

        static {
            $VALUES = objectSlotsArray = new ObjectSlots[]{ObjectSlots.SUBTUPLE_AT_};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000bH\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u000fJ\u0018\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0017H\u0002J&\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000bJ\u0018\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u000bH\u0002J\u000e\u0010$\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u000bH\u0002R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lavail/descriptor/tuples/TreeTupleDescriptor$Companion;", "", "()V", "descriptors", "Lavail/utility/structures/EnumMap;", "Lavail/descriptor/representation/Mutability;", "", "Lavail/descriptor/tuples/TreeTupleDescriptor;", "getDescriptors", "()Lavail/utility/structures/EnumMap;", "maxWidth", "", "minWidthOfNonRoot", "numberOfLevels", "shouldCheckTreeTuple", "", "check", "", "self", "Lavail/descriptor/representation/AvailObject;", "childSubscriptForIndex", "index", "concatenateAtLeastOneTree", "Lavail/descriptor/tuples/A_Tuple;", "tuple1", "tuple2", "canDestroy", "concatenateSameLevel", "createTwoPartTreeTuple", "left", "right", "newLevel", "newHashOrZero", "createUninitializedTree", "level", "size", "internalTreeReverse", "offsetForChildSubscript", "childSubscript", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final AvailObject concatenateSameLevel(A_Tuple tuple1, A_Tuple tuple2) {
            String string2;
            boolean bl;
            boolean bl2;
            int level = A_Tuple.Companion.getTreeTupleLevel(tuple1);
            boolean bl3 = bl2 = level == A_Tuple.Companion.getTreeTupleLevel(tuple2);
            if (_Assertions.ENABLED && !bl2) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            int count1 = A_Tuple.Companion.getChildCount(tuple1);
            int count2 = A_Tuple.Companion.getChildCount(tuple2);
            int newHash = (tuple1.hashOrZero() == 0 || tuple2.hashOrZero() == 0 ? 0 : tuple1.hashOrZero()) + tuple2.hashOrZero() * TupleDescriptor.Companion.multiplierRaisedTo(A_Tuple.Companion.getTupleSize(tuple1));
            if (count1 >= 16 && count2 >= 16) {
                return this.createTwoPartTreeTuple(tuple1, tuple2, level + 1, newHash);
            }
            if (count1 + count2 <= 64) {
                AbstractDescriptor abstractDescriptor = tuple1.descriptor().mutable();
                Intrinsics.checkNotNull(tuple1, "null cannot be cast to non-null type avail.descriptor.representation.AvailObject");
                AvailObject newNode = AvailObjectRepresentation.Companion.newLike(abstractDescriptor, (AvailObject)tuple1, count2, (count1 + count2 + 1 >> 1) - (count1 + 1 >> 1));
                int size = A_Tuple.Companion.getTupleSize(tuple1);
                int dest = count1 + 1;
                int src = 1;
                while (src <= count2) {
                    A_Tuple child = A_Tuple.Companion.childAt(tuple2, src);
                    newNode.setSlot(ObjectSlots.SUBTUPLE_AT_, dest, child);
                    newNode.setIntSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, dest, size += A_Tuple.Companion.getTupleSize(child));
                    ++src;
                    ++dest;
                }
                newNode.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), newHash);
                this.check(newNode);
                return newNode;
            }
            int totalCount = count1 + count2;
            int leftCount = totalCount + 1 >> 1;
            int rightCount = totalCount - leftCount;
            AvailObject newLeft = this.createUninitializedTree(level, leftCount);
            AvailObject newRight = this.createUninitializedTree(level, rightCount);
            AvailObject target = newLeft;
            int destLimit = leftCount;
            int size = 0;
            int dest = 1;
            for (int whichSource = 1; whichSource < 3; ++whichSource) {
                A_Tuple source = whichSource == 1 ? tuple1 : tuple2;
                int limit = whichSource == 1 ? count1 : count2;
                int src = 1;
                while (src <= limit) {
                    A_Tuple child = A_Tuple.Companion.childAt(source, src);
                    if (dest > destLimit) {
                        boolean bl4;
                        boolean bl5 = bl4 = target == newLeft;
                        if (_Assertions.ENABLED && !bl4) {
                            String string4 = "Assertion failed";
                            throw new AssertionError((Object)string4);
                        }
                        target = newRight;
                        destLimit = rightCount;
                        dest = 1;
                        size = 0;
                    }
                    target.setSlot(ObjectSlots.SUBTUPLE_AT_, dest, child);
                    target.setIntSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, dest, size += A_Tuple.Companion.getTupleSize(child));
                    ++src;
                    ++dest;
                }
            }
            boolean bl6 = bl = target == newRight;
            if (_Assertions.ENABLED && !bl) {
                string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl7 = bl = dest == destLimit + 1;
            if (_Assertions.ENABLED && !bl) {
                string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.check(target);
            return this.createTwoPartTreeTuple(newLeft, newRight, level + 1, newHash);
        }

        @NotNull
        public final A_Tuple concatenateAtLeastOneTree(@NotNull AvailObject tuple1, @NotNull A_Tuple tuple2, boolean canDestroy) {
            boolean bl;
            int childCount1;
            int h2;
            boolean bl2;
            Intrinsics.checkNotNullParameter(tuple1, "tuple1");
            Intrinsics.checkNotNullParameter(tuple2, "tuple2");
            int size1 = A_Tuple.Companion.getTupleSize(tuple1);
            int size2 = A_Tuple.Companion.getTupleSize(tuple2);
            int level1 = A_Tuple.Companion.getTreeTupleLevel(tuple1);
            int level2 = A_Tuple.Companion.getTreeTupleLevel(tuple2);
            boolean bl3 = bl2 = level1 > 0 || level2 > 0;
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (!canDestroy) {
                tuple1.makeImmutable();
                tuple2.makeImmutable();
            }
            if (level1 == level2) {
                return this.concatenateSameLevel(tuple1, tuple2);
            }
            int newHash = 0;
            int h1 = tuple1.hashOrZero();
            if (h1 != 0 && (h2 = tuple2.hashOrZero()) != 0) {
                newHash = h1 + h2 * TupleDescriptor.Companion.multiplierRaisedTo(size1);
            }
            if (level1 > level2) {
                AvailObject availObject;
                boolean withoutLast2;
                childCount1 = A_Tuple.Companion.getChildCount(tuple1);
                A_Tuple oldLast = A_Tuple.Companion.childAt(tuple1, childCount1);
                A_Tuple newLast = A_Tuple.Companion.concatenateWith(oldLast, tuple2, true);
                if (A_Tuple.Companion.getTreeTupleLevel(newLast) == level1) {
                    TreeTupleDescriptor[] treeTupleDescriptorArray = this.getDescriptors().get((Object)Mutability.MUTABLE);
                    Intrinsics.checkNotNull(treeTupleDescriptorArray);
                    AvailObject withoutLast2 = AvailObjectRepresentation.Companion.newLike(treeTupleDescriptorArray[level1], tuple1, -1, -(childCount1 & 1));
                    if ((childCount1 & 1) == 0) {
                        withoutLast2.setIntSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, childCount1, 0);
                    }
                    withoutLast2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
                    return this.concatenateSameLevel(withoutLast2, newLast);
                }
                boolean bl4 = withoutLast2 = A_Tuple.Companion.getTreeTupleLevel(newLast) == level1 - 1;
                if (_Assertions.ENABLED && !withoutLast2) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                if (canDestroy && tuple1.descriptor().isMutable()) {
                    availObject = tuple1;
                } else {
                    TreeTupleDescriptor[] treeTupleDescriptorArray = this.getDescriptors().get((Object)Mutability.MUTABLE);
                    Intrinsics.checkNotNull(treeTupleDescriptorArray);
                    availObject = AvailObjectRepresentation.Companion.newLike(treeTupleDescriptorArray[level1], tuple1, 0, 0);
                }
                AvailObject result2 = availObject;
                result2.setSlot(ObjectSlots.SUBTUPLE_AT_, childCount1, newLast);
                result2.setIntSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, childCount1, tuple1.intSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, childCount1) + size2);
                result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), newHash);
                this.check(result2);
                return result2;
            }
            int n = childCount1 = level1 < level2 ? 1 : 0;
            if (_Assertions.ENABLED && childCount1 == 0) {
                String oldLast = "Assertion failed";
                throw new AssertionError((Object)oldLast);
            }
            int childCount2 = A_Tuple.Companion.getChildCount(tuple2);
            A_Tuple oldFirst = A_Tuple.Companion.childAt(tuple2, 1);
            oldFirst.makeImmutable();
            A_Tuple newFirst = A_Tuple.Companion.concatenateWith(tuple1, oldFirst, true);
            if (A_Tuple.Companion.getTreeTupleLevel(newFirst) == level2) {
                AvailObject withoutFirst = this.createUninitializedTree(level2, childCount2 - 1);
                int size = 0;
                int src = 2;
                if (src <= childCount2) {
                    while (true) {
                        A_Tuple child = A_Tuple.Companion.childAt(tuple2, src);
                        withoutFirst.setSlot(ObjectSlots.SUBTUPLE_AT_, src - 1, child);
                        withoutFirst.setIntSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, src - 1, size += A_Tuple.Companion.getTupleSize(child));
                        if (src == childCount2) break;
                        ++src;
                    }
                }
                withoutFirst.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
                this.check(withoutFirst);
                return this.concatenateSameLevel(newFirst, withoutFirst);
            }
            boolean bl5 = bl = A_Tuple.Companion.getTreeTupleLevel(newFirst) == level2 - 1;
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            return A_Tuple.Companion.replaceFirstChild(tuple2, newFirst);
        }

        private final int childSubscriptForIndex(AvailObject self, int index2) {
            boolean bl;
            int childCount = self.variableObjectSlotsCount();
            boolean bl2 = bl = index2 >= 1;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl3 = bl = index2 <= self.intSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, childCount);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            int childSlotIndex = self.intBinarySearch(IntegerSlots.CUMULATIVE_SIZES_AREA_, childCount, index2);
            return (childSlotIndex >= 0 ? childSlotIndex : ~childSlotIndex) - IntegerSlots.CUMULATIVE_SIZES_AREA_.ordinal() + 2;
        }

        private final int offsetForChildSubscript(AvailObject self, int childSubscript) {
            return childSubscript == 1 ? 0 : self.intSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, childSubscript - 1);
        }

        private final void check(AvailObject self) {
        }

        private final AvailObject createUninitializedTree(int level, int size) {
            TreeTupleDescriptor[] treeTupleDescriptorArray = this.getDescriptors().get((Object)Mutability.MUTABLE);
            Intrinsics.checkNotNull(treeTupleDescriptorArray);
            AvailObject instance = AvailObject.Companion.newObjectIndexedIntegerIndexedDescriptor(size, size + 1 >> 1, treeTupleDescriptorArray[level]);
            instance.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return instance;
        }

        @NotNull
        public final AvailObject createTwoPartTreeTuple(@NotNull A_Tuple left, @NotNull A_Tuple right, int newLevel, int newHashOrZero) {
            boolean bl;
            Intrinsics.checkNotNullParameter(left, "left");
            Intrinsics.checkNotNullParameter(right, "right");
            boolean bl2 = bl = A_Tuple.Companion.getTreeTupleLevel(left) == newLevel - 1;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl3 = bl = A_Tuple.Companion.getTreeTupleLevel(right) == newLevel - 1;
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            boolean bl4 = bl = A_Tuple.Companion.getTupleSize(left) > 0;
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            boolean bl5 = bl = A_Tuple.Companion.getTupleSize(right) > 0;
            if (_Assertions.ENABLED && !bl) {
                String string5 = "Assertion failed";
                throw new AssertionError((Object)string5);
            }
            AvailObject newNode = this.createUninitializedTree(newLevel, 2);
            newNode.setSlot(ObjectSlots.SUBTUPLE_AT_, 1, left);
            newNode.setSlot(ObjectSlots.SUBTUPLE_AT_, 2, right);
            newNode.setIntSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, 1, A_Tuple.Companion.getTupleSize(left));
            newNode.setIntSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, 2, A_Tuple.Companion.getTupleSize(left) + A_Tuple.Companion.getTupleSize(right));
            newNode.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), newHashOrZero);
            this.check(newNode);
            return newNode;
        }

        @NotNull
        public final AvailObject internalTreeReverse(@NotNull AvailObject self) {
            boolean bl;
            Intrinsics.checkNotNullParameter(self, "self");
            int childCount = A_Tuple.Companion.getChildCount(self);
            AvailObject newTree = this.createUninitializedTree(A_Tuple.Companion.getTreeTupleLevel(self), childCount);
            int cumulativeSize = 0;
            int src = childCount;
            int dest = 1;
            while (src > 0) {
                A_Tuple child = A_Tuple.Companion.childAt(self, src);
                newTree.setSlot(ObjectSlots.SUBTUPLE_AT_, dest, A_Tuple.Companion.tupleReverse(child));
                newTree.setIntSlot(IntegerSlots.CUMULATIVE_SIZES_AREA_, dest, cumulativeSize += A_Tuple.Companion.getTupleSize(child));
                --src;
                ++dest;
            }
            boolean bl2 = bl = cumulativeSize == A_Tuple.Companion.getTupleSize(self);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            newTree.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return newTree;
        }

        @NotNull
        public final EnumMap<Mutability, TreeTupleDescriptor[]> getDescriptors() {
            return descriptors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

