/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter;

import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.methods.MethodDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.interpreter.JavaLibrary;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelOne.L1InstructionWriter;
import avail.interpreter.levelOne.L1Operation;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PrimitiveOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_RUN_INFALLIBLE_PRIMITIVE;
import avail.interpreter.levelTwo.register.L2Register;
import avail.interpreter.levelTwoSimple.L2SimpleTranslator;
import avail.interpreter.levelTwoSimple.L2Simple_RunInfalliblePrimitiveNoCheck;
import avail.optimizer.L1Translator;
import avail.optimizer.L2Generator;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.optimizer.values.L2SemanticValue;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00be\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 Z2\u00020\u0001:\u0005Z[\\]^B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003J\u0016\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H'J:\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u0002052\f\u00106\u001a\b\u0012\u0004\u0012\u00020/072\u0006\u00108\u001a\u000209H\u0016J\u0006\u0010\n\u001a\u000209J\n\u0010:\u001a\u0004\u0018\u00010\u0000H\u0016J\u0006\u0010;\u001a\u00020<J\u0016\u0010=\u001a\u00020>2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020907H\u0016J&\u0010@\u001a\u00020%2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020<2\u0006\u0010J\u001a\u00020\u0006J\b\u0010K\u001a\u000209H$J\b\u0010L\u001a\u000209H\u0014J\u001e\u0010M\u001a\u0002092\u0006\u00104\u001a\u0002052\f\u0010?\u001a\b\u0012\u0004\u0012\u00020907H\u0016J>\u0010N\u001a\u00020<2\u0006\u00104\u001a\u0002052\f\u0010E\u001a\b\u0012\u0004\u0012\u00020O072\f\u0010?\u001a\b\u0012\u0004\u0012\u000209072\u0006\u0010A\u001a\u00020P2\n\u0010Q\u001a\u00060RR\u00020PJH\u0010S\u001a\u00020<2\u0006\u0010T\u001a\u00020O2\u0006\u00104\u001a\u0002052\f\u0010E\u001a\b\u0012\u0004\u0012\u00020O072\f\u0010?\u001a\b\u0012\u0004\u0012\u000209072\u0006\u0010A\u001a\u00020P2\n\u0010Q\u001a\u00060RR\u00020PH\u0016J \u0010U\u001a\u00020%2\u0006\u0010V\u001a\u00020\u00032\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\r\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R2\u0010\u0016\u001a&\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00060\u0006 \u0018*\u0012\u0012\f\u0012\n \u0018*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00170\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u000e\u0010 \u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0015\u00a8\u0006_"}, d2={"Lavail/interpreter/Primitive;", "", "argCount", "", "flags", "", "Lavail/interpreter/Primitive$Flag;", "(I[Lavail/interpreter/Primitive$Flag;)V", "getArgCount", "()I", "blockTypeRestriction", "Lavail/descriptor/representation/AvailObject;", "getBlockTypeRestriction$annotations", "()V", "failureVariableType", "getFailureVariableType$annotations", "getFailureVariableType", "()Lavail/descriptor/representation/AvailObject;", "name", "", "getName", "()Ljava/lang/String;", "primitiveFlags", "Ljava/util/EnumSet;", "kotlin.jvm.PlatformType", "<set-?>", "Lavail/performance/Statistic;", "reificationAbandonmentStat", "getReificationAbandonmentStat", "()Lavail/performance/Statistic;", "reificationForNoninlineStat", "getReificationForNoninlineStat", "resultTypeCheckingNanos", "runningNanos", "simpleName", "getSimpleName", "addNanosecondsCheckingResultType", "", "deltaNanoseconds", "", "interpreterIndex", "addNanosecondsRunning", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "attemptToGenerateSimpleInvocation", "Lavail/interpreter/levelTwo/operand/TypeRestriction;", "simpleTranslator", "Lavail/interpreter/levelTwoSimple/L2SimpleTranslator;", "functionIfKnown", "Lavail/descriptor/functions/A_Function;", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argRestrictions", "", "expectedType", "Lavail/descriptor/types/A_Type;", "bootstrapStyler", "canHaveNybblecodes", "", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "generateJvmCode", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "arguments", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedVectorOperand;", "result", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "hasFlag", "flag", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "tryToGenerateGeneralPrimitiveInvocation", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "tryToGenerateSpecialPrimitiveInvocation", "functionToCallReg", "writeDefaultFailureCode", "lineNumber", "writer", "Lavail/interpreter/levelOne/L1InstructionWriter;", "numArgs", "Companion", "Fallibility", "Flag", "PrimitiveHolder", "Result", "avail"})
public abstract class Primitive {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int argCount;
    @NotNull
    private final AvailObject blockTypeRestriction;
    private final EnumSet<Flag> primitiveFlags;
    @NotNull
    private final AvailObject failureVariableType;
    @Nullable
    private Statistic reificationAbandonmentStat;
    @Nullable
    private Statistic reificationForNoninlineStat;
    @NotNull
    private final String name;
    @NotNull
    private final String simpleName;
    @NotNull
    private Statistic runningNanos;
    @NotNull
    private final Statistic resultTypeCheckingNanos;
    @NotNull
    private static final CheckedMethod attemptMethod;

    public Primitive(int argCount, Flag ... flags) {
        Intrinsics.checkNotNullParameter(flags, "flags");
        this.argCount = argCount;
        this.blockTypeRestriction = this.privateBlockTypeRestriction().makeShared();
        this.primitiveFlags = EnumSet.noneOf(Flag.class);
        this.failureVariableType = this.privateFailureVariableType().makeShared();
        PrimitiveHolder primitiveHolder = PrimitiveHolder.Companion.getHoldersByClassName().get(this.getClass().getName());
        Intrinsics.checkNotNull(primitiveHolder);
        this.name = primitiveHolder.getName();
        String string2 = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue(string2, "javaClass.simpleName");
        this.simpleName = string2;
        this.resultTypeCheckingNanos = new Statistic(StatisticReport.PRIMITIVE_RETURNER_TYPE_CHECKS, this.simpleName + " (checking result)");
        int n = this.primitiveFlags.isEmpty();
        if (_Assertions.ENABLED && n == 0) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        int n2 = flags.length;
        for (n = 0; n < n2; ++n) {
            boolean bl;
            Flag flag = flags[n];
            boolean bl2 = bl = !this.primitiveFlags.contains((Object)flag);
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string4 = "Duplicate flag in " + this.getClass().getSimpleName();
                throw new AssertionError((Object)string4);
            }
            this.primitiveFlags.add(flag);
        }
        int n3 = n = !this.primitiveFlags.contains((Object)Flag.CanFold) || this.primitiveFlags.contains((Object)Flag.CanInline) ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            boolean $i$a$-assert-Primitive$42 = false;
            String $i$a$-assert-Primitive$42 = "Primitive " + this.getClass().getSimpleName() + " has CanFold without CanInline";
            throw new AssertionError((Object)$i$a$-assert-Primitive$42);
        }
        int n4 = n = !this.primitiveFlags.contains((Object)Flag.Invokes) || this.primitiveFlags.contains((Object)Flag.CanInline) ? 1 : 0;
        if (_Assertions.ENABLED && n == 0) {
            boolean bl = false;
            String string5 = "Primitive " + this.getClass().getSimpleName() + " has Invokes without CanInline";
            throw new AssertionError((Object)string5);
        }
        this.runningNanos = new Statistic(StatisticReport.PRIMITIVES, (this.hasFlag(Flag.CanInline) ? "" : "[NOT INLINE] ") + this.simpleName + " (running)");
        if (this.hasFlag(Flag.CanSwitchContinuations)) {
            this.reificationAbandonmentStat = new Statistic(StatisticReport.REIFICATIONS, "Abandoned for CONTINUATION_CHANGED from " + this.name);
        }
        if (!this.hasFlag(Flag.CanInline)) {
            this.reificationForNoninlineStat = new Statistic(StatisticReport.REIFICATIONS, "Reification for non-inline " + this.name);
        }
    }

    public final int getArgCount() {
        return this.argCount;
    }

    @Nullable
    public Primitive bootstrapStyler() {
        return null;
    }

    private static /* synthetic */ void getBlockTypeRestriction$annotations() {
    }

    @NotNull
    public final AvailObject getFailureVariableType() {
        return this.failureVariableType;
    }

    public static /* synthetic */ void getFailureVariableType$annotations() {
    }

    @Nullable
    public final Statistic getReificationAbandonmentStat() {
        return this.reificationAbandonmentStat;
    }

    @Nullable
    public final Statistic getReificationForNoninlineStat() {
        return this.reificationForNoninlineStat;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getSimpleName() {
        return this.simpleName;
    }

    @ReferencedInGeneratedCode
    @NotNull
    public abstract Result attempt(@NotNull Interpreter var1);

    @NotNull
    protected abstract A_Type privateBlockTypeRestriction();

    @NotNull
    public final A_Type blockTypeRestriction() {
        return this.blockTypeRestriction;
    }

    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        boolean bl;
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        boolean bl2 = bl = rawFunction2.codePrimitive() == this;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return A_Type.Companion.getReturnType(this.blockTypeRestriction());
    }

    @NotNull
    protected A_Type privateFailureVariableType() {
        return this.primitiveFlags.contains((Object)Flag.CannotFail) ? BottomTypeDescriptor.Companion.getBottom() : IntegerRangeTypeDescriptor.Companion.getNaturalNumbers();
    }

    @NotNull
    public Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        return this.hasFlag(Flag.CannotFail) ? Fallibility.CallSiteCannotFail : Fallibility.CallSiteCanFail;
    }

    public final boolean hasFlag(@NotNull Flag flag) {
        Intrinsics.checkNotNullParameter((Object)flag, "flag");
        return this.primitiveFlags.contains((Object)flag);
    }

    public final boolean canHaveNybblecodes() {
        return !this.hasFlag(Flag.CannotFail) || this.hasFlag(Flag.SpecialForm);
    }

    public void writeDefaultFailureCode(int lineNumber, @NotNull L1InstructionWriter writer, int numArgs) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        if (!this.hasFlag(Flag.CannotFail)) {
            int failureLocal = writer.createLocal(VariableTypeDescriptor.Companion.variableTypeFor(this.failureVariableType));
            int i2 = 1;
            if (i2 <= numArgs) {
                do {
                    int[] nArray = new int[]{++i2};
                    writer.write(lineNumber, L1Operation.L1_doPushLastLocal, nArray);
                } while (i2 != numArgs);
            }
            int[] nArray = new int[]{failureLocal};
            writer.write(lineNumber, L1Operation.L1_doGetLocal, nArray);
            nArray = new int[]{numArgs + 1};
            writer.write(lineNumber, L1Operation.L1_doMakeTuple, nArray);
            nArray = new int[]{writer.addLiteral(MethodDescriptor.SpecialMethodAtom.CRASH.getBundle()), writer.addLiteral(BottomTypeDescriptor.Companion.getBottom())};
            writer.write(lineNumber, L1Operation.L1_doCall, nArray);
        }
    }

    public final void addNanosecondsRunning(long deltaNanoseconds, int interpreterIndex) {
        this.runningNanos.record(deltaNanoseconds, interpreterIndex);
    }

    public final void addNanosecondsCheckingResultType(long deltaNanoseconds, int interpreterIndex) {
        this.resultTypeCheckingNanos.record(deltaNanoseconds, interpreterIndex);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean tryToGenerateGeneralPrimitiveInvocation(@NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Object object;
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        if (this.hasFlag(Flag.CanSuspend) || this.hasFlag(Flag.Invokes) || this.fallibilityForArgumentTypes(argumentTypes) != Fallibility.CallSiteCannotFail) {
            return false;
        }
        L2Generator generator = translator.getGenerator();
        A_Type guaranteedType = this.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
        TypeRestriction restriction2 = TypeRestriction.Companion.restrictionForType(guaranteedType.isBottom() ? (A_Type)PrimitiveTypeDescriptor.Types.TOP.getO() : guaranteedType, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG);
        L2SemanticValue semanticValue = null;
        if (this.hasFlag(Flag.CanFold) && !guaranteedType.isBottom()) {
            Collection<L2SemanticValue> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = arguments2;
            Primitive primitive2 = this;
            L2SemanticValue.Companion companion = L2SemanticValue.Companion;
            boolean $i$f$map = false;
            void var12_15 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                L2ReadBoxedOperand l2ReadBoxedOperand = (L2ReadBoxedOperand)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(p0.semanticValue());
            }
            collection2 = (List)destination$iv$iv;
            semanticValue = companion.primitiveInvocation(primitive2, (List<? extends L2SemanticValue>)collection2);
            L2ValueManifest manifest2 = generator.getCurrentManifest();
            object = manifest2.equivalentSemanticValue(semanticValue);
            if (object != null) {
                L2Operand[] equivalent = object;
                boolean bl = false;
                manifest2.setRestriction((L2SemanticValue)equivalent, manifest2.restrictionFor((L2SemanticValue)equivalent).intersectionWithType(guaranteedType));
                callSiteHelper.useAnswer(generator.readBoxed((L2SemanticValue)equivalent));
                return true;
            }
        } else {
            semanticValue = generator.newTemp();
        }
        L2WriteBoxedOperand writer = generator.boxedWrite(semanticValue, restriction2);
        object = new L2Operand[]{new L2ConstantOperand(rawFunction2), new L2PrimitiveOperand(this), new L2ReadBoxedVectorOperand(arguments2), writer};
        translator.addInstruction(L2_RUN_INFALLIBLE_PRIMITIVE.Companion.forPrimitive(this), (L2Operand)object);
        if (guaranteedType.isBottom()) {
            generator.addUnreachableCode();
        } else {
            callSiteHelper.useAnswer(translator.readBoxed(writer));
        }
        return true;
    }

    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public TypeRestriction attemptToGenerateSimpleInvocation(@NotNull L2SimpleTranslator simpleTranslator, @Nullable A_Function functionIfKnown, @NotNull A_RawFunction rawFunction2, @NotNull List<TypeRestriction> argRestrictions, @NotNull A_Type expectedType) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(simpleTranslator, "simpleTranslator");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argRestrictions, "argRestrictions");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        Iterable $this$map$iv = argRestrictions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeRestriction typeRestriction = (TypeRestriction)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.getType());
        }
        List argTypes2 = (List)destination$iv$iv;
        if (functionIfKnown == null) {
            return null;
        }
        if (!this.hasFlag(Flag.CanInline) || this.hasFlag(Flag.CanSwitchContinuations) || this.hasFlag(Flag.CanSuspend) || this.hasFlag(Flag.Invokes) || this.fallibilityForArgumentTypes(argTypes2) != Fallibility.CallSiteCannotFail) {
            return null;
        }
        A_Type guaranteedType = this.returnTypeGuaranteedByVM(rawFunction2, argTypes2);
        if (!A_Type.Companion.isSubtypeOf(guaranteedType, expectedType)) {
            return null;
        }
        simpleTranslator.add(new L2Simple_RunInfalliblePrimitiveNoCheck(simpleTranslator.getStackp(), functionIfKnown, rawFunction2, null, 8, null));
        return TypeRestriction.Companion.restrictionForType(guaranteedType, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG);
    }

    public final void generateJvmCode(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2ReadBoxedVectorOperand arguments2, @NotNull L2WriteBoxedOperand result2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(result2, "result");
        translator.loadInterpreter(method);
        Interpreter.Companion.getArgsBufferField().generateRead(method);
        if (!((Collection)arguments2.getElements()).isEmpty()) {
            method.visitInsn(89);
        }
        JavaLibrary.INSTANCE.getListClearMethod().generateCall(method);
        int limit = arguments2.getElements().size();
        for (int i2 = 0; i2 < limit; ++i2) {
            if (i2 < limit - 1) {
                method.visitInsn(89);
            }
            translator.load(method, (L2Register)((L2ReadBoxedOperand)arguments2.getElements().get(i2)).register());
            JavaLibrary.INSTANCE.getListAddMethod().generateCall(method);
            method.visitInsn(87);
        }
        translator.loadInterpreter(method);
        translator.literal(method, this);
        method.visitInsn(92);
        method.visitInsn(92);
        Interpreter.Companion.getBeforeAttemptPrimitiveMethod().generateCall(method);
        method.visitInsn(94);
        method.visitInsn(88);
        method.visitInsn(95);
        attemptMethod.generateCall(method);
        Interpreter.Companion.getAfterAttemptPrimitiveMethod().generateCall(method);
        if (this.hasFlag(Flag.AlwaysSwitchesContinuation)) {
            method.visitInsn(87);
            method.visitInsn(1);
            method.visitInsn(176);
        } else if (this.hasFlag(Flag.CanSwitchContinuations)) {
            translator.loadInterpreter(method);
            method.visitInsn(95);
            translator.literal(method, this);
            method.visitInsn(95);
            Interpreter.Companion.getOptionalReifierIfCanSwitchContinuationsMethod().generateCall(method);
            method.visitVarInsn(58, translator.reifierLocal());
            Label noSwitchContinuationsLabel = new Label();
            method.visitVarInsn(25, translator.reifierLocal());
            method.visitJumpInsn(198, noSwitchContinuationsLabel);
            method.visitVarInsn(25, translator.reifierLocal());
            method.visitInsn(176);
            method.visitLabel(noSwitchContinuationsLabel);
            translator.loadInterpreter(method);
            Interpreter.Companion.getGetLatestResultMethod().generateCall(method);
            translator.store(method, (L2Register)result2.register());
        } else {
            method.visitInsn(87);
            translator.loadInterpreter(method);
            Interpreter.Companion.getGetLatestResultMethod().generateCall(method);
            translator.store(method, (L2Register)result2.register());
        }
    }

    static {
        Class[] classArray = new Class[]{Interpreter.class};
        attemptMethod = CheckedMethod.Companion.instanceMethod(Primitive.class, "attempt", Result.class, classArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lavail/interpreter/Primitive$Result;", "", "(Ljava/lang/String;I)V", "SUCCESS", "FAILURE", "CONTINUATION_CHANGED", "READY_TO_INVOKE", "FIBER_SUSPENDED", "avail"})
    public static final class Result
    extends Enum<Result> {
        @ReferencedInGeneratedCode
        public static final /* enum */ Result SUCCESS = new Result();
        public static final /* enum */ Result FAILURE = new Result();
        public static final /* enum */ Result CONTINUATION_CHANGED = new Result();
        public static final /* enum */ Result READY_TO_INVOKE = new Result();
        public static final /* enum */ Result FIBER_SUSPENDED = new Result();
        private static final /* synthetic */ Result[] $VALUES;

        public static Result[] values() {
            return (Result[])$VALUES.clone();
        }

        public static Result valueOf(String value) {
            return Enum.valueOf(Result.class, value);
        }

        static {
            $VALUES = resultArray = new Result[]{Result.SUCCESS, Result.FAILURE, Result.CONTINUATION_CHANGED, Result.READY_TO_INVOKE, Result.FIBER_SUSPENDED};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0013\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0014"}, d2={"Lavail/interpreter/Primitive$Flag;", "", "(Ljava/lang/String;I)V", "CanFold", "CanInline", "CanSuspend", "HasSideEffect", "Invokes", "CanSwitchContinuations", "AlwaysSwitchesContinuation", "SpecialForm", "CannotFail", "Private", "Bootstrap", "CatchException", "PreserveFailureVariable", "PreserveArguments", "WritesToHiddenGlobalState", "ReadsFromHiddenGlobalState", "Unknown", "avail"})
    public static final class Flag
    extends Enum<Flag> {
        public static final /* enum */ Flag CanFold = new Flag();
        public static final /* enum */ Flag CanInline = new Flag();
        public static final /* enum */ Flag CanSuspend = new Flag();
        public static final /* enum */ Flag HasSideEffect = new Flag();
        public static final /* enum */ Flag Invokes = new Flag();
        public static final /* enum */ Flag CanSwitchContinuations = new Flag();
        public static final /* enum */ Flag AlwaysSwitchesContinuation = new Flag();
        public static final /* enum */ Flag SpecialForm = new Flag();
        public static final /* enum */ Flag CannotFail = new Flag();
        public static final /* enum */ Flag Private = new Flag();
        public static final /* enum */ Flag Bootstrap = new Flag();
        public static final /* enum */ Flag CatchException = new Flag();
        public static final /* enum */ Flag PreserveFailureVariable = new Flag();
        public static final /* enum */ Flag PreserveArguments = new Flag();
        public static final /* enum */ Flag WritesToHiddenGlobalState = new Flag();
        public static final /* enum */ Flag ReadsFromHiddenGlobalState = new Flag();
        public static final /* enum */ Flag Unknown = new Flag();
        private static final /* synthetic */ Flag[] $VALUES;

        public static Flag[] values() {
            return (Flag[])$VALUES.clone();
        }

        public static Flag valueOf(String value) {
            return Enum.valueOf(Flag.class, value);
        }

        static {
            $VALUES = flagArray = new Flag[]{Flag.CanFold, Flag.CanInline, Flag.CanSuspend, Flag.HasSideEffect, Flag.Invokes, Flag.CanSwitchContinuations, Flag.AlwaysSwitchesContinuation, Flag.SpecialForm, Flag.CannotFail, Flag.Private, Flag.Bootstrap, Flag.CatchException, Flag.PreserveFailureVariable, Flag.PreserveArguments, Flag.WritesToHiddenGlobalState, Flag.ReadsFromHiddenGlobalState, Flag.Unknown};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lavail/interpreter/Primitive$Fallibility;", "", "(Ljava/lang/String;I)V", "CallSiteCannotFail", "CallSiteCanFail", "CallSiteMustFail", "CallSiteMayInvoke", "avail"})
    public static final class Fallibility
    extends Enum<Fallibility> {
        public static final /* enum */ Fallibility CallSiteCannotFail = new Fallibility();
        public static final /* enum */ Fallibility CallSiteCanFail = new Fallibility();
        public static final /* enum */ Fallibility CallSiteMustFail = new Fallibility();
        public static final /* enum */ Fallibility CallSiteMayInvoke = new Fallibility();
        private static final /* synthetic */ Fallibility[] $VALUES;

        public static Fallibility[] values() {
            return (Fallibility[])$VALUES.clone();
        }

        public static Fallibility valueOf(String value) {
            return Enum.valueOf(Fallibility.class, value);
        }

        static {
            $VALUES = fallibilityArray = new Fallibility[]{Fallibility.CallSiteCannotFail, Fallibility.CallSiteCanFail, Fallibility.CallSiteMustFail, Fallibility.CallSiteMayInvoke};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007R\u001b\u0010\t\u001a\u00020\n8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lavail/interpreter/Primitive$PrimitiveHolder;", "", "name", "", "className", "(Ljava/lang/String;Ljava/lang/String;)V", "getClassName", "()Ljava/lang/String;", "getName", "primitive", "Lavail/interpreter/Primitive;", "getPrimitive", "()Lavail/interpreter/Primitive;", "primitive$delegate", "Lkotlin/Lazy;", "Companion", "avail"})
    public static final class PrimitiveHolder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final String className;
        @NotNull
        private final Lazy primitive$delegate;
        @NotNull
        private static final Map<String, PrimitiveHolder> holdersByName;
        @NotNull
        private static final Map<String, PrimitiveHolder> holdersByClassName;
        @NotNull
        private static final String allPrimitivesFileName = "/avail/interpreter/All_Primitives.txt";
        private static final Pattern primitiveNamePattern;

        public PrimitiveHolder(@NotNull String name, @NotNull String className) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(className, "className");
            this.name = name;
            this.className = className;
            this.primitive$delegate = LazyKt.lazy((Function0)new Function0<Primitive>(this){
                final /* synthetic */ PrimitiveHolder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final Primitive invoke() {
                    Primitive primitive2;
                    ClassLoader loader = Primitive.class.getClassLoader();
                    try {
                        Class<?> primClass = loader.loadClass(this.this$0.getClassName());
                        Intrinsics.checkNotNullExpressionValue(primClass, "primClass");
                        ? obj = JvmClassMappingKt.getKotlinClass(primClass).getObjectInstance();
                        Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type avail.interpreter.Primitive");
                        primitive2 = (Primitive)obj;
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException(e);
                    }
                    catch (NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    return primitive2;
                }
            });
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getClassName() {
            return this.className;
        }

        @NotNull
        public final Primitive getPrimitive() {
            Lazy lazy = this.primitive$delegate;
            return (Primitive)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        static {
            primitiveNamePattern = Pattern.compile("P_(\\w+)");
            Map byNames = new LinkedHashMap();
            Map byClassNames = new LinkedHashMap();
            try {
                URL uRL = PrimitiveHolder.class.getResource(allPrimitivesFileName);
                Intrinsics.checkNotNull(uRL);
                URL resource = uRL;
                Closeable closeable = new BufferedReader(new InputStreamReader(resource.openStream(), StandardCharsets.UTF_8));
                Throwable throwable = null;
                try {
                    BufferedReader input = (BufferedReader)closeable;
                    boolean bl = false;
                    while (true) {
                        boolean it2;
                        List parts;
                        String lastPart;
                        Matcher matcher;
                        List list2;
                        void $this$dropLastWhile$iv;
                        String string2;
                        String string3 = string2 = input.readLine();
                        if (string3 == null) break;
                        Intrinsics.checkNotNullExpressionValue(string3, "input.readLine() ?: break");
                        String className = string2;
                        Object object = className;
                        Regex regex = new Regex("\\.");
                        int n = 0;
                        object = regex.split((CharSequence)object, n);
                        boolean $i$f$dropLastWhile = false;
                        if (!$this$dropLastWhile$iv.isEmpty()) {
                            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                            while (iterator$iv.hasPrevious()) {
                                String it2 = (String)iterator$iv.previous();
                                boolean bl2 = false;
                                if (((CharSequence)it2).length() == 0) continue;
                                list2 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, iterator$iv.nextIndex() + 1);
                                break;
                            }
                        } else {
                            list2 = CollectionsKt.emptyList();
                        }
                        if (!(matcher = primitiveNamePattern.matcher(lastPart = (String)CollectionsKt.last(parts = list2))).matches()) continue;
                        String name = matcher.group(1);
                        boolean bl3 = it2 = !byNames.containsKey(name);
                        if (_Assertions.ENABLED && !it2) {
                            String string4 = "Assertion failed";
                            throw new AssertionError((Object)string4);
                        }
                        Intrinsics.checkNotNullExpressionValue(name, "name");
                        PrimitiveHolder holder = new PrimitiveHolder(name, className);
                        byNames.put(name, holder);
                        byClassNames.put(className, holder);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            holdersByName = byNames;
            holdersByClassName = byClassNames;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lavail/interpreter/Primitive$PrimitiveHolder$Companion;", "", "()V", "allPrimitivesFileName", "", "holdersByClassName", "", "Lavail/interpreter/Primitive$PrimitiveHolder;", "getHoldersByClassName", "()Ljava/util/Map;", "holdersByName", "getHoldersByName", "primitiveNamePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "primitiveByName", "Lavail/interpreter/Primitive;", "name", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Map<String, PrimitiveHolder> getHoldersByName() {
                return holdersByName;
            }

            @NotNull
            public final Map<String, PrimitiveHolder> getHoldersByClassName() {
                return holdersByClassName;
            }

            @Nullable
            public final Primitive primitiveByName(@NotNull String name) {
                Intrinsics.checkNotNullParameter(name, "name");
                PrimitiveHolder primitiveHolder = this.getHoldersByName().get(name);
                return primitiveHolder != null ? primitiveHolder.getPrimitive() : null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/Primitive$Companion;", "", "()V", "attemptMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getAttemptMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "validatePrimitiveAcceptsArguments", "", "primitive", "Lavail/interpreter/Primitive;", "arguments", "", "Lavail/descriptor/phrases/A_Phrase;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final String validatePrimitiveAcceptsArguments(@NotNull Primitive primitive2, @NotNull List<? extends A_Phrase> arguments2) {
            CharSequence charSequence;
            boolean bl;
            Intrinsics.checkNotNullParameter(primitive2, "primitive");
            Intrinsics.checkNotNullParameter(arguments2, "arguments");
            int expected2 = primitive2.getArgCount();
            if (expected2 == -1) {
                return null;
            }
            if (arguments2.size() != expected2) {
                Object[] objectArray = new Object[]{arguments2.size(), expected2};
                return String.format("number of declared arguments (%d) to agree with primitive's required number of arguments (%d).", objectArray);
            }
            A_Type expectedTypes = A_Type.Companion.getArgsTupleType(primitive2.blockTypeRestriction());
            boolean bl2 = bl = A_Number.Companion.getExtractInt(A_Type.Companion.getUpperBound(A_Type.Companion.getSizeRange(expectedTypes))) == expected2;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            CharSequence charSequence2 = new StringBuilder();
            StringBuilder $this$validatePrimitiveAcceptsArguments_u24lambda_u240 = charSequence2;
            boolean bl3 = false;
            int i2 = 1;
            if (i2 <= expected2) {
                while (true) {
                    A_Type expectedType;
                    A_Type declaredType;
                    if (!A_Type.Companion.isSubtypeOf(declaredType = A_Phrase.Companion.getDeclaredType(arguments2.get(i2 - 1)), expectedType = A_Type.Companion.typeAtIndex(expectedTypes, i2))) {
                        if (((CharSequence)$this$validatePrimitiveAcceptsArguments_u24lambda_u240).length() > 0) {
                            $this$validatePrimitiveAcceptsArguments_u24lambda_u240.append("\n");
                        }
                        Object[] objectArray = new Object[]{i2, A_Phrase.Companion.getToken(arguments2.get(i2 - 1)).string(), primitive2.getName(), expectedType, declaredType};
                        $this$validatePrimitiveAcceptsArguments_u24lambda_u240.append(String.format("argument #%d (%s) of primitive %s to be a subtype of %s, not %s.", objectArray));
                    }
                    if (i2 == expected2) break;
                    ++i2;
                }
            }
            String string3 = ((StringBuilder)charSequence2).toString();
            Intrinsics.checkNotNullExpressionValue(string3, "StringBuilder().apply(builderAction).toString()");
            String string4 = string3;
            charSequence2 = string4;
            if (charSequence2.length() == 0) {
                boolean bl4 = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            return (String)charSequence;
        }

        @NotNull
        public final CheckedMethod getAttemptMethod() {
            return attemptMethod;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

