/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.operation.L2ControlFlowOperation;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.JVMTranslator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lavail/interpreter/levelTwo/operation/L2_ADD_INT_TO_INT;", "Lavail/interpreter/levelTwo/operation/L2ControlFlowOperation;", "()V", "hasSideEffect", "", "getHasSideEffect", "()Z", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "instructionWasAdded", "manifest", "Lavail/optimizer/L2ValueManifest;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_ADD_INT_TO_INT
extends L2ControlFlowOperation {
    @NotNull
    public static final L2_ADD_INT_TO_INT INSTANCE = new L2_ADD_INT_TO_INT();

    private L2_ADD_INT_TO_INT() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_INT.named("augend"), L2OperandType.READ_INT.named("addend"), L2OperandType.WRITE_INT.named("sum", L2NamedOperandType.Purpose.SUCCESS), L2OperandType.PC.named("out of range", L2NamedOperandType.Purpose.FAILURE), L2OperandType.PC.named("in range", L2NamedOperandType.Purpose.SUCCESS)};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void instructionWasAdded(@NotNull L2Instruction instruction2, @NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(manifest2, "manifest");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2WriteIntOperand sumReg = (L2WriteIntOperand)instruction2.operand(2);
        L2PcOperand inRange = (L2PcOperand)instruction2.operand(4);
        super.instructionWasAdded(instruction2, manifest2);
        inRange.manifest().intersectType(sumReg.pickSemanticValue(), IntegerRangeTypeDescriptor.Companion.getInt32());
    }

    @Override
    public boolean getHasSideEffect() {
        return true;
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadIntOperand augend = (L2ReadIntOperand)instruction2.operand(0);
        L2ReadIntOperand addend = (L2ReadIntOperand)instruction2.operand(1);
        L2WriteIntOperand sum = (L2WriteIntOperand)instruction2.operand(2);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        builder.append(sum.registerString());
        builder.append(" \u2190 ");
        builder.append(augend.registerString());
        builder.append(" + ");
        builder.append(addend.registerString());
        this.renderOperandsStartingAt(instruction2, 3, desiredTypes, builder);
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2ReadIntOperand augendReg = (L2ReadIntOperand)instruction2.operand(0);
        L2ReadIntOperand addendReg = (L2ReadIntOperand)instruction2.operand(1);
        L2WriteIntOperand sumReg = (L2WriteIntOperand)instruction2.operand(2);
        L2PcOperand outOfRange = (L2PcOperand)instruction2.operand(3);
        L2PcOperand inRange = (L2PcOperand)instruction2.operand(4);
        translator.load(method, (L2Register)augendReg.register());
        method.visitInsn(133);
        translator.load(method, (L2Register)addendReg.register());
        method.visitInsn(133);
        method.visitInsn(97);
        Label longSumStart = new Label();
        Label longSumEnd = new Label();
        Type type2 = Type.LONG_TYPE;
        Intrinsics.checkNotNullExpressionValue(type2, "LONG_TYPE");
        int longSumLocal = translator.nextLocal(type2);
        method.visitLocalVariable("longSum", Type.LONG_TYPE.getDescriptor(), null, longSumStart, longSumEnd, longSumLocal);
        method.visitVarInsn(55, longSumLocal);
        method.visitLabel(longSumStart);
        method.visitVarInsn(22, longSumLocal);
        method.visitInsn(136);
        method.visitInsn(133);
        method.visitVarInsn(22, longSumLocal);
        method.visitInsn(148);
        translator.jumpIf(method, 154, outOfRange);
        method.visitVarInsn(22, longSumLocal);
        method.visitInsn(136);
        translator.store(method, (L2Register)sumReg.register());
        translator.jump(method, instruction2, inRange);
        method.visitLabel(longSumEnd);
        Type type3 = Type.LONG_TYPE;
        Intrinsics.checkNotNullExpressionValue(type3, "LONG_TYPE");
        translator.endLocal(longSumLocal, type3);
    }
}

