/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_Function;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L1InstructionStepper;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lavail/interpreter/levelTwo/operation/L2_REENTER_L1_CHUNK_FROM_INTERRUPT;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "hasSideEffect", "", "getHasSideEffect", "()Z", "reenterMethod", "Lavail/optimizer/jvm/CheckedMethod;", "isEntryPoint", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "reenter", "", "interpreter", "Lavail/interpreter/execution/Interpreter;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_REENTER_L1_CHUNK_FROM_INTERRUPT
extends L2Operation {
    @NotNull
    public static final L2_REENTER_L1_CHUNK_FROM_INTERRUPT INSTANCE = new L2_REENTER_L1_CHUNK_FROM_INTERRUPT();
    @NotNull
    private static final CheckedMethod reenterMethod;

    private L2_REENTER_L1_CHUNK_FROM_INTERRUPT() {
        super(new L2NamedOperandType[0]);
    }

    @Override
    public boolean getHasSideEffect() {
        return true;
    }

    @Override
    public boolean isEntryPoint(@NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        return true;
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        translator.loadInterpreter(method);
        reenterMethod.generateCall(method);
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    public static final void reenter(@NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        AvailObject availObject = interpreter.getReifiedContinuation();
        Intrinsics.checkNotNull(availObject);
        A_Continuation continuation = availObject;
        interpreter.setReifiedContinuation(A_Continuation.Companion.caller(continuation));
        if (Interpreter.Companion.getDebugL1()) {
            Logger logger = Interpreter.Companion.getLoggerDebugL1();
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue(level, "FINER");
            Object[] objectArray = new Object[]{interpreter.getDebugModeString()};
            Interpreter.Companion.log(logger, level, "{0}Reenter L1 from interrupt", objectArray);
        }
        A_Function a_Function = interpreter.function;
        Intrinsics.checkNotNull(a_Function);
        A_Function function = a_Function;
        boolean bl2 = bl = function == A_Continuation.Companion.function(continuation);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int numSlots = A_Continuation.Companion.numSlots(continuation);
        L1InstructionStepper stepper = interpreter.levelOneStepper;
        int n = numSlots + 1;
        AvailObject[] availObjectArray = new AvailObject[n];
        L1InstructionStepper l1InstructionStepper = stepper;
        for (int j = 0; j < n; ++j) {
            int n2 = j;
            availObjectArray[n2] = n2 == 0 ? NilDescriptor.Companion.getNil() : A_Continuation.Companion.stackAt(continuation, n2);
        }
        l1InstructionStepper.setPointers(availObjectArray);
        function.code().setUpInstructionDecoder(stepper.getInstructionDecoder());
        stepper.getInstructionDecoder().pc(A_Continuation.Companion.pc(continuation));
        stepper.setStackp(A_Continuation.Companion.stackp(continuation));
    }

    static {
        Class<Void> clazz = Void.TYPE;
        Intrinsics.checkNotNullExpressionValue(clazz, "TYPE");
        Class[] classArray = new Class[]{Interpreter.class};
        reenterMethod = CheckedMethod.Companion.staticMethod(L2_REENTER_L1_CHUNK_FROM_INTERRUPT.class, "reenter", clazz, classArray);
    }
}

