/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.types.A_Type;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.L2Synonym;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.JVMTranslator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0012H\u0016J0\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006$"}, d2={"Lavail/interpreter/levelTwo/operation/L2_STRENGTHEN_TYPE;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "hasSideEffect", "", "getHasSideEffect", "()Z", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "extractFunctionOuter", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "functionRegister", "outerIndex", "", "outerType", "Lavail/descriptor/types/A_Type;", "generator", "Lavail/optimizer/L2Generator;", "instructionWasAdded", "manifest", "Lavail/optimizer/L2ValueManifest;", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_STRENGTHEN_TYPE
extends L2Operation {
    @NotNull
    public static final L2_STRENGTHEN_TYPE INSTANCE = new L2_STRENGTHEN_TYPE();

    private L2_STRENGTHEN_TYPE() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED.named("input"), L2OperandType.WRITE_BOXED.named("output")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public boolean getHasSideEffect() {
        return true;
    }

    @Override
    @NotNull
    public L2ReadBoxedOperand extractFunctionOuter(@NotNull L2Instruction instruction2, @NotNull L2ReadBoxedOperand functionRegister, int outerIndex, @NotNull A_Type outerType, @NotNull L2Generator generator) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(functionRegister, "functionRegister");
        Intrinsics.checkNotNullParameter(outerType, "outerType");
        Intrinsics.checkNotNullParameter(generator, "generator");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand read2 = (L2ReadBoxedOperand)instruction2.operand(0);
        L2Instruction earlierInstruction = read2.definitionSkippingMoves(true);
        return earlierInstruction.getOperation().extractFunctionOuter(earlierInstruction, functionRegister, outerIndex, outerType, generator);
    }

    @Override
    public void instructionWasAdded(@NotNull L2Instruction instruction2, @NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(manifest2, "manifest");
        L2ReadBoxedOperand read2 = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteBoxedOperand write2 = (L2WriteBoxedOperand)instruction2.operand(1);
        read2.instructionWasAdded(manifest2);
        L2Synonym oldSynonym = manifest2.semanticValueToSynonym(read2.semanticValue());
        manifest2.forgetBoxedRegistersFor(oldSynonym);
        write2.instructionWasAddedForMove(read2.semanticValue(), manifest2);
        L2Synonym newSynonym = manifest2.semanticValueToSynonym(write2.pickSemanticValue());
        manifest2.updateConstraint(newSynonym, (Function1<? super L2ValueManifest.Constraint, Unit>)new Function1<L2ValueManifest.Constraint, Unit>(write2){
            final /* synthetic */ L2WriteBoxedOperand $write;
            {
                this.$write = $write;
                super(1);
            }

            public final void invoke(@NotNull L2ValueManifest.Constraint $this$updateConstraint) {
                Intrinsics.checkNotNullParameter($this$updateConstraint, "$this$updateConstraint");
                $this$updateConstraint.setRestriction($this$updateConstraint.getRestriction().intersection(this.$write.restriction()));
            }
        });
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, "desiredTypes");
        Intrinsics.checkNotNullParameter(builder, "builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, "warningStyleChange");
        boolean bl = Intrinsics.areEqual(this, instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand read2 = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteBoxedOperand write2 = (L2WriteBoxedOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder);
        builder.append(' ');
        builder.append(write2.registerString());
        builder.append(" \u2190 ");
        builder.append(read2.registerString());
        builder.append(" strengthened to " + write2.restriction());
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(method, "method");
        Intrinsics.checkNotNullParameter(instruction2, "instruction");
        L2ReadBoxedOperand source = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteBoxedOperand destination = (L2WriteBoxedOperand)instruction2.operand(1);
        if (source.finalIndex() != destination.finalIndex()) {
            translator.load(method, (L2Register)source.register());
            translator.store(method, (L2Register)destination.register());
        }
    }
}

