/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.DeclarationPhraseDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.ContinuationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapPrefixLabelDeclaration;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_BootstrapPrefixLabelDeclaration
extends Primitive {
    @NotNull
    public static final P_BootstrapPrefixLabelDeclaration INSTANCE = new P_BootstrapPrefixLabelDeclaration();

    private P_BootstrapPrefixLabelDeclaration() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        A_Type functionType;
        A_Type continuationType;
        A_Phrase labelDeclaration;
        A_Phrase conflictingDeclaration;
        A_Type a_Type;
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject optionalBlockArgumentsList = interpreter.argument(0);
        AvailObject optionalLabelPhrase = interpreter.argument(2);
        if (interpreter.availLoaderOrNull() == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        boolean bl3 = bl2 = A_Phrase.Companion.getExpressionsSize(optionalLabelPhrase) == 1;
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Phrase labelPairPhrase = A_Phrase.Companion.getLastExpression(optionalLabelPhrase);
        boolean bl4 = bl = A_Phrase.Companion.getExpressionsSize(labelPairPhrase) == 2;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        A_Phrase labelNamePhrase = A_Phrase.Companion.expressionAt(labelPairPhrase, 1);
        AvailObject labelName = A_Phrase.Companion.getToken(labelNamePhrase).literal();
        if (labelName.tokenType() != TokenDescriptor.TokenType.KEYWORD) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "label name to be alphanumeric", new Object[0]);
        }
        A_Phrase optionalLabelReturnTypePhrase = A_Phrase.Companion.expressionAt(labelPairPhrase, 2);
        A_Phrase labelReturnTypePhrase = null;
        if (A_Phrase.Companion.getExpressionsSize(optionalLabelReturnTypePhrase) == 1) {
            labelReturnTypePhrase = A_Phrase.Companion.expressionAt(optionalLabelReturnTypePhrase, 1);
            boolean bl5 = A_Phrase.Companion.phraseKindIsUnder(labelReturnTypePhrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE);
            if (_Assertions.ENABLED && !bl5) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            a_Type = A_Phrase.Companion.getToken(labelReturnTypePhrase).literal();
        } else {
            labelReturnTypePhrase = NilDescriptor.Companion.getNil();
            a_Type = BottomTypeDescriptor.Companion.getBottom();
        }
        A_Type labelReturnType = a_Type;
        List blockArgumentTypes = new ArrayList();
        if (A_Phrase.Companion.getExpressionsSize(optionalBlockArgumentsList) > 0) {
            boolean bl6;
            boolean bl7;
            boolean bl8 = bl7 = A_Phrase.Companion.getExpressionsSize(optionalBlockArgumentsList) == 1;
            if (_Assertions.ENABLED && !bl7) {
                String string5 = "Assertion failed";
                throw new AssertionError((Object)string5);
            }
            A_Phrase blockArgumentsList = A_Phrase.Companion.getLastExpression(optionalBlockArgumentsList);
            boolean bl9 = bl6 = A_Phrase.Companion.getExpressionsSize(blockArgumentsList) >= 1;
            if (_Assertions.ENABLED && !bl6) {
                String string6 = "Assertion failed";
                throw new AssertionError((Object)string6);
            }
            for (AvailObject argumentPair : A_Phrase.Companion.getExpressionsTuple(blockArgumentsList)) {
                boolean bl10;
                boolean bl11 = bl10 = A_Phrase.Companion.getExpressionsSize(argumentPair) == 2;
                if (_Assertions.ENABLED && !bl10) {
                    String string7 = "Assertion failed";
                    throw new AssertionError((Object)string7);
                }
                A_Phrase typePhrase = A_Phrase.Companion.getLastExpression(argumentPair);
                boolean bl12 = typePhrase.isInstanceOfKind(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(InstanceMetaDescriptor.Companion.anyMeta()));
                if (_Assertions.ENABLED && !bl12) {
                    String string8 = "Assertion failed";
                    throw new AssertionError((Object)string8);
                }
                AvailObject argType = A_Phrase.Companion.getToken(typePhrase).literal();
                boolean bl13 = argType.isType();
                if (_Assertions.ENABLED && !bl13) {
                    String string9 = "Assertion failed";
                    throw new AssertionError((Object)string9);
                }
                blockArgumentTypes.add(argType);
            }
        }
        if ((conflictingDeclaration = FiberDescriptor.Companion.addDeclaration(labelDeclaration = DeclarationPhraseDescriptor.Companion.newLabel(labelName, labelReturnTypePhrase, continuationType = ContinuationTypeDescriptor.Companion.continuationTypeForFunctionType(functionType = FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tupleFromList(blockArgumentTypes), labelReturnType, null, 4, null))))) != null) {
            String kind2 = conflictingDeclaration.declarationKind().nativeKindName();
            int lineNumber = A_Phrase.Companion.getToken(conflictingDeclaration).lineNumber();
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "label declaration " + labelName.string() + " to have a name that doesn't shadow an existing " + kind2 + " (from line " + lineNumber + ")", new Object[0]);
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_Type[] a_TypeArray = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), InstanceMetaDescriptor.Companion.anyMeta()};
        A_BasicObject a_BasicObject = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.oneOrMoreOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray))));
        a_TypeArray = new A_Type[2];
        a_TypeArray[0] = PrimitiveTypeDescriptor.Types.TOKEN.getO();
        A_Type[] a_TypeArray2 = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), InstanceMetaDescriptor.Companion.anyMeta()};
        a_TypeArray[1] = TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray2));
        A_BasicObject a_BasicObject2 = PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray)));
        a_TypeArray = new A_Type[]{PrimitiveTypeDescriptor.Types.TOKEN.getO(), TupleTypeDescriptor.Companion.zeroOrOneOf(InstanceMetaDescriptor.Companion.topMeta())};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(a_BasicObject, a_BasicObject2, PhraseTypeDescriptor.PhraseKind.LIST_PHRASE.create(TupleTypeDescriptor.Companion.zeroOrOneOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray)))), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

