/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.ListPhraseTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_ModuleHeaderPrefixCheckModuleVersion;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_ModuleHeaderPrefixCheckModuleVersion
extends Primitive {
    @NotNull
    public static final P_ModuleHeaderPrefixCheckModuleVersion INSTANCE = new P_ModuleHeaderPrefixCheckModuleVersion();

    private P_ModuleHeaderPrefixCheckModuleVersion() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Private, Primitive.Flag.Bootstrap};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        AvailObject versionsOptionalList = interpreter.argument(1);
        boolean bl2 = bl = A_Phrase.Companion.getExpressionsSize(versionsOptionalList) == 1;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Phrase versions = A_Phrase.Companion.expressionAt(versionsOptionalList, 1);
        int versionsCount = A_Phrase.Companion.getExpressionsSize(versions);
        A_Phrase latestVersionPhrase = A_Phrase.Companion.getLastExpression(versions);
        boolean bl3 = A_Phrase.Companion.phraseKindIsUnder(latestVersionPhrase, PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE);
        if (_Assertions.ENABLED && !bl3) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        A_Token latestVersionToken = A_Phrase.Companion.getToken(latestVersionPhrase);
        boolean bl4 = latestVersionToken.isLiteralToken();
        if (_Assertions.ENABLED && !bl4) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        AvailObject latestVersionString = latestVersionToken.literal().literal();
        for (int i2 = 1; i2 < versionsCount; ++i2) {
            A_Phrase oldVersionPhrase = A_Phrase.Companion.expressionAt(versions, i2);
            AvailObject oldVersion = A_Phrase.Companion.getToken(oldVersionPhrase).literal().literal();
            if (!latestVersionString.equals(oldVersion)) continue;
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "module version " + latestVersionString + " to be unique, not a duplicate of #" + i2 + " in the list (on line " + A_Phrase.Companion.getToken(oldVersionPhrase).lineNumber() + ")", new Object[0]);
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{PhraseTypeDescriptor.Constants.INSTANCE.getStringLiteralType(), ListPhraseTypeDescriptor.Companion.zeroOrOneList(ListPhraseTypeDescriptor.Companion.zeroOrMoreList(PhraseTypeDescriptor.Constants.INSTANCE.getStringLiteralType()))};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

