/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/files/P_FileMove;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_FileMove
extends Primitive {
    @NotNull
    public static final P_FileMove INSTANCE = new P_FileMove();

    private P_FileMove() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        CopyOption[] copyOptionArray;
        Path path;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject source = interpreter.argument(0);
        AvailObject destination = interpreter.argument(1);
        AvailObject overwrite = interpreter.argument(2);
        Path sourcePath = null;
        try {
            Path path2 = IOSystem.Companion.getFileSystem().getPath(A_String.Companion.asNativeString(source), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path2, "IOSystem.fileSystem.getP\u2026\tsource.asNativeString())");
            sourcePath = path2;
            path = IOSystem.Companion.getFileSystem().getPath(A_String.Companion.asNativeString(destination), new String[0]);
            Intrinsics.checkNotNullExpressionValue(path, "{\n\t\t\t\tsourcePath = IOSys\u2026on.asNativeString())\n\t\t\t}");
        }
        catch (InvalidPathException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INVALID_PATH);
        }
        Path destinationPath = path;
        if (A_Atom.Companion.getExtractBoolean(overwrite)) {
            CopyOption[] e = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            copyOptionArray = e;
        } else {
            copyOptionArray = new CopyOption[]{};
        }
        CopyOption[] options = copyOptionArray;
        try {
            Files.move(sourcePath, destinationPath, Arrays.copyOf(options, options.length));
        }
        catch (SecurityException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (AccessDeniedException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_PERMISSION_DENIED);
        }
        catch (NoSuchFileException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_NO_FILE);
        }
        catch (FileAlreadyExistsException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_FILE_EXISTS);
        }
        catch (IOException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_IO_ERROR);
        }
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getStringType(), TupleTypeDescriptor.Companion.getStringType(), EnumerationTypeDescriptor.Companion.getBooleanType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_PATH, AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_NO_FILE, AvailErrorCode.E_FILE_EXISTS, AvailErrorCode.E_IO_ERROR};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

