/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.general;

import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.serialization.Deserializer;
import avail.utility.CollectionExtensionsKt;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/general/P_Deserialize;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_Deserialize
extends Primitive {
    @NotNull
    public static final P_Deserialize INSTANCE = new P_Deserialize();

    private P_Deserialize() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject bytes2 = interpreter.argument(0);
        AvailObject module = interpreter.argument(1);
        byte[] byteArray = null;
        if (bytes2.isByteArrayTuple()) {
            byteArray = A_Tuple.Companion.getByteArray(bytes2);
        } else if (bytes2.isByteBufferTuple()) {
            ByteBuffer buffer = A_Tuple.Companion.getByteBuffer(bytes2).slice();
            if (buffer.hasArray()) {
                byte[] byArray = buffer.array();
                Intrinsics.checkNotNullExpressionValue(byArray, "buffer.array()");
                byteArray = byArray;
            } else {
                int limit = buffer.limit();
                byteArray = new byte[limit];
                buffer.get(byteArray);
            }
        } else {
            int limit = A_Tuple.Companion.getTupleSize(bytes2);
            ByteBuffer buffer = ByteBuffer.allocate(limit);
            A_Tuple a_Tuple = bytes2;
            Intrinsics.checkNotNullExpressionValue(buffer, "buffer");
            A_Tuple.Companion.transferIntoByteBuffer(a_Tuple, 1, limit, buffer);
            byte[] byArray = buffer.array();
            Intrinsics.checkNotNullExpressionValue(byArray, "buffer.array()");
            byteArray = byArray;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(byteArray);
        Deserializer deserializer2 = new Deserializer(input, interpreter.runtime, null, 4, null);
        deserializer2.setCurrentModule(module);
        List values2 = new ArrayList();
        try {
            CollectionsKt.addAll((Collection)values2, CollectionExtensionsKt.iterableWith(deserializer2.deserialize(), (Function1)new Function1<AvailObject, AvailObject>(deserializer2){
                final /* synthetic */ Deserializer $deserializer;
                {
                    this.$deserializer = $deserializer;
                    super(1);
                }

                @Nullable
                public final AvailObject invoke(@NotNull AvailObject it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return this.$deserializer.deserialize();
                }
            }));
        }
        catch (Exception e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_DESERIALIZATION_FAILED);
        }
        return interpreter.primitiveSuccess(ObjectTupleDescriptor.Companion.tupleFromList(values2));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.zeroOrMoreOf(IntegerRangeTypeDescriptor.Companion.getBytes()), PrimitiveTypeDescriptor.Types.MODULE.getO()), TupleTypeDescriptor.Companion.zeroOrMoreOf(PrimitiveTypeDescriptor.Types.ANY.getO()), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_DESERIALIZATION_FAILED};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

