/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.methods;

import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_SemanticRestriction;
import avail.descriptor.methods.SemanticRestrictionDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.exceptions.SignatureException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/methods/P_AddSemanticRestrictionForAtom;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_AddSemanticRestrictionForAtom
extends Primitive {
    @NotNull
    public static final P_AddSemanticRestrictionForAtom INSTANCE = new P_AddSemanticRestrictionForAtom();

    private P_AddSemanticRestrictionForAtom() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.Unknown};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject atom = interpreter.argument(0);
        AvailObject function = interpreter.argument(1);
        A_Type functionType = function.kind();
        A_Type tupleType = A_Type.Companion.getArgsTupleType(functionType);
        AvailLoader availLoader = interpreter.availLoaderOrNull();
        if (availLoader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        AvailLoader loader = availLoader;
        if (!loader.getPhase().isExecuting()) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION);
        }
        for (int i2 = A_RawFunction.Companion.numArgs(function.code()); 0 < i2; --i2) {
            if (A_Type.Companion.typeAtIndex(tupleType, i2).isInstanceMeta()) continue;
            return interpreter.primitiveFailure(AvailErrorCode.E_TYPE_RESTRICTION_MUST_ACCEPT_ONLY_TYPES);
        }
        try {
            A_Method method = A_Bundle.Companion.getBundleMethod(A_Atom.Companion.bundleOrCreate(atom));
            A_SemanticRestriction restriction2 = SemanticRestrictionDescriptor.Companion.newSemanticRestriction(function, method, interpreter.module());
            loader.addSemanticRestriction(restriction2);
        }
        catch (MalformedMessageException e) {
            return interpreter.primitiveFailure(e);
        }
        catch (SignatureException e) {
            return interpreter.primitiveFailure(e);
        }
        A_RawFunction.Companion.setMethodName(function.code(), StringDescriptor.Companion.stringFrom("Semantic restriction of " + A_Atom.Companion.getAtomName(atom)));
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.ATOM.getO(), FunctionTypeDescriptor.Companion.functionTypeReturning(InstanceMetaDescriptor.Companion.topMeta())), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_LOADING_IS_OVER, AvailErrorCode.E_CANNOT_DEFINE_DURING_COMPILATION, AvailErrorCode.E_TYPE_RESTRICTION_MUST_ACCEPT_ONLY_TYPES, AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(A_Set.Companion.setUnionCanDestroy(SetDescriptor.Companion.set(availErrorCodeArray), MessageSplitter.Companion.getPossibleErrors(), true));
    }
}

