/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.objects;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.maps.A_Map;
import avail.descriptor.objects.ObjectTypeDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\u0011"}, d2={"Lavail/interpreter/primitive/objects/P_GetObjectField;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "avail"})
public final class P_GetObjectField
extends Primitive {
    @NotNull
    public static final P_GetObjectField INSTANCE = new P_GetObjectField();

    private P_GetObjectField() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(2);
        List<AvailObject> list2 = interpreter.argsBuffer;
        AvailObject obj = list2.get(0);
        AvailObject field = list2.get(1);
        AvailObject fieldValue = obj.fieldAtOrNull(field);
        return fieldValue == null ? interpreter.primitiveFailure(AvailErrorCode.E_NO_SUCH_FIELD) : interpreter.primitiveSuccess(fieldValue);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(ObjectTypeDescriptor.Companion.getMostGeneralObjectType(), PrimitiveTypeDescriptor.Types.ATOM.getO()), PrimitiveTypeDescriptor.Types.ANY.getO(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type objectType = argumentTypes.get(0);
        A_Type fieldType = argumentTypes.get(1);
        if (objectType.isBottom()) {
            return BottomTypeDescriptor.Companion.getBottom();
        }
        A_Map fieldTypeMap = A_Type.Companion.getFieldTypeMap(objectType);
        if (fieldType.isEnumeration()) {
            A_Type union = BottomTypeDescriptor.Companion.getBottom();
            for (AvailObject possibleField : A_Type.Companion.getInstances(fieldType)) {
                AvailObject newType;
                if (A_Map.Companion.mapAtOrNull(fieldTypeMap, possibleField) == null) {
                    return PrimitiveTypeDescriptor.Types.ANY.getO();
                }
                union = A_Type.Companion.typeUnion(union, newType);
            }
            return union;
        }
        return super.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type objectType = argumentTypes.get(0);
        A_Type fieldType = argumentTypes.get(1);
        A_Map fieldTypeMap = A_Type.Companion.getFieldTypeMap(objectType);
        if (fieldType.isEnumeration()) {
            for (AvailObject possibleField : A_Type.Companion.getInstances(fieldType)) {
                if (A_Map.Companion.hasKey(fieldTypeMap, possibleField)) continue;
                return Primitive.Fallibility.CallSiteCanFail;
            }
            return Primitive.Fallibility.CallSiteCannotFail;
        }
        return Primitive.Fallibility.CallSiteCanFail;
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_NO_SUCH_FIELD};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

