/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.objects;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.objects.ObjectTypeDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.InstanceMetaDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/primitive/objects/P_TupleToObjectType;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_TupleToObjectType
extends Primitive {
    @NotNull
    public static final P_TupleToObjectType INSTANCE = new P_TupleToObjectType();

    private P_TupleToObjectType() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject tuple2 = interpreter.argument(0);
        return interpreter.primitiveSuccess(ObjectTypeDescriptor.Companion.objectTypeFromTuple(tuple2));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_Type[] a_TypeArray = new A_Type[]{PrimitiveTypeDescriptor.Types.ATOM.getO(), InstanceMetaDescriptor.Companion.anyMeta()};
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.zeroOrMoreOf(TupleTypeDescriptor.Companion.tupleTypeForTypes(a_TypeArray))), ObjectTypeDescriptor.Companion.getMostGeneralObjectMeta(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type tupleType = argumentTypes.get(0);
        A_Type tupleSizes = A_Type.Companion.getSizeRange(tupleType);
        A_Number tupleSizeLowerBound = A_Type.Companion.getLowerBound(tupleSizes);
        if (!tupleSizeLowerBound.equals(A_Type.Companion.getUpperBound(tupleSizes)) || !A_Number.Companion.isInt(tupleSizeLowerBound)) {
            return super.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
        }
        int tupleSize = A_Number.Companion.getExtractInt(tupleSizeLowerBound);
        A_Map fieldTypeMap = MapDescriptor.Companion.getEmptyMap();
        int i2 = 1;
        if (i2 <= tupleSize) {
            while (true) {
                String string2;
                A_Type pairType;
                boolean bl;
                boolean bl2 = bl = A_Number.Companion.getExtractInt(A_Type.Companion.getLowerBound(A_Type.Companion.getSizeRange(pairType = A_Type.Companion.typeAtIndex(tupleType, i2)))) == 2;
                if (_Assertions.ENABLED && !bl) {
                    string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                boolean bl3 = bl = A_Number.Companion.getExtractInt(A_Type.Companion.getUpperBound(A_Type.Companion.getSizeRange(pairType))) == 2;
                if (_Assertions.ENABLED && !bl) {
                    string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Type keyType = A_Type.Companion.typeAtIndex(pairType, 1);
                if (!keyType.isEnumeration() || !A_Number.Companion.equalsInt(A_Type.Companion.getInstanceCount(keyType), 1)) {
                    return super.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
                }
                AvailObject keyValue = A_Type.Companion.getInstance(keyType);
                boolean bl4 = keyValue.isAtom();
                if (_Assertions.ENABLED && !bl4) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                if (A_Map.Companion.hasKey(fieldTypeMap, keyValue)) {
                    return super.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
                }
                A_Type valueMeta = A_Type.Companion.typeAtIndex(pairType, 2);
                boolean bl5 = valueMeta.isInstanceMeta();
                if (_Assertions.ENABLED && !bl5) {
                    String string4 = "Assertion failed";
                    throw new AssertionError((Object)string4);
                }
                AvailObject valueType = A_Type.Companion.getInstance(valueMeta);
                fieldTypeMap = A_Map.Companion.mapAtPuttingCanDestroy(fieldTypeMap, keyValue, valueType, true);
                if (i2 == tupleSize) break;
                ++i2;
            }
        }
        return InstanceMetaDescriptor.Companion.instanceMeta(ObjectTypeDescriptor.Companion.objectTypeFromMap(fieldTypeMap));
    }
}

