/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.sets;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.SetTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.TypeRestriction;
import avail.interpreter.levelTwo.operation.L2_CREATE_SET;
import avail.optimizer.L1Translator;
import avail.optimizer.L2Generator;
import avail.optimizer.values.L2SemanticPrimitiveInvocation;
import avail.optimizer.values.L2SemanticValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\rH\u0016JH\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016R\u00020\u0014H\u0016\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/primitive/sets/P_TupleToSet;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_TupleToSet
extends Primitive {
    @NotNull
    public static final P_TupleToSet INSTANCE = new P_TupleToSet();

    private P_TupleToSet() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject tuple2 = interpreter.argument(0);
        return interpreter.primitiveSuccess(A_Tuple.Companion.getAsSet(tuple2));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getMostGeneralTupleType()), SetTypeDescriptor.Companion.mostGeneralSetType(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type tupleType = argumentTypes.get(0);
        A_Type unionType = A_Type.Companion.unionOfTypesAtThrough(tupleType, 1, Integer.MAX_VALUE);
        unionType.makeImmutable();
        A_Type tupleSizes = A_Type.Companion.getSizeRange(tupleType);
        AvailObject minSize = A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(tupleSizes), 0) ? IntegerDescriptor.Companion.getZero() : IntegerDescriptor.Companion.getOne();
        A_Type setSizes = IntegerRangeTypeDescriptor.Companion.integerRangeType(minSize, true, A_Type.Companion.getUpperBound(tupleSizes), A_Type.Companion.getUpperInclusive(tupleSizes));
        return SetTypeDescriptor.Companion.setTypeForSizesContentType(setSizes, unionType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction2, @NotNull List<L2ReadBoxedOperand> arguments2, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Collection<L2SemanticValue> collection2;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(functionToCallReg, "functionToCallReg");
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        Intrinsics.checkNotNullParameter(translator, "translator");
        Intrinsics.checkNotNullParameter(callSiteHelper, "callSiteHelper");
        L2ReadBoxedOperand tupleReg = arguments2.get(0);
        L2Generator generator = translator.getGenerator();
        if (!generator.currentlyReachable()) {
            return true;
        }
        A_Type sizeRange = A_Type.Companion.getSizeRange(tupleReg.type());
        A_Number size = A_Type.Companion.getLowerBound(sizeRange);
        if (!A_Number.Companion.isInt(size) || !A_Type.Companion.getUpperBound(sizeRange).equals(size)) {
            return false;
        }
        int sizeInt = A_Number.Companion.getExtractInt(size);
        List<L2ReadBoxedOperand> elementRegs = generator.explodeTupleIfPossible(tupleReg, CollectionsKt.toList(A_Type.Companion.tupleOfTypesFromTo(tupleReg.type(), 1, sizeInt)));
        if (elementRegs == null) {
            return false;
        }
        A_Type restriction2 = this.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
        Iterable iterable = arguments2;
        Primitive primitive2 = this;
        L2SemanticValue.Companion companion = L2SemanticValue.Companion;
        boolean $i$f$map = false;
        void var17_19 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            L2ReadBoxedOperand l2ReadBoxedOperand = (L2ReadBoxedOperand)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it.semanticValue());
        }
        collection2 = (List)destination$iv$iv;
        L2SemanticPrimitiveInvocation semanticResult = companion.primitiveInvocation(primitive2, (List<? extends L2SemanticValue>)collection2);
        L2WriteBoxedOperand write2 = generator.boxedWrite(semanticResult, TypeRestriction.Companion.restrictionForType(restriction2, TypeRestriction.RestrictionFlagEncoding.BOXED_FLAG));
        L2Operand[] l2OperandArray = new L2Operand[]{new L2ReadBoxedVectorOperand(elementRegs), write2};
        generator.addInstruction(L2_CREATE_SET.INSTANCE, l2OperandArray);
        callSiteHelper.useAnswer(translator.readBoxed(write2));
        return true;
    }
}

