/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.tuples;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\nH\u0014J\u001e\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lavail/interpreter/primitive/tuples/P_TupleSwapElements;", "Lavail/interpreter/Primitive;", "()V", "maximumComplexity", "", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_TupleSwapElements
extends Primitive {
    @NotNull
    public static final P_TupleSwapElements INSTANCE = new P_TupleSwapElements();
    private static final int maximumComplexity = 100;

    private P_TupleSwapElements() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        int index2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject tuple2 = interpreter.argument(0);
        AvailObject indexObject1 = interpreter.argument(1);
        AvailObject indexObject2 = interpreter.argument(2);
        if (!A_Number.Companion.isInt(indexObject1) || !A_Number.Companion.isInt(indexObject2)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS);
        }
        int index1 = A_Number.Companion.getExtractInt(indexObject1);
        if (index1 == (index2 = A_Number.Companion.getExtractInt(indexObject2))) {
            return interpreter.primitiveSuccess(tuple2);
        }
        AvailObject temp1 = A_Tuple.Companion.tupleAt(tuple2, index1);
        AvailObject temp2 = A_Tuple.Companion.tupleAt(tuple2, index2);
        A_Tuple newTuple2 = A_Tuple.Companion.tupleAtPuttingCanDestroy(tuple2, index1, temp2, true);
        newTuple2 = A_Tuple.Companion.tupleAtPuttingCanDestroy(newTuple2, index2, temp1, true);
        return interpreter.primitiveSuccess(newTuple2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(TupleTypeDescriptor.Companion.getMostGeneralTupleType(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.getNaturalNumbers()), TupleTypeDescriptor.Companion.getMostGeneralTupleType(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type originalTupleType = argumentTypes.get(0);
        A_Type indexRange1 = argumentTypes.get(1);
        A_Type indexRange2 = argumentTypes.get(2);
        A_Type tupleSizeRange = A_Type.Companion.getSizeRange(originalTupleType);
        A_Number lowerBound1 = A_Type.Companion.getLowerBound(indexRange1);
        A_Number lowerBound2 = A_Type.Companion.getLowerBound(indexRange2);
        if (!A_Number.Companion.isInt(lowerBound1) || !A_Number.Companion.isInt(lowerBound2)) {
            return super.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
        }
        int maxLowerBound = Math.max(A_Number.Companion.getExtractInt(lowerBound1), A_Number.Companion.getExtractInt(lowerBound2));
        A_Number maxTupleSize = A_Type.Companion.getUpperBound(tupleSizeRange);
        if (A_Number.Companion.isInt(maxTupleSize) && maxLowerBound > A_Number.Companion.getExtractInt(maxTupleSize)) {
            return super.returnTypeGuaranteedByVM(rawFunction2, argumentTypes);
        }
        int minLowerBound = Math.min(A_Number.Companion.getExtractInt(lowerBound1), A_Number.Companion.getExtractInt(lowerBound2));
        int startOfSmear = Math.min(minLowerBound, 100);
        AvailObject newLeadingTypes2 = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(startOfSmear - 1, (Function1<? super Integer, ? extends A_BasicObject>)new Function1<Integer, A_BasicObject>(originalTupleType){
            final /* synthetic */ A_Type $originalTupleType;
            {
                this.$originalTupleType = $originalTupleType;
                super(1);
            }

            @NotNull
            public final A_BasicObject invoke(int it) {
                return A_Type.Companion.typeAtIndex(this.$originalTupleType, it);
            }
        });
        return TupleTypeDescriptor.Companion.tupleTypeForSizesTypesDefaultType(tupleSizeRange, newLeadingTypes2, A_Type.Companion.unionOfTypesAtThrough(originalTupleType, startOfSmear, Integer.MAX_VALUE));
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_SUBSCRIPT_OUT_OF_BOUNDS};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

