/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.variables;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.VariableGetException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014J\u001e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lavail/interpreter/primitive/variables/P_GetValue;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "argumentTypes", "", "avail"})
public final class P_GetValue
extends Primitive {
    @NotNull
    public static final P_GetValue INSTANCE = new P_GetValue();

    private P_GetValue() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(1, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(1);
        AvailObject variable = interpreter.argument(0);
        try {
            result2 = interpreter.primitiveSuccess(variable.getValue());
        }
        catch (VariableGetException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(VariableTypeDescriptor.Companion.getMostGeneralVariableType()), PrimitiveTypeDescriptor.Types.ANY.getO(), null, 4, null);
    }

    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction2, @NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(rawFunction2, "rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, "argumentTypes");
        A_Type varType = argumentTypes.get(0);
        A_Type readType = A_Type.Companion.getReadType(varType);
        return readType.isTop() ? (A_Type)PrimitiveTypeDescriptor.Types.ANY.getO() : readType;
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_READ_UNASSIGNED_VARIABLE, AvailErrorCode.E_JAVA_MARSHALING_FAILED};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }
}

