/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer.values;

import avail.descriptor.functions.A_RawFunction;
import avail.optimizer.values.Frame;
import avail.optimizer.values.L2SemanticCaller;
import avail.optimizer.values.L2SemanticFunction;
import avail.optimizer.values.L2SemanticLabel;
import avail.optimizer.values.L2SemanticOuter;
import avail.optimizer.values.L2SemanticResult;
import avail.optimizer.values.L2SemanticSlot;
import avail.optimizer.values.L2SemanticTemp;
import avail.optimizer.values.L2SemanticValue;
import avail.utility.CollectionExtensionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u0017\u001a\u00020\u0011J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000fJ\b\u0010\u001d\u001a\u00020\u0006H\u0016J\"\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00002\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00000!R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\""}, d2={"Lavail/optimizer/values/Frame;", "", "outerFrame", "code", "Lavail/descriptor/functions/A_RawFunction;", "debugName", "", "(Lavail/optimizer/values/Frame;Lavail/descriptor/functions/A_RawFunction;Ljava/lang/String;)V", "getCode", "()Lavail/descriptor/functions/A_RawFunction;", "getDebugName", "()Ljava/lang/String;", "getOuterFrame", "()Lavail/optimizer/values/Frame;", "depth", "", "function", "Lavail/optimizer/values/L2SemanticValue;", "label", "outer", "outerIndex", "optionalName", "reifiedCaller", "result", "slot", "slotIndex", "afterPc", "temp", "uniqueId", "toString", "transform", "topFrameReplacement", "frameTransformer", "Lkotlin/Function1;", "avail"})
public final class Frame {
    @Nullable
    private final Frame outerFrame;
    @NotNull
    private final A_RawFunction code;
    @NotNull
    private final String debugName;

    public Frame(@Nullable Frame outerFrame, @NotNull A_RawFunction code, @NotNull String debugName) {
        Intrinsics.checkNotNullParameter(code, "code");
        Intrinsics.checkNotNullParameter(debugName, "debugName");
        this.outerFrame = outerFrame;
        this.code = code;
        this.debugName = debugName;
    }

    @Nullable
    public final Frame getOuterFrame() {
        return this.outerFrame;
    }

    @NotNull
    public final A_RawFunction getCode() {
        return this.code;
    }

    @NotNull
    public final String getDebugName() {
        return this.debugName;
    }

    public final int depth() {
        return CollectionsKt.count(CollectionExtensionsKt.iterableWith(this, depth.1.INSTANCE));
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @NotNull
    public final L2SemanticValue function() {
        return new L2SemanticFunction(this);
    }

    @NotNull
    public final L2SemanticValue label() {
        return new L2SemanticLabel(this);
    }

    @NotNull
    public final L2SemanticValue outer(int outerIndex, @Nullable String optionalName) {
        return new L2SemanticOuter(this, outerIndex, optionalName);
    }

    @NotNull
    public final L2SemanticValue slot(int slotIndex, int afterPc, @Nullable String optionalName) {
        return new L2SemanticSlot(this, slotIndex, afterPc, optionalName);
    }

    @NotNull
    public final L2SemanticValue result() {
        return new L2SemanticResult(this);
    }

    @NotNull
    public final L2SemanticValue temp(int uniqueId) {
        return new L2SemanticTemp(this, uniqueId);
    }

    @NotNull
    public final L2SemanticValue reifiedCaller() {
        return new L2SemanticCaller(this);
    }

    @NotNull
    public final Frame transform(@NotNull Frame topFrameReplacement, @NotNull Function1<? super Frame, Frame> frameTransformer) {
        Intrinsics.checkNotNullParameter(topFrameReplacement, "topFrameReplacement");
        Intrinsics.checkNotNullParameter(frameTransformer, "frameTransformer");
        if (this.outerFrame == null) {
            return topFrameReplacement;
        }
        Frame newOuterFrame = frameTransformer.invoke(this.outerFrame);
        return Intrinsics.areEqual(newOuterFrame, this.outerFrame) ? this : new Frame(newOuterFrame, this.code, this.debugName + " (inlined)");
    }
}

